<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output indent="yes" method="html"/>

<xsl:template match="/">
	<xsl:apply-templates select="build"/>
</xsl:template>

<xsl:template match="build">
<html>
<body>
<h1>MDM Workbench Build</h1>
<p>The following is the state of the MDM Workbench Ant build, at the end of each target.</p>
<p><br/></p>

<xsl:if test="target[@name='checkProperties']">
	<p>
	checkPropertiesExist: 
		<xsl:choose>
			<xsl:when
				test="target[@name='checkProperties']/task[@name='echo']/message/text()[1] = 'Start of target checkProperties'">
				<xsl:choose>
					<xsl:when
						test="target[@name='checkProperties']/task[@name='echo']/message/text()[1] = 'End of target checkProperties'">
						SUCCESSFUL
					</xsl:when>
					<xsl:otherwise>
						FAILED
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				NOT ENABLED
			</xsl:otherwise>
		</xsl:choose>
	</p>
</xsl:if>

<xsl:if test="target[@name='createServerRuntimeAndTargetPlatform']">
	<p>
	createServerRuntimeAndTargetPlatform: 
		<xsl:choose>
			<xsl:when
				test="target[@name='createServerRuntimeAndTargetPlatform']/task[@name='echo']/message/text()[1] = 'Start of target createServerRuntimeAndTargetPlatform'">
				<xsl:choose>
					<xsl:when
						test="target[@name='createServerRuntimeAndTargetPlatform']/task[@name='echo']/message/text()[1] = 'End of target createServerRuntimeAndTargetPlatform'">
						SUCCESSFUL
					</xsl:when>
					<xsl:otherwise>
						FAILED
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				NOT ENABLED
			</xsl:otherwise>
		</xsl:choose>
	</p>
</xsl:if>

<xsl:if test="target[@name='importProjects']">
	<p>
	importProjects: 
		<xsl:choose>
			<xsl:when
				test="target[@name='importProjects']/task[@name='echo']/message/text()[1] = 'Start of target importProjects'">
				<xsl:choose>
					<xsl:when
						test="target[@name='importProjects']/task[@name='echo']/message/text()[1] = 'End of target importProjects'">
						SUCCESSFUL
					</xsl:when>
					<xsl:otherwise>
						FAILED
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				NOT ENABLED
			</xsl:otherwise>
		</xsl:choose>
	</p>
</xsl:if>

<xsl:if test="target[@name='generateCode']">
	<p>
	generateCode: 
		<xsl:choose>
			<xsl:when
				test="target[@name='generateCode']/task[@name='echo']/message/text()[1] = 'Start of target generateCode'">
				<xsl:choose>
					<xsl:when
						test="target[@name='generateCode']/task[@name='echo']/message/text()[1] = 'End of target generateCode'">
						SUCCESSFUL
					</xsl:when>
					<xsl:otherwise>
						FAILED
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				NOT ENABLED
			</xsl:otherwise>
		</xsl:choose>
	</p>
</xsl:if>

<xsl:if test="target[@name='workspaceBuild']">
	<p>
	workspaceBuild: 
		<xsl:choose>
			<xsl:when
				test="target[@name='workspaceBuild']/task[@name='echo']/message/text()[1] = 'Start of target workspaceBuild'">
				<xsl:choose>
					<xsl:when
						test="target[@name='workspaceBuild']/task[@name='echo']/message/text()[1] = 'End of target workspaceBuild'">
						SUCCESSFUL
					</xsl:when>
					<xsl:otherwise>
						FAILED
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				NOT ENABLED
			</xsl:otherwise>
		</xsl:choose>
	</p>
</xsl:if>

<xsl:if test="target[@name='exportCBAs']">
	<p>
	exportCBAs: 
		<xsl:choose>
			<xsl:when
				test="target[@name='exportCBAs']/task[@name='echo']/message/text()[1] = 'Start of target exportCBAs'">
				<xsl:choose>
					<xsl:when
						test="target[@name='exportCBAs']/task[@name='echo']/message/text()[1] = 'End of target exportCBAs'">
						SUCCESSFUL
					</xsl:when>
					<xsl:otherwise>
						FAILED
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				NOT ENABLED
			</xsl:otherwise>
		</xsl:choose>
	</p>
</xsl:if>

<p><br/></p>
<p>End of report.</p>
</body>
</html>
</xsl:template>
</xsl:stylesheet>