/*
       IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2007, ALL RIGHTS RESERVED.
 */

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using FileNet.Api.Exception;

namespace FolderBrowser
{
    //
    // Form with UI components to collect necessary information
    // to connect to CE and establish security credentials for
    // the user. It has a button that, when clicked, pops up a
    // form for selecting a folder and displaying its containees.
    //
    public partial class MainForm : Form
    {
        private CEConnection ce;

        //
        // Constructor
        //
        public MainForm()
        {
            ce = new CEConnection();
            InitializeComponent();
        }

        //
        // Handles the event generated when 'Test Connection' button is clicked.
        // It establishes the security credentials for the user with the CE.
        //
        private void connectionButton_Click(object sender, EventArgs e)
        {
            String user = userTextBox.Text;
            String pass = passTextBox.Text;
            String uri = uriTextBox.Text;
            try
            {
                if (CheckRequiredFields())
                {
                    ce.EstablishCredentials(user, pass, uri);
                    statusLabel.Text = "Connection verified with Content Engine";
                    connectionButton.Enabled = false;
                    browserButton.Enabled = true; 
                }
            }
            catch (EngineRuntimeException ere)
            {
                statusLabel.Text = ere.Message;
                System.Console.WriteLine(ere.StackTrace);
            }
        }

        //
        // Handles the event generated when 'Close' button is clicked.
        // Closes this Form.
        //
        private void closeButton_Click(object sender, EventArgs e)
        {
            base.Dispose();
        }

        //
        // Checks whether all required fields are filled before 
        // performing any action.
        //
        private bool CheckRequiredFields()
        {
            bool check = true;
            if (uriTextBox.Text.Equals(""))
            {
                uriTextBox.Text = "Enter CE URI.";
                check = false;
            }
            if (userTextBox.Text.Equals(""))
            {
                userTextBox.Text = "Enter Username.";
                check = false;
            }
            if (passTextBox.Text.Equals(""))
            {
                passTextBox.Text = "Enter Password.";
                check = false;
            }
            return check;
        }

        //
        // Handles the event generated when 'browseButton' is clicked.
        // Opens up FolderBrowserForm.
        //
        private void browserButton_Click(object sender, EventArgs e)
        {
            FolderBrowserForm form = new FolderBrowserForm(ce);
            form.Show();
        }
    }
}