/*
       IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2007, ALL RIGHTS RESERVED.
 */

using System;
using System.Collections.Generic;
using System.Text;
using FileNet.Api.Core;
using FileNet.Api.Collection;

namespace FolderBrowser
{
    //
    // This class provides static methods to make API calls
    // to Content Engine.
    //
    public class FolderUtil
    {
        private static IObjectStore os;

        //
        // Provides the getter and setter for currently
        // selected ObjectStore by the user.
        //
        public static IObjectStore OS
        {
            set
            {
                os = value;
            }
            get
            {
                return os;
            }
        }

        //
        // API call to CE to fetch Folder instance from supplied ObjectStore
        // and path.
        //
        public static IFolder FetchFolder(IObjectStore os, String fPath)
        {
            IFolder f = Factory.Folder.FetchInstance(os, fPath, null);
            return f;
        }

        //
        // API call to CE to retrieve sub folders of the specified
        // Folder instance.
        //
        public static IFolderSet GetSubFolders(IFolder f)
        {
            IFolderSet fs = f.SubFolders;
            return fs;
        }

        //
        // API call to CE to retrieve Name property of the specified
        // Folder instance.
        //
        public static String GetFolderName(IFolder f)
        {
            String name = f.Name;
            return name;
        }

        //
        // API call to CE to retrieve containees of specified Folder instance. 
        // It returns ReferentialContainmentRelationshipSet. You can iterate the
	 // ReferentialContainmentRelationshipSet  to get ReferentialContainmentRelationship objects,
	 // from which Documents and CustomObjects can be retrieved. 
        //
        public static IReferentialContainmentRelationshipSet GetFolderContainees(IFolder f)
        {
            IReferentialContainmentRelationshipSet rcrSet = f.Containees;
            return rcrSet;
        }

        //
        // API call to Content Engine to retrieve ContainmentName property of 
        // ReferentialContainmentRelationship object.
        //
        public static String GetContainmentName(IReferentialContainmentRelationship rcr)
        {
            String name = rcr.ContainmentName;
            return name;
        }
    }
}
