/*
       IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2007, ALL RIGHTS RESERVED.
 */

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using FileNet.Api.Core;
using FileNet.Api.Collection;
using FileNet.Api.Exception;

namespace FolderBrowser
{
    //
    // Form with UI components to collect necessary information
    // to create and display Folder tree.
    //
    public partial class FolderBrowserForm : Form
    {
        private CEConnection ce;
        
        //
        // Constructor
        //
        public FolderBrowserForm(CEConnection c)
        {
            ce = c;
            InitializeComponent();
        }

        //
        // Handles the event generated when this Form is loaded.
        // It populates the 'osComboBox' with names of the available
        // ObjectStores.
        //
        private void FolderBrowser_Load(object sender, EventArgs e)
        {
            ArrayList osNames = ce.GetOSNames();
            osComboBox.Items.Clear();
            for (int i = 0; i < osNames.Count; i++)
            {
                osComboBox.Items.Add(osNames[i]);
            }
        }

        //
        // Handles the event generated when item is selected in 'osComboBox'.
        // Clears the existing tree from the tree view and items from the 
        // list box if there are any. Then intializes tree with root folder.
        //
        private void osComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            String osName = (String)osComboBox.SelectedItem;
            IObjectStore os = ce.FetchOS(osName);
            FolderUtil.OS = os;
            folderTreeView.Nodes.Clear();
            folderListBox.Items.Clear();
            folderTreeView.Nodes.Add("/");
            statusLabel.Text = "ObjectStore " + osName + " is currently selected.";
        }

        //
        // Handles the event generated when some node is selected in the displayed tree.
        // Fetches the subfolders of the selected Folder if they have not been fetched 
        // already. Also fetches the folder containees such as Document and CustomObject types, 
        // and displays them in the list box.
        //
        private void folderTreeView_AfterSelect(object sender, TreeViewEventArgs e)
        {
            TreeNode node = folderTreeView.SelectedNode;
            String path = node.FullPath;
            try
            {
                IFolder root = FolderUtil.FetchFolder(FolderUtil.OS, path);
                folderListBox.Items.Clear();
                IReferentialContainmentRelationshipSet rcrSet = FolderUtil.GetFolderContainees(root);
                IEnumerator ie = rcrSet.GetEnumerator();
                while (ie.MoveNext())
                {
                    IReferentialContainmentRelationship rcr = (IReferentialContainmentRelationship)ie.Current;
                    folderListBox.Items.Add(FolderUtil.GetContainmentName(rcr));
                }
                if (!(node.Nodes.Count > 0))
                {
                    IFolderSet fs = FolderUtil.GetSubFolders(root);
                    IEnumerator ie1 = fs.GetEnumerator();
                    while (ie1.MoveNext())
                    {
                        IFolder f = (IFolder)ie1.Current;
                        node.Nodes.Add(FolderUtil.GetFolderName(f));
                    }
                }
            }
            catch (EngineRuntimeException ere)
            {
                statusLabel.Text = ere.Message;
                System.Console.WriteLine(ere.StackTrace);
            }
        }

        //
        // Handles the event generated when 'Close' button is clicked.
        // Closes this Form.
        //
        private void closeButton_Click(object sender, EventArgs e)
        {
            base.Dispose();
        }
    }
}