/**
	IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2007, ALL RIGHTS RESERVED.
 */

package cefolderbrowser;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import java.awt.GridBagLayout;
import javax.swing.JTabbedPane;
import javax.swing.JButton;
import java.awt.GridBagConstraints;

/**
 * This is the main JFrame that hosts ConnectionPanel and
 * FolderBrowserPanel as tabs.
 */
public class MainFrame extends JFrame
{
	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JPanel buttonPanel = null;
	private JTabbedPane mainTabbedPane = null;
	private JButton closeButton = null;
	private ConnectionPanel connectionPanel = null;
	private FolderBrowserPanel folderBrowserPanel = null;
	private CEConnection ce = null;
	
	/**
	 * This is the default constructor.
	 */
	public MainFrame()
	{
		super();
		ce = new CEConnection();
		initialize();
	}

	/**
	 * This method initializes this class.
	 * 
	 * @return void
	 */
	private void initialize()
	{
		connectionPanel = new ConnectionPanel(ce);
		folderBrowserPanel = new FolderBrowserPanel(ce);
		this.setSize(600, 500);
		this.setContentPane(getJContentPane());
		this.setTitle("Content Engine Folder Browser");
	}

	/**
	 * This method initializes jContentPane.
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane()
	{
		if (jContentPane == null)
		{
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getButtonPanel(), BorderLayout.SOUTH);
			jContentPane.add(getMainTabbedPane(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	/**
	 * This method initializes buttonPanel.	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getButtonPanel()
	{
		if (buttonPanel == null)
		{
			buttonPanel = new JPanel();
			buttonPanel.setLayout(new GridBagLayout());
			buttonPanel.add(getCloseButton(), new GridBagConstraints());
		}
		return buttonPanel;
	}

	/**
	 * This method initializes mainTabbedPane.	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getMainTabbedPane()
	{
		if (mainTabbedPane == null)
		{
			mainTabbedPane = new JTabbedPane();
			mainTabbedPane.setTabLayoutPolicy(javax.swing.JTabbedPane.SCROLL_TAB_LAYOUT);
	        	mainTabbedPane.setTabPlacement(javax.swing.JTabbedPane.TOP);
	        	mainTabbedPane.addTab("Server Connection", connectionPanel);
	        	mainTabbedPane.addTab("Browse Folders", folderBrowserPanel);
		}
		return mainTabbedPane;
	}

	/**
	 * This method initializes closeButton.	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCloseButton()
	{
		if (closeButton == null)
		{
			closeButton = new JButton();
			closeButton.setText("Close");
			closeButton.addActionListener(new java.awt.event.ActionListener()
	        {
	            public void actionPerformed(java.awt.event.ActionEvent evt)
	            {
	                closeButtonActionPerformed(evt);
	            }
	        });
		}
		return closeButton;
	}
	
	/*
	 * Closes the frame when user clicks Close button.
	 * @return void
	 */
	private void closeButtonActionPerformed(java.awt.event.ActionEvent evt)                                            
    {                                                
        MainFrame.this.dispose();
    } 

	/**
	 * @param args
	 */
	public static void main(String[] args) 
	{
		SwingUtilities.invokeLater(new Runnable() 
		{
			public void run() 
			{
				MainFrame thisClass = new MainFrame();
				thisClass.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				thisClass.setVisible(true);
				thisClass.setLocationRelativeTo(null);
			}
		});
	}
}
