/**
	IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2007, ALL RIGHTS RESERVED.
 */

package cefolderbrowser;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import com.filenet.api.collection.FolderSet;
import com.filenet.api.collection.ReferentialContainmentRelationshipSet;
import com.filenet.api.core.Folder;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.exception.EngineRuntimeException;


/**
 * JPanel UI to display object store folders in a JTree
 */
public class FolderBrowserPanel extends JPanel
{

	private static final long serialVersionUID = 1L;
	private JRadioButton osRadioButton = null;
	private JComboBox osComboBox = null;
	private JPanel osPanel = null;
	private JScrollPane treeScrollPane = null;
	private JTree folderTree = null;
	private Vector osnames = null;
       private CEConnection ce = null;
	private JSplitPane treeSplitPane = null;
	private JScrollPane areaScrollPane = null;
	private JTextArea treeTextArea = null;
	private JLabel statusLabel = null;
	
	/**
	 * This is the default constructor.
	 */
	public FolderBrowserPanel(CEConnection c)
	{
		super();
		ce = c;
        osnames = new Vector();
		initialize();
	}

	/**
	 * This method initializes this class.
	 * 
	 * @return void
	 */
	private void initialize()
	{
		statusLabel = new JLabel();
		statusLabel.setText("Folder Browser");
		this.setSize(300, 200);
		this.setLayout(new BorderLayout());
		this.add(getOsPanel(), BorderLayout.NORTH);
		this.add(getTreeSplitPane(), BorderLayout.CENTER);
		this.add(statusLabel, BorderLayout.SOUTH);
	}

	/**
	 * This method initializes osRadioButton.	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getOsRadioButton()
	{
		if (osRadioButton == null)
		{
			osRadioButton = new JRadioButton();
			osRadioButton.setText("Select Object Store");
			osRadioButton.addActionListener(new java.awt.event.ActionListener()
	        {
	            public void actionPerformed(java.awt.event.ActionEvent evt)
	            {
	                osRadioButtonActionPerformed(evt);
	            }
	        });
		}
		return osRadioButton;
	}

	/**
	 * This method initializes osComboBox.
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getOsComboBox()
	{
		if (osComboBox == null)
		{
			osComboBox = new JComboBox();
			osComboBox.addItemListener(new java.awt.event.ItemListener()
				{
					public void itemStateChanged(java.awt.event.ItemEvent e)
					{
						if (!(e.getStateChange() == java.awt.event.ItemEvent.SELECTED))
						{
							comboboxItemSelectionActionPerformed(e);
						}
					}
				});
		}
		return osComboBox;
	}

	/**
	 * This method initializes osPanel.	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getOsPanel()
	{
		if (osPanel == null)
		{
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.anchor = GridBagConstraints.WEST;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.weightx = 1.0;
			osPanel = new JPanel();
			osPanel.setLayout(new GridBagLayout());
			osPanel.add(getOsRadioButton(), gridBagConstraints1);
			osPanel.add(getOsComboBox(), gridBagConstraints);
		}
		return osPanel;
	}

	/**
	 * This method initializes treeScrollPane.	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getTreeScrollPane()
	{
		if (treeScrollPane == null)
		{
			treeScrollPane = new JScrollPane();
			treeScrollPane.setViewportView(getFolderTree());
		}
		return treeScrollPane;
	}

	/**
	 * This method initializes folderTree.	
	 * 	
	 * @return javax.swing.JTree	
	 */
	private JTree getFolderTree()
	{
		if (folderTree == null)
		{
			folderTree = new JTree();
			folderTree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
			//Set the icon for nodes in JTree.
			ClassLoader cldr = this.getClass().getClassLoader();
			java.net.URL closeURL = cldr.getResource("images/mini-shut.gif");
			java.net.URL openURL = cldr.getResource("images/mini-open.gif");
			if (openURL != null && closeURL != null) 
			{
				ImageIcon closeIcon = new ImageIcon(closeURL);
				ImageIcon openIcon = new ImageIcon(openURL);
				DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
				renderer.setLeafIcon(closeIcon);
				renderer.setOpenIcon(openIcon);
				renderer.setClosedIcon(closeIcon);
				folderTree.setCellRenderer(renderer);
			} 
			else 
			{
				System.err.println("icon missing; using default.");
			}
			folderTree.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener()
						{
							public void valueChanged(javax.swing.event.TreeSelectionEvent e)
							{
								treeSelectionEventPerformed(e);
							}
						});
		}
		return folderTree;
	}
	
	/**
	 * This method initializes treeSplitPane.	
	 * 	
	 * @return javax.swing.JSplitPane	
	 */
	private JSplitPane getTreeSplitPane()
	{
		if (treeSplitPane == null)
		{
			treeSplitPane = new JSplitPane();
			treeSplitPane.setDividerLocation(100);
			treeSplitPane.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
			treeSplitPane.setRightComponent(getAreaScrollPane());
			treeSplitPane.setLeftComponent(getTreeScrollPane());
		}
		return treeSplitPane;
	}

	/**
	 * This method initializes areaScrollPane.	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getAreaScrollPane()
	{
		if (areaScrollPane == null)
		{
			areaScrollPane = new JScrollPane();
			areaScrollPane.setViewportView(getTreeTextArea());
		}
		return areaScrollPane;
	}

	/**
	 * This method initializes treeTextArea.	
	 * 	
	 * @return javax.swing.JTextArea	
	 */
	private JTextArea getTreeTextArea()
	{
		if (treeTextArea == null)
		{
			treeTextArea = new JTextArea();
			treeTextArea.setLineWrap(true);
			treeTextArea.setEditable(false);
		}
		return treeTextArea;
	}

    /*
     * Populates the osComboBox with available
     * object store names when user selects osRadioButton.
     */
	private void osRadioButtonActionPerformed(java.awt.event.ActionEvent evt)
    {
        try
		{
			if(ce.isConnected())
			{
			    osnames = ce.getOSNames();
			    osComboBox.removeAllItems();
			    osComboBox.addItem("List Populated with available Object Stores");
			    for(int i = 0; i < osnames.size(); i++)
			    {
			        osComboBox.addItem(osnames.get(i));
			    }
			}
		} 
        catch (EngineRuntimeException e)
		{
			e.printStackTrace();
		}
    }
	
	/*
	 * Action performed while selecting a node from the tree. 
	 * On selection, method fetches the Documents and CustomObjects
	 * from the folder represented by selected node. If subfolders
	 * of that folder have not been fetched yet, it 
	 * fetches them, too.
	 */
	private void treeSelectionEventPerformed(javax.swing.event.TreeSelectionEvent e)
	{
		try
		{
			DefaultTreeModel m = (DefaultTreeModel) folderTree.getModel();
			if(m.getRoot() != null)
			{
				DefaultMutableTreeNode top = (DefaultMutableTreeNode) folderTree.getLastSelectedPathComponent();
				TreePath tp = folderTree.getSelectionPath();
				String path = "";
				for(int i = 0; i < tp.getPathCount(); i++)
				{
					if( i == 0 || i == (tp.getPathCount() - 1))
						path = path + tp.getPathComponent(i);
					else
						path = path +  tp.getPathComponent(i) +  "/";
				}
				Folder root = FolderUtil.fetchFolder(FolderUtil.getOs(), path);
				ReferentialContainmentRelationshipSet rcrSet = FolderUtil.getFolderContainees(root);
				Iterator i = rcrSet.iterator();
				treeTextArea.setText("");
				while(i.hasNext())
				{
					ReferentialContainmentRelationship rcr = (ReferentialContainmentRelationship) i.next();
					treeTextArea.append(FolderUtil.getContainmentName(rcr) + '\n');
				}
				if(top.isLeaf())
				{
					FolderSet fs = FolderUtil.getSubFolders(root);
					Iterator it = fs.iterator();
					while(it.hasNext())
					{
						Folder f = (Folder) it.next();
						top.add(new DefaultMutableTreeNode(FolderUtil.getFolderName(f)));
					}
					if(top.isRoot())
						folderTree.expandPath(new TreePath(top.getPath()));
				}
			}
		} 
		catch (EngineRuntimeException e1)
		{
			statusLabel.setText(e1.getMessage());
			e1.printStackTrace();
		}
		catch (RuntimeException e2)
		{
			e2.printStackTrace();
		}
	}
	
	
	/*
	 * Based on selected object store, calls createTree method to build
	 * new JTree.
	 */
	private void comboboxItemSelectionActionPerformed(java.awt.event.ItemEvent e)
	{
		DefaultTreeModel m = (DefaultTreeModel) folderTree.getModel();
		m.setRoot(null);
		treeTextArea.setText("");
		statusLabel.setText("Object Store: " + osComboBox.getSelectedItem());
		createTree(folderTree);
	}
	
	/*
	 * Builds new JTree with root folder from selected object store as 
	 * top node.
	 */
	private void createTree(JTree tree)
	{
		try
		{
			DefaultMutableTreeNode top = new DefaultMutableTreeNode("/");
			DefaultTreeModel m = (DefaultTreeModel) tree.getModel();
			m.setRoot(top);
			FolderUtil.setOs(ce.fetchOS((String) osComboBox.getSelectedItem()));
		} 
		catch (EngineRuntimeException e)
		{
			e.printStackTrace();
		}
	}
}
