/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsc.util;

import com.ibm.os390.security.PlatformReturned;
import com.ibm.os390.security.PlatformUser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FormLoginFilter
implements Filter {
    public static Hashtable<String, String> errortable = new Hashtable();
    public static Hashtable<String, String> forwardtable = new Hashtable();
    private FilterConfig filterConfig = null;

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        if (this.filterConfig == null) {
            return;
        }
        String username = req.getParameter("j_username");
        String password = req.getParameter("j_password");
        String newPassword = req.getParameter("newPassword");
        String confirmPassword = req.getParameter("confirmPassword");
        boolean success = false;
        if (newPassword == null || newPassword.length() == 0) {
            success = this.authenticate(username, password, req, resp);
        } else if (newPassword.equals(confirmPassword)) {
            success = this.changePassword(username, password, newPassword, confirmPassword, req, resp);
            if (success) {
                req.getRequestDispatcher("/error/ChangePasswordSuccess.jsp").forward(req, resp);
                success = false;
            }
        } else {
            req.getRequestDispatcher("/error/PasswordMatch.jsp").forward(req, resp);
            success = false;
        }
        if (success) {
            chain.doFilter(req, resp);
        }
    }

    private boolean authenticate(String username, String password, ServletRequest req, ServletResponse resp) throws UnsupportedEncodingException, IOException, ServletException {
        PlatformReturned retVal = PlatformUser.authenticate((String)username, (String)password);
        if (retVal != null) {
            String error = Integer.toString(retVal.errno);
            req.setAttribute("errno", (Object)Integer.toString(retVal.errno));
            req.setAttribute("errno2", (Object)Integer.toString(retVal.errno2));
            if (errortable.containsKey(error)) {
                req.setAttribute("errorstring", (Object)errortable.get(error));
            } else {
                req.setAttribute("errorstring", (Object)errortable.get("unknownerror"));
            }
            req.getRequestDispatcher("/error/AuthFailed.jsp").forward(req, resp);
            return false;
        }
        return true;
    }

    private boolean changePassword(String username, String password, String newPassword, String confirmPassword, ServletRequest req, ServletResponse resp) throws IOException, ServletException {
        PlatformReturned retVal = PlatformUser.changePassword((String)username, (String)password, (String)newPassword);
        if (retVal != null) {
            String error = Integer.toString(retVal.errno);
            req.setAttribute("errno", (Object)Integer.toString(retVal.errno));
            req.setAttribute("errno2", (Object)Integer.toString(retVal.errno2));
            if (errortable.containsKey(error)) {
                req.setAttribute("errorstring", (Object)errortable.get(error));
            } else {
                req.setAttribute("errorstring", (Object)errortable.get("unknownerror"));
            }
            req.getRequestDispatcher("/error/ChangePasswordFailed.jsp").forward(req, resp);
            return false;
        }
        return true;
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        errortable.put("121", "Username, password, or new password has an incorrect length.");
        errortable.put("139", "Caller does not have access to BPX.DAEMON FACILITY class profile.");
        errortable.put("143", "Username not defined to OMVS.");
        errortable.put("111", "Incorrect password.");
        errortable.put("168", "Expired password. Please use the form to enter a new password.");
        errortable.put("169", "The new password is not valid.");
        errortable.put("163", "The username is revoked.");
        errortable.put("164", "RACF UMAP Service Error.");
        errortable.put("unknownerror", "An unknown error has occurred. Please contact your system administrator.");
    }
}

