ALTER TABLE <dbSchema>.RuleAppProperty DROP CONSTRAINT RuleAppProperty_RuleApp ;
ALTER TABLE <dbSchema>.RuleAppProperty ADD CONSTRAINT RuleAppProperty_RuleApp FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.RuleApp ;
ALTER TABLE <dbSchema>.BRSTUDIO DROP CONSTRAINT BRSTUDIO_RuleProject ;
ALTER TABLE <dbSchema>.BRSTUDIO ADD CONSTRAINT BRSTUDIO_RuleProject FOREIGN KEY (project) REFERENCES <dbSchema>.RuleProject ;
ALTER TABLE <dbSchema>.ConnectionEntry DROP CONSTRAINT ConnectionEntry_RuleProject ;
ALTER TABLE <dbSchema>.ConnectionEntry ADD CONSTRAINT ConnectionEntry_RuleProject FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.RuleProject ;
ALTER TABLE <dbSchema>.MergeReport DROP CONSTRAINT MergeReport_RuleProject ;
ALTER TABLE <dbSchema>.MergeReport ADD CONSTRAINT MergeReport_RuleProject FOREIGN KEY (project) REFERENCES <dbSchema>.RuleProject ;
ALTER TABLE <dbSchema>.Ruleset DROP CONSTRAINT Ruleset_RuleApp ;
ALTER TABLE <dbSchema>.Ruleset ADD CONSTRAINT Ruleset_RuleApp FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.RuleApp ;
ALTER TABLE <dbSchema>.Baseline DROP CONSTRAINT BSLN_RULEPROJECT ;
ALTER TABLE <dbSchema>.Baseline ADD CONSTRAINT BSLN_RULEPROJECT FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.RuleProject ;
ALTER TABLE <dbSchema>.BSLNLFTRGT DROP CONSTRAINT BSLNLFTRGT_BSLN ;
ALTER TABLE <dbSchema>.BSLNLFTRGT ADD CONSTRAINT BSLNLFTRGT_BSLN FOREIGN KEY (ID) REFERENCES <dbSchema>.Baseline ;
ALTER TABLE <dbSchema>.ProjectInfo DROP CONSTRAINT ProjectInfo_BSLN ;
ALTER TABLE <dbSchema>.ProjectInfo ADD CONSTRAINT ProjectInfo_BSLN FOREIGN KEY (baseline) REFERENCES <dbSchema>.Baseline ;
ALTER TABLE <dbSchema>.Dependency DROP CONSTRAINT Dependency_ProjectInfo ;
ALTER TABLE <dbSchema>.Dependency ADD CONSTRAINT Dependency_ProjectInfo FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ProjectInfo ;
ALTER TABLE <dbSchema>.MessageMap DROP CONSTRAINT MessageMap_ProjectInfo ;
ALTER TABLE <dbSchema>.MessageMap ADD CONSTRAINT MessageMap_ProjectInfo FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ProjectInfo ;
ALTER TABLE <dbSchema>.Parameter DROP CONSTRAINT Parameter_ProjectInfo ;
ALTER TABLE <dbSchema>.Parameter ADD CONSTRAINT Parameter_ProjectInfo FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ProjectInfo ;
ALTER TABLE <dbSchema>.RTSSCHEMA DROP CONSTRAINT RTSSCHEMA_ProjectInfo ;
ALTER TABLE <dbSchema>.RTSSCHEMA ADD CONSTRAINT RTSSCHEMA_ProjectInfo FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ProjectInfo ;
ALTER TABLE <dbSchema>.RuleProjectTag DROP CONSTRAINT RLPRJTAG_ProjectInfo ;
ALTER TABLE <dbSchema>.RuleProjectTag ADD CONSTRAINT RLPRJTAG_ProjectInfo FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ProjectInfo ;
ALTER TABLE <dbSchema>.RulesetProperty DROP CONSTRAINT RulesetProperty_ProjectInfo ;
ALTER TABLE <dbSchema>.RulesetProperty ADD CONSTRAINT RulesetProperty_ProjectInfo FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ProjectInfo ;
ALTER TABLE <dbSchema>.ScenarioSuiteReport DROP CONSTRAINT ScenarioSuiteReport_BSLN ;
ALTER TABLE <dbSchema>.ScenarioSuiteReport ADD CONSTRAINT ScenarioSuiteReport_BSLN FOREIGN KEY (branch) REFERENCES <dbSchema>.Baseline ;
ALTER TABLE <dbSchema>.ScenarioSuiteKPIReport DROP CONSTRAINT SCSUITEKPIRPRT_ScenarioSuiteReport ;
ALTER TABLE <dbSchema>.ScenarioSuiteKPIReport ADD CONSTRAINT SCSUITEKPIRPRT_ScenarioSuiteReport FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ScenarioSuiteReport ;
ALTER TABLE <dbSchema>.ScenarioTestReport DROP CONSTRAINT SCTSTRPRT_ScenarioSuiteReport ;
ALTER TABLE <dbSchema>.ScenarioTestReport ADD CONSTRAINT SCTSTRPRT_ScenarioSuiteReport FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ScenarioSuiteReport ;
ALTER TABLE <dbSchema>.TestReport DROP CONSTRAINT TestReport_ScenarioSuiteReport ;
ALTER TABLE <dbSchema>.TestReport ADD CONSTRAINT TestReport_ScenarioSuiteReport FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ScenarioSuiteReport ;
ALTER TABLE <dbSchema>.VERSION DROP CONSTRAINT VERSION_Baseline ;
ALTER TABLE <dbSchema>.VERSION ADD CONSTRAINT VERSION_Baseline FOREIGN KEY (BASELINE) REFERENCES <dbSchema>.Baseline ;
ALTER TABLE <dbSchema>.LVIPBRCH DROP CONSTRAINT LVIPBRCH_VERSION ;
ALTER TABLE <dbSchema>.LVIPBRCH ADD CONSTRAINT LVIPBRCH_VERSION FOREIGN KEY (VERSION) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.BASELINECONTENT DROP CONSTRAINT BASELINECONTENT_VERSION ;
ALTER TABLE <dbSchema>.BASELINECONTENT ADD CONSTRAINT BASELINECONTENT_VERSION FOREIGN KEY (VERSION) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.LOCKTBL DROP CONSTRAINT LOCKTBL_BSLN ;
ALTER TABLE <dbSchema>.LOCKTBL ADD CONSTRAINT LOCKTBL_BSLN FOREIGN KEY (branch) REFERENCES <dbSchema>.Baseline ;
ALTER TABLE <dbSchema>.RulePackage DROP CONSTRAINT FKRulePackage_STARTV ;
ALTER TABLE <dbSchema>.RulePackage ADD CONSTRAINT FKRulePackage_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.RulePackageSIBLING DROP CONSTRAINT FKRulePackage ;
ALTER TABLE <dbSchema>.RulePackageSIBLING ADD CONSTRAINT FKRulePackage FOREIGN KEY (ID) REFERENCES <dbSchema>.RulePackage ;
ALTER TABLE <dbSchema>.AbstractQuery DROP CONSTRAINT FKAbstractQuery_STARTV ;
ALTER TABLE <dbSchema>.AbstractQuery ADD CONSTRAINT FKAbstractQuery_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.ActivityLock DROP CONSTRAINT ActivityLock_BSLN ;
ALTER TABLE <dbSchema>.ActivityLock ADD CONSTRAINT ActivityLock_BSLN FOREIGN KEY (branch) REFERENCES <dbSchema>.Baseline ;
ALTER TABLE <dbSchema>.BOM DROP CONSTRAINT FKBOM_STARTV ;
ALTER TABLE <dbSchema>.BOM ADD CONSTRAINT FKBOM_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.BOM2XOMMapping DROP CONSTRAINT FKBOM2XOMMapping_STARTV ;
ALTER TABLE <dbSchema>.BOM2XOMMapping ADD CONSTRAINT FKBOM2XOMMapping_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.BOMPathEntry DROP CONSTRAINT BOMPathEntry_ProjectInfo ;
ALTER TABLE <dbSchema>.BOMPathEntry ADD CONSTRAINT BOMPathEntry_ProjectInfo FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ProjectInfo ;
ALTER TABLE <dbSchema>.DSDeploymentReport DROP CONSTRAINT DSDeploymentReport_RulePackage ;
ALTER TABLE <dbSchema>.DSDeploymentReport ADD CONSTRAINT DSDeploymentReport_RulePackage FOREIGN KEY (rulePackage) REFERENCES <dbSchema>.RulePackage ;
ALTER TABLE <dbSchema>.DecisionModel DROP CONSTRAINT FKDecisionModel_STARTV ;
ALTER TABLE <dbSchema>.DecisionModel ADD CONSTRAINT FKDecisionModel_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.DecisionModelSIBLING DROP CONSTRAINT FKDecisionModel ;
ALTER TABLE <dbSchema>.DecisionModelSIBLING ADD CONSTRAINT FKDecisionModel FOREIGN KEY (ID) REFERENCES <dbSchema>.DecisionModel ;
ALTER TABLE <dbSchema>.Deployment DROP CONSTRAINT FKDPLMNT_STARTV ;
ALTER TABLE <dbSchema>.Deployment ADD CONSTRAINT FKDPLMNT_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.DepGroup DROP CONSTRAINT FKDepGroup_STARTV ;
ALTER TABLE <dbSchema>.DepGroup ADD CONSTRAINT FKDepGroup_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.DepPropertyTag DROP CONSTRAINT FKDEPPROPTAG_STARTV ;
ALTER TABLE <dbSchema>.DepPropertyTag ADD CONSTRAINT FKDEPPROPTAG_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.DepTarget DROP CONSTRAINT FKDEPTARGET_STARTV ;
ALTER TABLE <dbSchema>.DepTarget ADD CONSTRAINT FKDEPTARGET_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.DepVersionPolicy DROP CONSTRAINT FKDEPVERSPOLICY_STARTV ;
ALTER TABLE <dbSchema>.DepVersionPolicy ADD CONSTRAINT FKDEPVERSPOLICY_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.DeploymentError DROP CONSTRAINT DeploymentError_DSDeploymentReport ;
ALTER TABLE <dbSchema>.DeploymentError ADD CONSTRAINT DeploymentError_DSDeploymentReport FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.DSDeploymentReport ;
ALTER TABLE <dbSchema>.EVENT DROP CONSTRAINT FKEVENT_STARTV ;
ALTER TABLE <dbSchema>.EVENT ADD CONSTRAINT FKEVENT_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.EVENTSIBLING DROP CONSTRAINT FKEVENT ;
ALTER TABLE <dbSchema>.EVENTSIBLING ADD CONSTRAINT FKEVENT FOREIGN KEY (ID) REFERENCES <dbSchema>.EVENT ;
ALTER TABLE <dbSchema>.Extractor DROP CONSTRAINT Extractor_ProjectInfo ;
ALTER TABLE <dbSchema>.Extractor ADD CONSTRAINT Extractor_ProjectInfo FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ProjectInfo ;
ALTER TABLE <dbSchema>.OperationLatestDeployedVersion DROP CONSTRAINT OPLATESTV_DSDeploymentReport ;
ALTER TABLE <dbSchema>.OperationLatestDeployedVersion ADD CONSTRAINT OPLATESTV_DSDeploymentReport FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.DSDeploymentReport ;
ALTER TABLE <dbSchema>.OperationNewDeployedVersion DROP CONSTRAINT OPNEWV_DSDeploymentReport ;
ALTER TABLE <dbSchema>.OperationNewDeployedVersion ADD CONSTRAINT OPNEWV_DSDeploymentReport FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.DSDeploymentReport ;
ALTER TABLE <dbSchema>.PRJRESOURCE DROP CONSTRAINT FKPRJRESOURCE_STARTV ;
ALTER TABLE <dbSchema>.PRJRESOURCE ADD CONSTRAINT FKPRJRESOURCE_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.RPLFTRGT DROP CONSTRAINT RPLFTRGT_RulePackage ;
ALTER TABLE <dbSchema>.RPLFTRGT ADD CONSTRAINT RPLFTRGT_RulePackage FOREIGN KEY (ID) REFERENCES <dbSchema>.RulePackage ;
ALTER TABLE <dbSchema>.Ruleflow DROP CONSTRAINT FKRuleflow_STARTV ;
ALTER TABLE <dbSchema>.Ruleflow ADD CONSTRAINT FKRuleflow_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.RuleflowSIBLING DROP CONSTRAINT FKRuleflow ;
ALTER TABLE <dbSchema>.RuleflowSIBLING ADD CONSTRAINT FKRuleflow FOREIGN KEY (ID) REFERENCES <dbSchema>.RULEFLOW ;
ALTER TABLE <dbSchema>.Operation DROP CONSTRAINT FKOperation_STARTV ;
ALTER TABLE <dbSchema>.Operation ADD CONSTRAINT FKOperation_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.DepOperation DROP CONSTRAINT FKDEPOP_STARTV ;
ALTER TABLE <dbSchema>.DepOperation ADD CONSTRAINT FKDEPOP_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.DepOperationProperty DROP CONSTRAINT FKDEPOPPROP_STARTV ;
ALTER TABLE <dbSchema>.DepOperationProperty ADD CONSTRAINT FKDEPOPPROP_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.OperationTag DROP CONSTRAINT FKOPTAG_STARTV ;
ALTER TABLE <dbSchema>.OperationTag ADD CONSTRAINT FKOPTAG_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.RuleflowTag DROP CONSTRAINT FKRuleflowTag_STARTV ;
ALTER TABLE <dbSchema>.RuleflowTag ADD CONSTRAINT FKRuleflowTag_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.ScenarioSuite DROP CONSTRAINT FKSCSUITE_STARTV ;
ALTER TABLE <dbSchema>.ScenarioSuite ADD CONSTRAINT FKSCSUITE_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.ScenarioSuiteResource DROP CONSTRAINT FKSCSUITERS_STARTV ;
ALTER TABLE <dbSchema>.ScenarioSuiteResource ADD CONSTRAINT FKSCSUITERS_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.Task DROP CONSTRAINT FKTask_STARTV ;
ALTER TABLE <dbSchema>.Task ADD CONSTRAINT FKTask_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.Template DROP CONSTRAINT FKTemplate_STARTV ;
ALTER TABLE <dbSchema>.Template ADD CONSTRAINT FKTemplate_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.InitialValue DROP CONSTRAINT FKInitialValue_STARTV ;
ALTER TABLE <dbSchema>.InitialValue ADD CONSTRAINT FKInitialValue_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.RuleArtifact DROP CONSTRAINT FKRuleArtifact_STARTV ;
ALTER TABLE <dbSchema>.RuleArtifact ADD CONSTRAINT FKRuleArtifact_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.RuleArtifactSIBLING DROP CONSTRAINT FKRuleArtifact ;
ALTER TABLE <dbSchema>.RuleArtifactSIBLING ADD CONSTRAINT FKRuleArtifact FOREIGN KEY (ID) REFERENCES <dbSchema>.RuleArtifact ;
ALTER TABLE <dbSchema>.ActivityCommentAccess DROP CONSTRAINT ACMTACCES_BSLN ;
ALTER TABLE <dbSchema>.ActivityCommentAccess ADD CONSTRAINT ACMTACCES_BSLN FOREIGN KEY (branch) REFERENCES <dbSchema>.Baseline ;
ALTER TABLE <dbSchema>.ActivityCommentAccess DROP CONSTRAINT ACMTACCES_ACOMMENT ;
ALTER TABLE <dbSchema>.ActivityCommentAccess ADD CONSTRAINT ACMTACCES_ACOMMENT FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ActivityComment ;
ALTER TABLE <dbSchema>.ActivityCommentAttachment DROP CONSTRAINT ACMTATCHMT_ACOMMENT ;
ALTER TABLE <dbSchema>.ActivityCommentAttachment ADD CONSTRAINT ACMTATCHMT_ACOMMENT FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ActivityComment ;
ALTER TABLE <dbSchema>.ActivityCommentLink DROP CONSTRAINT ACMTLINK_ACOMMENT ;
ALTER TABLE <dbSchema>.ActivityCommentLink ADD CONSTRAINT ACMTLINK_ACOMMENT FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.ActivityComment ;
ALTER TABLE <dbSchema>.ActivitySubscription DROP CONSTRAINT ACMTSUBSCR_RuleArtifact ;
ALTER TABLE <dbSchema>.ActivitySubscription ADD CONSTRAINT ACMTSUBSCR_RuleArtifact FOREIGN KEY (srcRule) REFERENCES <dbSchema>.RuleArtifact ;
ALTER TABLE <dbSchema>.Argument DROP CONSTRAINT FKArgument_STARTV ;
ALTER TABLE <dbSchema>.Argument ADD CONSTRAINT FKArgument_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.DEFINITION DROP CONSTRAINT FKDefinition_STARTV ;
ALTER TABLE <dbSchema>.DEFINITION ADD CONSTRAINT FKDefinition_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.OverriddenRule DROP CONSTRAINT FKOverriddenRule_STARTV ;
ALTER TABLE <dbSchema>.OverriddenRule ADD CONSTRAINT FKOverriddenRule_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.RuleArtifactTag DROP CONSTRAINT FKRULARTTAG_STARTV ;
ALTER TABLE <dbSchema>.RuleArtifactTag ADD CONSTRAINT FKRULARTTAG_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.ScopeElement DROP CONSTRAINT FKScopeElement_STARTV ;
ALTER TABLE <dbSchema>.ScopeElement ADD CONSTRAINT FKScopeElement_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VSINPUTDATA DROP CONSTRAINT FKVSINPUTDATA_STARTV ;
ALTER TABLE <dbSchema>.VSINPUTDATA ADD CONSTRAINT FKVSINPUTDATA_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VSKPI DROP CONSTRAINT FKVSKPI_STARTV ;
ALTER TABLE <dbSchema>.VSKPI ADD CONSTRAINT FKVSKPI_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VSMETRIC DROP CONSTRAINT FKVSMETRIC_STARTV ;
ALTER TABLE <dbSchema>.VSMETRIC ADD CONSTRAINT FKVSMETRIC_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VSMODEL DROP CONSTRAINT FKVSMODEL_STARTV ;
ALTER TABLE <dbSchema>.VSMODEL ADD CONSTRAINT FKVSMODEL_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VSCONFIG DROP CONSTRAINT FKVSCONFIG_STARTV ;
ALTER TABLE <dbSchema>.VSCONFIG ADD CONSTRAINT FKVSCONFIG_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VSREPORT DROP CONSTRAINT reportSRBslnRef ;
ALTER TABLE <dbSchema>.VSREPORT ADD CONSTRAINT reportSRBslnRef FOREIGN KEY (reportBaseline) REFERENCES <dbSchema>.Baseline ;
ALTER TABLE <dbSchema>.VTREPORT DROP CONSTRAINT reportTRBslnRef ;
ALTER TABLE <dbSchema>.VTREPORT ADD CONSTRAINT reportTRBslnRef FOREIGN KEY (reportBaseline) REFERENCES <dbSchema>.Baseline ;
ALTER TABLE <dbSchema>.VTDETAIL DROP CONSTRAINT VTDETAIL_VTREPORT ;
ALTER TABLE <dbSchema>.VTDETAIL ADD CONSTRAINT VTDETAIL_VTREPORT FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.VTREPORT ;
ALTER TABLE <dbSchema>.VTROINFO DROP CONSTRAINT VTROINFO_VTREPORT ;
ALTER TABLE <dbSchema>.VTROINFO ADD CONSTRAINT VTROINFO_VTREPORT FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.VTREPORT ;
ALTER TABLE <dbSchema>.VTRTSINFO DROP CONSTRAINT VTRTSINFO_VTREPORT ;
ALTER TABLE <dbSchema>.VTRTSINFO ADD CONSTRAINT VTRTSINFO_VTREPORT FOREIGN KEY (CONTAINER) REFERENCES <dbSchema>.VTREPORT ;
ALTER TABLE <dbSchema>.VTSUITE DROP CONSTRAINT FKVTSUITE_STARTV ;
ALTER TABLE <dbSchema>.VTSUITE ADD CONSTRAINT FKVTSUITE_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VTCRESOURCE DROP CONSTRAINT FKVTCRESOURCE_STARTV ;
ALTER TABLE <dbSchema>.VTCRESOURCE ADD CONSTRAINT FKVTCRESOURCE_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VTCASE DROP CONSTRAINT FKVTCASE_STARTV ;
ALTER TABLE <dbSchema>.VTCASE ADD CONSTRAINT FKVTCASE_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VARIABLESET DROP CONSTRAINT FKVariableSet_STARTV ;
ALTER TABLE <dbSchema>.VARIABLESET ADD CONSTRAINT FKVariableSet_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.OPERATIONVARIABLE DROP CONSTRAINT FKOPVARIABLE_STARTV ;
ALTER TABLE <dbSchema>.OPERATIONVARIABLE ADD CONSTRAINT FKOPVARIABLE_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VARIABLE DROP CONSTRAINT FKVARIABLE_STARTV ;
ALTER TABLE <dbSchema>.VARIABLE ADD CONSTRAINT FKVARIABLE_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
ALTER TABLE <dbSchema>.VOCABULARY DROP CONSTRAINT FKVocabulary_STARTV ;
ALTER TABLE <dbSchema>.VOCABULARY ADD CONSTRAINT FKVocabulary_STARTV FOREIGN KEY (STARTID) REFERENCES <dbSchema>.VERSION ;
CREATE INDEX FKACOMMENTprntIDX ON <dbSchema>.ActivityComment (parent) ;
DROP VIEW <dbSchema>.baselineDTLS ;
CREATE VIEW <dbSchema>.BaselineDTLS
AS
SELECT <dbSchema>.Baseline.ID,
	<dbSchema>.Baseline.type,
	<dbSchema>.Baseline.CONTAINER,
	<dbSchema>.Baseline.parent,
	<dbSchema>.Baseline.maxVersionId,
	<dbSchema>.Baseline.name,
	<dbSchema>.Baseline.baselineKind,
	<dbSchema>.Baseline.createdBy,
	<dbSchema>.Baseline.createdOn,
	<dbSchema>.Baseline.lastChangedBy,
	<dbSchema>.Baseline.lastChangedOn,
	<dbSchema>.Baseline.uuid,
	<dbSchema>.BSLNLFTRGT.LFT,
	<dbSchema>.BSLNLFTRGT.RGT
FROM <dbSchema>.Baseline,
	<dbSchema>.BSLNLFTRGT
WHERE <dbSchema>.Baseline.ID = <dbSchema>.BSLNLFTRGT.ID;
