define([
    // Standard Dojo modules for widget
    "dojo/_base/declare",
    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin",
    // The template
    "dojo/text!./templates/YesNoCheckBoxEditor.html",
    // Modules required by properties view
    "idx/form/_CssStateMixin",
    "idx/form/_CompositeMixin",
    "idx/form/_ValidationMixin",
    "pvr/widget/editors/mixins/_EditorMixin"
], function(declare, _WidgetBase, _TemplatedMixin, template,
    _CssStateMixin, _CompositeMixin, _ValidationMixin, _EditorMixin)
{
    // Define the custom editor class. 
    return declare("custom.editor.YesNoCheckBoxEditor", [ 
            _WidgetBase, _TemplatedMixin, 
            _CssStateMixin, _CompositeMixin, _ValidationMixin, 
            _EditorMixin], 
    {
        // Standard Dojo practices
        // Loading the template.
        templateString: template,
        
        // Custom mouse click handlers to avoid both options are checked.
        _onYesClick: function(nodeBeingChecked) {
            this.noNode.checked = false;
        },
        _onNoClick: function(nodeBeingChecked) {
            this.yesNode.checked = false;
        },
        
        // Properties view required methods.
        // The class to apply CSS. Must be set even if you don't want your custom CSS.
        oneuiBaseClass: "customYesNoCheckBoxEditor",
        
        // Register the basic events for the widget
        postCreate: function(){
            this._event = {
                "input" : "onChange",
                "blur"     : "_onBlur",
                "focus" : "_onFocus"
            }
            this.inherited(arguments);
        },
        
        // Provide the value attribute for controller to get and set the value from the editor.
        _setValueAttr: function(_val) {
            if (typeof _val === "undefined" || _val == null) {
                // The input value is neither yes nor no, uncheck both boxes.
                this.yesNode.checked = false;
                this.noNode.checked = false;
            } else if (_val) {
                // The input value is yes, check the yes box and uncheck the no box.
                this.yesNode.checked = true;
                this.noNode.checked = false;
            } else {
                // The input value is no, check the no box and uncheck the yes box.
                this.yesNode.checked = false;
                this.noNode.checked = true;
            }
        },
        _getValueAttr: function() {
            if (this.yesNode.checked) {
                return true;
            } else if (this.noNode.checked) {
                return false;
            } else {
                return null;
            }
        }
    });
});
