/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class MessageResources
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static MessageResources messageResources;
    private Map<String, MessageFormat> formats = new HashMap<String, MessageFormat>();
    private Map<String, String> locales = new HashMap<String, String>();
    private Map<String, String> messages = new HashMap<String, String>();
    private String resourceConfigFile;

    public static synchronized MessageResources getMessageResources(String messageProperties) {
        if (messageResources == null) {
            messageResources = new MessageResources(messageProperties);
        }
        return messageResources;
    }

    private MessageResources(String config) {
        this.resourceConfigFile = config;
    }

    public final String getConfig() {
        return this.resourceConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getMessage(Locale locale, String key) {
        Map<String, String> map;
        String localeKey = this.localeKey(locale);
        String originalKey = this.messageKey(localeKey, key);
        String messageKey = null;
        String message = null;
        int underscore = 0;
        boolean addMessage = false;
        while (true) {
            this.loadMessageResourceForLocale(localeKey);
            messageKey = this.messageKey(localeKey, key);
            map = this.messages;
            synchronized (map) {
                message = this.messages.get(messageKey);
                if (message != null) {
                    if (addMessage) {
                        this.messages.put(originalKey, message);
                    }
                    return message;
                }
                addMessage = true;
            }
            underscore = localeKey.lastIndexOf("_");
            if (underscore < 0) break;
            localeKey = localeKey.substring(0, underscore);
        }
        localeKey = "";
        messageKey = this.messageKey(localeKey, key);
        this.loadMessageResourceForLocale(localeKey);
        map = this.messages;
        synchronized (map) {
            message = this.messages.get(messageKey);
            if (message != null) {
                this.messages.put(originalKey, message);
                return message;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getMessage(Locale locale, String key, Object[] args) {
        MessageFormat format = null;
        String messageKey = this.messageKey(this.localeKey(locale), key);
        Map<String, MessageFormat> map = this.formats;
        synchronized (map) {
            format = this.formats.get(messageKey);
            if (format == null) {
                String formatString = this.getMessage(locale, key);
                if (formatString == null) {
                    return null;
                }
                format = new MessageFormat(this.escape(formatString));
                this.formats.put(messageKey, format);
            }
        }
        return format.format(args);
    }

    public final String getMessage(Locale locale, String key, Object arg0) {
        Object[] args = new Object[]{arg0};
        return this.getMessage(locale, key, args);
    }

    public final String getMessage(Locale locale, String key, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        return this.getMessage(locale, key, args);
    }

    public final String getMessage(Locale locale, String key, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        return this.getMessage(locale, key, args);
    }

    public final String getMessage(Locale locale, String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        return this.getMessage(locale, key, args);
    }

    public final String getMessage(String key) {
        return this.getMessage((Locale)null, key);
    }

    public final String getMessage(String key, Object arg0) {
        return this.getMessage((Locale)null, key, arg0);
    }

    public final String getMessage(String key, Object arg0, Object arg1) {
        return this.getMessage((Locale)null, key, arg0, arg1);
    }

    public final String getMessage(String key, Object arg0, Object arg1, Object arg2) {
        return this.getMessage((Locale)null, key, arg0, arg1, arg2);
    }

    public final String getMessage(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return this.getMessage(null, key, arg0, arg1, arg2, arg3);
    }

    public final String getMessage(String key, Object[] args) {
        return this.getMessage((Locale)null, key, args);
    }

    private final InputStream getResourceAsStreamFromClassLoader(String resourceFileName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader.getResourceAsStream(resourceFileName);
    }

    private final synchronized void loadMessageResourceForLocale(String localeKey) {
        if (this.locales.get(localeKey) != null) {
            return;
        }
        this.locales.put(localeKey, localeKey);
        String name = this.resourceConfigFile.replace('.', '/');
        if (localeKey.length() > 0) {
            name = name + "_" + localeKey;
        }
        name = name + ".properties";
        Properties props = new Properties();
        InputStream is = this.getResourceAsStreamFromClassLoader(name);
        if (is != null) {
            try {
                props.load(is);
                for (String string : props.keySet()) {
                    this.messages.put(this.messageKey(localeKey, string), props.getProperty(string));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private final String localeKey(Locale locale) {
        return locale == null ? "" : locale.toString();
    }

    private final String messageKey(String localeKey, String key) {
        return localeKey + "." + key;
    }

    private final String escape(String string) {
        if (string == null || string.indexOf(39) < 0) {
            return string;
        }
        int n = string.length();
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char ch = string.charAt(i);
            if (ch == '\'') {
                sb.append('\'');
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

