/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.java.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Serializer {
    private Writer writer;

    public Serializer(Writer writer) {
        this.writer = writer;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public Serializer writeRawString(String s) throws IOException {
        this.writer.write(s);
        return this;
    }

    public Serializer writeNull() throws IOException {
        this.writeRawString("null");
        return this;
    }

    public Serializer writeNumber(Number value) throws IOException {
        if (null == value) {
            return this.writeNull();
        }
        if (value instanceof Float) {
            if (((Float)value).isNaN()) {
                return this.writeNull();
            }
            if (Float.NEGATIVE_INFINITY == value.floatValue()) {
                return this.writeNull();
            }
            if (Float.POSITIVE_INFINITY == value.floatValue()) {
                return this.writeNull();
            }
        }
        if (value instanceof Double) {
            if (((Double)value).isNaN()) {
                return this.writeNull();
            }
            if (Double.NEGATIVE_INFINITY == value.doubleValue()) {
                return this.writeNull();
            }
            if (Double.POSITIVE_INFINITY == value.doubleValue()) {
                return this.writeNull();
            }
        }
        this.writeRawString(value.toString());
        return this;
    }

    public Serializer writeBoolean(Boolean value) throws IOException {
        if (null == value) {
            return this.writeNull();
        }
        this.writeRawString(value.toString());
        return this;
    }

    private String rightAlignedZero(String s, int len) {
        if (len == s.length()) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s);
        while (sb.length() < len) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public Serializer writeString(String value) throws IOException {
        if (null == value) {
            return this.writeNull();
        }
        this.writer.write(34);
        char[] chars = value.toCharArray();
        block11: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block11;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block11;
                }
                case '\u0000': {
                    this.writer.write("\\0");
                    continue block11;
                }
                case '\b': {
                    this.writer.write("\\b");
                    continue block11;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block11;
                }
                case '\n': {
                    this.writer.write("\\n");
                    continue block11;
                }
                case '\f': {
                    this.writer.write("\\f");
                    continue block11;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block11;
                }
                case '/': {
                    this.writer.write("\\/");
                    continue block11;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        this.writer.write(c);
                        continue block11;
                    }
                    this.writer.write("\\u");
                    this.writer.write(this.rightAlignedZero(Integer.toHexString(c), 4));
                }
            }
        }
        this.writer.write(34);
        return this;
    }

    private Serializer write(Object object) throws IOException {
        if (null == object) {
            return this.writeNull();
        }
        if (object instanceof Number) {
            return this.writeNumber((Number)object);
        }
        if (object instanceof String) {
            return this.writeString((String)object);
        }
        if (object instanceof Boolean) {
            return this.writeBoolean((Boolean)object);
        }
        if (object instanceof JSONObject) {
            return this.writeObject((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return this.writeArray((JSONArray)object);
        }
        throw new IOException("Attempting to serialize unserializable object: '" + object + "'");
    }

    public Serializer writeObject(JSONObject object) throws IOException {
        if (null == object) {
            return this.writeNull();
        }
        this.writeRawString("{");
        this.indentPush();
        Iterator iter = null;
        if (object instanceof OrderedJSONObject) {
            iter = ((OrderedJSONObject)object).getOrder();
        } else {
            List propertyNames = this.getPropertyNames(object);
            iter = propertyNames.iterator();
        }
        while (iter.hasNext()) {
            Object key = iter.next();
            if (!(key instanceof String)) {
                throw new IOException("attempting to serialize object with an invalid property name: '" + key + "'");
            }
            Object value = object.get(key);
            if (!JSONObject.isValidObject(value)) {
                throw new IOException("attempting to serialize object with an invalid property value: '" + value + "'");
            }
            this.newLine();
            this.indent();
            this.writeString((String)key);
            this.writeRawString(":");
            this.space();
            this.write(value);
            if (!iter.hasNext()) continue;
            this.writeRawString(",");
        }
        this.indentPop();
        this.newLine();
        this.indent();
        this.writeRawString("}");
        return this;
    }

    public Serializer writeArray(JSONArray value) throws IOException {
        if (null == value) {
            return this.writeNull();
        }
        this.writeRawString("[");
        this.indentPush();
        Iterator iter = value.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!JSONObject.isValidObject(element)) {
                throw new IOException("attempting to serialize array with an invalid element: '" + value + "'");
            }
            this.newLine();
            this.indent();
            this.write(element);
            if (!iter.hasNext()) continue;
            this.writeRawString(",");
        }
        this.indentPop();
        this.newLine();
        this.indent();
        this.writeRawString("]");
        return this;
    }

    public void space() throws IOException {
    }

    public void newLine() throws IOException {
    }

    public void indent() throws IOException {
    }

    public void indentPush() {
    }

    public void indentPop() {
    }

    public List getPropertyNames(Map map) {
        return new ArrayList(map.keySet());
    }
}

