/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.json.java;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;

public class JSON {
    public static JSONArtifact parse(Reader reader, boolean order) throws IOException, NullPointerException {
        if (reader != null) {
            PushbackReader pReader = null;
            boolean bufferIt = false;
            Class<?> readerClass = reader.getClass();
            if (!(StringReader.class.isAssignableFrom(readerClass) || CharArrayReader.class.isAssignableFrom(readerClass) || PushbackReader.class.isAssignableFrom(readerClass) || BufferedReader.class.isAssignableFrom(readerClass))) {
                bufferIt = true;
            }
            pReader = PushbackReader.class.isAssignableFrom(readerClass) ? (PushbackReader)reader : new PushbackReader(reader);
            Reader rdr = pReader;
            int ch = pReader.read();
            block5: while (ch != -1) {
                switch (ch) {
                    case 123: {
                        pReader.unread(ch);
                        if (bufferIt) {
                            rdr = new BufferedReader(pReader);
                        }
                        if (order) {
                            return OrderedJSONObject.parse(rdr);
                        }
                        return JSONObject.parse(rdr);
                    }
                    case 91: {
                        pReader.unread(ch);
                        if (bufferIt) {
                            rdr = new BufferedReader(pReader);
                        }
                        return JSONArray.parse(rdr);
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 32: {
                        ch = pReader.read();
                        continue block5;
                    }
                }
                throw new IOException("Unexpected character: [" + (char)ch + "] while scanning JSON String for JSON type.  Invalid JSON.");
            }
            throw new IOException("Encountered end of stream before JSON data was read.  Invalid JSON");
        }
        throw new NullPointerException("reader cannot be null.");
    }

    public static JSONArtifact parse(Reader reader) throws IOException, NullPointerException {
        return JSON.parse(reader, false);
    }

    public static JSONArtifact parse(InputStream is, boolean order) throws IOException, NullPointerException {
        if (is != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            }
            catch (Exception ex) {
                IOException iox = new IOException("Could not construct UTF-8 character reader for the InputStream");
                iox.initCause(ex);
                throw iox;
            }
            return JSON.parse(reader, order);
        }
        throw new NullPointerException("is cannot be null");
    }

    public static JSONArtifact parse(InputStream is) throws IOException, NullPointerException {
        return JSON.parse(is, false);
    }

    public static JSONArtifact parse(String str, boolean order) throws IOException, NullPointerException {
        if (str != null) {
            return JSON.parse(new StringReader(str), order);
        }
        throw new NullPointerException("str cannot be null");
    }

    public static JSONArtifact parse(String str) throws IOException, NullPointerException {
        return JSON.parse(str, false);
    }
}

