/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.serviceability;

import com.ibm.ecm.jaxrs.GlobalConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Logger {
    private static final String applicationId = "CIWEB";
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_PERF = 3;
    public static final int LOG_DEBUG = 4;
    public static final int LOG_ENTRY = 5;
    public static final int LOG_EXIT = 6;
    public static final int LOG_DEV = 7;
    protected static int logLevel = 3;
    private static String[] _loggingIncludes = null;
    private static String[] _loggingExcludes = null;
    private static String[] _userIds = null;
    private static String[] _hostNames = null;
    public static boolean enableTimestamps = true;
    public static boolean validateHttp = true;
    public static final String SESSION_REMOTE_HOST = "session_remote_host";
    public static final String PARM_USERID = "userid";
    public static final String PARM_REPOSITORY_ID = "repositoryId";
    public static final String SESSION_USERID = "session_userid";
    private static LoggingContext NULL_CONTEXT = new LoggingContext(null, null, null);
    private static Map<Thread, SharedDateFormats> localData = Collections.synchronizedMap(new WeakHashMap());

    public static String getAppId() {
        return applicationId;
    }

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    private static SimpleDateFormat getLogDateFormat() {
        SharedDateFormats sharedDateFormats = localData.get(Thread.currentThread());
        if (sharedDateFormats == null) {
            sharedDateFormats = new SharedDateFormats();
            localData.put(Thread.currentThread(), sharedDateFormats);
        }
        return sharedDateFormats.logDateFormat;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogIncludes(HttpServletRequest request, String includes) {
        String methodName = "setLogIncludes";
        if (includes != null && includes.length() > 0) {
            String[] result = includes.split(",");
            _loggingIncludes = new String[result.length];
            int y = 0;
            for (int i = 0; i < result.length; ++i) {
                if (result == null || result[i] == null || result[i].length() <= 0) continue;
                Logger.logDebug(Logger.class, methodName, (ServletRequest)request, "logging.class.includes[" + i + "]: " + result[i]);
                Logger._loggingIncludes[y++] = result[i];
            }
        }
    }

    public static String[] getLoggingIncludes() {
        if (_loggingIncludes == null || _loggingIncludes.length == 0) {
            return null;
        }
        return _loggingIncludes;
    }

    public static void setLogExcludes(HttpServletRequest request, String excludes) {
        String methodName = "setLogExcludes";
        if (excludes != null && excludes.length() > 0) {
            String[] result = excludes.split(",");
            _loggingExcludes = new String[result.length];
            int y = 0;
            for (int i = 0; i < result.length; ++i) {
                if (result == null || result[i] == null || result[i].length() <= 0) continue;
                Logger.logDebug(Logger.class, methodName, (ServletRequest)request, "logging.class.excludes[" + i + "]: " + result[i]);
                Logger._loggingExcludes[y++] = result[i];
            }
        }
    }

    public static String[] getLoggingExcludes() {
        if (_loggingExcludes == null || _loggingExcludes.length == 0) {
            return null;
        }
        return _loggingExcludes;
    }

    public static void setLogUserIds(HttpServletRequest request, String userIds) {
        String methodName = "setLogUserIds";
        if (userIds != null && userIds.length() > 0) {
            String[] result = userIds.split(",");
            _userIds = new String[result.length];
            int y = 0;
            for (int i = 0; i < result.length; ++i) {
                if (result == null || result[i] == null || result[i].length() <= 0) continue;
                Logger.logDebug(Logger.class, methodName, (ServletRequest)request, "logging.debug.users[" + i + "]: " + result[i]);
                Logger._userIds[y++] = result[i];
            }
        }
    }

    public static String[] getLoggingUserIds() {
        if (_userIds == null || _userIds.length == 0) {
            return null;
        }
        return _userIds;
    }

    public static void setLogHostNames(HttpServletRequest request, String hostNames) {
        String methodName = "setLogHostNames";
        if (hostNames != null && hostNames.length() > 0) {
            String[] result = hostNames.split(",");
            _hostNames = new String[result.length];
            int y = 0;
            for (int i = 0; i < result.length; ++i) {
                if (result == null || result[i] == null || result[i].length() <= 0) continue;
                Logger.logDebug(Logger.class, methodName, (ServletRequest)request, "logging.debug.hosts[" + i + "]: " + result[i]);
                Logger._hostNames[y++] = result[i];
            }
        }
    }

    public static String[] getLoggingHostNames() {
        if (_hostNames == null || _hostNames.length == 0) {
            return null;
        }
        return _hostNames;
    }

    public static Date logEntry(Object loggingObject, String methodName, ServletRequest request) {
        return Logger._log(Logger.getAppId(), 5, Logger.getLogLevel(), loggingObject, methodName, "", request, null, null, null, true);
    }

    public static Date logEntry(Object loggingObject, String methodName, ServletRequest request, String message) {
        return Logger._log(Logger.getAppId(), 5, Logger.getLogLevel(), loggingObject, methodName, message, request, null, null, null, true);
    }

    public static Date logEntry(Object loggingObject, String methodName, LoggingContext loggingContext) {
        return Logger._log(Logger.getAppId(), 5, Logger.getLogLevel(), loggingObject, methodName, "", loggingContext, null, true);
    }

    public static Date logEntry(Object loggingObject, String methodName, LoggingContext loggingContext, String message) {
        return Logger._log(Logger.getAppId(), 5, Logger.getLogLevel(), loggingObject, methodName, message, loggingContext, null, true);
    }

    public static Date logEntry(Object loggingObject, String methodName, HttpSession session) {
        return Logger._log(Logger.getAppId(), 5, Logger.getLogLevel(), loggingObject, methodName, "Entry", null, session, null, null, true);
    }

    public static Date logEntry(Object loggingObject, String methodName, HttpSession session, String message) {
        return Logger._log(Logger.getAppId(), 5, Logger.getLogLevel(), loggingObject, methodName, message, null, session, null, null, true);
    }

    public static void logExit(Object loggingObject, String methodName, ServletRequest request) {
        Logger._log(Logger.getAppId(), 6, Logger.getLogLevel(), loggingObject, methodName, "", request, null, null, null, true);
    }

    public static void logExit(Object loggingObject, String methodName, ServletRequest request, String message) {
        Logger._log(Logger.getAppId(), 6, Logger.getLogLevel(), loggingObject, methodName, message, request, null, null, null, true);
    }

    public static void logExit(Object loggingObject, String methodName, LoggingContext loggingContext) {
        Logger._log(Logger.getAppId(), 6, Logger.getLogLevel(), loggingObject, methodName, "", loggingContext, null, true);
    }

    public static void logExit(Object loggingObject, String methodName, LoggingContext loggingContext, String message) {
        Logger._log(Logger.getAppId(), 6, Logger.getLogLevel(), loggingObject, methodName, message, loggingContext, null, true);
    }

    public static void logExit(Object loggingObject, String methodName, ServletRequest request, Date date) {
        String elapsedInfo = "0";
        long elapsedTime = 0L;
        if (date != null) {
            elapsedTime = System.currentTimeMillis() - date.getTime();
        }
        elapsedInfo = Logger.formatElapsed(elapsedTime);
        Logger._log(Logger.getAppId(), 6, Logger.getLogLevel(), loggingObject, methodName, elapsedInfo, request, null, null, null, true);
    }

    public static void logExit(Object loggingObject, String methodName, ServletRequest request, Date date, String message) {
        String elapsedInfo = "0";
        long elapsedTime = 0L;
        if (date != null) {
            elapsedTime = System.currentTimeMillis() - date.getTime();
        }
        elapsedInfo = Logger.formatElapsed(elapsedTime);
        Logger._log(Logger.getAppId(), 6, Logger.getLogLevel(), loggingObject, methodName, elapsedInfo + " - " + message, request, null, null, null, true);
    }

    public static void logExit(Object loggingObject, String methodName, HttpSession session) {
        Logger._log(Logger.getAppId(), 6, Logger.getLogLevel(), loggingObject, methodName, "Exit", null, session, null, null, true);
    }

    public static void logExit(Object loggingObject, String methodName, HttpSession session, String message) {
        Logger._log(Logger.getAppId(), 6, Logger.getLogLevel(), loggingObject, methodName, message, null, session, null, null, true);
    }

    public static void logError(Object loggingObject, String methodName, String text, Throwable exception) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, text, null, null, null, exception, true);
    }

    public static void logError(Object loggingObject, String methodName, String text, LoggingContext loggingContext, Throwable exception) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, text, loggingContext, exception, true);
    }

    public static void logError(Object loggingObject, String methodName, ServletRequest request, String text) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, text, request, null, null, null, true);
    }

    public static void logError(Object loggingObject, String methodName, LoggingContext loggingContext, String text) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, text, loggingContext, null, true);
    }

    public static void logError(Object loggingObject, String methodName, HttpSession session, String text) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, text, null, session, null, null, true);
    }

    public static void logError(Object loggingObject, String methodName, ServletRequest request, Throwable exception) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, null, request, null, null, exception, true);
    }

    public static void logError(Object loggingObject, String methodName, HttpSession session, Throwable exception) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, null, null, session, null, exception, true);
    }

    public static void logError(Object loggingObject, String methodName, LoggingContext loggingContext, Throwable exception) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, null, loggingContext, exception, true);
    }

    public static void logError(Object loggingObject, String methodName, HttpSession session, String text, Throwable exception) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, text, null, session, null, exception, true);
    }

    public static void logError(Object loggingObject, String methodName, ServletRequest request, String text, Throwable exception) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, text, request, null, null, exception, true);
    }

    public static void logError(Object loggingObject, String methodName, LoggingContext loggingContext, String text, Throwable exception) {
        Logger._log(Logger.getAppId(), 1, Logger.getLogLevel(), loggingObject, methodName, text, loggingContext, exception, true);
    }

    public static void logWarning(Object loggingObject, String methodName, ServletRequest request, String text) {
        Logger._log(Logger.getAppId(), 2, Logger.getLogLevel(), loggingObject, methodName, text, request, null, null, null, true);
    }

    public static void logWarning(Object loggingObject, String methodName, LoggingContext loggingContext, String text) {
        Logger._log(Logger.getAppId(), 2, Logger.getLogLevel(), loggingObject, methodName, text, loggingContext, null, true);
    }

    public static void logWarning(Object loggingObject, String methodName, HttpSession session, String text) {
        Logger._log(Logger.getAppId(), 2, Logger.getLogLevel(), loggingObject, methodName, text, null, session, null, null, true);
    }

    public static void logInfo(Object loggingObject, String methodName, ServletRequest request, String text) {
        Logger._log(Logger.getAppId(), 3, Logger.getLogLevel(), loggingObject, methodName, text, request, null, null, null, true);
    }

    public static void logInfo(Object loggingObject, String methodName, LoggingContext loggingContext, String text) {
        Logger._log(Logger.getAppId(), 3, Logger.getLogLevel(), loggingObject, methodName, text, loggingContext, null, true);
    }

    public static void logInfo(Object loggingObject, String methodName, HttpSession session, String text) {
        Logger._log(Logger.getAppId(), 3, Logger.getLogLevel(), loggingObject, methodName, text, null, session, null, null, true);
    }

    public static Date logPerf(Object loggingObject, String methodName, ServletRequest request) {
        return Logger._log(Logger.getAppId(), 3, Logger.getLogLevel(), loggingObject, methodName, "", request, null, null, new Exception(), true);
    }

    public static Date logPerf(Object loggingObject, String methodName, ServletRequest request, String message) {
        return Logger._log(Logger.getAppId(), 3, Logger.getLogLevel(), loggingObject, methodName, message, request, null, null, new Exception(), true);
    }

    public static Date logPerf(Object loggingObject, String methodName, ServletRequest request, Date date) {
        String elapsedInfo = "0";
        long elapsedTime = 0L;
        if (date != null) {
            elapsedTime = System.currentTimeMillis() - date.getTime();
        }
        elapsedInfo = Logger.formatElapsed(elapsedTime);
        return Logger._log(Logger.getAppId(), 3, Logger.getLogLevel(), loggingObject, methodName, elapsedInfo, request, null, null, new Exception(), true);
    }

    public static Date logPerf(Object loggingObject, String methodName, ServletRequest request, Date date, String message) {
        String elapsedInfo = "0";
        long elapsedTime = 0L;
        if (date != null) {
            elapsedTime = System.currentTimeMillis() - date.getTime();
        }
        elapsedInfo = Logger.formatElapsed(elapsedTime);
        return Logger._log(Logger.getAppId(), 3, Logger.getLogLevel(), loggingObject, methodName, elapsedInfo + " - " + message, request, null, null, new Exception(), true);
    }

    public static String formatElapsed(long millis) {
        StringBuffer sb = new StringBuffer();
        long tlSeconds = millis / 1000L;
        int minutes = (int)tlSeconds / 60;
        int minuteSeconds = minutes * 60;
        int leftoverSeconds = (int)tlSeconds - minuteSeconds;
        int milliseconds = (int)millis % 1000;
        String formattedMillis = String.format("%03d", milliseconds);
        sb.append("(elapsed time: ").append(minutes).append(":").append(leftoverSeconds).append(".").append(formattedMillis).append(")");
        return sb.toString();
    }

    public static boolean isDebugLogged() {
        return Logger.getLogLevel() >= 4;
    }

    public static void logDebug(Object loggingObject, String methodName, ServletRequest request, String message) {
        Logger._log(Logger.getAppId(), 4, Logger.getLogLevel(), loggingObject, methodName, message, request, null, null, null, true);
    }

    public static void logDebug(Object loggingObject, String methodName, LoggingContext loggingContext, String message) {
        Logger._log(Logger.getAppId(), 4, Logger.getLogLevel(), loggingObject, methodName, message, loggingContext, null, true);
    }

    public static void logDebug(Object loggingObject, String methodName, HttpSession session, String text) {
        Logger._log(Logger.getAppId(), 4, Logger.getLogLevel(), loggingObject, methodName, text, null, session, null, null, true);
    }

    public static void logDebug(Object loggingObject, String methodName, ServletContext context, String text) {
        Logger._log(Logger.getAppId(), 4, Logger.getLogLevel(), loggingObject, methodName, text, null, null, context, null, true);
    }

    private static boolean isNameInList(String name, String[] list) {
        boolean found = false;
        if (name != null && list != null && list.length > 0) {
            for (String listName : list) {
                if (listName == null || !name.equalsIgnoreCase(listName)) continue;
                return true;
            }
        }
        return found;
    }

    private static boolean isDebugLoggingUser(String userid) {
        return userid != null && Logger.isNameInList(userid, Logger.getLoggingUserIds());
    }

    private static boolean isDebugLoggingHost(String remoteHost) {
        return remoteHost != null && Logger.isNameInList(remoteHost, Logger.getLoggingHostNames());
    }

    public static Date _log(String appId, int type, int level, Object loggingObject, String methodName, String text, ServletRequest request, HttpSession session, ServletContext context, Throwable exception, boolean validate) {
        LoggingContext loggingContext = new LoggingContext(request, session, context);
        return Logger._log(appId, type, level, loggingObject, methodName, text, loggingContext, exception, validate);
    }

    private static Date _log(String appId, int type, int level, Object loggingObject, String methodName, String text, LoggingContext loggingContext, Throwable exception, boolean validate) {
        Date date = null;
        validate = false;
        if (validate && !Logger.validateParams(loggingObject, methodName)) {
            return null;
        }
        int _logType = type;
        int _logLevel = level;
        if (loggingContext == null) {
            loggingContext = NULL_CONTEXT;
        }
        boolean generateTimestamp = Logger.includeTimestamp(loggingContext);
        if (Logger.getLoggingUserIds() != null || Logger.getLoggingHostNames() != null) {
            if (Logger.isDebugLoggingUser(loggingContext.userId) || Logger.isDebugLoggingHost(loggingContext.remoteHost)) {
                _logType = 4;
                _logLevel = 4;
            } else {
                return null;
            }
        }
        if (_logType > _logLevel && _logLevel < 4) {
            return null;
        }
        String loggingObjectName = null;
        if (loggingObject != null && (loggingObjectName = Logger.appendLoggingObjectInfo(loggingObject)) == null) {
            return null;
        }
        date = new Date();
        String timestamp = generateTimestamp ? Logger.getTimestamp(date) : null;
        Logger.__log(appId, type, timestamp, Logger.getFormattedUser(loggingContext), loggingObject, methodName, text, exception);
        return date;
    }

    protected static void __log(String appId, int _logType, String timestamp, String userInfo, Object loggingObject, String methodName, String text, Throwable exception) {
        String exceptionText;
        long reqNo;
        StringBuffer st = new StringBuffer();
        if (enableTimestamps && timestamp != null) {
            st.append("[").append(timestamp).append("] ").append(Logger.getThreadId()).append(" SystemOut  O ");
        }
        st.append(appId);
        if (_logType == 1) {
            st.append(" Error: ");
        } else if (_logType == 2) {
            st.append(" Warn : ");
        } else if (_logType == 3) {
            if (exception != null) {
                st.append(" Perf : ");
            } else {
                st.append(" Info : ");
            }
        } else if (_logType == 4) {
            st.append(" Debug: ");
        } else if (_logType == 5) {
            st.append(" Entry: ");
        } else if (_logType == 6) {
            st.append(" Exit : ");
        } else if (_logType == 7) {
            st.append(" Dev  : ");
        }
        if (userInfo != null) {
            st.append(userInfo);
        }
        if (Logger.isDebugLogged() && (reqNo = GlobalConfiguration.getInstance().getRequestNumber()) != -1L) {
            st.append(" [REQUEST ").append(reqNo).append("]");
        }
        st.append(" ").append(Logger.appendLoggingObjectName(loggingObject));
        st.append(".").append(methodName).append("()");
        if (text != null && text.length() > 0) {
            st.append(" ").append(text);
        }
        if (_logType == 1 && exception != null && (exceptionText = Logger.getStackTraceAsString(exception)) != null && exceptionText.length() > 0) {
            st.append(System.getProperty("line.separator")).append(exceptionText);
        }
        System.out.println(st.toString());
        if (_logType == 1 && exception != null) {
            System.err.println(st.toString());
        }
    }

    private static boolean validateParams(Object loggingObject, String methodName) {
        if (loggingObject == null) {
            System.out.println();
            StackTraceElement[] ste = Thread.currentThread().getStackTrace();
            System.out.println(new StringBuffer().append("Logging error: ").append("CLASS NAME NOT PROVIDED @ ").append(ste[5].toString()));
            System.out.println();
            return false;
        }
        if (methodName == null || methodName.length() == 0) {
            System.out.println();
            StackTraceElement[] ste = Thread.currentThread().getStackTrace();
            System.out.println(new StringBuffer().append("Logging error: ").append("METHOD NAME NOT PROVIDED @ ").append(ste[5].toString()));
            System.out.println();
            return false;
        }
        return true;
    }

    public static String getStackTraceAsString(Throwable exception) {
        if (exception == null) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bytes, true);
        exception.printStackTrace(writer);
        return bytes.toString();
    }

    protected static String appendLoggingObjectInfo(Object loggingObject) {
        if (loggingObject == null) {
            return null;
        }
        return Logger.appendLoggingObjectInfo(Logger.appendLoggingObjectName(loggingObject));
    }

    protected static String appendLoggingObjectName(Object loggingObject) {
        if (loggingObject == null) {
            return null;
        }
        if (loggingObject instanceof Class) {
            return ((Class)loggingObject).getName();
        }
        return loggingObject.getClass().getCanonicalName();
    }

    protected static String appendLoggingObjectInfo(String loggingObjectName) {
        boolean includeMatchFound = false;
        String[] includes = Logger.getLoggingIncludes();
        if (includes != null && includes.length > 0) {
            for (int i = 0; i < includes.length; ++i) {
                String include;
                String string = include = includes[i] != null && includes[i].endsWith("*") ? includes[i].substring(0, includes[i].length() - 1) : includes[i];
                if (include == null || loggingObjectName == null || !loggingObjectName.startsWith(include)) continue;
                includeMatchFound = true;
                break;
            }
        } else {
            includeMatchFound = true;
        }
        boolean excludeMatchFound = false;
        String[] excludes = Logger.getLoggingExcludes();
        if (excludes != null && excludes.length > 0) {
            for (int i = 0; i < excludes.length; ++i) {
                String exclude;
                String string = exclude = excludes[i] != null && excludes[i].endsWith("*") ? excludes[i].substring(0, excludes[i].length() - 1) : excludes[i];
                if (exclude == null || loggingObjectName == null || !loggingObjectName.startsWith(exclude)) continue;
                excludeMatchFound = true;
                break;
            }
        }
        if (!includeMatchFound || excludeMatchFound) {
            return null;
        }
        return loggingObjectName;
    }

    protected static String getTimestamp(Date date) {
        return Logger.getLogDateFormat().format(date).toString();
    }

    private static boolean includeTimestamp(LoggingContext loggingContext) {
        return loggingContext.serverInfo.toUpperCase().indexOf("WEBSPHERE") == -1;
    }

    private static String getThreadId() {
        return String.format("%08x", Thread.currentThread().getId());
    }

    private static String getFormattedUser(LoggingContext loggingContext) {
        return Logger.getFormattedUser(loggingContext.userId, loggingContext.remoteHost);
    }

    public static String getFormattedUser(String userId, String clientHostName) {
        StringBuffer st = new StringBuffer();
        st.append("[");
        st.append(userId != null ? userId : "");
        st.append(" @ ");
        st.append(clientHostName != null ? clientHostName : "");
        st.append("]");
        return st.toString();
    }

    public static class LoggingContext {
        protected String userId = null;
        protected String remoteHost = null;
        protected String serverInfo = null;

        private LoggingContext(ServletRequest request, HttpSession session, ServletContext context) {
            this.initialize(request, session, context);
        }

        public LoggingContext(ServletContext context) {
            this.initialize(null, null, context);
        }

        public LoggingContext(ServletRequest request) {
            this.initialize(request, null, null);
        }

        public LoggingContext(HttpSession session) {
            this.initialize(null, session, null);
        }

        private void initialize(ServletRequest request, HttpSession session, ServletContext context) {
            this.userId = this.getUserId(request, session);
            this.remoteHost = this.getRemoteHost(request, session);
            this.serverInfo = this.getServerInfo(request, session, context);
        }

        private String getServerInfo(ServletRequest request, HttpSession session, ServletContext context) {
            String serverInfo = "";
            HttpSession _session = session;
            if (session == null && request != null && request instanceof HttpServletRequest && (_session = ((HttpServletRequest)request).getSession(false)) == null) {
                serverInfo = "WebSphere";
            }
            if (_session != null && _session.getServletContext() != null) {
                serverInfo = _session.getServletContext().getServerInfo();
            } else if (context != null) {
                serverInfo = context.getServerInfo();
            }
            return serverInfo;
        }

        private String getUserId(ServletRequest request, HttpSession session) {
            String userid = null;
            try {
                String string = userid = request != null ? (String)request.getAttribute(Logger.PARM_USERID) : null;
                if (userid == null) {
                    String string2 = userid = request != null ? request.getParameter(Logger.PARM_USERID) : null;
                }
                if (userid == null || userid.length() == 0) {
                    HttpSession _session = null;
                    if (request != null) {
                        _session = ((HttpServletRequest)request).getSession(false);
                        userid = _session != null ? this.getUserId(_session) : null;
                    }
                    if ((userid == null || userid.length() == 0) && session != null) {
                        _session = session;
                        userid = this.getUserId(_session);
                    }
                }
            }
            catch (Exception e) {
                userid = null;
            }
            return userid;
        }

        private String getUserId(HttpSession session) {
            String userid = null;
            if (session != null) {
                try {
                    userid = (String)session.getAttribute(Logger.SESSION_USERID);
                }
                catch (IllegalStateException e) {
                    userid = null;
                }
                if (userid == null || userid.length() == 0) {
                    userid = null;
                }
            }
            return userid;
        }

        private String getRemoteHost(ServletRequest request, HttpSession session) {
            String remoteHost = null;
            try {
                String string = remoteHost = request != null ? request.getRemoteAddr() : null;
                if (remoteHost == null || remoteHost.length() == 0) {
                    HttpSession _session = null;
                    if (request != null) {
                        _session = ((HttpServletRequest)request).getSession(false);
                        if (_session != null) {
                            remoteHost = (String)_session.getAttribute(Logger.SESSION_REMOTE_HOST);
                        }
                    } else if (session != null && session != null) {
                        _session = session;
                        remoteHost = (String)_session.getAttribute(Logger.SESSION_REMOTE_HOST);
                    }
                }
            }
            catch (Exception e) {
                remoteHost = null;
            }
            return remoteHost;
        }

        public String getUserId() {
            return this.userId != null ? this.userId : "unknown";
        }

        public String getRemoteHost() {
            return this.remoteHost != null ? this.remoteHost : "unknown";
        }
    }

    private static class SharedDateFormats {
        public SimpleDateFormat logDateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss:SSS z");

        SharedDateFormats() {
            this.logDateFormat.setTimeZone(TimeZone.getDefault());
        }
    }
}

