/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.json;

import com.ibm.ecm.util.JSONUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;

public class JSONResultSetColumn
extends JSONObject {
    static final String NAME = "name";
    static final String WIDTH = "width";
    static final String WIDTH_WEBKIT = "widthWebKit";
    static final String FIELD = "field";
    static final String STYLE = "style";
    static final String NOSORT = "nosort";
    static final String SORTABLE = "sortable";
    static final String CELL_CLASSES = "cellClasses";
    static final String HEADER_CLASSES = "headerClasses";
    static final String DECORATOR = "decorator";
    static final String FILTERABLE = "filterable";
    static final String STATES = "states";
    static final String WIDGETS_IN_CELL = "widgetsInCell";
    static final String SET_CELL_VALUE = "setCellValue";
    static final String FIELDS_TO_DISPLAY = "fieldsToDisplay";
    static final String EXTRA_FIELDS_TO_DISPLAY = "extraFieldsToDisplay";
    static final String ALLOW_EVENT_BUBBLE = "allowEventBubble";
    public static final String STATE_DECLARED = "isDeclared";
    public static final String STATE_MAJORMINOR = "hasMinorVersion";
    public static final String STATE_LOCKED = "isLocked";
    public static final String STATE_SUSPENDED = "isSuspended";
    public static final String STATE_DEADLINE = "hasDeadline";
    public static final String STATE_ONHOLD = "hasHold";
    public static final String STATE_NOTE = "hasNote";
    public static final String STATE_BOOKMARK = "hasBookmark";
    public static final String STATE_OFFLINE = "offline";
    public static final String STATE_DEFAULT = "default";

    public static final JSONResultSetColumn toJSONResultSetColumn(JSONObject jsonObject) {
        if (jsonObject instanceof JSONResultSetColumn) {
            return (JSONResultSetColumn)jsonObject;
        }
        JSONResultSetColumn resultSetColumn = new JSONResultSetColumn();
        resultSetColumn.putAll(jsonObject);
        return resultSetColumn;
    }

    public JSONResultSetColumn() {
    }

    public JSONResultSetColumn(String name, String width, String field, String style, boolean sortable) {
        this.put(NAME, name);
        this.put(WIDTH, width);
        this.put(FIELD, field);
        if (style != null) {
            this.put(STYLE, style);
        }
        if (!sortable) {
            this.put(NOSORT, (Object)true);
        }
        this.put(SORTABLE, (Object)sortable);
        if (field != null && field.equals("mimeTypeIcon")) {
            this.put(CELL_CLASSES, "ecmIconCell");
            this.put(HEADER_CLASSES, "ecmIconCell");
            this.put(DECORATOR, "DetailsViewDecorator.mimeTypeDecorator");
            this.put(FILTERABLE, (Object)false);
        }
        if (field != null && field.equals("icon")) {
            this.put(DECORATOR, "DetailsViewDecorator.iconDecorator");
            this.put(FILTERABLE, (Object)false);
        }
        if (field != null && field.equals("state")) {
            this.put(DECORATOR, "DetailsViewDecorator.teamspaceStateLabelDecorator");
            this.put(FILTERABLE, (Object)false);
        }
        if (field != null && field.equals("teamspaceIcon")) {
            this.put(DECORATOR, "DetailsViewDecorator.teamspaceIconDecorator");
            this.put(FILTERABLE, (Object)false);
        }
    }

    public JSONResultSetColumn(String name, String field, boolean sortable, String[] states) {
        this.put(NAME, name);
        this.put(FIELD, field);
        if (!sortable) {
            this.put(NOSORT, (Object)true);
        }
        this.put(SORTABLE, (Object)sortable);
        this.put(CELL_CLASSES, "ecmIconCell");
        this.put(HEADER_CLASSES, "ecmIconCell");
        this.put(DECORATOR, "DetailsViewDecorator.multiStateDecorator");
        this.put(FILTERABLE, (Object)false);
        this.put(STATES, JSONUtils.toJSONArray((String[])states));
        this.calculateColumnWidth(states);
    }

    private void calculateColumnWidth(String[] states) {
        int marginSize = 0;
        if (states.length > 1) {
            marginSize = (states.length - 1) * 2;
        }
        String width = Integer.toString(states.length * 16 + marginSize) + "px";
        this.put(WIDTH, width);
        width = Integer.toString(states.length * 25 + marginSize) + "px";
        this.put(WIDTH_WEBKIT, width);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setName(String name) {
        this.put(NAME, name);
    }

    public String getField() {
        return (String)this.get(FIELD);
    }

    public void setField(String field) {
        this.put(FIELD, field);
    }

    public String getWidth() {
        if (this.containsKey(WIDTH)) {
            return (String)this.get(WIDTH);
        }
        return null;
    }

    public void setWidth(String width) {
        this.put(WIDTH, width);
    }

    public boolean isSortable() {
        if (this.containsKey(SORTABLE)) {
            return (Boolean)this.get(SORTABLE);
        }
        return true;
    }

    public void setSortable(boolean sortable) {
        this.put(SORTABLE, (Object)sortable);
        if (!sortable) {
            this.put(NOSORT, (Object)true);
        }
    }

    public boolean isFilterable() {
        if (this.containsKey(FILTERABLE)) {
            return (Boolean)this.get(FILTERABLE);
        }
        return true;
    }

    public void setFilterable(boolean filterable) {
        this.put(FILTERABLE, (Object)filterable);
    }

    public JSONResultSetColumn(String name, String width, String field, JSONArray fieldsToDisplay, JSONArray extraFieldsToDisplay) {
        this.put(NAME, name);
        this.put(FIELD, field);
        this.put(SORTABLE, (Object)false);
        if (width != null) {
            this.put(WIDTH, width);
        }
        if (field.equals("thumbnail")) {
            if (width == null) {
                this.put(WIDTH, "60px");
            }
            this.put(DECORATOR, "MagazineViewDecorator.thumbnailDecorator");
        } else if (field.equals("content")) {
            this.put(DECORATOR, "MagazineViewDecorator.contentCellDecorator");
            this.put(WIDGETS_IN_CELL, (Object)true);
            this.put(SET_CELL_VALUE, "MagazineViewDecorator.contentCellValue");
            this.put(ALLOW_EVENT_BUBBLE, (Object)true);
            this.put(FIELDS_TO_DISPLAY, fieldsToDisplay);
            if (extraFieldsToDisplay != null) {
                this.put(EXTRA_FIELDS_TO_DISPLAY, extraFieldsToDisplay);
            }
        }
        this.put(FILTERABLE, (Object)false);
    }

    public JSONArray getFieldsToDisplay() {
        return (JSONArray)this.get(FIELDS_TO_DISPLAY);
    }

    public void setFieldToDisplay(JSONArray fieldsToDisplay) {
        this.put(FIELDS_TO_DISPLAY, fieldsToDisplay);
    }

    public JSONArray getExtraFieldsToDisplay() {
        if (this.containsKey(EXTRA_FIELDS_TO_DISPLAY)) {
            return (JSONArray)this.get(EXTRA_FIELDS_TO_DISPLAY);
        }
        return null;
    }

    public void setExtraFieldsToDisplay(JSONArray extraFieldsToDisplay) {
        this.put(EXTRA_FIELDS_TO_DISPLAY, extraFieldsToDisplay);
    }
}

