/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.extension;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.extension.PluginLogger;
import com.ibm.ecm.extension.PluginServiceCallbacks;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cmis.CMISConnection;
import com.ibm.ecm.util.od.ODConnection;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import java.util.Hashtable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PluginServiceUtil {
    public static P8Connection getP8Connection(HttpServletRequest request, String repositoryId) {
        return (P8Connection)PluginServiceUtil.getConnection(request, "p8_servers", repositoryId);
    }

    public static CMConnection getCMConnection(HttpServletRequest request, String repositoryId) {
        return (CMConnection)PluginServiceUtil.getConnection(request, "cm_servers", repositoryId);
    }

    public static ODConnection getODServer(HttpServletRequest request, String repositoryId) {
        return (ODConnection)PluginServiceUtil.getConnection(request, "od_servers", repositoryId);
    }

    public static CMISConnection getCMISConnection(HttpServletRequest request, String repositoryId) {
        return (CMISConnection)PluginServiceUtil.getConnection(request, "CMIS_servers", repositoryId);
    }

    static DKRetrieveOptionsICM createDKRetrieveOptions(CMConnection connection, boolean baseAttributes, boolean partsList, boolean partsAttributes) throws Exception {
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
        dkRetrieveOptions.baseAttributes(baseAttributes);
        dkRetrieveOptions.partsList(partsList);
        dkRetrieveOptions.partsAttributes(partsAttributes);
        return dkRetrieveOptions;
    }

    private static Object getConnection(HttpServletRequest request, String connectionListKey, String repositoryId) {
        PluginLogger pluginLogger;
        String methodName = "getConnection";
        PluginServiceCallbacks callbacks = (PluginServiceCallbacks)request.getAttribute("PluginServiceCallbacks");
        PluginLogger pluginLogger2 = pluginLogger = callbacks != null ? callbacks.getLogger() : null;
        if (pluginLogger != null) {
            pluginLogger.logEntry(PluginServiceUtil.class, methodName, (ServletRequest)request);
        }
        Object connection = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            Hashtable connectionList;
            if (pluginLogger != null) {
                pluginLogger.logDebug(PluginServiceUtil.class, methodName, (ServletRequest)request, "HttpSession ID is: " + session.getId());
                pluginLogger.logDebug(PluginServiceUtil.class, methodName, (ServletRequest)request, "serverName: " + repositoryId);
            }
            if ((connectionList = (Hashtable)session.getAttribute(connectionListKey)) != null && repositoryId != null) {
                connection = connectionList.get(repositoryId);
                Logger.logDebug(P8Util.class, methodName, (ServletRequest)request, "Returning connection: " + connection);
            }
        }
        if (pluginLogger != null) {
            pluginLogger.logDebug(PluginServiceUtil.class, methodName, (ServletRequest)request, "Returning connection: " + connection);
            pluginLogger.logExit(PluginServiceUtil.class, methodName, (ServletRequest)request);
        }
        return connection;
    }
}

