/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.extension;

import com.filenet.api.collection.AnnotationSet;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.property.PropertyFilter;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopFeatureConfig;
import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.extension.PluginDocumentContent;
import com.ibm.ecm.extension.PluginLogger;
import com.ibm.ecm.extension.PluginRepositoryConnection;
import com.ibm.ecm.extension.PluginServiceUtil;
import com.ibm.ecm.json.JSONRequest;
import com.ibm.ecm.json.JSONResponse;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMHitMediator;
import com.ibm.ecm.mediator.od.ODAnnotationMediator;
import com.ibm.ecm.mediator.od.ODHitMediator;
import com.ibm.ecm.mediator.p8.P8HitMediator;
import com.ibm.ecm.search.p8.P8Query;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.util.Connection;
import com.ibm.ecm.util.DocumentContent;
import com.ibm.ecm.util.PluginUtil;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.cm.CMContentUtil;
import com.ibm.ecm.util.cmis.CMISContentUtil;
import com.ibm.ecm.util.od.ODConnection;
import com.ibm.ecm.util.od.ODContentUtil;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8ContentUtil;
import com.ibm.ecm.util.p8.P8Util;
import com.ibm.ecm.util.p8.P8Workflow;
import com.ibm.edms.od.ODConstant;
import com.ibm.edms.od.ODFolder;
import com.ibm.edms.od.ODHit;
import com.ibm.edms.od.ODServer;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKCommonPrivilege;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkXDO;
import com.ibm.mm.sdk.server.DKDatastoreExtICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import filenet.vw.api.VWSession;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;

public class PluginServiceCallbacks {
    private static MessageResources resources = MessageResources.getMessageResources("com.ibm.ecm.nls.ServicesMessages");
    private HttpServletRequest request;
    private Plugin plugin;
    private PluginLogger pluginLogger = null;

    public PluginServiceCallbacks(HttpServletRequest request, Plugin plugin) {
        this.request = request;
        this.plugin = plugin;
        this.pluginLogger = new PluginLogger(plugin);
        if (request != null) {
            request.setAttribute("PluginServiceCallbacks", (Object)this);
        }
    }

    public PluginLogger getLogger() {
        if (this.pluginLogger == null) {
            this.pluginLogger = new PluginLogger((Plugin)null);
        }
        return this.pluginLogger;
    }

    public String loadConfiguration() throws Exception {
        return PluginUtil.loadPluginConfig((Plugin)this.plugin);
    }

    public void saveConfiguration(String config) throws Exception {
        PluginUtil.savePluginConfig((Plugin)this.plugin, (String)config);
    }

    public String[] loadConfigurations(String[] keys) throws Exception {
        return PluginUtil.loadPluginConfig((Plugin)this.plugin, (String[])keys);
    }

    public void saveConfiguration(Hashtable<String, String> configs) throws Exception {
        PluginUtil.savePluginConfig((Plugin)this.plugin, configs);
    }

    public String[] getConfigurationKeys() throws Exception {
        return PluginUtil.getPluginConfigKeys((Plugin)this.plugin);
    }

    public String loadFeatureConfiguration(String featureId) throws Exception {
        DesktopFeatureConfig desktopConfig = Config.getDesktopFeatureConfig("navigator", featureId);
        return desktopConfig.getFeatureConfiguration();
    }

    public void saveFeatureConfiguration(String featureId, String config) throws Exception {
        DesktopFeatureConfig desktopConfig = Config.getDesktopFeatureConfig("navigator", featureId);
        desktopConfig.setFeatureConfiguration(config);
    }

    public String loadUserConfiguration(String key) throws Exception {
        return PluginUtil.loadPluginUserConfig((HttpServletRequest)this.request, (Plugin)this.plugin, (String)key);
    }

    public void saveUserConfiguration(String key, String config) throws Exception {
        PluginUtil.savePluginUserConfig((HttpServletRequest)this.request, (Plugin)this.plugin, (String)key, (String)config);
    }

    public String[] loadUserConfiguration(String[] keys) throws Exception {
        return PluginUtil.loadPluginUserConfig((HttpServletRequest)this.request, (Plugin)this.plugin, (String[])keys);
    }

    public String[] getUserConfigurationKeys() throws Exception {
        return PluginUtil.getPluginUserConfigKeys((HttpServletRequest)this.request, (Plugin)this.plugin);
    }

    public void saveUserConfiguration(Hashtable<String, String> configs) throws Exception {
        PluginUtil.savePluginUserConfig((HttpServletRequest)this.request, (Plugin)this.plugin, configs);
    }

    public String getRepositoryId() {
        String repositoryId = this.request.getParameter("repositoryId");
        if (repositoryId == null && this.request.getAttribute("repositoryId") != null) {
            repositoryId = (String)this.request.getAttribute("repositoryId");
        }
        return repositoryId;
    }

    public String getUserId() {
        PluginRepositoryConnection pluginConnection;
        Connection cmisConnection;
        Connection p8Connection;
        Connection cmConnection;
        Connection server;
        String repositoryId = this.getRepositoryId();
        HttpSession session = this.request.getSession(false);
        Map connectionList = (Map)session.getAttribute("od_servers");
        if (connectionList != null && (server = (Connection)connectionList.get(repositoryId)) != null) {
            return server.getUserId();
        }
        connectionList = (Map)session.getAttribute("cm_servers");
        if (connectionList != null && (cmConnection = (Connection)connectionList.get(repositoryId)) != null) {
            return cmConnection.getUserId();
        }
        connectionList = (Map)session.getAttribute("p8_servers");
        if (connectionList != null && (p8Connection = (Connection)connectionList.get(repositoryId)) != null) {
            return p8Connection.getUserId();
        }
        connectionList = (Map)session.getAttribute("CMIS_servers");
        if (connectionList != null && (cmisConnection = (Connection)connectionList.get(repositoryId)) != null) {
            return cmisConnection.getUserId();
        }
        connectionList = (Map)session.getAttribute("plugin_repositories");
        if (connectionList != null && (pluginConnection = (PluginRepositoryConnection)connectionList.get(repositoryId)) != null) {
            return pluginConnection.getUserId();
        }
        return null;
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public URL getServerBaseUrl() {
        try {
            String serverURL = this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort();
            return new URL(serverURL);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public DKDatastoreICM getCMDatastore(String repositoryId) {
        DKDatastoreICM cmDatastore = null;
        CMConnection cmConnection = PluginServiceUtil.getCMConnection(this.request, repositoryId);
        if (cmConnection != null) {
            cmDatastore = cmConnection.getDatastore();
        }
        return cmDatastore;
    }

    public ODServer getODServer(String repositoryId) {
        ODServer server = null;
        ODConnection connection = PluginServiceUtil.getODServer(this.request, repositoryId);
        if (connection != null) {
            server = connection.getODServer();
        }
        return server;
    }

    public com.filenet.api.core.Connection getP8Connection(String repositoryId) {
        com.filenet.api.core.Connection ceConnection = null;
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        if (p8Connection != null) {
            ceConnection = p8Connection.getCEConnection();
        }
        return ceConnection;
    }

    public P8Connection getP8ConnectionObject(String repositoryId) {
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        return p8Connection;
    }

    public VWSession getVWSession(String repositoryId, String connectionPoint) throws Exception {
        String methodName = "getVWSession";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        VWSession vwSession = null;
        try {
            P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
            if (p8Connection != null) {
                vwSession = P8Workflow.getVWSessionUsingConnection((P8Connection)p8Connection, (String)repositoryId, (String)connectionPoint, (boolean)true, (HttpServletRequest)this.request);
            } else {
                this.getLogger().logDebug(this, methodName, (ServletRequest)this.request, "No P8Connection has been established with the repository.");
            }
        }
        catch (Exception e) {
            this.getLogger().logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            throw e;
        }
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return vwSession;
    }

    public ObjectStore getP8ObjectStore(String repositoryId) {
        ObjectStore objectStore = null;
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        if (p8Connection != null) {
            objectStore = p8Connection.getObjectStore();
        }
        return objectStore;
    }

    public Domain getP8Domain(String repositoryId) {
        String methodName = "getP8Domain";
        Domain domain = null;
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        if (p8Connection != null) {
            domain = p8Connection.getDomain();
            try {
                if (domain.get_ObjectStores() != null && domain.getProperties() != null && domain.get_PEConnectionPoints() != null) {
                    this.getLogger().logDebug(this, methodName, (ServletRequest)this.request, "using domain object from cache");
                } else {
                    this.getLogger().logDebug(this, methodName, (ServletRequest)this.request, "Loading the full domain object");
                    domain.refresh();
                }
            }
            catch (Exception e) {
                this.getLogger().logDebug(this, methodName, (ServletRequest)this.request, "Loading the full domain object");
                domain.refresh();
            }
        }
        return domain;
    }

    public Domain getP8Domain(String repositoryId, PropertyFilter propertyFilter) {
        Domain domain = null;
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        if (p8Connection != null) {
            domain = p8Connection.getDomain();
            domain.refresh(propertyFilter);
        }
        return domain;
    }

    public Subject getP8Subject(String repositoryId) {
        Subject subject = null;
        P8Connection p8Connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        if (p8Connection != null) {
            subject = p8Connection.getSubject();
        }
        return subject;
    }

    public MessageResources getResources() {
        return resources;
    }

    public Object getSynchObject(String repositoryId, String repositoryType) {
        Object synchObject = null;
        if (repositoryType.equalsIgnoreCase("cm")) {
            synchObject = CMContentUtil.getSynchObject((HttpServletRequest)this.request, (String)repositoryId);
        } else if (repositoryType.equalsIgnoreCase("od")) {
            synchObject = ODContentUtil.getSynchObject((HttpServletRequest)this.request, (String)repositoryId);
        } else if (repositoryType.equalsIgnoreCase("p8")) {
            synchObject = P8ContentUtil.getSynchObject((HttpServletRequest)this.request, (String)repositoryId);
        }
        return synchObject;
    }

    public PluginDocumentContent retrieveDocumentContent(String repositoryId, String repositoryType, String documentId, int partNum, String p8VsId, String p8Version, String odFolderName, int odSegmentNum, boolean odAsciiTransform) throws Exception {
        return this.retrieveContentInternal(repositoryId, repositoryType, documentId, partNum, p8VsId, p8Version, odFolderName, odSegmentNum, odAsciiTransform ? ODConstant.ASCII : ODConstant.NATIVE);
    }

    public PluginDocumentContent retrieveDocumentContent(String repositoryId, String repositoryType, String documentId, int partNum, String p8VsId, String p8Version, String odFolderName, int odSegmentNum, String odTransform) throws Exception {
        return this.retrieveContentInternal(repositoryId, repositoryType, documentId, partNum, p8VsId, p8Version, odFolderName, odSegmentNum, odTransform);
    }

    public DocumentContent retrieveContent(String repositoryId, String repositoryType, String documentId, int partNum, String p8VsId, String p8Version, String odFolderName, int odSegmentNum, boolean odAsciiTransform) throws Exception {
        return this.retrieveContentInternal(repositoryId, repositoryType, documentId, partNum, p8VsId, p8Version, odFolderName, odSegmentNum, odAsciiTransform ? ODConstant.ASCII : ODConstant.NATIVE);
    }

    private DocumentContent retrieveContentInternal(String repositoryId, String repositoryType, String documentId, int partNum, String p8VsId, String p8Version, String odFolderName, int odSegmentNum, String odTransform) throws Exception {
        String methodName = "retrieveContent";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        DocumentContent documentContent = null;
        if (repositoryType.equalsIgnoreCase("p8")) {
            documentContent = P8ContentUtil.retrieveContent((HttpServletRequest)this.request, (String)repositoryId, (String)documentId, (String)p8VsId, (String)p8Version, (int)partNum);
        } else if (repositoryType.equalsIgnoreCase("cm")) {
            documentContent = CMContentUtil.retrieveContent((HttpServletRequest)this.request, (String)repositoryId, (String)documentId, (int)partNum);
        } else if (repositoryType.equalsIgnoreCase("od")) {
            documentContent = ODContentUtil.retrieveContent((HttpServletRequest)this.request, (String)repositoryId, (String)documentId, (String)odFolderName, (int)odSegmentNum, (String)odTransform);
        } else if (repositoryType.equalsIgnoreCase("cmis")) {
            documentContent = CMISContentUtil.retrieveContent((HttpServletRequest)this.request, (String)repositoryId, (String)documentId);
        }
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return documentContent;
    }

    public BaseMediator retrieveAnnotations(String repositoryId, String repositoryType, String documentId, String p8VsId, String p8Version, String odFolderName, boolean cmBookmarks, Integer cmAnnotationPosition) {
        String methodName = "retrieveAnnotations";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        Object mediator = null;
        if (repositoryType.equalsIgnoreCase("p8")) {
            mediator = P8ContentUtil.retrieveAnnotations((HttpServletRequest)this.request, (MessageResources)this.getResources(), (String)repositoryId, (String)documentId, (String)p8VsId, (String)p8Version);
        } else if (repositoryType.equalsIgnoreCase("cm")) {
            mediator = cmBookmarks ? CMContentUtil.retrieveBookmarks((HttpServletRequest)this.request, (MessageResources)this.getResources(), (String)repositoryId, (String)documentId) : CMContentUtil.retrieveAnnotations((HttpServletRequest)this.request, (MessageResources)this.getResources(), (String)repositoryId, (String)documentId, (Integer)cmAnnotationPosition);
        } else if (repositoryType.equalsIgnoreCase("od")) {
            mediator = ODContentUtil.retrieveAnnotations((HttpServletRequest)this.request, (MessageResources)this.getResources(), (String)repositoryId, (String)documentId, (String)odFolderName);
        }
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return mediator;
    }

    public JSONObject retrieveJSONAnnotations(String repositoryId, String repositoryType, String documentId, String p8VsId, String p8Version, String odFolderName, boolean cmBookmarks, Integer cmAnnotationPosition) {
        BaseMediator mediator = this.retrieveAnnotations(repositoryId, repositoryType, documentId, p8VsId, p8Version, odFolderName, cmBookmarks, cmAnnotationPosition);
        return mediator.toJSONObject();
    }

    public Document getP8Document(String repositoryId, String documentId, String vsId, String version) {
        return P8ContentUtil.retrieveDocument((HttpServletRequest)this.request, (String)repositoryId, (String)documentId, (String)vsId, (String)version);
    }

    public PropertyFilter getP8DocumentResultsPropertyFilter() {
        return P8Query.getDocumentPropertyFilter();
    }

    public PropertyFilter getP8FolderResultsPropertyFilter() {
        return P8Query.getFolderPropertyFilter();
    }

    public HashMap<Object, Long> getP8PrivilegeMasks(String repositoryId, List<Object> items) throws Exception {
        if (repositoryId == null || repositoryId.isEmpty()) {
            return null;
        }
        if (items == null || items.size() == 0) {
            return null;
        }
        P8Connection connection = PluginServiceUtil.getP8Connection(this.request, repositoryId);
        if (connection == null) {
            return null;
        }
        String docNameProperty = P8Util.getNameProperty((HttpServletRequest)this.request, (boolean)false);
        String folderNameProperty = P8Util.getNameProperty((HttpServletRequest)this.request, (boolean)true);
        P8HitMediator hitMediator = new P8HitMediator(this.request, resources, this.request.getLocale(), false, null, docNameProperty, folderNameProperty, true, null, null, null);
        hitMediator.setConnection(connection);
        HashMap<Object, Long> privMasks = new HashMap<Object, Long>(items.size());
        for (Object item : items) {
            hitMediator.setHit(item);
            privMasks.put(item, hitMediator.getPrivileges());
        }
        return privMasks;
    }

    public CMItem getCMDocument(String repositoryId, String documentId, DKRetrieveOptionsICM dkRetrieveOptions) throws Exception {
        return CMContentUtil.retrieveDocument((HttpServletRequest)this.request, (String)repositoryId, (String)documentId, (DKRetrieveOptionsICM)dkRetrieveOptions);
    }

    public DKDDO getCMDocument(String repositoryId, String documentId, boolean baseAttributes, boolean partsList, boolean partsAttributes) throws Exception {
        return this.getCMDocumentDDO(repositoryId, documentId, baseAttributes, partsList, partsAttributes);
    }

    public DKDDO getCMDocumentDDO(String repositoryId, String documentId, boolean baseAttributes, boolean partsList, boolean partsAttributes) throws Exception {
        CMConnection connection = PluginServiceUtil.getCMConnection(this.request, repositoryId);
        DKRetrieveOptionsICM dkRetrieveOptions = PluginServiceUtil.createDKRetrieveOptions(connection, baseAttributes, partsList, partsAttributes);
        CMItem item = CMContentUtil.retrieveDocument((HttpServletRequest)this.request, (String)repositoryId, (String)documentId, (DKRetrieveOptionsICM)dkRetrieveOptions);
        return item.getDDO();
    }

    public boolean CMApiAndServerVersionAtOrNewer(DKDatastoreICM datastore, int version, int release, int csd, int fixpack) {
        return CMBaseUtil.apiAndServerVersionAtOrNewer((DKDatastoreICM)datastore, (int)version, (int)release, (int)csd, (int)fixpack);
    }

    public HashMap<DKDDO, Long> getCMPrivilegeMasks(String repositoryId, List<DKDDO> items) throws Exception {
        if (repositoryId == null || repositoryId.isEmpty()) {
            return null;
        }
        if (items == null || items.size() == 0) {
            return null;
        }
        CMConnection connection = PluginServiceUtil.getCMConnection(this.request, repositoryId);
        if (connection == null) {
            return null;
        }
        DKDatastoreICM datastore = connection.getDatastore();
        if (datastore == null) {
            return null;
        }
        DKSequentialCollection ddoColl = new DKSequentialCollection();
        for (DKDDO item : items) {
            ddoColl.addElement((Object)item);
        }
        HashMap commonPrivs = ((DKDatastoreExtICM)datastore.getExtension("DATASTORE_EXTENSION")).getCommonItemPrivilege((dkCollection)ddoColl);
        HashMap<DKDDO, Long> privMasks = new HashMap<DKDDO, Long>(commonPrivs.size());
        CMHitMediator hitMediator = new CMHitMediator(this.request, resources, this.request.getLocale());
        for (DKDDO keyItem : commonPrivs.keySet()) {
            CMItem item = new CMItem(this.request, connection, keyItem, null, true, false, true);
            item.getItemType();
            hitMediator.setHit(item, false, false, true);
            hitMediator.setDKCommonPrivilege((DKCommonPrivilege)commonPrivs.get(keyItem));
            privMasks.put(keyItem, hitMediator.getPrivileges());
        }
        return privMasks;
    }

    public ODHit getODDocument(String repositoryId, String documentId, String templateName) throws Exception {
        return ODContentUtil.retrieveDocument((HttpServletRequest)this.request, (String)repositoryId, (String)documentId, (String)templateName);
    }

    public HashMap<ODHit, Long> getODPrivilegeMasks(String repositoryId, ODFolder folder, List<ODHit> items) throws Exception {
        if (repositoryId == null || repositoryId.isEmpty()) {
            return null;
        }
        if (items == null || items.size() == 0) {
            return null;
        }
        ODConnection connection = PluginServiceUtil.getODServer(this.request, repositoryId);
        if (connection == null) {
            return null;
        }
        ODHitMediator hitMediator = new ODHitMediator(this.request, resources, this.request.getLocale());
        hitMediator.setFolder(folder);
        HashMap<ODHit, Long> privMasks = new HashMap<ODHit, Long>(items.size());
        for (ODHit item : items) {
            hitMediator.setHit(item);
            privMasks.put(item, hitMediator.getPrivileges());
        }
        return privMasks;
    }

    public org.apache.chemistry.opencmis.client.api.Document getCMISDocument(String repositoryId, String documentId) {
        return CMISContentUtil.retrieveDocument((HttpServletRequest)this.request, (String)repositoryId, (String)documentId);
    }

    public ODAnnotationMediator addODNote(String repositoryId, String documentId, String templateName, String noteGroupName, String noteText, boolean noteIsOKToCopy, boolean noteIsPublic) {
        String methodName = "addODNote";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        ODAnnotationMediator mediator = ODContentUtil.addNote((HttpServletRequest)this.request, (MessageResources)this.getResources(), (String)repositoryId, (String)documentId, (String)templateName, (String)noteGroupName, (String)noteText, (boolean)noteIsOKToCopy, (boolean)noteIsPublic);
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return mediator;
    }

    public AnnotationSet getP8Annotations(Document document, String repositoryId, String[] properties) {
        String methodName = "getP8Annotations";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        AnnotationSet annotations = P8ContentUtil.retrieveNativeAnnotations((HttpServletRequest)this.request, (String)repositoryId, (Document)document, (String[])properties);
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return annotations;
    }

    public String getP8AnnotationsXML(Document document, String repositoryId) throws Exception {
        String methodName = "getP8AnnotationsXML";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        String annotationsXml = P8ContentUtil.retrieveAnnotationsXml((HttpServletRequest)this.request, (Document)document, (String)repositoryId);
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return annotationsXml;
    }

    public CMObject getCMAnnotations(CMItem item, String repositoryId, int partNum) throws Exception {
        String methodName = "getCMAnnotations";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        CMObject annotations = CMContentUtil.retrieveNativeAnnotations((HttpServletRequest)this.request, (CMItem)item, (String)repositoryId, (int)partNum);
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return annotations;
    }

    public CMObject getCMAnnotations(CMItem item, String repositoryId) throws Exception {
        String methodName = "getCMAnnotations";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        CMObject annotations = CMContentUtil.retrieveNativeAnnotations((HttpServletRequest)this.request, (CMItem)item, (String)repositoryId);
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return annotations;
    }

    public CMObject getCMBookmarks(CMItem item, String repositoryId) throws Exception {
        String methodName = "getCMBookmarks";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        CMObject bookmarks = CMContentUtil.retrieveNativeBookmarks((HttpServletRequest)this.request, (CMItem)item, (String)repositoryId);
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return bookmarks;
    }

    public dkXDO getCMAnnotations(String repositoryId, String documentId, int partNum) throws Exception {
        return this.getCMAnnotationsXDO(repositoryId, documentId, partNum);
    }

    public dkXDO getCMAnnotations(String repositoryId, String documentId) throws Exception {
        return this.getCMAnnotationsXDO(repositoryId, documentId, 0);
    }

    public dkXDO getCMBookmarks(String repositoryId, String documentId) throws Exception {
        return this.getCMAnnotationsXDO(repositoryId, documentId, 1);
    }

    public dkXDO getCMAnnotationsXDO(String repositoryId, String documentId, int partNum) throws Exception {
        String methodName = "getCMAnnotations";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        CMConnection connection = PluginServiceUtil.getCMConnection(this.request, repositoryId);
        DKRetrieveOptionsICM dkRetrieveOptions = PluginServiceUtil.createDKRetrieveOptions(connection, false, true, true);
        CMItem item = CMContentUtil.retrieveDocument((HttpServletRequest)this.request, (String)repositoryId, (String)documentId, (DKRetrieveOptionsICM)dkRetrieveOptions);
        CMObject annotations = CMContentUtil.retrieveNativeAnnotations((HttpServletRequest)this.request, (CMItem)item, (String)repositoryId, (int)partNum);
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return annotations.getXDO();
    }

    public dkXDO getCMAnnotationsXDO(String repositoryId, String documentId) throws Exception {
        return this.getCMAnnotationsXDO(repositoryId, documentId, 0);
    }

    public dkXDO getCMBookmarksXDO(String repositoryId, String documentId) throws Exception {
        return this.getCMAnnotationsXDO(repositoryId, documentId, 1);
    }

    public Vector[] getODNotes(String repositoryId, String documentId, String templateName) throws Exception {
        String methodName = "getODNotes";
        this.getLogger().logEntry((Object)this, methodName, (ServletRequest)this.request);
        Vector[] hitAndNotes = ODContentUtil.retrieveNativeAnnotations((HttpServletRequest)this.request, (String)repositoryId, (String)documentId, (String)templateName);
        this.getLogger().logExit((Object)this, methodName, (ServletRequest)this.request);
        return hitAndNotes;
    }

    public FormFile getRequestUploadFile() {
        FileUploadActionForm form = (FileUploadActionForm)this.request.getAttribute(FileUploadActionForm.class.getName());
        if (form != null) {
            return form.getUploadFile();
        }
        return null;
    }

    public ActionForm getRequestActionForm() {
        return (FileUploadActionForm)this.request.getAttribute(FileUploadActionForm.class.getName());
    }

    public String getSystemPropertyLabel(String repositoryType, String id, Locale locale) {
        return PluginUtil.getSystemPropertyLabel((HttpServletRequest)this.request, (String)repositoryType, (String)id, (Locale)locale);
    }

    public PluginRepositoryConnection getPluginRepositoryConnection(String repositoryId) {
        return PluginUtil.getPluginRepositoryConnection((HttpServletRequest)this.request, (String)repositoryId);
    }

    public JSONRequest readJSONRequest(HttpServletRequest request, HttpServletResponse response, Class jsonRequestClass) throws Exception {
        return PluginUtil.readJSONRequest((HttpServletRequest)request, (HttpServletResponse)response, (Class)jsonRequestClass);
    }

    public void writeJSONResponse(JSONResponse jsonResponse, HttpServletResponse response) throws Exception {
        PluginUtil.writeJSONResponse((HttpServletRequest)this.request, (HttpServletResponse)response, (JSONResponse)jsonResponse);
    }

    public boolean pluginAPIExists(String pluginId, String apiId) {
        return PluginUtil.pluginAPIExists((HttpServletRequest)this.request, (String)pluginId, (String)apiId);
    }

    public Object executePluginAPI(String pluginId, String apiId, Object[] arguments) throws Exception {
        return PluginUtil.executePluginAPI((HttpServletRequest)this.request, (String)pluginId, (String)apiId, (Object[])arguments);
    }
}

