/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.extension;

import com.ibm.ecm.extension.PluginServiceCallbacks;
import com.ibm.ecm.json.JSONMessage;
import com.ibm.ecm.json.JSONResponse;
import com.ibm.ecm.util.PluginUtil;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PluginResponseUtil {
    private static String SECURE_JSON_PREFIX = "{}&&";

    public static void writeJSONResponse(HttpServletRequest request, HttpServletResponse response, JSONResponse jsonResponse, PluginServiceCallbacks callbacks, String pluginServiceId) {
        String methodName = "writeJSONMediator";
        callbacks.getLogger().logEntry(PluginResponseUtil.class, methodName, (ServletRequest)request);
        boolean secureJsonPrefixWritten = false;
        try {
            response.addHeader("Cache-Control", "no-cache");
            if (!jsonResponse.hasErrors() && PluginUtil.responseFilterExists((HttpServletRequest)request, (String)pluginServiceId)) {
                callbacks.getLogger().logDebug(PluginResponseUtil.class, methodName, (ServletRequest)request, "No errors, and response filters were found.");
                PluginUtil.invokeResponseFilters((HttpServletRequest)request, (JSONObject)jsonResponse, (String)pluginServiceId);
                secureJsonPrefixWritten = PluginResponseUtil.writeJSON(request, response, jsonResponse, callbacks);
            } else {
                secureJsonPrefixWritten = PluginResponseUtil.writeJSON(request, response, jsonResponse, callbacks);
            }
        }
        catch (UnsupportedEncodingException e) {
            callbacks.getLogger().logError(PluginResponseUtil.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (Throwable e) {
            callbacks.getLogger().logError(PluginResponseUtil.class, methodName, (ServletRequest)request, e);
            JSONResponse json = new JSONResponse();
            String msgText = callbacks.getResources().getMessage(request.getLocale(), "error.exception.general");
            String msgId = callbacks.getResources().getMessage(request.getLocale(), "error.exception.general.id");
            int msgNumber = 0;
            if (msgId != null) {
                msgNumber = Integer.parseInt(msgId.trim());
            }
            String msgExplanation = callbacks.getResources().getMessage(request.getLocale(), "error.exception.general.explanation");
            String msgUserResponse = callbacks.getResources().getMessage(request.getLocale(), "error.exception.general.userResponse");
            String msgAdminResponse = callbacks.getResources().getMessage(request.getLocale(), "error.exception.general.adminResponse");
            JSONMessage message = new JSONMessage(msgNumber, msgText, msgExplanation, msgUserResponse, msgAdminResponse, null);
            jsonResponse.addErrorMessage(message);
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            try {
                PrintWriter writer = response.getWriter();
                if (PluginResponseUtil.isSecureServiceEnabled(request) && !secureJsonPrefixWritten) {
                    ((Writer)writer).write(SECURE_JSON_PREFIX);
                }
                ((Writer)writer).write(json.toString());
                ((Writer)writer).close();
            }
            catch (Exception e2) {
                callbacks.getLogger().logError(PluginResponseUtil.class, methodName, (ServletRequest)request, (Throwable)e2);
            }
        }
        callbacks.getLogger().logExit(PluginResponseUtil.class, methodName, (ServletRequest)request);
    }

    private static boolean writeJSON(HttpServletRequest request, HttpServletResponse response, JSONResponse jsonResponse, PluginServiceCallbacks callbacks) throws IOException, Exception {
        String methodName = "writeJSON";
        boolean returnVal = false;
        String acceptedEncodings = request.getHeader("Accept-Encoding");
        if (acceptedEncodings != null && acceptedEncodings.indexOf("gzip") >= 0) {
            callbacks.getLogger().logDebug(PluginResponseUtil.class, methodName, (ServletRequest)request, "GZIP is supported, sending compressed response.");
            if (!response.isCommitted()) {
                response.setBufferSize(65536);
            }
            response.setHeader("Content-Encoding", "gzip");
            response.setContentType("text/plain");
            GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)response.getOutputStream());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)gzos, "UTF-8");
            if (PluginResponseUtil.isSecureServiceEnabled(request)) {
                writer.write(SECURE_JSON_PREFIX);
                returnVal = true;
            }
            callbacks.getLogger().logDebug(PluginResponseUtil.class, methodName, (ServletRequest)request, "GZIP: Calling to write JSON response.");
            writer.write(jsonResponse.toString());
            ((Writer)writer).close();
        } else {
            response.setContentType("text/plain");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            if (PluginResponseUtil.isSecureServiceEnabled(request)) {
                ((Writer)writer).write(SECURE_JSON_PREFIX);
                returnVal = true;
            }
            callbacks.getLogger().logDebug(PluginResponseUtil.class, methodName, (ServletRequest)request, "Uncompressed: Calling to write JSON response.");
            ((Writer)writer).write(jsonResponse.toString());
            ((Writer)writer).close();
        }
        return returnVal;
    }

    private static boolean isSecureServiceEnabled(HttpServletRequest request) {
        return request != null && request.getAttribute("enableSecureService") == Boolean.TRUE;
    }
}

