/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.extension;

import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.serviceability.Logger;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;

public class PluginLogger {
    private String applId = Logger.getAppId();
    private int level = Logger.getLogLevel();
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_PERF = 3;
    public static final int LOG_DEBUG = 4;
    public static final int LOG_ENTRY = 5;
    public static final int LOG_EXIT = 6;
    public static final int LOG_DEV = 7;

    public PluginLogger(Plugin plugin) {
        this.applId = plugin != null ? this.applId + "." + plugin.getId() : this.applId + ".unknown";
    }

    public PluginLogger(String pluginId) {
        this.applId = pluginId != null ? this.applId + "." + pluginId : this.applId + ".unknown";
    }

    public String getPluginAppId() {
        return this.applId;
    }

    public int getLogLevel() {
        return this.level;
    }

    public void setLogLevel(int level) {
        this.level = level;
    }

    public boolean isDebugLogged() {
        return this.getLogLevel() >= 4;
    }

    public void logEntry(Object object, String methodName) {
        this._log(this.getPluginAppId(), 5, object, methodName, "", null, null, null, null);
    }

    public void logEntry(Object object, String methodName, ServletRequest request) {
        this._log(this.getPluginAppId(), 5, object, methodName, "", request, null, null, null);
    }

    public void logEntry(Object object, String methodName, String message) {
        this._log(this.getPluginAppId(), 5, object, methodName, message, null, null, null, null);
    }

    public void logEntry(Object object, String methodName, ServletRequest request, String message) {
        this._log(this.getPluginAppId(), 5, object, methodName, message, request, null, null, null);
    }

    public void logExit(Object object, String methodName) {
        this._log(this.getPluginAppId(), 6, object, methodName, "", null, null, null, null);
    }

    public void logExit(Object object, String methodName, ServletRequest request) {
        this._log(this.getPluginAppId(), 6, object, methodName, "", request, null, null, null);
    }

    public void logExit(Object object, String methodName, String message) {
        this._log(this.getPluginAppId(), 6, object, methodName, message, null, null, null, null);
    }

    public void logExit(Object object, String methodName, ServletRequest request, String message) {
        this._log(this.getPluginAppId(), 6, object, methodName, message, request, null, null, null);
    }

    public void logError(Object loggingObject, String methodName, String text) {
        this._log(this.getPluginAppId(), 1, loggingObject, methodName, text, null, null, null, null);
    }

    public void logError(Object loggingObject, String methodName, ServletRequest request, String text) {
        this._log(this.getPluginAppId(), 1, loggingObject, methodName, text, request, null, null, null);
    }

    public void logError(Object object, String methodName, Throwable exception) {
        this._log(this.getPluginAppId(), 1, object, methodName, null, null, null, null, exception);
    }

    public void logError(Object object, String methodName, ServletRequest request, Throwable exception) {
        this._log(this.getPluginAppId(), 1, object, methodName, null, request, null, null, exception);
    }

    public void logError(Object object, String methodName, String text, Throwable exception) {
        this._log(this.getPluginAppId(), 1, object, methodName, text, null, null, null, exception);
    }

    public void logError(Object object, String methodName, ServletRequest request, String text, Throwable exception) {
        this._log(this.getPluginAppId(), 1, object, methodName, text, request, null, null, exception);
    }

    public void logWarning(Object loggingObject, String methodName, String text) {
        this._log(this.getPluginAppId(), 2, loggingObject, methodName, text, null, null, null, null);
    }

    public void logWarning(Object loggingObject, String methodName, ServletRequest request, String text) {
        this._log(this.getPluginAppId(), 2, loggingObject, methodName, text, request, null, null, null);
    }

    public void logInfo(Object loggingObject, String methodName, String text) {
        this._log(this.getPluginAppId(), 3, loggingObject, methodName, text, null, null, null, null);
    }

    public void logInfo(Object loggingObject, String methodName, ServletRequest request, String text) {
        this._log(this.getPluginAppId(), 3, loggingObject, methodName, text, request, null, null, null);
    }

    public void logDebug(Object loggingObject, String methodName, String text) {
        this._log(this.getPluginAppId(), 4, loggingObject, methodName, text, null, null, null, null);
    }

    public void logDebug(Object loggingObject, String methodName, ServletRequest request, String text) {
        this._log(this.getPluginAppId(), 4, loggingObject, methodName, text, request, null, null, null);
    }

    public Date logPerf(Object object, String methodName) {
        return this._log(this.getPluginAppId(), 3, object, methodName, "", null, null, null, new Exception());
    }

    public Date logPerf(Object object, String methodName, ServletRequest request) {
        return this._log(this.getPluginAppId(), 3, object, methodName, "", request, null, null, new Exception());
    }

    public Date logPerf(Object object, String methodName, String message) {
        return this._log(this.getPluginAppId(), 3, object, methodName, message, null, null, null, new Exception());
    }

    public Date logPerf(Object object, String methodName, ServletRequest request, String message) {
        return this._log(this.getPluginAppId(), 3, object, methodName, message, request, null, null, new Exception());
    }

    public Date logPerf(Object object, String methodName, Date date) {
        String elapsedInfo = null;
        if (date != null) {
            long elapsedTime = System.currentTimeMillis() - date.getTime();
            elapsedInfo = Logger.formatElapsed(elapsedTime);
        }
        return this._log(this.getPluginAppId(), 3, object, methodName, elapsedInfo, null, null, null, new Exception());
    }

    public Date logPerf(Object object, String methodName, ServletRequest request, Date date) {
        String elapsedInfo = null;
        if (date != null) {
            long elapsedTime = System.currentTimeMillis() - date.getTime();
            elapsedInfo = Logger.formatElapsed(elapsedTime);
        }
        return this._log(this.getPluginAppId(), 3, object, methodName, elapsedInfo, request, null, null, new Exception());
    }

    public Date logPerf(Object object, String methodName, Date date, String message) {
        String elapsedInfo = null;
        if (date != null) {
            long elapsedTime = System.currentTimeMillis() - date.getTime();
            elapsedInfo = Logger.formatElapsed(elapsedTime);
        }
        return this._log(this.getPluginAppId(), 3, object, methodName, elapsedInfo + message, null, null, null, new Exception());
    }

    public Date logPerf(Object object, String methodName, ServletRequest request, Date date, String message) {
        String elapsedInfo = null;
        if (date != null) {
            long elapsedTime = System.currentTimeMillis() - date.getTime();
            elapsedInfo = Logger.formatElapsed(elapsedTime);
        }
        return this._log(this.getPluginAppId(), 3, object, methodName, elapsedInfo + message, request, null, null, new Exception());
    }

    private Date _log(String appId, int type, Object loggingObject, String methodName, String message, ServletRequest request, HttpSession session, ServletContext context, Throwable exception) {
        return Logger._log(appId, type, this.getLogLevel(), loggingObject, methodName, message, request, session, context, exception, false);
    }
}

