/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import org.apache.commons.configuration.Configuration;

public class ViewerDefConfig
extends ConfigurationObject {
    private static final String LAUNCH_URL = "launchUrl";
    private static final String VIEWER_NAME = "viewerName";
    private static final String SERVER_TYPES = "serverTypes";
    private static final String LAUNCH_SEPARATE = "launchInSeparateWindow";
    private static final String LABEL = "label";
    private static final String VIEWER_CLASS = "viewerClass";
    private static final String IS_PREVIEW_VIEWER = "isPreviewViewer";

    public ViewerDefConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.upgrade();
    }

    @Override
    public String getObjectType() {
        return "viewerDef";
    }

    @Override
    protected Class getDataType(String key) {
        Class dataType = String.class;
        if (key.equals(SERVER_TYPES)) {
            dataType = String[].class;
        } else if (key.equals(LAUNCH_SEPARATE)) {
            dataType = Boolean.class;
        } else if (key.equals(IS_PREVIEW_VIEWER)) {
            dataType = Boolean.class;
        }
        return dataType;
    }

    public void upgrade() {
        this.setDefaultValue(IS_PREVIEW_VIEWER, "false");
    }

    public String getLaunchUrl() {
        return this.properties.getProperty(LAUNCH_URL);
    }

    public void setLaunchUrl(String launchUrl) {
        this.properties.setProperty(LAUNCH_URL, launchUrl);
    }

    public String getServerTypes() {
        return this.properties.getProperty(SERVER_TYPES);
    }

    public void setServerTypes(String serverTypes) {
        this.properties.setProperty(SERVER_TYPES, serverTypes);
    }

    public String getViewerName() {
        return this.properties.getProperty(VIEWER_NAME);
    }

    public void setViewerName(String viewerName) {
        this.properties.setProperty(VIEWER_NAME, viewerName);
    }

    public String getLabel() {
        return this.properties.getProperty(LABEL);
    }

    public void setLabel(String label) {
        this.properties.setProperty(LABEL, label);
    }

    public String getLaunchInSeparateWindow() {
        return this.properties.getProperty(LAUNCH_SEPARATE, "false");
    }

    public void setLaunchInSeparateWindow(String launchSeparate) {
        this.properties.setProperty(LAUNCH_SEPARATE, launchSeparate);
    }

    public String getViewerClass() {
        return this.properties.getProperty(VIEWER_CLASS, "ecm.widget.viewer.IframeDocViewer");
    }

    public void setViewerClass(String viewerClass) {
        this.properties.setProperty(VIEWER_CLASS, viewerClass);
    }

    public boolean getIsPreviewViewer() {
        return Boolean.valueOf(this.properties.getProperty(IS_PREVIEW_VIEWER, "false"));
    }

    public void setIsPreviewViewer(boolean isPreviewViewer) {
        this.properties.setProperty(IS_PREVIEW_VIEWER, Boolean.toString(isPreviewViewer));
    }
}

