/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.ViewerMappingConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.json.java.JSONArray;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

public class ViewerConfig
extends ConfigurationObject {
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String MAPPINGS = "mappings";

    @Override
    public String getObjectType() {
        return "viewer";
    }

    public ViewerConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    protected Class getDataType(String key) {
        if (key.equals(MAPPINGS)) {
            return String[].class;
        }
        return String.class;
    }

    @Override
    public Collection getList(String type, String appName, HttpServletRequest request) {
        if (type.equals(MAPPINGS)) {
            return this.getViewerMappingList();
        }
        return null;
    }

    public void setName(String name) {
        this.properties.setProperty(NAME, name);
    }

    @Override
    public String getName() {
        return this.properties.getProperty(NAME);
    }

    public void setDescription(String name) {
        this.properties.setProperty(DESCRIPTION, name);
    }

    public String getDescription() {
        return this.properties.getProperty(DESCRIPTION);
    }

    public String[] getMappingsId() {
        return this.stringToArray(this.properties.getProperty(MAPPINGS));
    }

    public void setMappingsId(String[] mappings) {
        this.properties.setProperty(MAPPINGS, this.arrayToString(mappings));
    }

    public Collection<ViewerMappingConfig> getViewerMappingList() {
        return this.getViewerMappingsMap().values();
    }

    public Map<String, ViewerMappingConfig> getViewerMappingsMap() {
        return this.getMap(ViewerMappingConfig.class, this.getIdPrefix(), this.getMappingsId(), true);
    }

    public JSONArray getViewerMappingsJSON() {
        JSONArray jsonViewerMappings = new JSONArray();
        for (ViewerMappingConfig mappingConfig : this.getViewerMappingList()) {
            jsonViewerMappings.add(mappingConfig.toJSON());
        }
        return jsonViewerMappings;
    }

    @Override
    public void delete() {
        String methodName = "delete";
        String[] mappingIDs = this.getMappingsId();
        if (mappingIDs != null) {
            for (int i = 0; i < mappingIDs.length; ++i) {
                String id = mappingIDs[i];
                try {
                    ViewerMappingConfig config = Config.getConfiguration(ViewerMappingConfig.class, this.getIdPrefix(), id, new boolean[0]);
                    config.delete();
                    Config.removeConfigurationFromCache(config);
                    continue;
                }
                catch (ConfigurationException e) {
                    AdminLogger.logError(ViewerConfig.class, (String)methodName, (Throwable)e);
                    continue;
                }
                catch (MissingValueException e) {
                    AdminLogger.logError(ViewerConfig.class, (String)methodName, (Throwable)e);
                }
            }
        }
        super.delete();
    }
}

