/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.viewone.DaejaConfigFileUtil;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public class ViewOneConfig
extends ConfigurationObject {
    private static final String DAEJA_VIEWONEPRO_STREAM_PDF = "daejaStreamPDF";
    private static final String DAEJA_VIEWONEPRO_STREAM_TIFF = "daejaStreamTIFF";
    private static final String DAEJA_VIEWONEPRO_EDIT_ANNOTATIONS = "proEditAnnotations";
    private static final String DAEJA_VIEWONEPRO_ROUTE_DOCS = "proRouteDocs";
    private static final String DAEJA_VIEWONEPRO_ANNOTATION_UNITS = "proAnnotationUnits";
    private static final String DAEJA_VIEWONEPRO_SCALE = "proScale";
    private static final String DAEJA_VIEWONEPRO_FILE_BUTTONS = "proFileButtons";
    private static final String DAEJA_VIEWONEPRO_FILE_MENUS = "proFileMenus";
    private static final String DAEJA_VIEWONEPRO_PRINT_BUTTONS = "proPrintButtons";
    private static final String DAEJA_VIEWONEPRO_PRINT_MENUS = "proPrintMenus";
    private static final String DAEJA_VIEWONEPRO_INVERT_BUTTONS = "proInvertButtons";
    private static final String DAEJA_VIEWONEPRO_FLIP_BUTTONS = "proFlipButtons";
    private static final String DAEJA_VIEWONEPRO_FILE_KEYS = "proFileKeys";
    private static final String DAEJA_VIEWONEPRO_PRINT_KEYS = "proPrintKeys";
    private static final String DAEJA_VIEWONEPRO_CUSTOM_TOOLTIP = "proCustomTooltip";
    private static final String DAEJA_VIEWONEPRO_ALWAYS_RUBBERBAND = "proAlwaysRubberband";
    private static final String DAEJA_VIEWONEPRO_PHOTOMETRIC = "proPhotometric";
    private static final String DAEJA_VIEWONEPRO_HELP_URL = "proHelpUrl";
    private static final String DAEJA_VIEWONEPRO_CUSTOM_SETTINGS = "proCustomSettings";
    private static final String DAEJA_STREAMER_CACHE_ROOT = "streamerCacheRoot";
    private static final String DAEJA_STREAMER_SESSION_COOKIES = "streamerSessionCookies";
    private static final String DAEJA_STREAMER_CUSTOM_SETTINGS = "streamerCustomSettings";
    private static final String DAEJA_REDACTION_SESSION_COOKIES = "redactionSessionCookies";
    private static final String DAEJA_REDACTION_CUSTOM_SETTINGS = "redactionCustomSettings";
    private static final String DAEJA_VIRTUAL_ROUTE_DOCS = "virtualRouteDocs";
    private static final String DAEJA_VIRTUAL_FILE_BUTTONS = "virtualFileButtons";
    private static final String DAEJA_VIRTUAL_EDIT_ANNOTATIONS = "virtualEditAnnotations";
    private static final String DAEJA_VIRTUAL_CUSTOM_TOOLTIP = "virtualCustomTooltip";
    private static final String DAEJA_VIRTUAL_SESSION_COOKIES = "virtualSessionCookies";
    private static final String DAEJA_VIRTUAL_CUSTOM_SETTINGS = "virtualCustomSettings";
    private static Set<String> booleanSettings = new HashSet<String>();
    private static Map<String, String> proMap = new HashMap<String, String>();
    private static Set<String> serviceExclude = new HashSet<String>();
    private static Set<String> proExclude = new HashSet<String>();
    private static Map<String, String> platformMap = new HashMap<String, String>();
    private static Map<String, String> virtualMap = new HashMap<String, String>();
    private boolean _replaceProJSP = true;

    public ViewOneConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.upgrade();
    }

    @Override
    public String getObjectType() {
        return "viewOne";
    }

    @Override
    protected Class getDataType(String key) {
        if (booleanSettings.contains(key)) {
            return Boolean.class;
        }
        return String.class;
    }

    private void upgrade() {
        this.setDefaultValue(DAEJA_VIEWONEPRO_STREAM_PDF, "true");
        this.setDefaultValue(DAEJA_VIEWONEPRO_STREAM_TIFF, "true");
        this.setDefaultValue(DAEJA_STREAMER_CACHE_ROOT, DaejaConfigFileUtil.getProperty((String)"streamer.cacheRoot"));
        this.setDefaultValue(DAEJA_STREAMER_SESSION_COOKIES, DaejaConfigFileUtil.getProperty((String)"streamer.sessionCookieList"));
        this.setDefaultValue(DAEJA_REDACTION_SESSION_COOKIES, DaejaConfigFileUtil.getProperty((String)"redact.sessionCookieList"));
        this.setDefaultValue(DAEJA_VIRTUAL_ROUTE_DOCS, "false");
        this.setDefaultValue(DAEJA_VIRTUAL_EDIT_ANNOTATIONS, "true");
        this.setDefaultValue(DAEJA_VIRTUAL_FILE_BUTTONS, "false");
        this.setDefaultValue(DAEJA_VIRTUAL_SESSION_COOKIES, "JSESSIONID");
        this.loadVirtualCustomDefaults();
        for (Map.Entry<String, String> entry : proMap.entrySet()) {
            this.setDefaultValue(entry.getKey(), DaejaConfigFileUtil.getAppletProperty((String)entry.getValue()));
        }
        if (this.properties.getProperty(DAEJA_VIEWONEPRO_CUSTOM_SETTINGS) == null) {
            this.importProConfiguration();
        }
        if (this.properties.getProperty(DAEJA_STREAMER_CUSTOM_SETTINGS) == null) {
            this.importServiceConfiguration(DAEJA_STREAMER_CUSTOM_SETTINGS, DaejaConfigFileUtil.getStreamerPropertyKeySet(), "streamer");
        }
        if (this.properties.getProperty(DAEJA_REDACTION_CUSTOM_SETTINGS) == null) {
            this.importServiceConfiguration(DAEJA_REDACTION_CUSTOM_SETTINGS, DaejaConfigFileUtil.getRedactionPropertyKeySet(), "redact");
        }
    }

    private void importProConfiguration() {
        JSONObject jsonObject = null;
        for (String key : DaejaConfigFileUtil.getAppletPropertyKeySet()) {
            if (proMap.containsValue(key) || proExclude.contains(key)) continue;
            if (jsonObject == null) {
                jsonObject = new JSONObject();
            }
            jsonObject.put(key, DaejaConfigFileUtil.getAppletProperty((String)key));
        }
        if (jsonObject != null) {
            this.setDefaultValue(DAEJA_VIEWONEPRO_CUSTOM_SETTINGS, jsonObject.toString());
        } else if (this.getProCustomSettings() == null) {
            this._replaceProJSP = false;
        }
    }

    private void importServiceConfiguration(String serviceCustomKey, Set defaultKeySet, String keyPrefix) {
        if (this.properties.getProperty(serviceCustomKey) == null) {
            JSONObject jsonObject = null;
            for (String key : defaultKeySet) {
                if (serviceExclude.contains(key)) continue;
                if (jsonObject == null) {
                    jsonObject = new JSONObject();
                }
                jsonObject.put(key, DaejaConfigFileUtil.getProperty((String)(keyPrefix + "." + key)));
            }
            if (jsonObject != null) {
                this.setDefaultValue(serviceCustomKey, jsonObject.toString());
            }
        }
    }

    private void loadVirtualCustomDefaults() {
        boolean modified = false;
        JSONObject jsonObject = this.getJSONObject(DAEJA_VIRTUAL_CUSTOM_SETTINGS);
        modified = this.setDefaultValue(jsonObject, "modifiedDocumentCheckMethod", "uniqueid");
        if (modified) {
            this.properties.setProperty(DAEJA_VIRTUAL_CUSTOM_SETTINGS, jsonObject.toString());
        }
    }

    private boolean setDefaultValue(JSONObject jsonObject, String key, String value) {
        boolean containsKey = jsonObject.containsKey(key);
        if (!containsKey) {
            jsonObject.put(key, value);
        }
        return !containsKey;
    }

    private JSONObject getJSONObject(String key) {
        JSONObject jsonObject = null;
        String jsonString = this.properties.getProperty(key);
        try {
            jsonObject = jsonString != null ? JSONObject.parse(jsonString) : new JSONObject();
        }
        catch (IOException ioe) {
            jsonObject = new JSONObject();
        }
        return jsonObject;
    }

    public boolean replaceProJSP() {
        return this._replaceProJSP;
    }

    public boolean getDaejaStreamPDF() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_STREAM_PDF, "true"));
    }

    public void setDaejaStreamPDF(boolean p8DaejaStreamPDF) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_STREAM_PDF, Boolean.toString(p8DaejaStreamPDF));
    }

    public boolean getDaejaStreamTIFF() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_STREAM_TIFF, "true"));
    }

    public void setDaejaStreamTIFF(boolean p8DaejaStreamTIFF) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_STREAM_TIFF, Boolean.toString(p8DaejaStreamTIFF));
    }

    public boolean getProEditAnnotations() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_EDIT_ANNOTATIONS));
    }

    public void setProEditAnnotations(boolean proEditAnnotations) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_EDIT_ANNOTATIONS, Boolean.toString(proEditAnnotations));
    }

    public boolean getProRouteDocs() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_ROUTE_DOCS));
    }

    public void setProRouteDocs(boolean proRouteDocs) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_ROUTE_DOCS, Boolean.toString(proRouteDocs));
    }

    public String getProAnnotationUnits() {
        return this.properties.getProperty(DAEJA_VIEWONEPRO_ANNOTATION_UNITS);
    }

    public void setProAnnotationUnits(String proAnnotationUnits) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_ANNOTATION_UNITS, proAnnotationUnits);
    }

    public String getProScale() {
        return this.properties.getProperty(DAEJA_VIEWONEPRO_SCALE);
    }

    public void setProScale(String proScale) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_SCALE, proScale);
    }

    public boolean getProFileButtons() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_FILE_BUTTONS));
    }

    public void setProFileButtons(boolean proFileButtons) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_FILE_BUTTONS, Boolean.toString(proFileButtons));
    }

    public boolean getProFileMenus() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_FILE_MENUS));
    }

    public void setProFileMenus(boolean proFileMenus) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_FILE_MENUS, Boolean.toString(proFileMenus));
    }

    public boolean getProPrintButtons() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_PRINT_BUTTONS));
    }

    public void setProPrintButtons(boolean proPrintButtons) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_PRINT_BUTTONS, Boolean.toString(proPrintButtons));
    }

    public boolean getProPrintMenus() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_PRINT_MENUS));
    }

    public void setProPrintMenus(boolean proPrintMenus) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_PRINT_MENUS, Boolean.toString(proPrintMenus));
    }

    public boolean getProInvertButtons() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_INVERT_BUTTONS));
    }

    public void setProInvertButtons(boolean proInvertButtons) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_INVERT_BUTTONS, Boolean.toString(proInvertButtons));
    }

    public boolean getProFlipButtons() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_FLIP_BUTTONS));
    }

    public void setProFlipButtons(boolean proFlipButtons) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_FLIP_BUTTONS, Boolean.toString(proFlipButtons));
    }

    public boolean getProFileKeys() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_FILE_KEYS));
    }

    public void setProFileKeys(boolean proFileKeys) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_FILE_KEYS, Boolean.toString(proFileKeys));
    }

    public boolean getProPrintKeys() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_PRINT_KEYS));
    }

    public void setProPrintKeys(boolean proPrintKeys) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_PRINT_KEYS, Boolean.toString(proPrintKeys));
    }

    public String getProCustomTooltip() {
        return this.properties.getProperty(DAEJA_VIEWONEPRO_CUSTOM_TOOLTIP);
    }

    public void setProCustomTooltip(String proCustomTooltip) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_CUSTOM_TOOLTIP, proCustomTooltip);
    }

    public boolean getProAlwaysRubberband() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_ALWAYS_RUBBERBAND));
    }

    public void setProAlwaysRubberband(boolean proAlwaysRubberband) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_ALWAYS_RUBBERBAND, Boolean.toString(proAlwaysRubberband));
    }

    public boolean getProPhotometric() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_PHOTOMETRIC));
    }

    public void setProPhotometric(boolean proPhotometric) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_PHOTOMETRIC, Boolean.toString(proPhotometric));
    }

    public String getProHelpUrl() {
        return this.properties.getProperty(DAEJA_VIEWONEPRO_HELP_URL);
    }

    public void setProHelpUrl(String proHelpUrl) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_HELP_URL, proHelpUrl);
    }

    public String getProCustomSettings() {
        return this.properties.getProperty(DAEJA_VIEWONEPRO_CUSTOM_SETTINGS);
    }

    public void setProCustomSettings(String proCustomSettings) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_CUSTOM_SETTINGS, proCustomSettings);
    }

    public String getStreamerCacheRoot() {
        return this.properties.getProperty(DAEJA_STREAMER_CACHE_ROOT);
    }

    public void setStreamerCacheRoot(String streamerCacheRoot) {
        this.properties.setProperty(DAEJA_STREAMER_CACHE_ROOT, streamerCacheRoot);
    }

    public String getStreamerSessionCookies() {
        return this.properties.getProperty(DAEJA_STREAMER_SESSION_COOKIES);
    }

    public void setStreamerSessionCookies(String streamerSessionCookies) {
        this.properties.setProperty(DAEJA_STREAMER_SESSION_COOKIES, streamerSessionCookies);
    }

    public String getStreamerCustomSettings() {
        return this.properties.getProperty(DAEJA_STREAMER_CUSTOM_SETTINGS);
    }

    public void setStreamerCustomSettings(String streamerCustomSettings) {
        this.properties.setProperty(DAEJA_STREAMER_CUSTOM_SETTINGS, streamerCustomSettings);
    }

    public String getRedactionSessionCookies() {
        return this.properties.getProperty(DAEJA_REDACTION_SESSION_COOKIES);
    }

    public void setRedactionSessionCookies(String redactionSessionCookies) {
        this.properties.setProperty(DAEJA_REDACTION_SESSION_COOKIES, redactionSessionCookies);
    }

    public String getRedactionCustomSettings() {
        return this.properties.getProperty(DAEJA_REDACTION_CUSTOM_SETTINGS);
    }

    public void setRedactionCustomSettings(String redactionCustomSettings) {
        this.properties.setProperty(DAEJA_REDACTION_CUSTOM_SETTINGS, redactionCustomSettings);
    }

    public boolean getVirtualEditAnnotations() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIRTUAL_EDIT_ANNOTATIONS));
    }

    public void setVirtualEditAnnotations(boolean virtualEditAnnotations) {
        this.properties.setProperty(DAEJA_VIRTUAL_EDIT_ANNOTATIONS, Boolean.toString(virtualEditAnnotations));
    }

    public boolean getVirtualRouteDocs() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIRTUAL_ROUTE_DOCS));
    }

    public void setVirtualRouteDocs(boolean virtualRouteDocs) {
        this.properties.setProperty(DAEJA_VIRTUAL_ROUTE_DOCS, Boolean.toString(virtualRouteDocs));
    }

    public boolean getVirtualFileButtons() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIRTUAL_FILE_BUTTONS));
    }

    public void setVirtualFileButtons(boolean virtualFileButtons) {
        this.properties.setProperty(DAEJA_VIRTUAL_FILE_BUTTONS, Boolean.toString(virtualFileButtons));
    }

    public String getVirtualCustomTooltip() {
        return this.properties.getProperty(DAEJA_VIRTUAL_CUSTOM_TOOLTIP);
    }

    public void setVirtualCustomTooltip(String virtualCustomTooltip) {
        this.properties.setProperty(DAEJA_VIRTUAL_CUSTOM_TOOLTIP, virtualCustomTooltip);
    }

    public String getVirtualSessionCookies() {
        return this.properties.getProperty(DAEJA_STREAMER_SESSION_COOKIES);
    }

    public void setVirtualSessionCookies(String streamerSessionCookies) {
        this.properties.setProperty(DAEJA_STREAMER_SESSION_COOKIES, streamerSessionCookies);
    }

    public String getVirtualCustomSettings() {
        return this.properties.getProperty(DAEJA_VIRTUAL_CUSTOM_SETTINGS);
    }

    public void setVirtualCustomSettings(String virtualCustomSettings) {
        this.properties.setProperty(DAEJA_VIRTUAL_CUSTOM_SETTINGS, virtualCustomSettings);
    }

    public void transferViewonePlatformProperties(Properties properties, boolean virtualOnly, Logger.LoggingContext loggingContext) {
        String methodName = "transferViewonePlatformProperties";
        Logger.logEntry((Object)this, methodName, loggingContext);
        if (virtualOnly) {
            Logger.logDebug((Object)this, methodName, loggingContext, "Transferring ViewONE Virtual configuration.");
            this.transferFixedSettings(properties, virtualMap, loggingContext);
            this.transferPlaformCustomSettings(properties, this.getVirtualCustomSettings(), null, loggingContext);
        } else {
            Logger.logDebug((Object)this, methodName, loggingContext, "Transferring ViewONE services configuration.");
            this.transferFixedSettings(properties, platformMap, loggingContext);
            this.transferPlaformCustomSettings(properties, this.getStreamerCustomSettings(), "streamer", loggingContext);
            this.transferPlaformCustomSettings(properties, this.getRedactionCustomSettings(), "redact", loggingContext);
            this.transferPlaformCustomSettings(properties, this.getVirtualCustomSettings(), "tile", loggingContext);
        }
        Logger.logExit((Object)this, methodName, loggingContext);
    }

    private void transferFixedSettings(Properties properties, Map<String, String> transferMap, Logger.LoggingContext loggingContext) {
        String methodName = "transferFixedSettings";
        for (String configKey : transferMap.keySet()) {
            String platformKey = transferMap.get(configKey);
            String platformValue = (String)this.properties.get(configKey);
            if (platformValue == null || platformValue.length() <= 0) continue;
            Logger.logDebug((Object)this, methodName, loggingContext, "Transferring setting: " + platformKey + "=" + platformValue);
            properties.put(platformKey, platformValue);
        }
    }

    private void transferPlaformCustomSettings(Properties properties, String jsonString, String prefix, Logger.LoggingContext loggingContext) {
        String methodName = "transferPlaformCustomSettings";
        if (jsonString != null && jsonString.length() > 0) {
            try {
                JSONArtifact artifact = JSON.parse(jsonString);
                if (artifact instanceof JSONObject) {
                    JSONObject customSettings = (JSONObject)artifact;
                    for (String configKey : customSettings.keySet()) {
                        String qualifiedKey = prefix != null ? prefix + "." + configKey : configKey;
                        String customValue = (String)customSettings.get(configKey);
                        Logger.logDebug((Object)this, methodName, loggingContext, "Transferring custom setting: " + qualifiedKey + "=" + customValue);
                        properties.put(qualifiedKey, customValue);
                    }
                }
            }
            catch (IOException ioe) {
                Logger.logError((Object)this, methodName, loggingContext, (Throwable)ioe);
            }
        }
    }

    static {
        proMap.put(DAEJA_VIEWONEPRO_EDIT_ANNOTATIONS, "annotateEdit");
        proMap.put(DAEJA_VIEWONEPRO_ANNOTATION_UNITS, "annotationUnits");
        proMap.put(DAEJA_VIEWONEPRO_ROUTE_DOCS, "routeDocs");
        proMap.put(DAEJA_VIEWONEPRO_SCALE, "scale");
        proMap.put(DAEJA_VIEWONEPRO_CUSTOM_TOOLTIP, "customAnnotationToolTip");
        proMap.put(DAEJA_VIEWONEPRO_FILE_BUTTONS, "fileButtons");
        proMap.put(DAEJA_VIEWONEPRO_FILE_KEYS, "fileKeys");
        proMap.put(DAEJA_VIEWONEPRO_FILE_MENUS, "fileMenus");
        proMap.put(DAEJA_VIEWONEPRO_PRINT_BUTTONS, "printButtons");
        proMap.put(DAEJA_VIEWONEPRO_PRINT_KEYS, "printKeys");
        proMap.put(DAEJA_VIEWONEPRO_PRINT_MENUS, "printMenus");
        proMap.put(DAEJA_VIEWONEPRO_INVERT_BUTTONS, "invertButtons");
        proMap.put(DAEJA_VIEWONEPRO_FLIP_BUTTONS, "flipButtons");
        proMap.put(DAEJA_VIEWONEPRO_ALWAYS_RUBBERBAND, "filenetAlwaysRubberband");
        proMap.put(DAEJA_VIEWONEPRO_PHOTOMETRIC, "Photometric");
        proMap.put(DAEJA_VIEWONEPRO_HELP_URL, DAEJA_VIEWONEPRO_HELP_URL);
        proExclude.add("trace");
        proExclude.add("traceNet");
        proExclude.add("traceAnnotation");
        serviceExclude.add("trace");
        serviceExclude.add("traceNet");
        serviceExclude.add("logFile");
        serviceExclude.add("cacheRoot");
        serviceExclude.add("sessionCookieList");
        booleanSettings.add(DAEJA_VIEWONEPRO_STREAM_PDF);
        booleanSettings.add(DAEJA_VIEWONEPRO_STREAM_TIFF);
        booleanSettings.add(DAEJA_VIEWONEPRO_EDIT_ANNOTATIONS);
        booleanSettings.add(DAEJA_VIEWONEPRO_ROUTE_DOCS);
        booleanSettings.add(DAEJA_VIEWONEPRO_FILE_BUTTONS);
        booleanSettings.add(DAEJA_VIEWONEPRO_FILE_MENUS);
        booleanSettings.add(DAEJA_VIEWONEPRO_PRINT_BUTTONS);
        booleanSettings.add(DAEJA_VIEWONEPRO_PRINT_MENUS);
        booleanSettings.add(DAEJA_VIEWONEPRO_INVERT_BUTTONS);
        booleanSettings.add(DAEJA_VIEWONEPRO_FLIP_BUTTONS);
        booleanSettings.add(DAEJA_VIEWONEPRO_FILE_KEYS);
        booleanSettings.add(DAEJA_VIEWONEPRO_PRINT_KEYS);
        booleanSettings.add(DAEJA_VIEWONEPRO_ALWAYS_RUBBERBAND);
        booleanSettings.add(DAEJA_VIEWONEPRO_PHOTOMETRIC);
        booleanSettings.add(DAEJA_VIRTUAL_ROUTE_DOCS);
        booleanSettings.add(DAEJA_VIRTUAL_FILE_BUTTONS);
        booleanSettings.add(DAEJA_VIRTUAL_EDIT_ANNOTATIONS);
        platformMap.put(DAEJA_STREAMER_CACHE_ROOT, "streamer.cacheRoot");
        platformMap.put(DAEJA_STREAMER_SESSION_COOKIES, "streamer.sessionCookieList");
        platformMap.put(DAEJA_REDACTION_SESSION_COOKIES, "redact.sessionCookieList");
        platformMap.put(DAEJA_VIRTUAL_ROUTE_DOCS, "tile.routeDocs");
        platformMap.put(DAEJA_VIRTUAL_FILE_BUTTONS, "tile.fileButtons");
        platformMap.put(DAEJA_VIRTUAL_EDIT_ANNOTATIONS, "tile.annotateEdit");
        platformMap.put(DAEJA_VIRTUAL_CUSTOM_TOOLTIP, "tile.customAnnotationToolTip");
        platformMap.put(DAEJA_VIRTUAL_SESSION_COOKIES, "tile.sessionCookieList");
        virtualMap.put(DAEJA_VIRTUAL_ROUTE_DOCS, "routeDocs");
        virtualMap.put(DAEJA_VIRTUAL_FILE_BUTTONS, "fileButtons");
        virtualMap.put(DAEJA_VIRTUAL_EDIT_ANNOTATIONS, "annotateEdit");
        virtualMap.put(DAEJA_VIRTUAL_CUSTOM_TOOLTIP, "customAnnotationToolTip");
    }
}

