/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.FavoriteConfig;
import com.ibm.ecm.configuration.RecentItemConfig;
import com.ibm.ecm.configuration.RecentSearchConfig;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;

public class UserConfig
extends ConfigurationObject {
    private static final String FAVORITES = "favorites";
    private static final String RECENT_SEARCHES = "recentSearches";
    private static final String RECENT_ITEMS = "recentItems";
    public static final int FAVORITE_CAP = 100;
    public static final int RECENT_SEARCH_CAP = 10;
    public static final int RECENT_ITEM_CAP = 20;

    @Override
    public String getObjectType() {
        return "user";
    }

    public UserConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    protected Class getDataType(String key) {
        if (key.equals(FAVORITES)) {
            return String[].class;
        }
        return String.class;
    }

    @Override
    public Collection getList(String type, String appName, HttpServletRequest request) {
        if (type != null) {
            if (type.equals(FAVORITES)) {
                return this.getFavoriteList();
            }
            if (type.equals(RECENT_SEARCHES)) {
                return this.getRecentSearchList();
            }
            if (type.equals(RECENT_ITEMS)) {
                return this.getRecentItemList();
            }
        }
        return super.getList(type, appName, request);
    }

    public String[] getFavoritesId() {
        return this.stringToArray(this.properties.getProperty(FAVORITES));
    }

    public void setFavoritesId(String[] favorites) {
        this.properties.setProperty(FAVORITES, this.arrayToString(favorites));
    }

    public Collection<FavoriteConfig> getFavoriteList() {
        return this.getFavoritesMap().values();
    }

    public boolean isFavorteMax() {
        return this.getFavoriteList().size() >= 100;
    }

    public Map<String, FavoriteConfig> getFavoritesMap() {
        return this.getMap(FavoriteConfig.class, this.getIdPrefix(), this.getFavoritesId(), true);
    }

    public boolean isRecentSearchMax() {
        return this.getRecentSearchList().size() >= 10;
    }

    public Collection<RecentSearchConfig> getRecentSearchList() {
        LinkedList<RecentSearchConfig> recentSearches;
        block8: {
            recentSearches = null;
            String value = this.properties.getProperty(RECENT_SEARCHES);
            if (value == null) break block8;
            if (value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']') {
                JSONArray jsonArray;
                try {
                    jsonArray = (JSONArray)JSON.parse(value);
                }
                catch (Exception e) {
                    Logger.logError(UserConfig.class, "getRecentSearchList", "Unable to parse recent searches", (Throwable)e);
                    return null;
                }
                Iterator i = jsonArray.iterator();
                recentSearches = new LinkedList<RecentSearchConfig>();
                while (i.hasNext()) {
                    RecentSearchConfig recentSearchConfig = new RecentSearchConfig(this.getConfigurationObject(), this.getIdPrefix(), null);
                    recentSearchConfig.setValues((JSONObject)i.next());
                    recentSearches.add(recentSearchConfig);
                }
            } else {
                try {
                    String[] idArray;
                    for (String id : idArray = this.stringToArray(value)) {
                        RecentSearchConfig config = Config.getConfiguration(RecentSearchConfig.class, this.getIdPrefix(), id, new boolean[0]);
                        config.delete();
                        Config.removeConfigurationFromCache(config);
                    }
                    this.properties.remove(RECENT_SEARCHES);
                    this.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return recentSearches;
    }

    public void addRecentSearch(RecentSearchConfig recentSearchConfig) throws IOException {
        JSONArray jsonArray = new JSONArray();
        Collection<RecentSearchConfig> recentSearches = this.getRecentSearchList();
        if (recentSearches != null) {
            for (RecentSearchConfig currRecentSearchConfig : recentSearches) {
                if (recentSearchConfig.equals(currRecentSearchConfig)) continue;
                jsonArray.add(currRecentSearchConfig.toJSON());
                if (jsonArray.size() != 10) continue;
                jsonArray.remove(0);
            }
        }
        jsonArray.add(recentSearchConfig.toJSON());
        this.setProperty(RECENT_SEARCHES, jsonArray.serialize());
    }

    public Collection<RecentItemConfig> getRecentItemList() {
        LinkedList<RecentItemConfig> recentItems = null;
        String value = this.properties.getProperty(RECENT_ITEMS);
        if (value != null) {
            JSONArray jsonArray;
            try {
                jsonArray = (JSONArray)JSON.parse(value);
            }
            catch (Exception e) {
                Logger.logError(UserConfig.class, "getRecentItemList", "Unable to parse recent items", (Throwable)e);
                return null;
            }
            Iterator i = jsonArray.iterator();
            recentItems = new LinkedList<RecentItemConfig>();
            while (i.hasNext()) {
                RecentItemConfig recentItemConfig = new RecentItemConfig(this.getConfigurationObject(), this.getIdPrefix(), null);
                recentItemConfig.setValues((JSONObject)i.next());
                recentItems.add(recentItemConfig);
            }
        }
        return recentItems;
    }

    public void addRecentItem(RecentItemConfig recentItemConfig) throws IOException {
        JSONArray jsonArray = new JSONArray();
        Collection<RecentItemConfig> recentItems = this.getRecentItemList();
        if (recentItems != null) {
            for (RecentItemConfig currRecentItemConfig : recentItems) {
                if (recentItemConfig.equals(currRecentItemConfig)) continue;
                jsonArray.add(currRecentItemConfig.toJSON());
                if (jsonArray.size() != 20) continue;
                jsonArray.remove(0);
            }
        }
        jsonArray.add(recentItemConfig.toJSON());
        this.setProperty(RECENT_ITEMS, jsonArray.serialize());
    }

    @Override
    public void removeValuesFromList(String key, List<String> deleteValues, Properties props) {
        boolean isRecentSearches = key.equals(RECENT_SEARCHES);
        if (isRecentSearches || key.equals(RECENT_ITEMS)) {
            JSONArray jsonArray;
            try {
                jsonArray = (JSONArray)JSON.parse(props.getProperty(key));
            }
            catch (Exception e) {
                Logger.logError(UserConfig.class, "removeValuesFromList", "Unable to parse recent " + (isRecentSearches ? "searches" : "items"), (Throwable)e);
                return;
            }
            boolean removed = false;
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObj = (JSONObject)jsonArray.get(i);
                String id = (String)jsonObj.get(isRecentSearches ? "templateId" : "itemId");
                String vsId = (String)jsonObj.get("vsId");
                if (!this.isInList(deleteValues, id) && (vsId == null || !this.isInList(deleteValues, vsId))) continue;
                jsonArray.remove(i);
                --i;
                removed = true;
            }
            if (removed) {
                try {
                    props.setProperty(key, jsonArray.serialize());
                }
                catch (Exception e) {
                    Logger.logError(UserConfig.class, "removeValuesFromList", "Unable to serialize recent " + (isRecentSearches ? "searches" : "items"), (Throwable)e);
                }
            }
        } else {
            super.removeValuesFromList(key, deleteValues, props);
        }
    }
}

