/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.FileTypeConfig;
import com.ibm.ecm.configuration.IconStatusConfig;
import com.ibm.ecm.configuration.InterfaceTextConfig;
import com.ibm.ecm.configuration.InterfaceTextLocaleConfig;
import com.ibm.ecm.configuration.UserActionMacroConfig;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.util.viewone.DaejaConfigFileUtil;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.configuration.Configuration;

public class SettingsConfig
extends ConfigurationObject {
    private static final String LOGGING_LEVEL = "logging.level";
    private static final String LOGGING_CLASS_INCLUDES = "logging.class.includes";
    private static final String LOGGING_CLASS_EXCLUDES = "logging.class.excludes";
    private static final String LOGGING_DEBUG_USERS = "logging.debug.users";
    private static final String LOGGING_DEBUG_HOSTS = "logging.debug.hosts";
    private static final String OFFICE_LOGGING_LEVEL = "office.logging.level";
    private static final String OFFICE_LOGGING_CLASS_INCLUDES = "office.logging.class.includes";
    private static final String OFFICE_LOGGING_CLASS_EXCLUDES = "office.logging.class.excludes";
    private static final String OFFICE_LOGGING_DEBUG_USERS = "office.logging.debug.users";
    private static final String OFFICE_LOGGING_DEBUG_HOSTS = "office.logging.debug.hosts";
    private static final String OFFICE_LOGGING_FILE_SIZE = "office.logging.file.size";
    private static final String OFFICE_LOGGING_SHOW_STRACKTRACE_ON_DIALOGS = "office.logging.show.stacktrace.on.dialogs";
    private static final String DISABLE_AUTOCOMPLETE = "disableAutocomplete";
    private static final String CULTURAL_COLLATION = "culturalCollation";
    private static final String ADMIN_USERS = "adminUsers";
    private static final String ICON_STATUS = "iconStatus";
    private static final String OD_LANGUAGE = "odLanguage";
    private static final String OD_TEMPDIR = "odTempdir";
    private static final String OD_TRACEDIR = "odTracedir";
    private static final String OD_TRACELEVEL = "odTracelevel";
    private static final String OD_MAX_TRACE_FILESIZE = "odMaxTraceFilesize";
    private static final String OD_AFP2PDF_INSTALLDIR = "odAfp2pdfInstalldir";
    private static final String OD_CUSTOM_PROPS = "odCustomProperties";
    private static final String DAEJA_VIEWONEPRO_TRACE = "daejaViewONEProTrace";
    private static final String DAEJA_VIEWONEPRO_TRACE_NET = "daejaViewONEProTraceNet";
    private static final String DAEJA_VIEWONEPRO_TRACE_ANNOTATIONS = "daejaViewONEProTraceAnnotations";
    private static final String DAEJA_VIRTUAL_TRACE = "daejaVirtualTrace";
    private static final String DAEJA_VIRTUAL_TRACE_NET = "daejaVirtualTraceNet";
    private static final String DAEJA_VIRTUAL_TRACE_ANNOTATIONS = "daejaVirtualTraceAnnotations";
    private static final String DAEJA_VIRTUAL_LOG_FILE = "daejaVirtualLogFile";
    private static final String DAEJA_STREAMER_TRACE = "daejaStreamerTrace";
    private static final String DAEJA_STREAMER_TRACE_NET = "daejaStreamerTraceNet";
    private static final String DAEJA_STREAMER_LOG_FILE = "daejaStreamerLogFile";
    private static final String DAEJA_REDACTION_TRACE = "daejaRedactionTrace";
    private static final String DAEJA_REDACTION_TRACE_NET = "daejaRedactionTraceNet";
    private static final String DAEJA_REDACTION_LOG_FILE = "daejaRedactionLogFile";
    private static final String TASKMANGER_SERVICE_URL = "taskManagerServiceURL";
    private static final String TASKMANGER_LOG_DIRECTORY = "taskManagerLogDirectory";
    private static final String TASKMANGER_SERVICE_ENABLED = "taskManagerServiceEnabled";
    private static final String TASKMANGER_HEART_BEAT_MONITOR = "taskManagerHeartBeatMonitor";
    private static final String CMC_TTL = "CMCTTL";
    private static final String SYNC_ENABLED = "syncEnabled";
    private static final String FILE_TYPES = "fileTypes";
    private static final String USER_ACTION_MACROS = "userActionMacros";
    public static final String MS_FILE_TYPES = "word,excel,powerpoint,outlook,pdf";
    public static final String ENCRYPTION_KEY = "encryptionKey";
    private static Set<String> booleanSettings = new HashSet<String>();

    public SettingsConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.upgrade();
    }

    @Override
    public String getObjectType() {
        return "settings";
    }

    @Override
    protected Class getDataType(String key) {
        if (booleanSettings.contains(key)) {
            return Boolean.class;
        }
        if (key.equals(LOGGING_LEVEL) || key.equals(OD_MAX_TRACE_FILESIZE) || key.equals(OD_TRACELEVEL)) {
            return Integer.class;
        }
        if (key.equals(ADMIN_USERS) || key.equals(FILE_TYPES) || key.equals(OD_CUSTOM_PROPS) || key.equals(ICON_STATUS) || key.equals(USER_ACTION_MACROS)) {
            return String[].class;
        }
        return String.class;
    }

    private void upgrade() {
        if (!this.isEmpty()) {
            this.setDefaultValue(CMC_TTL, "36000");
            if (this.properties.getProperty(OD_MAX_TRACE_FILESIZE) == null || this.properties.getProperty(OD_MAX_TRACE_FILESIZE).equals("")) {
                this.properties.setProperty(OD_MAX_TRACE_FILESIZE, "0");
            }
            this.setDefaultValue(DAEJA_VIEWONEPRO_TRACE, "false");
            this.setDefaultValue(DAEJA_VIEWONEPRO_TRACE_NET, "false");
            this.setDefaultValue(DAEJA_VIEWONEPRO_TRACE_ANNOTATIONS, "false");
            this.setDefaultValue(DAEJA_STREAMER_TRACE, "false");
            this.setDefaultValue(DAEJA_STREAMER_TRACE_NET, "false");
            String configFileValue = DaejaConfigFileUtil.getProperty((String)"streamerstreamer.logFile");
            this.setDefaultValue(DAEJA_STREAMER_LOG_FILE, configFileValue != null ? configFileValue : "");
            this.setDefaultValue(DAEJA_REDACTION_TRACE, "false");
            this.setDefaultValue(DAEJA_REDACTION_TRACE_NET, "false");
            this.setDefaultValue(DAEJA_VIRTUAL_TRACE, "false");
            this.setDefaultValue(DAEJA_VIRTUAL_TRACE_NET, "false");
            this.setDefaultValue(DAEJA_VIRTUAL_TRACE_ANNOTATIONS, "false");
            configFileValue = DaejaConfigFileUtil.getProperty((String)"redact.logFile");
            this.setDefaultValue(DAEJA_REDACTION_LOG_FILE, configFileValue != null ? configFileValue : "");
        }
    }

    public int getCMCTTL() {
        return this.getPropertyValue(CMC_TTL, 36000);
    }

    public void setCMCTTL(int ttl) {
        this.properties.setProperty(CMC_TTL, Integer.toString(ttl));
    }

    public String getLoggingClassIncludes() {
        return this.properties.getProperty(LOGGING_CLASS_INCLUDES, "");
    }

    public void setLoggingClassIncludes(String loggingClassIncludes) {
        this.properties.setProperty(LOGGING_CLASS_INCLUDES, loggingClassIncludes);
    }

    public String getTaskManagerServiceURL() {
        return this.properties.getProperty(TASKMANGER_SERVICE_URL, "");
    }

    public void setTaskManagerServiceURL(String url) {
        this.properties.setProperty(TASKMANGER_SERVICE_URL, url);
    }

    public String getTaskManagerLogDirectory() {
        return this.properties.getProperty(TASKMANGER_LOG_DIRECTORY, "");
    }

    public void setTaskManagerLogDirectory(String directory) {
        this.properties.setProperty(TASKMANGER_LOG_DIRECTORY, directory);
    }

    public String getTaskManagerServiceEnabled() {
        return this.properties.getProperty(TASKMANGER_SERVICE_ENABLED, "");
    }

    public void setTaskManagerServiceEnabled(String enabled) {
        this.properties.setProperty(TASKMANGER_SERVICE_ENABLED, enabled);
    }

    public boolean getTaskManagerHeartBeatMonitor() {
        return Boolean.parseBoolean(this.properties.getProperty(TASKMANGER_HEART_BEAT_MONITOR, "false"));
    }

    public void setTaskManagerHeartBeatMonitor(boolean enabled) {
        this.properties.setProperty(TASKMANGER_HEART_BEAT_MONITOR, Boolean.toString(enabled));
    }

    public String getEncryptionKey() {
        String base64String = this.properties.getProperty(ENCRYPTION_KEY, "");
        String key = null;
        if (base64String != null) {
            byte[] bytes = Base64.decodeBase64((String)base64String);
            try {
                key = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                AdminLogger.logError((Object)this, (String)"getEncryptionKey", (Throwable)e);
            }
        }
        return key;
    }

    public void setEncryptionKey(String key) {
        if (key != null) {
            try {
                byte[] bytes = key.getBytes("UTF-8");
                String encodedKey = Base64.encodeBase64String((byte[])bytes);
                this.properties.setProperty(ENCRYPTION_KEY, encodedKey);
            }
            catch (UnsupportedEncodingException e) {
                AdminLogger.logError((Object)this, (String)"setEncryptionKey", (Throwable)e);
            }
        }
    }

    public String getLoggingClassExcludes() {
        return this.properties.getProperty(LOGGING_CLASS_EXCLUDES, "");
    }

    public void setLoggingClassExcludes(String loggingClassExcludes) {
        this.properties.setProperty(LOGGING_CLASS_EXCLUDES, loggingClassExcludes);
    }

    public String getLoggingDebugUsers() {
        return this.properties.getProperty(LOGGING_DEBUG_USERS, "");
    }

    public void setLoggingDebugUsers(String loggingDebugUsers) {
        this.properties.setProperty(LOGGING_DEBUG_USERS, loggingDebugUsers);
    }

    public String getLoggingDebugHosts() {
        return this.properties.getProperty(LOGGING_DEBUG_HOSTS, "");
    }

    public void setLoggingDebugHosts(String loggingDebugHosts) {
        this.properties.setProperty(LOGGING_DEBUG_HOSTS, loggingDebugHosts);
    }

    public int getLoggingLevel() {
        return this.getPropertyValue(LOGGING_LEVEL, 2);
    }

    public void setLoggingLevel(int loggingLevel) {
        this.properties.setProperty(LOGGING_LEVEL, Integer.toString(loggingLevel));
    }

    public String getOfficeLoggingClassIncludes() {
        return this.properties.getProperty(OFFICE_LOGGING_CLASS_INCLUDES, "");
    }

    public void setOfficeLoggingClassIncludes(String loggingClassIncludes) {
        this.properties.setProperty(OFFICE_LOGGING_CLASS_INCLUDES, loggingClassIncludes);
    }

    public String getOfficeLoggingClassExcludes() {
        return this.properties.getProperty(OFFICE_LOGGING_CLASS_EXCLUDES, "");
    }

    public void setOfficeLoggingClassExcludes(String officeLoggingClassExcludes) {
        this.properties.setProperty(OFFICE_LOGGING_CLASS_EXCLUDES, officeLoggingClassExcludes);
    }

    public String getOfficeLoggingDebugUsers() {
        return this.properties.getProperty(OFFICE_LOGGING_DEBUG_USERS, "");
    }

    public void setOfficeLoggingDebugUsers(String officeLoggingDebugUsers) {
        this.properties.setProperty(OFFICE_LOGGING_DEBUG_USERS, officeLoggingDebugUsers);
    }

    public String getOfficeLoggingDebugHosts() {
        return this.properties.getProperty(OFFICE_LOGGING_DEBUG_HOSTS, "");
    }

    public void setOfficeLoggingDebugHosts(String officeLoggingDebugHosts) {
        this.properties.setProperty(OFFICE_LOGGING_DEBUG_HOSTS, officeLoggingDebugHosts);
    }

    public int getOfficeLoggingLevel() {
        return this.getPropertyValue(OFFICE_LOGGING_LEVEL, 2);
    }

    public void setOfficeLoggingLevel(int officeLoggingLevel) {
        this.properties.setProperty(OFFICE_LOGGING_LEVEL, Integer.toString(officeLoggingLevel));
    }

    public boolean getOfficeLoggingShowStacktraceOnDialogs() {
        return Boolean.parseBoolean(this.properties.getProperty(OFFICE_LOGGING_SHOW_STRACKTRACE_ON_DIALOGS, "false"));
    }

    public void setOficeLoggingShowStacktraceOnDialogs(boolean officeLoggingShowStacktraceOnDialogs) {
        this.properties.setProperty(OFFICE_LOGGING_SHOW_STRACKTRACE_ON_DIALOGS, Boolean.toString(officeLoggingShowStacktraceOnDialogs));
    }

    public int getOfficeLoggingFileSize() {
        return this.getPropertyValue(OFFICE_LOGGING_FILE_SIZE, 2);
    }

    public void setOfficeLoggingFileSize(int officeLoggingFileSize) {
        this.properties.setProperty(OFFICE_LOGGING_FILE_SIZE, Integer.toString(officeLoggingFileSize));
    }

    public boolean getDisableAutocomplete() {
        return Boolean.parseBoolean(this.properties.getProperty(DISABLE_AUTOCOMPLETE, "false"));
    }

    public void setDisableAutocomplete(boolean disableAutocomplete) {
        this.properties.setProperty(DISABLE_AUTOCOMPLETE, Boolean.toString(disableAutocomplete));
    }

    public boolean getCulturalCollation() {
        return Boolean.parseBoolean(this.properties.getProperty(CULTURAL_COLLATION, "false"));
    }

    public void setCulturalCollation(boolean culturalCollation) {
        this.properties.setProperty(CULTURAL_COLLATION, Boolean.toString(culturalCollation));
    }

    public String[] getIconStatusId() {
        return this.stringToArray(this.properties.getProperty(ICON_STATUS));
    }

    public Collection<IconStatusConfig> getIconStatusList() {
        return this.getMap(IconStatusConfig.class, this.getIdPrefix(), this.getIconStatusId(), true).values();
    }

    public String getODLanguage() {
        return this.properties.getProperty(OD_LANGUAGE, "");
    }

    public void setODLanguage(String language) {
        this.properties.setProperty(OD_LANGUAGE, language);
    }

    public String getODTempdir() {
        return this.properties.getProperty(OD_TEMPDIR, "");
    }

    public void setODTempdir(String tempdir) {
        this.properties.setProperty(OD_TEMPDIR, tempdir);
    }

    public String getODTracedir() {
        return this.properties.getProperty(OD_TRACEDIR, "");
    }

    public void setODTracedir(String tracedir) {
        this.properties.setProperty(OD_TRACEDIR, tracedir);
    }

    public String getODTracelevelString() {
        return this.getPropertyValue(OD_TRACELEVEL, "1");
    }

    public int getODTracelevel() {
        return this.getPropertyValue(OD_TRACELEVEL, 1);
    }

    public void setODTracelevel(int tracelevel) {
        this.properties.setProperty(OD_TRACELEVEL, Integer.toString(tracelevel));
    }

    public String getODMaxTraceFilesizeString() {
        return this.getPropertyValue(OD_MAX_TRACE_FILESIZE, "0");
    }

    public int getODMaxTraceFilesize() {
        return this.getPropertyValue(OD_MAX_TRACE_FILESIZE, 0);
    }

    public void setODMaxTraceFilesize(int maxTraceFilesize) {
        this.properties.setProperty(OD_MAX_TRACE_FILESIZE, Integer.toString(maxTraceFilesize));
    }

    public String getODAfp2pdfInstalldir() {
        return this.properties.getProperty(OD_AFP2PDF_INSTALLDIR, "");
    }

    public void setODAfp2pdfInstalldir(String afp2pdfInstalldir) {
        this.properties.setProperty(OD_AFP2PDF_INSTALLDIR, afp2pdfInstalldir);
    }

    public boolean getDaejaViewONEProTrace() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_TRACE, "false"));
    }

    public void setDaejaViewONEProTrace(boolean p8DaejaTrace) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_TRACE, Boolean.toString(p8DaejaTrace));
    }

    public boolean getDaejaViewONEProTraceNet() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_TRACE_NET, "false"));
    }

    public void setDaejaViewONEProTraceNet(boolean p8DaejaTraceNet) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_TRACE_NET, Boolean.toString(p8DaejaTraceNet));
    }

    public boolean getDaejaViewONEProTraceAnnotations() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIEWONEPRO_TRACE_ANNOTATIONS, "false"));
    }

    public void setDaejaViewONEProTraceAnnotations(boolean p8DaejaTraceAnnotations) {
        this.properties.setProperty(DAEJA_VIEWONEPRO_TRACE_ANNOTATIONS, Boolean.toString(p8DaejaTraceAnnotations));
    }

    public boolean getDaejaStreamerTrace() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_STREAMER_TRACE, "false"));
    }

    public void setDaejaStreamerTrace(boolean daejaStreamerTrace) {
        this.properties.setProperty(DAEJA_STREAMER_TRACE, Boolean.toString(daejaStreamerTrace));
    }

    public boolean getDaejaStreamerTraceNet() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_STREAMER_TRACE_NET, "false"));
    }

    public void setDaejaStreamerTraceNet(boolean daejaStreamerTraceNet) {
        this.properties.setProperty(DAEJA_STREAMER_TRACE_NET, Boolean.toString(daejaStreamerTraceNet));
    }

    public String getDeajeStreamerLogFile() {
        return this.properties.getProperty(DAEJA_STREAMER_LOG_FILE, "");
    }

    public void setDaejaStreamerLogFile(String daejaStreamerLogFile) {
        this.properties.setProperty(DAEJA_STREAMER_LOG_FILE, daejaStreamerLogFile);
    }

    public boolean getDaejaRedactionTrace() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_REDACTION_TRACE, "false"));
    }

    public void setDaejaRedactionTrace(boolean daejaRedactionTrace) {
        this.properties.setProperty(DAEJA_REDACTION_TRACE, Boolean.toString(daejaRedactionTrace));
    }

    public boolean getDaejaRedactionTraceNet() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_REDACTION_TRACE_NET, "false"));
    }

    public void setDaejaRedactionTraceNet(boolean daejaRedactionTraceNet) {
        this.properties.setProperty(DAEJA_REDACTION_TRACE_NET, Boolean.toString(daejaRedactionTraceNet));
    }

    public String getDeajeRedactionLogFile() {
        return this.properties.getProperty(DAEJA_REDACTION_LOG_FILE, "");
    }

    public void setDaejaRedactionLogFile(String daejaRedactionLogFile) {
        this.properties.setProperty(DAEJA_REDACTION_LOG_FILE, daejaRedactionLogFile);
    }

    public boolean getDaejaVirtualTrace() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIRTUAL_TRACE, "false"));
    }

    public void setDaejaVirtualTrace(boolean daejaVirtualTrace) {
        this.properties.setProperty(DAEJA_VIRTUAL_TRACE, Boolean.toString(daejaVirtualTrace));
    }

    public boolean getDaejaVirtualTraceNet() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIRTUAL_TRACE_NET, "false"));
    }

    public void setDaejaVirtualTraceNet(boolean daejaVirtualTraceNet) {
        this.properties.setProperty(DAEJA_VIRTUAL_TRACE_NET, Boolean.toString(daejaVirtualTraceNet));
    }

    public boolean getDaejaVirtualTraceAnnotations() {
        return Boolean.parseBoolean(this.properties.getProperty(DAEJA_VIRTUAL_TRACE_ANNOTATIONS, "false"));
    }

    public void setDaejaVirtualTraceAnnotations(boolean daejaVirtualTraceAnnotations) {
        this.properties.setProperty(DAEJA_VIRTUAL_TRACE_ANNOTATIONS, Boolean.toString(daejaVirtualTraceAnnotations));
    }

    public String getDeajeVirtualLogFile() {
        return this.properties.getProperty(DAEJA_VIRTUAL_LOG_FILE, "");
    }

    public void setDaejaVirtualLogFile(String daejaVirtualLogFile) {
        this.properties.setProperty(DAEJA_VIRTUAL_LOG_FILE, daejaVirtualLogFile);
    }

    public String getCustomProperties() {
        return this.properties.getProperty(OD_CUSTOM_PROPS, "");
    }

    public void setCustomProperties(String customProps) {
        this.properties.setProperty(OD_CUSTOM_PROPS, customProps);
    }

    public String[] getAdminUsers() {
        return this.stringToArray(this.properties.getProperty(ADMIN_USERS));
    }

    public void setAdminUsers(String[] adminUsers) {
        this.properties.setProperty(ADMIN_USERS, this.arrayToString(adminUsers));
    }

    public List<String> getAdminUsersList() {
        return this.stringToList(this.properties.getProperty(ADMIN_USERS));
    }

    public String[] getFileTypes() {
        return this.stringToArray(this.properties.getProperty(FILE_TYPES, MS_FILE_TYPES));
    }

    public String[] getFilterredFileType() {
        String fileTypes = this.properties.getProperty(FILE_TYPES);
        if (fileTypes != null && fileTypes.length() > 4) {
            fileTypes = fileTypes.replaceAll("word,", "").trim();
            fileTypes = fileTypes.replaceAll("excel,", "").trim();
            fileTypes = fileTypes.replaceAll("powerpoint,", "").trim();
            fileTypes = fileTypes.replaceAll("outlook,", "").trim();
            fileTypes = fileTypes.replaceAll("pdf,", "").trim();
        }
        return this.stringToArray(fileTypes);
    }

    public void setFileTypes(String[] fileTypes) {
        this.properties.setProperty(FILE_TYPES, this.arrayToString(fileTypes));
    }

    public static String getLocalizedFileTypeLabel(FileTypeConfig fileTypeConfig, Locale locale) {
        String label = fileTypeConfig.getName();
        String id = fileTypeConfig.getObjectId();
        InterfaceTextConfig config = null;
        try {
            config = Config.getInterfaceTextConfig("navigator", id);
        }
        catch (Exception e) {
            return label;
        }
        if (!config.isEmpty() && config.getLocaleData() != null) {
            InterfaceTextLocaleConfig localeConfig = config.getLocaleData();
            if (localeConfig.properties.get(locale.toString()) != null) {
                label = (String)localeConfig.properties.get(locale.toString());
            } else if (localeConfig.properties.get(locale.toString().substring(0, 2)) != null) {
                label = (String)localeConfig.properties.get(locale.toString().substring(0, 2));
            }
        }
        return label;
    }

    @Override
    public Collection getList(String type, String appName, HttpServletRequest request) {
        return type.equals(FILE_TYPES) ? this.getFileTypesList(appName) : (type.equals(USER_ACTION_MACROS) ? this.getUserActionMacrosList(appName) : null);
    }

    public Collection<FileTypeConfig> getFileTypesList(String appName) {
        return this.getFileTypesMap(appName).values();
    }

    public Map<String, FileTypeConfig> getFileTypesMap(String appName) {
        return this.getMacrosMap(appName, FileTypeConfig.class);
    }

    public String[] getUserActionMacros() {
        return this.stringToArray(this.properties.getProperty(USER_ACTION_MACROS, "added.p8, modified.p8, checkedOut.p8, added.cm, modified.cm, checkedOut.cm"));
    }

    public void setUserActionMacros(String[] userActionMacros) {
        this.properties.setProperty(USER_ACTION_MACROS, this.arrayToString(userActionMacros));
    }

    public Collection<UserActionMacroConfig> getUserActionMacrosList(String appName) {
        return this.getUserActionMacrosMap(appName).values();
    }

    public Map<String, UserActionMacroConfig> getUserActionMacrosMap(String appName) {
        return this.getMacrosMap(appName, UserActionMacroConfig.class);
    }

    public <T extends ConfigurationObject> String[] getMacros(Class<T> configClass) {
        String[] macros = null;
        if (configClass == FileTypeConfig.class) {
            macros = this.getFileTypes();
        } else if (configClass == UserActionMacroConfig.class) {
            macros = this.getUserActionMacros();
        }
        return macros;
    }

    public <T extends ConfigurationObject> Map<String, T> getMacrosMap(String appName, Class<T> configClass) {
        if (appName == null || appName.isEmpty()) {
            appName = "navigator";
        }
        Map<String, T> configMap = this.getMap(configClass, appName, this.getMacros(configClass), true);
        for (ConfigurationObject config : configMap.values()) {
            if (!config.isEmpty()) continue;
            configMap = this.getMap(configClass, "navigator.default", this.getMacros(configClass), true);
            break;
        }
        return configMap;
    }

    static {
        booleanSettings.add(CULTURAL_COLLATION);
        booleanSettings.add(DISABLE_AUTOCOMPLETE);
        booleanSettings.add(DAEJA_VIEWONEPRO_TRACE);
        booleanSettings.add(DAEJA_VIEWONEPRO_TRACE_NET);
        booleanSettings.add(DAEJA_VIEWONEPRO_TRACE_ANNOTATIONS);
        booleanSettings.add(DAEJA_VIRTUAL_TRACE);
        booleanSettings.add(DAEJA_VIRTUAL_TRACE_NET);
        booleanSettings.add(DAEJA_VIRTUAL_TRACE_ANNOTATIONS);
        booleanSettings.add(DAEJA_STREAMER_TRACE);
        booleanSettings.add(DAEJA_STREAMER_TRACE_NET);
        booleanSettings.add(DAEJA_REDACTION_TRACE);
        booleanSettings.add(DAEJA_REDACTION_TRACE_NET);
        booleanSettings.add(TASKMANGER_HEART_BEAT_MONITOR);
    }
}

