/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.serviceability.AdminLogger;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public class ServerConfig
extends ConfigurationObject {
    private static final String REPOSITORIES = "repositories";
    private static final String CONFIG_INFO = "configInfo";
    private static final String SERVICE_URL = "serviceURL";
    private static final String LABEL_KEY = "labelKey";
    private static final String USE_ANNOTATION_CLASS_SECURITY = "useAnnotationClassSecurity";
    private static final String TYPE = "type";

    @Override
    public String getObjectType() {
        return "server";
    }

    public ServerConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    protected Class getDataType(String key) {
        if (key.equals(USE_ANNOTATION_CLASS_SECURITY)) {
            return Boolean.class;
        }
        if (key.equals(REPOSITORIES)) {
            return String[].class;
        }
        return String.class;
    }

    public String getType() {
        return this.properties.getProperty(TYPE);
    }

    public void setType(String type) {
        this.properties.setProperty(TYPE, type);
    }

    public String getServiceURL() {
        return this.properties.getProperty(SERVICE_URL);
    }

    public void setServiceURL(String serviceURL) {
        this.properties.setProperty(SERVICE_URL, serviceURL);
    }

    public String getLabelKey() {
        return this.properties.getProperty(LABEL_KEY);
    }

    public void setLabelKey(String labelKey) {
        this.properties.setProperty(LABEL_KEY, labelKey);
    }

    public boolean useAnnotationClassSecurity() {
        return Boolean.parseBoolean(this.properties.getProperty(USE_ANNOTATION_CLASS_SECURITY, "false"));
    }

    public void setUseAnnotationClassSecurity(boolean useAnnotationClassSecurity) {
        this.properties.setProperty(USE_ANNOTATION_CLASS_SECURITY, Boolean.toString(useAnnotationClassSecurity));
    }

    public String getConfigInfo() {
        return this.properties.getProperty(CONFIG_INFO);
    }

    public void setConfigInfo(String configInfo) {
        this.properties.setProperty(CONFIG_INFO, configInfo);
    }

    public String[] getRepositoriesId() {
        return this.stringToArray(this.properties.getProperty(REPOSITORIES));
    }

    public void setRepositoriesId(String[] servers) {
        this.properties.setProperty(REPOSITORIES, this.arrayToString(servers));
    }

    public Collection<RepositoryConfig> getRepositoryList() {
        return this.getMap(RepositoryConfig.class, "navigator", this.getRepositoriesId(), new boolean[0]).values();
    }

    public Map<String, RepositoryConfig> getRepositoryMap() {
        return this.getMap(RepositoryConfig.class, "navigator", this.getRepositoriesId(), new boolean[0]);
    }

    public RepositoryConfig getRepository(String repositoryId) {
        RepositoryConfig repositoryConfig = null;
        try {
            repositoryConfig = Config.getRepositoryConfig("navigator", repositoryId);
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, (String)"getRepository", (String)"unexpected error", (Throwable)e);
        }
        return repositoryConfig;
    }
}

