/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.ConfigurationValidation;
import com.ibm.ecm.configuration.ODLoginConfig;
import com.ibm.ecm.configuration.PropertyMappingConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.UserGroupConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.util.PasswordEncrypter;
import com.ibm.ecm.util.security.Cryption;
import com.ibm.edms.od.ODConfig;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.Key;
import java.util.Collection;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

public class RepositoryConfig
extends ConfigurationObject
implements ConfigurationValidation {
    private static final String INCLUDE_MIME_TYPES_IN_SEARCH_RESULTS = "includeMIMETypesInSearchResults";
    private static final String KEEP_IN_AUTO_FOLDER = "keepInAutoFolder";
    private static final String UPDATE_STORAGE_COLLECTION = "updateStorageCollection";
    private static final String MAX_WORKLISTS = "maxWorklists";
    private static final String MAX_ITEM_TYPES = "maxItemTypes";
    private static final String LANGUAGE_CODES = "languageCodes";
    private static final String ROOT_FOLDER_ID = "rootFolderId";
    private static final String FOLDERING_ENABLED = "folderingEnabled";
    private static final String UNIFIED_SEARCHES_ENABLED = "unifiedSearchesEnabled";
    private static final String SEARCH_MAX_RESULTS = "searchMaxResults";
    private static final String TIMEOUT_IN_SECONDS = "timeoutInSeconds";
    private static final String MATCH_ALL = "matchAll";
    private static final String DEFAULT_SEARCH_TYPE = "defaultSearchType";
    private static final String DEFAULT_SEARCH_VERSION = "defaultSearchVersion";
    private static final String USE_SSO = "useSSO";
    private static final String ANONYMOUS_ACCESS_ENABLED = "anonymousAccessEnabled";
    private static final String DIRECT_RETRIEVE_ENABLED = "directRetrieveEnabled";
    private static final String DOC_MODEL_ONLY_ENABLED = "enableOnlyDocumentItemTypes";
    private static final String CONNECTION_POINT = "connectionPoint";
    private static final String DOMAIN_ID = "domainId";
    private static final String OBJECT_STORE = "objectStore";
    private static final String OBJECT_STORE_DISPLAY_NAME = "objectStoreName";
    private static final String PROTOCOL = "protocol";
    private static final String CMIS_REPOSITORY_ID = "cmisRepositoryID";
    private static final String USE_GZIP_ENCODING = "useGzipEncoding";
    private static final String ADD_AS_MAJOR_VERSION = "addAsMajorVersion";
    private static final String CHECKIN_AS_MAJOR_VERSION = "checkinAsMajorVersion";
    private static final String INCLUDE_WORKFLOW_DEFINITION = "includeWorkflowDefinition";
    private static final String INCLUDE_FORM_TEMPLATE = "includeFormTemplate";
    private static final String ANNOTATION_SECURITY = "annotationSecurity";
    private static final String FOLDER_SEARCH_EXPRESSION = "folderSearchExpression";
    private static final String MAX_HITS = "maxHits";
    private static final String LINE_CONVERSION = "lineConversion";
    private static final String AFP_CONVERSION = "afpConversion";
    private static final String SHOW_DOC_LOCATION = "showDocLocation";
    private static final String TEMP_DIR = "tempDir";
    private static final String TRACE_DIR = "traceDir";
    private static final String TRACE_LEVEL = "traceLevel";
    private static final String PORT_NUMBER = "portNumber";
    private static final String AFP2PD_CONFIG_FILE = "afp2pdfConfigFile";
    private static final String XFORM_XML_FILE = "transformXMLFile";
    private static final String OD_SSL = "odSSL";
    private static final String OD_KEYRING_DBFILE = "odKeyringDBFile";
    private static final String OD_KEYRING_STASHFILE = "odKeyringStashFile";
    private static final String CUSTOM_PROPS = "customProperties";
    private static final String IS_VALID = "isValid";
    private static final String PLUGIN_CONFIGURATION = "pluginConfiguration";
    private static final String MAX_IN_MEMORY_RETRIEVE_SIZE = "maxInMemoryRetrieveSize";
    private static final String MAX_DOWNLOAD_SIZE = "maxDownloadSize";
    private static final String TIMESTAMP_FORMAT = "timestampFormat";
    private static final String TIME_FORMAT = "timeFormat";
    private static final String DATE_FORMAT = "dateFormat";
    private static final String TEAMSPACES_ENABLED = "teamspacesEnabled";
    private static final String TEAMSPACES_OWNER_MODIFY_ROLE = "teamspaceOwnersModifyRoles";
    private static final String TEAMSPACES_DISPLAY_RECENT = "teamspaceDisplayRecent";
    private static final String TEAMSPACES_DISPLAY_RECENT_VALUE = "teamspaceDisplayRecentValue";
    private static final String TEAMSPACES_DELETE_TASK_ENABLE = "teamspaceDeleteTaskEnabled";
    private static final String TEAMSPACES_DELETE_TASK_ID = "teamspaceDeleteTaskId";
    private static final String TEAMSPACES_DELETE_TASK_PWD = "teamspaceDeleteTaskPwd";
    private static final String SERVER_NAME = "serverName";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String DOCUMENT_SYSTEM_PROPERTIES = "documentSystemProperties";
    private static final String FOLDER_SYSTEM_PROPERTIES = "folderSystemProperties";
    private static final String FOLDER_DEF_COLS = "folderDefCols";
    private static final String FOLDER_MAGAZINE_DEF_COLS = "folderMagazineDefCols";
    private static final String SEARCH_DEF_COLS = "searchDefCols";
    private static final String SEARCH_MAGAZINE_DEF_COLS = "searchMagazineDefCols";
    private static final String DOC_NAME_PROPERTY = "docNameProp";
    private static final String FOLDER_NAME_PROPERTY = "folderNameProp";
    private static final String SEARCH_FILTERED_DOCUMENT_PROPERTIES = "searchFilteredDocumentProperties";
    private static final String SEARCH_FILTERED_FOLDER_PROPERTIES = "searchFilteredFolderProperties";
    private static final String SEARCH_OP_DATETIME = "datetimeOp";
    private static final String SEARCH_OP_INTEGER = "integerOp";
    private static final String SEARCH_OP_STRING = "stringOp";
    private static final String SEARCH_OP_BOOLEAN = "booleanOp";
    private static final String SEARCH_OP_OBJECT = "objectOp";
    private static final String SEARCH_OP_ID = "idOp";
    private static final String SEARCH_OP_USER = "userOp";
    private static final String SEARCH_OP_FLOAT = "floatOp";
    public static final String[] SEARCH_FILTERED_OPERATORS_TYPES = new String[]{"datetimeOp", "integerOp", "stringOp", "booleanOp", "objectOp", "idOp", "userOp", "floatOp"};
    private static final String OD_SSO_PASSWD = "ssoPassword";
    private static final String STATUS_DOC_NOTES = "statusDocNotes";
    private static final String STATUS_DOC_HOLD = "statusDocHold";
    private static final String STATUS_DOC_CHECKED_OUT = "statusDocCheckedOut";
    private static final String STATUS_DOC_BOOKMARKS = "statusDocBookmarks";
    private static final String STATUS_DOC_DECLARED_RECORD = "statusDocDeclaredRecord";
    private static final String STATUS_DOC_MINOR_VERSIONS = "statusDocMinorVersions";
    private static final String STATUS_DOC_COMPOUND_DOCUMENT = "statusDocCompoundDocument";
    private static final String STATUS_WORK_ITEM_CHECKED_OUT = "statusWorkItemCheckedOut";
    private static final String STATUS_WORK_ITEM_LOCKED = "statusWorkItemLocked";
    private static final String STATUS_WORK_ITEM_SUSPENDED = "statusWorkItemSuspended";
    private static final String STATUS_WORK_ITEM_DEADLINE = "statusWorkItemDeadline";
    public static final String PROPERTIES_MAPPING_LIST_TYPE = "propertiesMapping";
    private static final String PROPERTIES_MAPPING = "propertiesMapping";
    private static final String DEFAULT_EMAIL_CLASS_FOR_ADD = "defaultEmailClassForAdd";
    private static final String DEFAULT_FOLDER_CLASS_FOR_ADD = "defaultFolderClassForAdd";
    private static final String ENTRY_TEMPLATE_ENABLED = "entryTemplatesEnabled";
    private static final String CM_ENTRY_TEMPLATE_ROOT_FOLDER_ASSOCIATIONS = "cmEntryTemplateRootFolderAssociations";
    private static final String SYNC_ENABLED = "syncEnabled";
    private static final String SYNC_REPOSITORY_ID = "syncRepositoryId";
    private static final String COMPOUND_DOCUMENTS_ENABLED = "compoundDocumentsEnabled";
    private static final String DATABASE_ENCODING_UTF8 = "databaseEncodingUTF8";
    private static final String P8_DOWNLOAD_RECORD = "p8DownloadRecord";
    private static final String P8_DOWNLOAD_RECORD_IGNORE_USER_IDS = "p8DownloadRecordIgnoreUsersIds";
    protected static final String P8_DOWNLOAD_RECORD_IGNORE_USER_OBJS = "p8DownloadRecordIgnoreUsersObjs";
    private static final String CONNECTIONS_COMMUNITY_LIBRARY = "conCommunityLib";
    private static final String CONNECTIONS_URL_HTTP = "conUrlHttp";
    private static final String CONNECTIONS_URL_HTTPS = "conUrlHttps";
    private static final String CONNECTIONS_SEEDLIST_ENABLE = "conSeedlistEnable";
    private static final String CONNECTIONS_ANONYMOUS_ENABLE = "conAnonymousEnable";
    private static final String CONNECTIONS_ANONYMOUS_USER_ID = "conAnonymousUserId";
    protected static final String CONNECTIONS_ANONYMOUS_USER_OBJ = "conAnonymousUserObj";
    private static final String CONNECTIONS_REVIEW_ADMIN_USER_IDS = "conReviewAdminUserIds";
    protected static final String CONNECTIONS_REVIEW_ADMIN_USER_OBJS = "conReviewAdminUserObjs";
    private static final String CONNECTIONS_GLOBAL_ADMIN_USER_IDS = "conGlobalAdminUserIds";
    protected static final String CONNECTIONS_GLOBAL_ADMIN_USER_OBJS = "conGlobalAdminUserObjs";
    private static final String CONNECTIONS_REVIEW_ADMIN_GROUP_IDS = "conReviewAdminGroupIds";
    protected static final String CONNECTIONS_REVIEW_ADMIN_GROUP_OBJS = "conReviewAdminGroupObjs";
    private static final String CONNECTIONS_GLOBAL_ADMIN_GROUP_IDS = "conGlobalAdminGroupIds";
    protected static final String CONNECTIONS_GLOBAL_ADMIN_GROUP_OBJS = "conGlobalAdminGroupObjs";
    private static final String CONNECTIONS_ACTIVITY_STREAM_ENABLE = "conActivityStreamEnable";
    private static final String CONNECTIONS_ACTIVITY_STREAM_CONNECTIONS_URL = "conActivityStreamConUrl";
    private static final String CONNECTIONS_ACTIVITY_STREAM_USER_ID = "conActivityUserId";
    private static final String CONNECTIONS_ACTIVITY_STREAM_PASSWORD = "conActivityStreamPw";
    private static final String CONNECTIONS_ACTIVITY_STREAM_IGNORE_USER_IDS = "conActivityStreamIgnoreUserIds";
    protected static final String CONNECTIONS_ACTIVITY_STREAM_IGNORE_USER_OBJS = "conActivityStreamIgnoreUserObjs";
    private static final String CONNECTIONS_ACTIVITY_STREAM_IGNORE_GROUP_IDS = "conActivityStreamIgnoreGroupIds";
    protected static final String CONNECTIONS_ACTIVITY_STREAM_IGNORE_GROUP_OBJS = "conActivityStreamIgnoreGroupObjs";
    private static int DEFAULT_TIMEOUT = 180;
    private int maxCabinets;

    @Override
    public String getObjectType() {
        return "repository";
    }

    public RepositoryConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.upgrade();
    }

    @Override
    protected Class getDataType(String key) {
        if (key.equals(ADD_AS_MAJOR_VERSION) || key.equals(CHECKIN_AS_MAJOR_VERSION) || key.equals(INCLUDE_MIME_TYPES_IN_SEARCH_RESULTS) || key.equals(KEEP_IN_AUTO_FOLDER) || key.equals(STATUS_DOC_BOOKMARKS) || key.equals(STATUS_DOC_CHECKED_OUT) || key.equals(STATUS_DOC_DECLARED_RECORD) || key.equals(STATUS_DOC_HOLD) || key.equals(STATUS_DOC_MINOR_VERSIONS) || key.equals(STATUS_DOC_COMPOUND_DOCUMENT) || key.equals(STATUS_DOC_NOTES) || key.equals(STATUS_WORK_ITEM_CHECKED_OUT) || key.equals(STATUS_WORK_ITEM_DEADLINE) || key.equals(STATUS_WORK_ITEM_LOCKED) || key.equals(STATUS_WORK_ITEM_SUSPENDED) || key.equals(UPDATE_STORAGE_COLLECTION) || key.equals(USE_SSO) || key.equals(DIRECT_RETRIEVE_ENABLED) || key.equals(MATCH_ALL) || key.equals(SHOW_DOC_LOCATION) || key.equals(TEAMSPACES_ENABLED) || key.equals(TEAMSPACES_DISPLAY_RECENT) || key.equals(TEAMSPACES_DELETE_TASK_ENABLE) || key.equals(TEAMSPACES_OWNER_MODIFY_ROLE) || key.equals(IS_VALID) || key.equals(INCLUDE_WORKFLOW_DEFINITION) || key.equals(INCLUDE_FORM_TEMPLATE) || key.equals(DOC_MODEL_ONLY_ENABLED) || key.equals(UNIFIED_SEARCHES_ENABLED) || key.equals(OD_SSL) || key.equals(ENTRY_TEMPLATE_ENABLED) || key.equals(CONNECTIONS_COMMUNITY_LIBRARY) || key.equals(CONNECTIONS_SEEDLIST_ENABLE) || key.equals(CONNECTIONS_ANONYMOUS_ENABLE) || key.equals(CONNECTIONS_ACTIVITY_STREAM_ENABLE) || key.equals(P8_DOWNLOAD_RECORD) || key.equals(COMPOUND_DOCUMENTS_ENABLED) || key.equals(DATABASE_ENCODING_UTF8)) {
            return Boolean.class;
        }
        if (key.equals(MAX_DOWNLOAD_SIZE) || key.equals(MAX_HITS) || key.equals(MAX_IN_MEMORY_RETRIEVE_SIZE) || key.equals(MAX_ITEM_TYPES) || key.equals(MAX_WORKLISTS) || key.equals(TIMEOUT_IN_SECONDS) || key.equals(TRACE_LEVEL) || key.equals(TEAMSPACES_DISPLAY_RECENT_VALUE)) {
            return Integer.class;
        }
        if (key.equals(DOCUMENT_SYSTEM_PROPERTIES) || key.equals(FOLDER_DEF_COLS) || key.equals(FOLDER_SYSTEM_PROPERTIES) || key.equals("propertiesMapping") || key.equals(LANGUAGE_CODES) || key.equals(SEARCH_DEF_COLS) || key.equals(SEARCH_FILTERED_DOCUMENT_PROPERTIES) || key.equals(SEARCH_FILTERED_FOLDER_PROPERTIES) || key.equals(SEARCH_OP_BOOLEAN) || key.equals(SEARCH_OP_DATETIME) || key.equals(SEARCH_OP_FLOAT) || key.equals(SEARCH_OP_ID) || key.equals(SEARCH_OP_INTEGER) || key.equals(TEAMSPACES_DELETE_TASK_ID) || key.equals(TEAMSPACES_DELETE_TASK_PWD) || key.equals(SEARCH_OP_OBJECT) || key.equals(SEARCH_OP_STRING) || key.equals(SEARCH_OP_USER) || key.equals(FOLDER_MAGAZINE_DEF_COLS) || key.equals(SEARCH_MAGAZINE_DEF_COLS) || key.equals(CONNECTIONS_ACTIVITY_STREAM_IGNORE_USER_IDS) || key.equals(CONNECTIONS_ACTIVITY_STREAM_IGNORE_GROUP_IDS) || key.equals(CONNECTIONS_REVIEW_ADMIN_USER_IDS) || key.equals(CONNECTIONS_REVIEW_ADMIN_GROUP_IDS) || key.equals(CONNECTIONS_GLOBAL_ADMIN_USER_IDS) || key.equals(CONNECTIONS_GLOBAL_ADMIN_GROUP_IDS) || key.equals(P8_DOWNLOAD_RECORD_IGNORE_USER_IDS) || key.equals(CM_ENTRY_TEMPLATE_ROOT_FOLDER_ASSOCIATIONS)) {
            return String[].class;
        }
        return String.class;
    }

    private void upgrade() {
        if (!this.isEmpty()) {
            this.setDefaultValue(INCLUDE_WORKFLOW_DEFINITION, "false");
            this.setDefaultValue(INCLUDE_FORM_TEMPLATE, "false");
            this.setDefaultValue(CMIS_REPOSITORY_ID, "*");
            String value = this.properties.getProperty(ENTRY_TEMPLATE_ENABLED);
            this.properties.setProperty(ENTRY_TEMPLATE_ENABLED, Boolean.toString(this.getDefaultEntryTemplateValue(value)));
            value = this.properties.getProperty(COMPOUND_DOCUMENTS_ENABLED);
            this.properties.setProperty(COMPOUND_DOCUMENTS_ENABLED, Boolean.toString(this.getDefaultCompoundDocumentsValue(value)));
            value = this.properties.getProperty(DATABASE_ENCODING_UTF8);
            this.properties.setProperty(DATABASE_ENCODING_UTF8, Boolean.toString(this.getDefaultDatabaseEncodingUTF8Value(value)));
            try {
                String timeoutValue = this.properties.getProperty(TIMEOUT_IN_SECONDS);
                if (timeoutValue == null || timeoutValue.isEmpty()) {
                    this.setTimeoutInSeconds(DEFAULT_TIMEOUT);
                } else {
                    Integer.parseInt(timeoutValue);
                }
            }
            catch (Exception e) {
                this.setTimeoutInSeconds(DEFAULT_TIMEOUT);
            }
        }
    }

    @Override
    public String getName() {
        return this.properties.getProperty(NAME);
    }

    public void setName(String name) {
        this.properties.setProperty(NAME, name);
    }

    public String getType() {
        return this.properties.getProperty(TYPE, "");
    }

    public void setType(String type) {
        this.properties.setProperty(TYPE, type);
    }

    public String getServerName() {
        return this.properties.getProperty(SERVER_NAME);
    }

    public void setServerName(String serverName) {
        this.properties.setProperty(SERVER_NAME, serverName);
    }

    public boolean isTeamspacesEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(TEAMSPACES_ENABLED, "false"));
    }

    public void setTeamspacesEnabled(boolean teamspacesEnabled) {
        this.properties.setProperty(TEAMSPACES_ENABLED, Boolean.toString(teamspacesEnabled));
    }

    public boolean isEntryTemplatesEnabled() {
        String value = this.properties.getProperty(ENTRY_TEMPLATE_ENABLED);
        return this.getDefaultEntryTemplateValue(value);
    }

    private boolean getDefaultEntryTemplateValue(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public void setEntryTemplatesEnabled(boolean entryTemplatesEnabled) {
        this.properties.setProperty(ENTRY_TEMPLATE_ENABLED, Boolean.toString(entryTemplatesEnabled));
    }

    public String getCmEntryTemplateRootFolderAssociations() {
        return this.properties.getProperty(CM_ENTRY_TEMPLATE_ROOT_FOLDER_ASSOCIATIONS);
    }

    public void setCmEntryTemplateRootFolderAssociations(String cmEntryTemplateRootFolderAssociations) {
        this.properties.setProperty(CM_ENTRY_TEMPLATE_ROOT_FOLDER_ASSOCIATIONS, cmEntryTemplateRootFolderAssociations);
    }

    public boolean getSyncEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(SYNC_ENABLED, "false"));
    }

    public void setSyncEnabled(boolean syncEnabled) {
        this.properties.setProperty(SYNC_ENABLED, Boolean.toString(syncEnabled));
    }

    public long getSyncRepositoryId() {
        return this.getPropertyValue(SYNC_REPOSITORY_ID, 0);
    }

    public void setSyncRepositoryId(long syncRepositoryId) {
        this.properties.setProperty(SYNC_REPOSITORY_ID, new Long(syncRepositoryId).toString());
    }

    public boolean isCompoundDocumentsEnabled() {
        String value = this.properties.getProperty(COMPOUND_DOCUMENTS_ENABLED);
        return this.getDefaultCompoundDocumentsValue(value);
    }

    private boolean getDefaultCompoundDocumentsValue(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public void setCompoundDocumentsEnabled(boolean compoundDocumentsEnabled) {
        this.properties.setProperty(COMPOUND_DOCUMENTS_ENABLED, Boolean.toString(compoundDocumentsEnabled));
    }

    public boolean isDatabaseEncodingUTF8() {
        String value = this.properties.getProperty(DATABASE_ENCODING_UTF8);
        return this.getDefaultDatabaseEncodingUTF8Value(value);
    }

    private boolean getDefaultDatabaseEncodingUTF8Value(String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public void setDatabaseEncodingUTF8(boolean databaseEncodingUTF8) {
        this.properties.setProperty(DATABASE_ENCODING_UTF8, Boolean.toString(databaseEncodingUTF8));
    }

    public boolean isTeamspaceOwnerModifyRole() {
        return Boolean.parseBoolean(this.properties.getProperty(TEAMSPACES_OWNER_MODIFY_ROLE, "false"));
    }

    public void setTeamspaceOwnerModifyRole(boolean teamspacesOwnerModifyRole) {
        this.properties.setProperty(TEAMSPACES_OWNER_MODIFY_ROLE, Boolean.toString(teamspacesOwnerModifyRole));
    }

    public boolean isTeamspaceRecentEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(TEAMSPACES_DISPLAY_RECENT, "false"));
    }

    public void setTeamspaceRecentEnabled(boolean value) {
        this.properties.setProperty(TEAMSPACES_DISPLAY_RECENT, Boolean.toString(value));
    }

    public boolean isTeamspaceTaskEnabledEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(TEAMSPACES_DELETE_TASK_ENABLE, "false"));
    }

    public void setTeamspaceTaskEnabledEnabled(boolean value) {
        this.properties.setProperty(TEAMSPACES_DELETE_TASK_ENABLE, Boolean.toString(value));
    }

    public String getTeamspaceDeleteTaskId() {
        return this.properties.getProperty(TEAMSPACES_DELETE_TASK_ID);
    }

    public void setTeamspaceDeleteTaskId(String val) {
        this.properties.setProperty(TEAMSPACES_DELETE_TASK_ID, val);
    }

    public String getTeamspaceDeleteTaskPwd() {
        return this.properties.getProperty(TEAMSPACES_DELETE_TASK_PWD);
    }

    public String getTeamspaceDeleteTaskPwdEncrypted() {
        return this.properties.getProperty(TEAMSPACES_DELETE_TASK_PWD);
    }

    private SettingsConfig getSettingsConfig() {
        try {
            SettingsConfig config = Config.getSettingsConfig("navigator");
            return config;
        }
        catch (ConfigurationException e) {
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return null;
    }

    public void setTeamspaceDeleteTaskPwd(String pwd) {
        try {
            String currentPassword = this.getTeamspaceDeleteTaskPwd();
            if (pwd != null && pwd.length() > 0 && currentPassword != null && !currentPassword.equals(pwd)) {
                AdminLogger.logInfo((Object)this, (String)"setTeamspaceDeleteTaskPwd", (String)"updating the password.");
                SettingsConfig settingConfig = this.getSettingsConfig();
                String key = settingConfig.getEncryptionKey();
                SecretKey keyObject = null;
                String value = null;
                if (key == null || key.length() == 0) {
                    Cryption.loadDefaultKey();
                    value = Cryption.encrypt((String)pwd);
                } else {
                    keyObject = Cryption.generateKey((String)key);
                    value = Cryption.encrypt((String)pwd, (Key)keyObject);
                }
                this.properties.setProperty(TEAMSPACES_DELETE_TASK_PWD, value);
            } else {
                AdminLogger.logInfo((Object)this, (String)"setTeamspaceDeleteTaskPwd", (String)"current password equals new password.  Not updating it.");
            }
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, (String)"setTeamspaceDeleteTaskPwd", (Throwable)e);
        }
    }

    public int getTeamspaceRecentValue() {
        return Integer.parseInt(this.properties.getProperty(TEAMSPACES_DISPLAY_RECENT_VALUE, "30"));
    }

    public void setTeamspaceRecentValue(int val) {
        this.properties.setProperty(TEAMSPACES_DISPLAY_RECENT_VALUE, Long.toString(val));
    }

    public String getDateFormat() {
        return this.properties.getProperty(DATE_FORMAT);
    }

    public void setDateFormat(String dateFormat) {
        this.properties.setProperty(DATE_FORMAT, dateFormat);
    }

    public String getTimeFormat() {
        return this.properties.getProperty(TIME_FORMAT);
    }

    public void setTimeFormat(String timeFormat) {
        this.properties.setProperty(TIME_FORMAT, timeFormat);
    }

    public String getTimestampFormat() {
        return this.properties.getProperty(TIMESTAMP_FORMAT);
    }

    public void setTimestampFormat(String timestampFormat) {
        this.properties.setProperty(TIMESTAMP_FORMAT, timestampFormat);
    }

    public int getMaxDownloadSize() {
        return this.getPropertyValue(MAX_DOWNLOAD_SIZE, 0);
    }

    public void setMaxDownloadSize(int maxDownloadSize) {
        this.properties.setProperty(MAX_DOWNLOAD_SIZE, Integer.toString(maxDownloadSize));
    }

    public int getMaxInMemoryRetrieveSize() {
        return this.getPropertyValue(MAX_IN_MEMORY_RETRIEVE_SIZE, 0);
    }

    public void setMaxInMemoryRetrieveSize(int maxInMemoryRetrieveSize) {
        this.properties.setProperty(MAX_IN_MEMORY_RETRIEVE_SIZE, Integer.toString(maxInMemoryRetrieveSize));
    }

    public boolean isMatchAll() {
        return Boolean.parseBoolean(this.properties.getProperty(MATCH_ALL, "true"));
    }

    public void setMatchAll(boolean matchAll) {
        this.properties.setProperty(MATCH_ALL, Boolean.toString(matchAll));
    }

    public String getDefaultSearchType() {
        return this.properties.getProperty(DEFAULT_SEARCH_TYPE);
    }

    public void setDefaultSearchType(String defaultSearchType) {
        this.properties.setProperty(DEFAULT_SEARCH_TYPE, defaultSearchType);
    }

    public String getDefaultSearchVersion() {
        return this.properties.getProperty(DEFAULT_SEARCH_VERSION);
    }

    public void setDefaultSearchVersion(String defaultSearchVersion) {
        this.properties.setProperty(DEFAULT_SEARCH_VERSION, defaultSearchVersion);
    }

    public String getPortNumber() {
        return this.getPropertyValue(PORT_NUMBER, "0");
    }

    public void setPortNumber(String port) {
        this.properties.setProperty(PORT_NUMBER, port);
    }

    public String getAfp2PdfConfigFile() {
        return this.properties.getProperty(AFP2PD_CONFIG_FILE, "");
    }

    public void setAfp2PdfConfigFile(String afp2PdfConfigFile) {
        this.properties.setProperty(AFP2PD_CONFIG_FILE, afp2PdfConfigFile);
    }

    public String getTransformXMLFile() {
        return this.properties.getProperty(XFORM_XML_FILE, "");
    }

    public void setTransformXMLFile(String transformXMLFile) {
        this.properties.setProperty(XFORM_XML_FILE, transformXMLFile);
    }

    public String getODSSL() {
        return this.properties.getProperty(OD_SSL, "false");
    }

    public void setODSSL(String odSSL) {
        this.properties.setProperty(OD_SSL, odSSL);
    }

    public String getODKeyringDBFile() {
        return this.properties.getProperty(OD_KEYRING_DBFILE, "");
    }

    public void setODKeyringDBFile(String odKeyringDBFile) {
        this.properties.setProperty(OD_KEYRING_DBFILE, odKeyringDBFile);
    }

    public String getODKeyringStashFile() {
        return this.properties.getProperty(OD_KEYRING_STASHFILE, "");
    }

    public void setODKeyringStashFile(String odKeyringStashFile) {
        this.properties.setProperty(OD_KEYRING_STASHFILE, odKeyringStashFile);
    }

    public String getCustomProperties() {
        return this.properties.getProperty(CUSTOM_PROPS, "");
    }

    public void setCustomProperties(String customProps) {
        this.properties.setProperty(CUSTOM_PROPS, customProps);
    }

    @Override
    public boolean isValid() {
        return Boolean.parseBoolean(this.properties.getProperty(IS_VALID, "true"));
    }

    @Override
    public void setValid(boolean value) {
        this.properties.setProperty(IS_VALID, Boolean.toString(value));
    }

    public int getTraceLevel() {
        return this.getPropertyValue(TRACE_LEVEL, 0);
    }

    public void setTraceLevel(int traceLevel) {
        this.properties.setProperty(TRACE_LEVEL, Integer.toString(traceLevel));
    }

    public String getTraceDir() {
        return this.properties.getProperty(TRACE_DIR);
    }

    public void setTraceDir(String traceDir) {
        this.properties.setProperty(TRACE_DIR, traceDir);
    }

    public String getTempDir() {
        return this.properties.getProperty(TEMP_DIR);
    }

    public void setTempDir(String tempDir) {
        this.properties.setProperty(TEMP_DIR, tempDir);
    }

    public boolean isShowDocLocation() {
        return Boolean.parseBoolean(this.properties.getProperty(SHOW_DOC_LOCATION, "false"));
    }

    public void setShowDocLocation(boolean showDocLocation) {
        this.properties.setProperty(SHOW_DOC_LOCATION, Boolean.toString(showDocLocation));
    }

    public String getAfpConversion() {
        return this.properties.getProperty(AFP_CONVERSION);
    }

    public void setAfpConversion(String afpConversion) {
        this.properties.setProperty(AFP_CONVERSION, afpConversion);
    }

    public String getLineConversion() {
        return this.properties.getProperty(LINE_CONVERSION);
    }

    public void setLineConversion(String lineConversion) {
        this.properties.setProperty(LINE_CONVERSION, lineConversion);
    }

    public int getMaxHits() {
        return this.getPropertyValue(MAX_HITS, 1000);
    }

    public void setMaxHits(int maxHits) {
        this.properties.setProperty(MAX_HITS, Integer.toString(maxHits));
    }

    public String getFolderSearchExpression() {
        return this.properties.getProperty(FOLDER_SEARCH_EXPRESSION, "");
    }

    public void setFolderSearchExpression(String folderSearchExpression) {
        this.properties.setProperty(FOLDER_SEARCH_EXPRESSION, folderSearchExpression);
    }

    public boolean getStatusDocNotes() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_NOTES, "true"));
    }

    public boolean getStatusDocHold() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_HOLD, "true"));
    }

    public boolean getStatusDocCheckedOut() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_CHECKED_OUT, "false"));
    }

    public boolean getStatusDocBookmarks() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_BOOKMARKS, "false"));
    }

    public boolean getStatusDocDeclaredRecord() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_DECLARED_RECORD, "false"));
    }

    public boolean getStatusDocMinorVersions() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_MINOR_VERSIONS, "false"));
    }

    public boolean getStatusDocCompoundDocument() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_DOC_COMPOUND_DOCUMENT, "false"));
    }

    public boolean getStatusWorkItemCheckedOut() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_WORK_ITEM_CHECKED_OUT, "false"));
    }

    public boolean getStatusWorkItemLocked() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_WORK_ITEM_LOCKED, "false"));
    }

    public boolean getStatusWorkItemSuspended() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_WORK_ITEM_SUSPENDED, "false"));
    }

    public boolean getStatusWorkItemDeadline() {
        return Boolean.parseBoolean(this.properties.getProperty(STATUS_WORK_ITEM_DEADLINE, "false"));
    }

    public int getMaxCabinets() {
        return this.maxCabinets;
    }

    public void setMaxCabinets(int maxCabinets) {
        this.maxCabinets = maxCabinets;
    }

    public ODConfig getODConfig(HttpServletRequest request) throws Exception {
        ODLoginConfig odLoginConfig = Config.getConfiguration(ODLoginConfig.class, this.getIdPrefix(), this.getObjectId(), new boolean[0]);
        return odLoginConfig.getODConfig(request);
    }

    public String getProtocol() {
        return this.properties.getProperty(PROTOCOL);
    }

    public void setProtocol(String protocol) {
        this.properties.setProperty(PROTOCOL, protocol);
    }

    public String getDomainId() {
        return this.properties.getProperty(DOMAIN_ID);
    }

    public void setDomainId(String domainId) {
        this.properties.setProperty(DOMAIN_ID, domainId);
    }

    public String getObjectStore() {
        return this.properties.getProperty(OBJECT_STORE);
    }

    public void setObjectStore(String objectStore) {
        this.properties.setProperty(OBJECT_STORE, objectStore);
    }

    public String getObjectStoreDisplayName() {
        return this.properties.getProperty(OBJECT_STORE_DISPLAY_NAME);
    }

    public void setObjectStoreDisplayName(String objectStore) {
        this.properties.setProperty(OBJECT_STORE_DISPLAY_NAME, objectStore);
    }

    public String getConnectionPoint() {
        return this.properties.getProperty(CONNECTION_POINT);
    }

    public void setConnectionPoint(String connectionPoint) {
        this.properties.setProperty(CONNECTION_POINT, connectionPoint);
    }

    public String getCmisRepositoryID() {
        return this.properties.getProperty(CMIS_REPOSITORY_ID);
    }

    public void setCmisRepositoryID(String cmisRepositoryID) {
        this.properties.setProperty(CMIS_REPOSITORY_ID, cmisRepositoryID);
    }

    public String getUseGzipEncoding() {
        return this.properties.getProperty(USE_GZIP_ENCODING);
    }

    public void setUseGzipEncoding(String useGzipEncoding) {
        this.properties.setProperty(USE_GZIP_ENCODING, useGzipEncoding);
    }

    public Boolean getAddAsMajorVersion() {
        return Boolean.parseBoolean(this.properties.getProperty(ADD_AS_MAJOR_VERSION, "true"));
    }

    public void setAddAsMajorVersion(Boolean addAsMajorVersion) {
        this.properties.setProperty(ADD_AS_MAJOR_VERSION, Boolean.toString(addAsMajorVersion));
    }

    public Boolean getCheckinAsMajorVersion() {
        return Boolean.parseBoolean(this.properties.getProperty(CHECKIN_AS_MAJOR_VERSION, "true"));
    }

    public void setCheckinAsMajorVersion(Boolean checkinAsMajorVersion) {
        this.properties.setProperty(CHECKIN_AS_MAJOR_VERSION, Boolean.toString(checkinAsMajorVersion));
    }

    public Boolean getIncludeWorkflowDefinition() {
        return Boolean.parseBoolean(this.properties.getProperty(INCLUDE_WORKFLOW_DEFINITION, "true"));
    }

    public void setIncludeWorkflowDefinition(Boolean includeWorkflowDefinition) {
        this.properties.setProperty(INCLUDE_WORKFLOW_DEFINITION, Boolean.toString(includeWorkflowDefinition));
    }

    public Boolean getIncludeFormTemplate() {
        return Boolean.parseBoolean(this.properties.getProperty(INCLUDE_FORM_TEMPLATE, "true"));
    }

    public void setIncludeFormTemplate(Boolean includeFormTemplate) {
        this.properties.setProperty(INCLUDE_FORM_TEMPLATE, Boolean.toString(includeFormTemplate));
    }

    public String getAnnotationSecurity() {
        return this.properties.getProperty(ANNOTATION_SECURITY);
    }

    public void setAnnotationSecurity(String annotationSecurity) {
        this.properties.setProperty(ANNOTATION_SECURITY, annotationSecurity);
    }

    public String getDocNameProperty() {
        return this.properties.getProperty(DOC_NAME_PROPERTY);
    }

    public void setDocNameProperty(String docNameProp) {
        this.properties.setProperty(DOC_NAME_PROPERTY, docNameProp);
    }

    public String getFolderNameProperty() {
        return this.properties.getProperty(FOLDER_NAME_PROPERTY);
    }

    public void setFolderNameProperty(String folderNameProp) {
        this.properties.setProperty(FOLDER_NAME_PROPERTY, folderNameProp);
    }

    public String[] getDocumentSystemProperties() {
        return this.stringToArray(this.properties.getProperty(DOCUMENT_SYSTEM_PROPERTIES));
    }

    public void setDocumentSystemProperties(String[] documentSystemProps) {
        this.properties.setProperty(DOCUMENT_SYSTEM_PROPERTIES, this.arrayToString(documentSystemProps));
    }

    public String[] getFolderSystemProperties() {
        return this.stringToArray(this.properties.getProperty(FOLDER_SYSTEM_PROPERTIES));
    }

    public void setFolderSystemProperties(String[] folderSystemProps) {
        this.properties.setProperty(FOLDER_SYSTEM_PROPERTIES, this.arrayToString(folderSystemProps));
    }

    public String[] getFolderDefaultColumns() {
        return this.stringToArray(this.properties.getProperty(FOLDER_DEF_COLS));
    }

    public void setFolderDefaultColumns(String[] folderDefCols) {
        this.properties.setProperty(FOLDER_DEF_COLS, this.arrayToString(folderDefCols));
    }

    public String[] getFolderMagazineDefaultColumns() {
        return this.stringToArray(this.properties.getProperty(FOLDER_MAGAZINE_DEF_COLS));
    }

    public void setFolderMagazineDefaultColumns(String[] folderDefCols) {
        this.properties.setProperty(FOLDER_MAGAZINE_DEF_COLS, this.arrayToString(folderDefCols));
    }

    public String[] getSearchMagazineDefaultColumns() {
        return this.stringToArray(this.properties.getProperty(SEARCH_MAGAZINE_DEF_COLS));
    }

    public void setSearchMagazineDefaultColumns(String[] defCols) {
        this.properties.setProperty(SEARCH_MAGAZINE_DEF_COLS, this.arrayToString(defCols));
    }

    public String[] getSearchDefaultColumns() {
        return this.stringToArray(this.properties.getProperty(SEARCH_DEF_COLS));
    }

    public void setSearchDefaultColumns(String[] searchDefCols) {
        this.properties.setProperty(SEARCH_DEF_COLS, this.arrayToString(searchDefCols));
    }

    public String[] getSearchFilteredOperators(String type) {
        return this.stringToArray(this.properties.getProperty(type));
    }

    public void setSearchFilteredOperators(String type, String[] operators) {
        this.properties.setProperty(type, this.arrayToString(operators));
    }

    public String[] getSearchFilteredDocumentProperties() {
        return this.stringToArray(this.properties.getProperty(SEARCH_FILTERED_DOCUMENT_PROPERTIES));
    }

    public void setSearchFilteredDocumentProperties(String[] searchFilteredProperties) {
        this.properties.setProperty(SEARCH_FILTERED_DOCUMENT_PROPERTIES, this.arrayToString(searchFilteredProperties));
    }

    public String[] getSearchFilteredFolderProperties() {
        return this.stringToArray(this.properties.getProperty(SEARCH_FILTERED_FOLDER_PROPERTIES));
    }

    public void setSearchFilteredFolderProperties(String[] searchFilteredProperties) {
        this.properties.setProperty(SEARCH_FILTERED_FOLDER_PROPERTIES, this.arrayToString(searchFilteredProperties));
    }

    public boolean isDirectRetrieveEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(DIRECT_RETRIEVE_ENABLED, "false"));
    }

    public void setDirectRetrieveEnabled(boolean directRetrieveEnabled) {
        this.properties.setProperty(DIRECT_RETRIEVE_ENABLED, Boolean.toString(directRetrieveEnabled));
    }

    public boolean isDocModelOnlyEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(DOC_MODEL_ONLY_ENABLED, "false"));
    }

    public void setDocModelOnlyEnabled(boolean docModelOnlyEnabled) {
        this.properties.setProperty(DOC_MODEL_ONLY_ENABLED, Boolean.toString(docModelOnlyEnabled));
    }

    public boolean getUseSSO() {
        return Boolean.parseBoolean(this.properties.getProperty(USE_SSO, "false"));
    }

    public void setUseSSO(boolean useSSO) {
        this.properties.setProperty(USE_SSO, Boolean.toString(useSSO));
    }

    public boolean getAnonymousAccessEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(ANONYMOUS_ACCESS_ENABLED, "false"));
    }

    public void setAnonymousAccessEnabled(boolean anonymousAccessEnabled) {
        this.properties.setProperty(ANONYMOUS_ACCESS_ENABLED, Boolean.toString(anonymousAccessEnabled));
    }

    public boolean isUnifiedSearchesEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(UNIFIED_SEARCHES_ENABLED, "false"));
    }

    public void setUnifiedSearchesEnabled(boolean unifiedSearchesEnabled) {
        this.properties.setProperty(UNIFIED_SEARCHES_ENABLED, Boolean.toString(unifiedSearchesEnabled));
    }

    public int getMaxResults() {
        return this.getPropertyValue(SEARCH_MAX_RESULTS, 5000);
    }

    public void setMaxResults(int maxResults) {
        this.properties.setProperty(SEARCH_MAX_RESULTS, Integer.toString(maxResults));
    }

    public int getTimeoutInSeconds() {
        return this.getPropertyValue(TIMEOUT_IN_SECONDS, DEFAULT_TIMEOUT);
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        this.properties.setProperty(TIMEOUT_IN_SECONDS, Integer.toString(timeoutInSeconds));
    }

    public String getRootFolderId() {
        return this.properties.getProperty(ROOT_FOLDER_ID);
    }

    public void setRootFolderId(String rootFolderId) {
        this.properties.setProperty(ROOT_FOLDER_ID, rootFolderId);
    }

    public String getFolderingEnabled() {
        return this.properties.getProperty(FOLDERING_ENABLED);
    }

    public void setFolderingEnabled(String folderingEnabled) {
        this.properties.setProperty(FOLDERING_ENABLED, folderingEnabled);
    }

    public String getLanguageCodes() {
        return this.properties.getProperty(LANGUAGE_CODES);
    }

    public void setLanguageCodes(String languageCodes) {
        this.properties.setProperty(LANGUAGE_CODES, languageCodes);
    }

    public int getMaxItemTypes() {
        return this.getPropertyValue(MAX_ITEM_TYPES, Integer.MAX_VALUE);
    }

    public void setMaxItemTypes(int maxItemTypes) {
        this.properties.setProperty(MAX_ITEM_TYPES, String.valueOf(maxItemTypes));
    }

    public int getMaxWorklists() {
        return this.getPropertyValue(MAX_WORKLISTS, Integer.MAX_VALUE);
    }

    public void setMaxWorklists(int maxWorklists) {
        this.properties.setProperty(MAX_WORKLISTS, String.valueOf(maxWorklists));
    }

    public boolean getUpdateStorageCollection() {
        return Boolean.parseBoolean(this.properties.getProperty(UPDATE_STORAGE_COLLECTION, "false"));
    }

    public void setUpdateStorageCollection(boolean updateStorageCollection) {
        this.properties.setProperty(UPDATE_STORAGE_COLLECTION, String.valueOf(updateStorageCollection));
    }

    public boolean getKeepInAutoFolder() {
        return Boolean.parseBoolean(this.properties.getProperty(KEEP_IN_AUTO_FOLDER, "true"));
    }

    public void setKeepInAutoFolder(boolean keepInAutoFolder) {
        this.properties.setProperty(KEEP_IN_AUTO_FOLDER, String.valueOf(keepInAutoFolder));
    }

    public boolean getIncludeMIMETypesInSearchResults() {
        return Boolean.parseBoolean(this.properties.getProperty(INCLUDE_MIME_TYPES_IN_SEARCH_RESULTS, "true"));
    }

    public void setIncludeMIMETypesInSearchResults(boolean includeMIMETypesInSearchResults) {
        this.properties.setProperty(INCLUDE_MIME_TYPES_IN_SEARCH_RESULTS, String.valueOf(includeMIMETypesInSearchResults));
    }

    public String getSSOPassword() {
        String clearTextPassword = null;
        try {
            PasswordEncrypter.init();
            clearTextPassword = PasswordEncrypter.decrypt((String)this.properties.getProperty(OD_SSO_PASSWD));
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, (String)"getSSOPassword", (String)"unexpected error", (Throwable)e);
        }
        return clearTextPassword;
    }

    public void setSSOPassword(String ssoPasswd) {
        String encryptedPassword = null;
        try {
            PasswordEncrypter.init();
            encryptedPassword = PasswordEncrypter.encrypt((String)ssoPasswd);
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, (String)"setSSOPassword", (String)"unexpected error", (Throwable)e);
        }
        this.properties.setProperty(OD_SSO_PASSWD, encryptedPassword);
    }

    @Override
    public Collection getList(String type, String appName, HttpServletRequest request) {
        if (type.equals("propertiesMapping")) {
            return this.getPropertiesMappingList(appName);
        }
        return null;
    }

    public Collection<PropertyMappingConfig> getPropertiesMappingList(String appName) {
        return this.getPropertiesMappingList(appName, this.getPropertiesMapping());
    }

    public Collection<PropertyMappingConfig> getPropertiesMappingList(String appName, String[] ids) {
        return this.getMap(PropertyMappingConfig.class, appName, ids, true).values();
    }

    public String[] getPropertiesMapping() {
        return this.stringToArray(this.properties.getProperty("propertiesMapping"));
    }

    public void setPropertiesMapping(String[] props) {
        this.properties.setProperty("propertiesMapping", this.arrayToString(props));
    }

    public String getDefaultEmailClassForAdd() {
        return this.properties.getProperty(DEFAULT_EMAIL_CLASS_FOR_ADD);
    }

    public void setDefaultEmailClassForAdd(String value) {
        this.properties.setProperty(DEFAULT_EMAIL_CLASS_FOR_ADD, value);
    }

    public String getConnectionsAnonymousUserId() {
        String result = null;
        Object obj = this.properties.get(CONNECTIONS_ANONYMOUS_USER_OBJ);
        result = obj instanceof UserGroupConfig ? ((UserGroupConfig)obj).getObjectId() : (obj instanceof String ? (String)obj : this.properties.getProperty(CONNECTIONS_ANONYMOUS_USER_ID, ""));
        return result;
    }

    public void setConnectionsAnonymousUser(UserGroupConfig userGroupConfig) {
        if (userGroupConfig != null) {
            this.properties.put(CONNECTIONS_ANONYMOUS_USER_OBJ, userGroupConfig);
        } else {
            this.properties.remove(CONNECTIONS_ANONYMOUS_USER_OBJ);
        }
    }

    public String[] getConnectionsActivityStreamIgnoreUserIds() {
        return this.stringToArray(this.properties.getProperty(CONNECTIONS_ACTIVITY_STREAM_IGNORE_USER_IDS, ""));
    }

    public String[] getConnectionsActivityStreamIgnoreGroupIds() {
        return this.stringToArray(this.properties.getProperty(CONNECTIONS_ACTIVITY_STREAM_IGNORE_GROUP_IDS, ""));
    }

    public void setConnectionsActivityStreamIgnoreUserObjs(JSONArray val) {
        if (val == null) {
            this.properties.remove(CONNECTIONS_ACTIVITY_STREAM_IGNORE_USER_OBJS);
            this.properties.remove(CONNECTIONS_ACTIVITY_STREAM_IGNORE_USER_IDS);
        } else {
            this.properties.put(CONNECTIONS_ACTIVITY_STREAM_IGNORE_USER_OBJS, val);
            this.properties.put(CONNECTIONS_ACTIVITY_STREAM_IGNORE_USER_IDS, this.getUserIdsFromObjs(val));
        }
    }

    public void setConnectionsActivityStreamIgnoreGroupObjs(JSONArray val) {
        if (val == null) {
            this.properties.remove(CONNECTIONS_ACTIVITY_STREAM_IGNORE_GROUP_OBJS);
            this.properties.remove(CONNECTIONS_ACTIVITY_STREAM_IGNORE_GROUP_IDS);
        } else {
            this.properties.put(CONNECTIONS_ACTIVITY_STREAM_IGNORE_GROUP_OBJS, val);
            this.properties.put(CONNECTIONS_ACTIVITY_STREAM_IGNORE_GROUP_IDS, this.getUserIdsFromObjs(val));
        }
    }

    private String getUserIdsFromObjs(JSONArray val) {
        StringBuffer result = new StringBuffer();
        for (Object obj : val) {
            if (obj instanceof String) {
                result.append((String)obj);
                continue;
            }
            if (!(obj instanceof JSONObject)) continue;
            JSONObject jobj = (JSONObject)obj;
            result.append((String)jobj.get("id"));
        }
        return result.toString();
    }

    public String[] getConnectionsGlobalAdminUserIds() {
        return this.stringToArray(this.properties.getProperty(CONNECTIONS_GLOBAL_ADMIN_USER_IDS, ""));
    }

    public String[] getConnectionsGlobalAdminGroupIds() {
        return this.stringToArray(this.properties.getProperty(CONNECTIONS_GLOBAL_ADMIN_GROUP_IDS, ""));
    }

    public void setConnectionsGlobalAdminUserObjs(JSONArray val) {
        if (val == null) {
            this.properties.remove(CONNECTIONS_GLOBAL_ADMIN_USER_OBJS);
            this.properties.remove(CONNECTIONS_GLOBAL_ADMIN_USER_IDS);
        } else {
            this.properties.put(CONNECTIONS_GLOBAL_ADMIN_USER_OBJS, val);
            this.properties.put(CONNECTIONS_GLOBAL_ADMIN_USER_IDS, this.getUserIdsFromObjs(val));
        }
    }

    public void setConnectionsGlobalAdminGroupObjs(JSONArray val) {
        if (val == null) {
            this.properties.remove(CONNECTIONS_GLOBAL_ADMIN_GROUP_OBJS);
            this.properties.remove(CONNECTIONS_GLOBAL_ADMIN_GROUP_IDS);
        } else {
            this.properties.put(CONNECTIONS_GLOBAL_ADMIN_GROUP_OBJS, val);
            this.properties.put(CONNECTIONS_GLOBAL_ADMIN_GROUP_IDS, this.getUserIdsFromObjs(val));
        }
    }

    public String[] getConnectionsReviewAdminUserIds() {
        return this.stringToArray(this.properties.getProperty(CONNECTIONS_REVIEW_ADMIN_USER_IDS, ""));
    }

    public String[] getConnectionsReviewAdminGroupIds() {
        return this.stringToArray(this.properties.getProperty(CONNECTIONS_REVIEW_ADMIN_GROUP_IDS, ""));
    }

    public void setConnectionsReviewAdminUserObjs(JSONArray val) {
        if (val == null) {
            this.properties.remove(CONNECTIONS_REVIEW_ADMIN_USER_OBJS);
            this.properties.remove(CONNECTIONS_REVIEW_ADMIN_USER_IDS);
        } else {
            this.properties.put(CONNECTIONS_REVIEW_ADMIN_USER_OBJS, val);
            this.properties.put(CONNECTIONS_REVIEW_ADMIN_USER_IDS, this.getUserIdsFromObjs(val));
        }
    }

    public void setConnectionsReviewAdminGroupObjs(JSONArray val) {
        if (val == null) {
            this.properties.remove(CONNECTIONS_REVIEW_ADMIN_GROUP_OBJS);
            this.properties.remove(CONNECTIONS_REVIEW_ADMIN_GROUP_IDS);
        } else {
            this.properties.put(CONNECTIONS_REVIEW_ADMIN_GROUP_OBJS, val);
            this.properties.put(CONNECTIONS_REVIEW_ADMIN_GROUP_IDS, this.getUserIdsFromObjs(val));
        }
    }

    public String[] getP8DownloadRecordIgnoreUserIds() {
        return this.stringToArray(this.properties.getProperty(P8_DOWNLOAD_RECORD_IGNORE_USER_IDS, ""));
    }

    public void setP8DownloadRecordIgnoreUserObjs(JSONArray val) {
        if (val == null) {
            this.properties.remove(P8_DOWNLOAD_RECORD_IGNORE_USER_OBJS);
            this.properties.remove(P8_DOWNLOAD_RECORD_IGNORE_USER_IDS);
        } else {
            this.properties.put(P8_DOWNLOAD_RECORD_IGNORE_USER_OBJS, val);
            this.properties.put(P8_DOWNLOAD_RECORD_IGNORE_USER_IDS, this.getUserIdsFromObjs(val));
        }
    }

    public String getDefaultFolderClassForAdd() {
        return this.properties.getProperty(DEFAULT_FOLDER_CLASS_FOR_ADD);
    }

    public void setDefaultFolderClassForAdd(String value) {
        this.properties.setProperty(DEFAULT_FOLDER_CLASS_FOR_ADD, value);
    }

    public String getPluginConfiguration() {
        return this.properties.getProperty(PLUGIN_CONFIGURATION);
    }

    public void setPluginConfiguration(String value) {
        this.properties.setProperty(PLUGIN_CONFIGURATION, value);
    }

    public boolean isP8DownloadRecordEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(P8_DOWNLOAD_RECORD, "false"));
    }

    public void setP8DownloadRecordEnabled(boolean enabled) {
        this.properties.setProperty(P8_DOWNLOAD_RECORD, Boolean.toString(enabled));
    }

    public boolean isConnActivityStreamEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(CONNECTIONS_ACTIVITY_STREAM_ENABLE, "false"));
    }

    public void setConnActivityStreamEnabled(boolean enabled) {
        this.properties.setProperty(CONNECTIONS_ACTIVITY_STREAM_ENABLE, Boolean.toString(enabled));
    }

    public boolean isConnSeedlistEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(CONNECTIONS_SEEDLIST_ENABLE, "false"));
    }

    public void setConnSeedlistEnabled(boolean enabled) {
        this.properties.setProperty(CONNECTIONS_SEEDLIST_ENABLE, Boolean.toString(enabled));
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void exportPropertiesMapping(String appName, OutputStreamWriter osw, RepositoryConfig repository) throws IOException, FileNotFoundException {
        Collection<PropertyMappingConfig> propsMapping = this.getPropertiesMappingList(appName);
        ConfigurationObject.writeConfigurationToFile(osw, propsMapping);
    }
}

