/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import java.util.Collection;
import org.apache.commons.configuration.Configuration;

public class PluginConfig
extends ConfigurationObject {
    private static final String CONFIGURATION = "configuration";
    private static final String CONFIGCLASS = "configClass";
    private static final String NAME = "name";
    private static final String FILENAME = "filename";
    private static final String OPTIONAL = "optional";
    private static final String VERSION = "version";
    private static final String ACTIONS = "actions";
    private static final String VIEWERS = "viewers";
    private static final String CLASSNAME = "classname";
    private static final String CONFIGURATION_KEYS = "configurationKeys";
    private static final String ENABLED = "enabled";
    private static final String ORDERING = "ordering";
    private static final String DEPENDENCIES = "dependencies";

    public PluginConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    public String getObjectType() {
        return "plugin";
    }

    @Override
    protected Class getDataType(String key) {
        if (key.equals(OPTIONAL) || key.equals(ENABLED)) {
            return Boolean.class;
        }
        if (key.equals(OPTIONAL) || key.equals(ORDERING)) {
            return Integer.class;
        }
        if (key.equals(CONFIGURATION_KEYS) || key.equals(DEPENDENCIES)) {
            return String[].class;
        }
        return String.class;
    }

    public String getFileName() {
        return this.properties.getProperty(FILENAME);
    }

    public void setFileName(String name) {
        this.properties.setProperty(FILENAME, name);
    }

    public String getClassName() {
        return this.properties.getProperty(CLASSNAME);
    }

    public void setClassName(String name) {
        this.properties.setProperty(CLASSNAME, name);
    }

    @Override
    public String getName() {
        return this.properties.getProperty(NAME, "");
    }

    public void setName(String name) {
        this.properties.setProperty(NAME, name);
    }

    public String getConfiguration() {
        return this.properties.getProperty(CONFIGURATION);
    }

    public void setConfiguration(String configuration) {
        this.properties.setProperty(CONFIGURATION, configuration);
    }

    public String getConfigClass() {
        return this.properties.getProperty(CONFIGCLASS);
    }

    public void setConfigClass(String configClass) {
        this.properties.setProperty(CONFIGCLASS, configClass);
    }

    public boolean isOptional() {
        return Boolean.parseBoolean(this.properties.getProperty(OPTIONAL, "false"));
    }

    public void setOptional(boolean optional) {
        this.properties.setProperty(OPTIONAL, String.valueOf(optional));
    }

    public String getVersion() {
        return this.properties.getProperty(VERSION, "");
    }

    public void setVersion(String version) {
        this.properties.setProperty(VERSION, version);
    }

    public String getActions() {
        return this.properties.getProperty(ACTIONS, "");
    }

    public void setActions(String actions) {
        this.properties.setProperty(ACTIONS, actions);
    }

    public String getViewers() {
        return this.properties.getProperty(VIEWERS, "");
    }

    public void setViewers(String viewers) {
        this.properties.setProperty(VIEWERS, viewers);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String[] getConfigurationKeys() {
        return this.stringToArray(this.properties.getProperty(CONFIGURATION_KEYS));
    }

    public boolean hasMoreConfiguration() {
        String keys = this.properties.getProperty(CONFIGURATION_KEYS);
        return keys != null && keys.length() > 1;
    }

    public void setConfigurationKeys(String[] keys) {
        this.properties.put(CONFIGURATION_KEYS, this.arrayToString(keys));
    }

    public Collection<PluginConfig> getConfigurationList() {
        return this.getConfigurationList(this.getConfigurationKeys());
    }

    public Collection<PluginConfig> getConfigurationList(String[] keys) {
        return this.getMap(PluginConfig.class, this.getObjectId(), keys, true).values();
    }

    public boolean getEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(ENABLED, "true"));
    }

    public void setEnabled(boolean enabled) {
        this.properties.setProperty(ENABLED, String.valueOf(enabled));
    }

    public int getOrdering() {
        int ordering = 0;
        try {
            ordering = Integer.parseInt(this.properties.getProperty(ORDERING, "-1"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ordering;
    }

    public void setOrdering(Integer ordering) {
        this.properties.setProperty(ORDERING, String.valueOf(ordering));
    }

    public String[] getPluginDependencies() {
        return this.stringToArray(this.properties.getProperty(DEPENDENCIES));
    }

    public void setPluginDependencies(String[] dependencies) {
        this.properties.put(DEPENDENCIES, this.arrayToString(dependencies));
    }
}

