/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.util.Util;
import com.ibm.edms.od.ODConfig;
import com.ibm.edms.od.ODException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;

public class ODLoginConfig
extends ConfigurationObject {
    @Override
    public String getObjectType() {
        return "odloginconfig";
    }

    public ODLoginConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    protected Class getDataType(String key) {
        return String.class;
    }

    public String getAfpConversion() {
        return this.properties.getProperty("afpConversion");
    }

    public void setAfpConversion(String afpConversion) {
        this.properties.setProperty("afpConversion", afpConversion);
    }

    public String getLineConversion() {
        return this.properties.getProperty("lineConversion");
    }

    public void setLineConversion(String lineConversion) {
        this.properties.setProperty("lineConversion", lineConversion);
    }

    public String getMetaConversion() {
        return this.properties.getProperty("metaConversion");
    }

    public void setMetaConversion(String metaConversion) {
        this.properties.setProperty("metaConversion", metaConversion);
    }

    public String getStrMaxHits() {
        return this.getPropertyValue("strMaxHits", "1000");
    }

    public void setStrMaxHits(String strMaxHits) {
        this.properties.setProperty("strMaxHits", strMaxHits);
    }

    public String getAppletDir() {
        return this.properties.getProperty("appletDir");
    }

    public void setAppletDir(String appletDir) {
        this.properties.setProperty("appletDir", appletDir);
    }

    public String getLanguage() {
        return this.properties.getProperty("language");
    }

    public void setLanguage(String language) {
        this.properties.setProperty("language", language);
    }

    public String getTempDir() {
        return this.properties.getProperty("tempDir", "java.io.tmpdir");
    }

    public void setTempDir(String tempDir) {
        this.properties.setProperty("tempDir", tempDir);
    }

    public String getTraceDir() {
        return this.properties.getProperty("traceDir", "java.io.tmpdir");
    }

    public void setTraceDir(String traceDir) {
        this.properties.setProperty("traceDir", traceDir);
    }

    public String getStrTraceLevel() {
        return this.getPropertyValue("strTraceLevel", "0");
    }

    public void setStrTraceLevel(String strTraceLevel) {
        this.properties.setProperty("strTraceLevel", strTraceLevel);
    }

    public String getStrMaxTraceFilesize() {
        return this.properties.getProperty("strMaxTraceFilesize");
    }

    public void setStrMaxTraceFilesize(String strMaxTraceFilesize) {
        this.properties.setProperty("strMaxTraceFilesize", strMaxTraceFilesize);
    }

    public String getAppletVersion() {
        return this.properties.getProperty("appletVersion");
    }

    public void setAppletVersion(String appletVersion) {
        this.properties.setProperty("appletVersion", appletVersion);
    }

    public String getAppletJreVersion() {
        return this.properties.getProperty("appletJreVersion");
    }

    public void setAppletJreVersion(String appletJreVersion) {
        this.properties.setProperty("appletJreVersion", appletJreVersion);
    }

    public String getAppletJreDownloadIE() {
        return this.properties.getProperty("appletJreDownloadIE");
    }

    public void setAppletJreDownloadIE(String appletJreDownloadIE) {
        this.properties.setProperty("appletJreDownloadIE", appletJreDownloadIE);
    }

    public String getAppletJreDownloadNN() {
        return this.properties.getProperty("appletJreDownloadNN");
    }

    public void setAppletJreDownloadNN(String appletJreDownloadNN) {
        this.properties.setProperty("appletJreDownloadNN", appletJreDownloadNN);
    }

    public String getAppletCacheDir() {
        return this.properties.getProperty("appletCacheDir");
    }

    public void setAppletCacheDir(String appletCacheDir) {
        this.properties.setProperty("appletCacheDir", appletCacheDir);
    }

    public String getAppletImageDir() {
        return this.properties.getProperty("appletImageDir");
    }

    public void setAppletImageDir(String appletImageDir) {
        this.properties.setProperty("appletImageDir", appletImageDir);
    }

    public String getAppletFitToWidth() {
        return this.properties.getProperty("appletFitToWidth");
    }

    public void setAppletFitToWidth(String appletFitToWidth) {
        this.properties.setProperty("appletFitToWidth", appletFitToWidth);
    }

    public String getAppletServerSearch() {
        return this.properties.getProperty("appletServerSearch");
    }

    public void setAppletServerSearch(String appletServerSearch) {
        this.properties.setProperty("appletServerSearch", appletServerSearch);
    }

    public String getAfp2HtmlInstallDir() {
        return this.properties.getProperty("afp2HtmlInstallDir");
    }

    public void setAfp2HtmlInstallDir(String afp2HtmlInstallDir) {
        this.properties.setProperty("afp2HtmlInstallDir", afp2HtmlInstallDir);
    }

    public String getAfp2HtmlConfigFile() {
        return this.properties.getProperty("afp2HtmlConfigFile");
    }

    public void setAfp2HtmlConfigFile(String afp2HtmlConfigFile) {
        this.properties.setProperty("afp2HtmlConfigFile", afp2HtmlConfigFile);
    }

    public String getAfp2HtmlUseExe() {
        return this.properties.getProperty("afp2HtmlUseExe");
    }

    public void setAfp2HtmlUseExe(String afp2HtmlUseExe) {
        this.properties.setProperty("afp2HtmlUseExe", afp2HtmlUseExe);
    }

    public String getAfp2PdfInstallDir() {
        return this.properties.getProperty("afp2PdfInstallDir");
    }

    public void setAfp2PdfInstallDir(String afp2PdfInstallDir) {
        this.properties.setProperty("afp2PdfInstallDir", afp2PdfInstallDir);
    }

    public String getAfp2PdfConfigFile() {
        return this.properties.getProperty("afp2PdfConfigFile");
    }

    public void setAfp2PdfConfigFile(String afp2PdfConfigFile) {
        this.properties.setProperty("afp2PdfConfigFile", afp2PdfConfigFile);
    }

    public String getAfp2PdfUseExe() {
        return this.properties.getProperty("afp2PdfUseExe");
    }

    public void setAfp2PdfUseExe(String afp2PdfUseExe) {
        this.properties.setProperty("afp2PdfUseExe", afp2PdfUseExe);
    }

    public String getAfp2XmlUseExe() {
        return this.properties.getProperty("afp2XmlUseExe");
    }

    public void setAfp2XmlUseExe(String afp2XmlUseExe) {
        this.properties.setProperty("afp2XmlUseExe", afp2XmlUseExe);
    }

    public String getAfp2XmlInstallDir() {
        return this.properties.getProperty("afp2XmlInstallDir");
    }

    public void setAfp2XmlInstallDir(String afp2XmlInstallDir) {
        this.properties.setProperty("afp2XmlInstallDir", afp2XmlInstallDir);
    }

    public String getAfp2XmlConfigFile() {
        return this.properties.getProperty("afp2XmlConfigFile");
    }

    public void setAfp2XmlConfigFile(String afp2XmlConfigFile) {
        this.properties.setProperty("afp2XmlConfigFile", afp2XmlConfigFile);
    }

    public String getXenosInstallDir() {
        return this.properties.getProperty("xenosInstallDir");
    }

    public void setXenosInstallDir(String xenosInstallDir) {
        this.properties.setProperty("xenosInstallDir", xenosInstallDir);
    }

    public String getXenosConfigFile() {
        return this.properties.getProperty("xenosConfigFile");
    }

    public void setXenosConfigFile(String xenosConfigFile) {
        this.properties.setProperty("xenosConfigFile", xenosConfigFile);
    }

    public String getTransformXMLFile() {
        return this.properties.getProperty("transformXMLFile");
    }

    public void setTransformXMLFile(String transformXMLFile) {
        this.properties.setProperty("transformXMLFile", transformXMLFile);
    }

    public String getOdSSL() {
        return this.properties.getProperty("odSSL");
    }

    public void setOdSSL(String odSSL) {
        this.properties.setProperty("odSSL", odSSL);
    }

    public String getOdKeyringDBFile() {
        return this.properties.getProperty("odKeyringDBFile");
    }

    public void setOdKeyringDBFile(String odKeyringDBFile) {
        this.properties.setProperty("odKeyringDBFile", odKeyringDBFile);
    }

    public String getOdKeyringStashFile() {
        return this.properties.getProperty("odKeyringStashFile");
    }

    public void setOdKeyringStashFile(String odKeyringStashFile) {
        this.properties.setProperty("odKeyringStashFile", odKeyringStashFile);
    }

    public String getCustomProperties() {
        return this.properties.getProperty("customProperties");
    }

    public void setCustomProperties(String customProperties) {
        this.properties.setProperty("customProperties", customProperties);
    }

    public String getGlobalCustomProperties() {
        return this.properties.getProperty("globalCustomProperties");
    }

    public void setGlobalCustomProperties(String customProperties) {
        this.properties.setProperty("globalCustomProperties", customProperties);
    }

    public ODConfig getODConfig(HttpServletRequest request) throws ODException, Exception {
        ODConfig odConfig;
        String fld;
        String[] p;
        int i;
        long maxHits = Long.valueOf(this.getStrMaxHits());
        if (this.getAppletDir() == null) {
            this.setAppletDir("../applets");
        }
        if (this.getLanguage() == null) {
            this.setLanguage(Util.getLanguageCode((Locale)request.getLocale()));
        }
        int traceLevel = Integer.valueOf(this.getStrTraceLevel());
        Properties additionalProperties = new Properties();
        Vector<String[]> v = this.getCustomPropertyPairs(this.getGlobalCustomProperties());
        for (i = 0; i < v.size(); ++i) {
            p = v.elementAt(i);
            fld = this.getODField(p[0]);
            if (fld == null) continue;
            additionalProperties.put(fld, p[1]);
        }
        if (this.getStrMaxTraceFilesize() != null) {
            additionalProperties.put(ODConfig.MAX_TRACELOG_SIZE, this.getStrMaxTraceFilesize());
        }
        if (this.getAfp2PdfInstallDir() != null) {
            additionalProperties.put(ODConfig.AFP2PDF_INSTALL_DIR, this.getAfp2PdfInstallDir());
        }
        if (this.getAppletVersion() != null) {
            additionalProperties.put(ODConfig.APPLET_VERSION, this.getAppletVersion());
        }
        if (this.getAppletJreVersion() != null) {
            additionalProperties.put(ODConfig.APPLET_JRE_VERSION, this.getAppletJreVersion());
        }
        if (this.getAppletJreDownloadIE() != null) {
            additionalProperties.put(ODConfig.APPLET_JRE_DOWNLOAD_IE, this.getAppletJreDownloadIE());
        }
        if (this.getAppletJreDownloadNN() != null) {
            additionalProperties.put(ODConfig.APPLET_JRE_DOWNLOAD_NN, this.getAppletJreDownloadNN());
        }
        if (this.getAppletCacheDir() != null) {
            additionalProperties.put(ODConfig.APPLET_CACHE_DIR, this.getAppletCacheDir());
        }
        if (this.getAppletImageDir() != null) {
            additionalProperties.put(ODConfig.APPLET_IMAGE_DIR, this.getAppletImageDir());
        }
        if (this.getAppletServerSearch() != null) {
            additionalProperties.put(ODConfig.APPLET_SERVER_SEARCH, this.getAppletServerSearch());
        }
        if (this.getAfp2HtmlInstallDir() != null) {
            additionalProperties.put(ODConfig.AFP2HTML_INSTALL_DIR, this.getAfp2HtmlInstallDir());
        }
        if (this.getAfp2HtmlConfigFile() != null) {
            additionalProperties.put(ODConfig.AFP2HTML_CONFIG_FILE, this.getAfp2HtmlConfigFile());
        }
        if (this.getAfp2XmlInstallDir() != null) {
            additionalProperties.put(ODConfig.AFP2XML_INSTALL_DIR, this.getAfp2XmlInstallDir());
        }
        if (this.getAfp2XmlConfigFile() != null) {
            additionalProperties.put(ODConfig.AFP2XML_CONFIG_FILE, this.getAfp2XmlConfigFile());
        }
        if (this.getXenosInstallDir() != null) {
            additionalProperties.put(ODConfig.XENOS_INSTALL_DIR, this.getXenosInstallDir());
        }
        if (this.getXenosConfigFile() != null) {
            additionalProperties.put(ODConfig.XENOS_CONFIG_FILE, this.getXenosConfigFile());
        }
        v = this.getCustomPropertyPairs(this.getCustomProperties());
        for (i = 0; i < v.size(); ++i) {
            p = v.elementAt(i);
            fld = this.getODField(p[0]);
            if (fld == null) continue;
            additionalProperties.put(fld, p[1]);
        }
        if (this.getAfp2PdfConfigFile() != null) {
            additionalProperties.put(ODConfig.AFP2PDF_CONFIG_FILE, this.getAfp2PdfConfigFile());
        }
        if (this.getTransformXMLFile() != null) {
            additionalProperties.put(ODConfig.TransformXML, this.getTransformXMLFile());
        }
        if (this.getOdSSL() != null) {
            additionalProperties.put(ODConfig.USE_SSL_DEFAULT, this.getOdSSL());
        }
        if (this.getOdKeyringDBFile() != null) {
            additionalProperties.put(ODConfig.SSL_KEYRINGFILE, this.getOdKeyringDBFile());
        }
        if (this.getOdKeyringStashFile() != null) {
            additionalProperties.put(ODConfig.SSL_KEYRINGSTASH, this.getOdKeyringStashFile());
        }
        String methodName = "getODConfig";
        AdminLogger.logDebug((Object)this, (String)"getODConfig", (ServletRequest)request, (String)("afpConversion = " + this.getAfpConversion()));
        AdminLogger.logDebug((Object)this, (String)"getODConfig", (ServletRequest)request, (String)("lineConversion = " + this.getLineConversion()));
        AdminLogger.logDebug((Object)this, (String)"getODConfig", (ServletRequest)request, (String)("metaConversion = " + this.getMetaConversion()));
        AdminLogger.logDebug((Object)this, (String)"getODConfig", (ServletRequest)request, (String)("maxHits = " + maxHits));
        AdminLogger.logDebug((Object)this, (String)"getODConfig", (ServletRequest)request, (String)("appletDir = " + this.getAppletDir()));
        AdminLogger.logDebug((Object)this, (String)"getODConfig", (ServletRequest)request, (String)("language = " + this.getLanguage()));
        AdminLogger.logDebug((Object)this, (String)"getODConfig", (ServletRequest)request, (String)("tempDir = " + this.getTempDir()));
        AdminLogger.logDebug((Object)this, (String)"getODConfig", (ServletRequest)request, (String)("traceDir = " + this.getTraceDir()));
        AdminLogger.logDebug((Object)this, (String)"getODConfig", (ServletRequest)request, (String)("traceLevel = " + traceLevel));
        AdminLogger.logDebug((Object)this, (String)"getODConfig", (ServletRequest)request, (String)("additionalProperties = " + additionalProperties));
        try {
            odConfig = new ODConfig(this.getAfpConversion(), this.getLineConversion(), this.getMetaConversion(), maxHits, this.getAppletDir(), this.getLanguage(), this.getTempDir(), this.getTraceDir(), traceLevel, additionalProperties);
        }
        catch (ODException e) {
            AdminLogger.logWarning((Object)this, (String)"getODConfig", (ServletRequest)request, (String)"Give it another try to get the OD configuration without the AFP2PDF config file.");
            additionalProperties.remove(ODConfig.AFP2PDF_CONFIG_FILE);
            odConfig = new ODConfig(this.getAfpConversion(), this.getLineConversion(), this.getMetaConversion(), maxHits, this.getAppletDir(), this.getLanguage(), this.getTempDir(), this.getTraceDir(), traceLevel, additionalProperties);
        }
        if (AdminLogger.isDebugLogged()) {
            odConfig.printConfig();
        }
        return odConfig;
    }

    private String getODField(String name) {
        String fieldValue = null;
        try {
            Class<?> c = Class.forName("com.ibm.edms.od.ODConfig");
            Field f = c.getField(name);
            if (f.getType().getName().equals("java.lang.String")) {
                ODConfig config = new ODConfig();
                fieldValue = (String)f.get(config);
            }
        }
        catch (Exception x) {
            fieldValue = null;
        }
        return fieldValue;
    }

    private Vector<String[]> getCustomPropertyPairs(String customPropertiesString) {
        Vector<String[]> properties = new Vector<String[]>();
        if (customPropertiesString != null && customPropertiesString.length() > 0) {
            try {
                JSONArray a = JSONArray.parse(customPropertiesString);
                for (int i = 0; i < a.size(); ++i) {
                    JSONObject o = (JSONObject)a.get(i);
                    String[] p = new String[]{(String)o.get("name"), (String)o.get("value")};
                    properties.add(p);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }
}

