/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.InterfaceTextLabelConfig;
import com.ibm.ecm.configuration.InterfaceTextLocaleConfig;
import org.apache.commons.configuration.Configuration;

public class InterfaceTextConfig
extends ConfigurationObject {
    private static final String LABEL_KEY = "labelKey";
    private static final String TOOLTIP_KEY = "tooltipKey";
    private static final String TYPE = "type";
    private static final String REPOSITORY_TYPE = "repositoryType";
    private static final String REPOSITORY_ID = "repositoryId";
    private static final String DISPLAYED_IN = "displayedIn";
    private static final String CLASSIC_LABEL_KEY = "classicLabelKey";
    private static final String USER_DATA = "userData";
    private static final String DESKTOP_ID = "desktopId";
    public static final String LOCALE_DATA = "localeData";
    public static final String LABEL_DATA = "labelData";
    private InterfaceTextLocaleConfig localeData = null;
    private InterfaceTextLabelConfig labelData = null;

    public InterfaceTextConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.getLocaleData();
        this.getLabelData();
    }

    @Override
    public String getObjectType() {
        return "interfaceText";
    }

    @Override
    protected Class getDataType(String key) {
        return String.class;
    }

    public InterfaceTextLocaleConfig getLocaleData() {
        if (this.localeData == null) {
            this.localeData = new InterfaceTextLocaleConfig(this.getConfigurationObject(), this.getIdPrefix(), this.getObjectId());
            if (!this.localeData.isEmpty()) {
                this.properties.put(LOCALE_DATA, this.localeData);
            }
        }
        return this.localeData;
    }

    public InterfaceTextLabelConfig getLabelData() {
        if (this.labelData == null) {
            this.labelData = new InterfaceTextLabelConfig(this.getConfigurationObject(), this.getIdPrefix(), this.getObjectId());
            if (!this.labelData.isEmpty()) {
                this.properties.put(LABEL_DATA, this.labelData);
            }
        }
        return this.labelData;
    }

    @Override
    protected boolean skipThisPropertyWhenSaving(String key) {
        return key.equals(LOCALE_DATA) || key.equals(LABEL_DATA);
    }

    public String getLabelKey() {
        return this.properties.getProperty(LABEL_KEY);
    }

    public void setLabelKey(String labelKey) {
        this.properties.setProperty(LABEL_KEY, labelKey);
    }

    public String getTooltipKey() {
        return this.properties.getProperty(TOOLTIP_KEY);
    }

    public void setTooltipKey(String tooltipKey) {
        this.properties.setProperty(TOOLTIP_KEY, tooltipKey);
    }

    public String getType() {
        return this.properties.getProperty(TYPE);
    }

    public void setType(String type) {
        this.properties.setProperty(TYPE, type);
    }

    public boolean isTypeAction() {
        return this.getType().equals("action");
    }

    public String getRepositoryType() {
        return this.properties.getProperty(REPOSITORY_TYPE);
    }

    public void setRepositoryType(String type) {
        this.properties.setProperty(REPOSITORY_TYPE, type);
    }

    public String getRepositoryId() {
        return this.properties.getProperty(REPOSITORY_ID);
    }

    public void setRepositoryId(String id) {
        this.properties.setProperty(REPOSITORY_ID, id);
    }

    public String getDesktopId() {
        return this.properties.getProperty(DESKTOP_ID);
    }

    public void setDesktopId(String id) {
        this.properties.setProperty(DESKTOP_ID, id);
    }

    public String getDisplayedIn() {
        return this.properties.getProperty(DISPLAYED_IN);
    }

    public void setDisplayedIn(String displayedIn) {
        this.properties.setProperty(DISPLAYED_IN, displayedIn);
    }

    public String getClassicLabelKey() {
        return this.properties.getProperty(CLASSIC_LABEL_KEY);
    }

    public void setClassicLabelKey(String classicLabelKey) {
        this.properties.setProperty(CLASSIC_LABEL_KEY, classicLabelKey);
    }

    public void setUserData(String[] userData) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < userData.length; ++i) {
            if (i != 0) {
                sb.append(";");
            }
            sb.append(userData[i]);
        }
        this.properties.setProperty(USER_DATA, sb.toString());
    }
}

