/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.configuration.Configuration;

public class IconConfig
extends ConfigurationObject {
    private static final String FILE_NAME = "fileName";
    private static final String CLASS_NAME = "className";
    private static final String CONTENT_TYPES = "contentTypes";

    @Override
    public String getObjectType() {
        return "icon";
    }

    public IconConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.upgrade();
    }

    private void upgrade() {
        if (!this.isEmpty()) {
            String className = this.properties.getProperty(CLASS_NAME);
            if (className.equalsIgnoreCase("ftData")) {
                this.addContentType("application/x-msexcel");
            } else if (className.equalsIgnoreCase("ftWordProcessing")) {
                this.addContentType("application/x-msword");
            } else if (className.equalsIgnoreCase("ftPresentation")) {
                this.addContentType("application/x-mspowerpoint");
            }
        }
    }

    private void addContentType(String newContentType) {
        String[] contentTypes = this.stringToArray(this.properties.getProperty(CONTENT_TYPES));
        boolean newContentTypeExists = false;
        for (String contentType : contentTypes) {
            if (!contentType.equalsIgnoreCase(newContentType)) continue;
            newContentTypeExists = true;
            break;
        }
        if (!newContentTypeExists) {
            ArrayList<String> newContentTypes = new ArrayList<String>(Arrays.asList(contentTypes));
            newContentTypes.add(newContentType);
            this.properties.setProperty(CONTENT_TYPES, this.arrayToString(newContentTypes.toArray(new String[newContentTypes.size()])));
        }
    }

    @Override
    protected Class getDataType(String key) {
        return key.equals(CONTENT_TYPES) ? String[].class : String.class;
    }

    public String getFileName() {
        return this.properties.getProperty(FILE_NAME, "");
    }

    public void setFileName(String fileName) {
        this.properties.setProperty(FILE_NAME, fileName);
    }

    public String getClassName() {
        return this.properties.getProperty(CLASS_NAME);
    }

    public void setClassName(String name) {
        this.properties.setProperty(CLASS_NAME, name);
    }

    public String getContentTypes() {
        return this.properties.getProperty(CONTENT_TYPES);
    }

    public void setContentTypes(String contentTypes) {
        this.properties.setProperty(CONTENT_TYPES, contentTypes);
    }
}

