/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import org.apache.commons.configuration.Configuration;

public class FilenetConfig
extends ConfigurationObject {
    private static final String P8_DOWNLOAD_CACHE_ENABLE = "p8DlCacheEnable";
    private static final String P8_DOWNLOAD_CACHE_FOLDER = "p8DlCacheFolder";
    private static final String P8_DOWNLOAD_CACHE_URL = "p8DlCacheUrl";
    private static final String P8_DOWNLOAD_CACHE_MAX_FILES = "p8DlCacheMaxFiles";
    private static final String P8_DOWNLOAD_CACHE_MAX_SIZE = "p8DlCacheMaxSize";
    private static final String P8_DOWNLOAD_CACHE_CLEANUP_DURATION = "p8DlCacheCleanupDuration";
    private static final String P8_DOWNLOAD_CACHE_CLEANUP_MIN = "p8DlCacheCleanupMin";
    private static final String P8_DOWNLOAD_CACHE_MIN_LIFETIME = "p8DlCacheMinLifetime";
    private static final String P8_DOWNLOAD_CACHE_SIZE_THRESHOLD = "p8DlCacheSizeThreshold";
    private static final String P8_DOWNLOAD_CACHE_GUARD_HEADER = "p8DlCacheGuardHeader";
    private static final String P8_HIDE_EMAIL_ADDRESSES = "p8HideEmailAddresses";
    private static final String P8_MASK_USER_IDS = "p8MaskUserIds";
    private static final String P8_SOFT_DELETE = "p8SoftDelete";
    private static final String P8_DOWNLOAD_URL = "p8DlUrl";
    private static final String P8_MAX_LIBRARIES = "p8MaxLibraries";
    private static final String P8_VALIDATE_CLIENT_IP = "p8ValidateClientIp";
    private static final String P8_SECURITY_TOKEN = "p8SecurityToken";
    private static final String P8_CONNECTIONS_URL = "p8ConnectionsUrl";
    private static final String P8_CONNECTIONS_URL_HTTP = "p8ConnectionsUrlHttp";
    private static final String P8_CONNECTIONS_URL_HTTPS = "p8ConnectionsUrlHttps";

    public FilenetConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.upgrade();
    }

    @Override
    public String getObjectType() {
        return "filenet";
    }

    @Override
    protected Class getDataType(String key) {
        if (key.equals(P8_DOWNLOAD_CACHE_ENABLE) || key.equals(P8_HIDE_EMAIL_ADDRESSES) || key.equals(P8_MASK_USER_IDS) || key.equals(P8_SOFT_DELETE) || key.equals(P8_VALIDATE_CLIENT_IP) || key.equals(P8_CONNECTIONS_URL)) {
            return Boolean.class;
        }
        if (key.equals(P8_DOWNLOAD_CACHE_MAX_FILES) || key.equals(P8_DOWNLOAD_CACHE_MAX_SIZE) || key.equals(P8_DOWNLOAD_CACHE_CLEANUP_DURATION) || key.equals(P8_DOWNLOAD_CACHE_CLEANUP_MIN) || key.equals(P8_DOWNLOAD_CACHE_MIN_LIFETIME) || key.equals(P8_DOWNLOAD_CACHE_SIZE_THRESHOLD) || key.equals(P8_MAX_LIBRARIES)) {
            return Integer.class;
        }
        return String.class;
    }

    private void upgrade() {
        if (this.isEmpty()) {
            this.setDefaultValue(P8_DOWNLOAD_CACHE_ENABLE, "false");
            this.setDefaultValue(P8_DOWNLOAD_CACHE_MAX_FILES, "1000");
            this.setDefaultValue(P8_DOWNLOAD_CACHE_MAX_SIZE, "10");
            this.setDefaultValue(P8_DOWNLOAD_CACHE_CLEANUP_DURATION, "5");
            this.setDefaultValue(P8_DOWNLOAD_CACHE_CLEANUP_MIN, "3600");
            this.setDefaultValue(P8_DOWNLOAD_CACHE_MIN_LIFETIME, "3600");
            this.setDefaultValue(P8_DOWNLOAD_CACHE_SIZE_THRESHOLD, "1000");
            this.setDefaultValue(P8_DOWNLOAD_CACHE_GUARD_HEADER, "CDHC");
            this.setDefaultValue(P8_HIDE_EMAIL_ADDRESSES, "true");
            this.setDefaultValue(P8_MASK_USER_IDS, "true");
            this.setDefaultValue(P8_SOFT_DELETE, "true");
            this.setDefaultValue(P8_VALIDATE_CLIENT_IP, "true");
            this.setDefaultValue(P8_MAX_LIBRARIES, "1000");
            this.setDefaultValue(P8_SECURITY_TOKEN, "encrypted");
            this.setDefaultValue(P8_CONNECTIONS_URL, "false");
        }
    }

    public boolean getP8MaskUserIds() {
        return Boolean.parseBoolean(this.properties.getProperty(P8_MASK_USER_IDS, "true"));
    }

    public void setP8MaskUserIds(boolean val) {
        this.properties.setProperty(P8_MASK_USER_IDS, Boolean.toString(val));
    }

    public boolean getP8SoftDelete() {
        return Boolean.parseBoolean(this.properties.getProperty(P8_SOFT_DELETE, "true"));
    }

    public void setP8SoftDelete(boolean val) {
        this.properties.setProperty(P8_SOFT_DELETE, Boolean.toString(val));
    }

    public boolean getP8HideEmailAddresses() {
        return Boolean.parseBoolean(this.properties.getProperty(P8_HIDE_EMAIL_ADDRESSES, "true"));
    }

    public void setP8HideEmailAddresses(boolean val) {
        this.properties.setProperty(P8_HIDE_EMAIL_ADDRESSES, Boolean.toString(val));
    }

    public boolean getP8ConenctionsUrl() {
        return Boolean.parseBoolean(this.properties.getProperty(P8_CONNECTIONS_URL, "false"));
    }

    public void setP8ConenctionsUrl(boolean val) {
        this.properties.setProperty(P8_CONNECTIONS_URL, Boolean.toString(val));
    }

    public boolean getP8ValidateClientIp() {
        return Boolean.parseBoolean(this.properties.getProperty(P8_VALIDATE_CLIENT_IP, "true"));
    }

    public void setP8ValidateClientIp(boolean val) {
        this.properties.setProperty(P8_VALIDATE_CLIENT_IP, Boolean.toString(val));
    }

    public boolean getP8DownloadCacheEnable() {
        return Boolean.parseBoolean(this.properties.getProperty(P8_DOWNLOAD_CACHE_ENABLE, "false"));
    }

    public void setP8DownloadCacheEnable(boolean val) {
        this.properties.setProperty(P8_DOWNLOAD_CACHE_ENABLE, Boolean.toString(val));
    }

    public int getP8MaxLibraries() {
        return Integer.parseInt(this.properties.getProperty(P8_MAX_LIBRARIES, "1000"));
    }

    public void setP8MaxLibraries(int val) {
        this.properties.setProperty(P8_MAX_LIBRARIES, Long.toString(val));
    }

    public int getP8DownloadCacheMaxFiles() {
        return Integer.parseInt(this.properties.getProperty(P8_DOWNLOAD_CACHE_MAX_FILES, "1000"));
    }

    public void setP8DownloadCacheMaxFiles(int val) {
        this.properties.setProperty(P8_DOWNLOAD_CACHE_MAX_FILES, Long.toString(val));
    }

    public int getP8DownloadCacheMaxSize() {
        return Integer.parseInt(this.properties.getProperty(P8_DOWNLOAD_CACHE_MAX_SIZE, "10"));
    }

    public void setP8DownloadCacheMaxSize(int val) {
        this.properties.setProperty(P8_DOWNLOAD_CACHE_MAX_SIZE, Long.toString(val));
    }

    public int getP8DownloadCacheCleanupDuration() {
        return Integer.parseInt(this.properties.getProperty(P8_DOWNLOAD_CACHE_CLEANUP_DURATION, "5"));
    }

    public void setP8DownloadCacheCleanupDuration(int val) {
        this.properties.setProperty(P8_DOWNLOAD_CACHE_CLEANUP_DURATION, Long.toString(val));
    }

    public int getP8DownloadCacheCleanupMinimum() {
        return Integer.parseInt(this.properties.getProperty(P8_DOWNLOAD_CACHE_CLEANUP_MIN, "3600"));
    }

    public void setP8DownloadCacheCleanupMinimum(int val) {
        this.properties.setProperty(P8_DOWNLOAD_CACHE_CLEANUP_MIN, Long.toString(val));
    }

    public int getP8DownloadCacheMinLifetime() {
        return Integer.parseInt(this.properties.getProperty(P8_DOWNLOAD_CACHE_MIN_LIFETIME, "3600"));
    }

    public void setP8DownloadCacheMinLifetime(int val) {
        this.properties.setProperty(P8_DOWNLOAD_CACHE_MIN_LIFETIME, Long.toString(val));
    }

    public int getP8DownloadCacheSizeThreshold() {
        return Integer.parseInt(this.properties.getProperty(P8_DOWNLOAD_CACHE_SIZE_THRESHOLD, "1000"));
    }

    public void setP8DownloadCacheSizeThreshold(int val) {
        this.properties.setProperty(P8_DOWNLOAD_CACHE_SIZE_THRESHOLD, Long.toString(val));
    }

    public String getP8DownloadCacheGuardHeader() {
        return this.properties.getProperty(P8_DOWNLOAD_CACHE_GUARD_HEADER, "CDHC");
    }

    public void setP8DownloadCacheGuardHeader(String val) {
        this.properties.setProperty(P8_DOWNLOAD_CACHE_GUARD_HEADER, val);
    }

    public String getP8DownloadCacheUrl() {
        return this.properties.getProperty(P8_DOWNLOAD_CACHE_URL, "");
    }

    public void setP8DownloadCacheUrl(String val) {
        this.properties.setProperty(P8_DOWNLOAD_CACHE_URL, val);
    }

    public String getP8DownloadCacheFolder() {
        return this.properties.getProperty(P8_DOWNLOAD_CACHE_FOLDER, "");
    }

    public void setP8DownloadCacheFolder(String val) {
        this.properties.setProperty(P8_DOWNLOAD_CACHE_FOLDER, val);
    }

    public String getP8DownloadUrl() {
        return this.properties.getProperty(P8_DOWNLOAD_URL, "");
    }

    public void setP8DownloadUrl(String val) {
        this.properties.setProperty(P8_DOWNLOAD_URL, val);
    }

    public String getP8SecurityToken() {
        return this.properties.getProperty(P8_SECURITY_TOKEN, "encrypted");
    }

    public void setP8SecurityToken(String val) {
        this.properties.setProperty(P8_SECURITY_TOKEN, val);
    }

    public String getP8ConnectionsUrlHttp() {
        return this.properties.getProperty(P8_CONNECTIONS_URL_HTTP, "");
    }

    public void setP8ConnectionsUrlHttp(String val) {
        this.properties.setProperty(P8_CONNECTIONS_URL_HTTP, val);
    }

    public String getP8ConnectionsUrlHttps() {
        return this.properties.getProperty(P8_CONNECTIONS_URL_HTTPS, "");
    }

    public void setP8ConnectionsUrlHttps(String val) {
        this.properties.setProperty(P8_CONNECTIONS_URL_HTTPS, val);
    }
}

