/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import org.apache.commons.configuration.Configuration;

public class FileTypeConfig
extends ConfigurationObject {
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String CONTENT_TYPES = "contentTypes";
    private static final String ONLY_USE_IN_ET_FOLDER_ASSOCIATIONS = "onlyUseInETAssociations";

    @Override
    public String getObjectType() {
        return "filetype";
    }

    public FileTypeConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.upgrade();
    }

    @Override
    protected Class getDataType(String key) {
        if (key.equals(CONTENT_TYPES)) {
            return String[].class;
        }
        return String.class;
    }

    @Override
    public String getName() {
        return this.properties.getProperty(NAME);
    }

    public void setName(String name) {
        this.properties.setProperty(NAME, name);
    }

    public String getDescription() {
        return this.properties.getProperty(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.properties.setProperty(DESCRIPTION, description);
    }

    public String[] getContentTypes() {
        return this.stringToArray(this.properties.getProperty(CONTENT_TYPES));
    }

    public void setContentTypes(String[] contentTypes) {
        this.properties.setProperty(CONTENT_TYPES, this.arrayToString(contentTypes));
    }

    public String getOnlyUseInEtFolderAssociations() {
        return this.properties.getProperty(ONLY_USE_IN_ET_FOLDER_ASSOCIATIONS);
    }

    public void setOnlyUseInEtFolderAssociations(String onlyUseInEtFolderAssociations) {
        this.properties.setProperty(ONLY_USE_IN_ET_FOLDER_ASSOCIATIONS, onlyUseInEtFolderAssociations);
    }

    public static String[] getMSFileTypes() {
        String[] types = "word,excel,powerpoint,outlook,pdf".split(",");
        return types;
    }

    private void upgrade() {
        if (!this.isEmpty()) {
            this.setDefaultValue(ONLY_USE_IN_ET_FOLDER_ASSOCIATIONS, "false");
        }
    }
}

