/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.text.Collator;
import org.apache.commons.configuration.Configuration;

public class FavoriteConfig
extends ConfigurationObject
implements Comparable {
    private static final String REPOSITORY_ID = "repositoryId";
    private static final String ALIAS = "alias";
    private static final String ITEM_ID = "itemId";
    private static final String TYPE = "type";
    private static final String TEMPLATE = "template";
    private static final String MIMETYPE = "mimetype";
    private static final String VSID = "vsId";
    private static final String HAS_CONTENT_FLAG = "hasContentFlag";
    private static final String REPOSITORY_LABEL = "repositoryLabel";
    private static final String SYNC_ENABLED = "syncEnabled";
    private static final String SYNC_ID = "syncId";
    private static final String SYNC_DEVICES = "syncDevices";
    Collator collator = Collator.getInstance();

    public FavoriteConfig(Configuration configuration, String idPrefix, String objectId) {
        super(configuration, idPrefix, objectId);
    }

    @Override
    public String getObjectType() {
        return "favorite";
    }

    @Override
    protected Class getDataType(String key) {
        return String.class;
    }

    public String getRepositoryId() {
        return this.properties.getProperty(REPOSITORY_ID);
    }

    public void setRepositoryId(String id) {
        this.properties.setProperty(REPOSITORY_ID, id);
    }

    public String getRepositoryLabel() {
        return this.properties.getProperty(REPOSITORY_LABEL);
    }

    public void setRepositoryLabel(String label) {
        this.properties.setProperty(REPOSITORY_LABEL, label);
    }

    public String getAlias() {
        return this.properties.getProperty(ALIAS);
    }

    public void setAlias(String alias) {
        this.properties.setProperty(ALIAS, alias);
    }

    public String getItemId() {
        return this.properties.getProperty(ITEM_ID);
    }

    public void setItemId(String itemId) {
        this.properties.setProperty(ITEM_ID, itemId);
    }

    public String getType() {
        return this.properties.getProperty(TYPE);
    }

    public void setType(String type) {
        this.properties.setProperty(TYPE, type);
    }

    public int compareTo(Object other) {
        return this.getAlias().compareTo(((FavoriteConfig)other).getAlias());
    }

    public void setTemplate(String template) {
        this.properties.setProperty(TEMPLATE, template);
    }

    public String getTemplate() {
        return this.properties.getProperty(TEMPLATE);
    }

    public void setMimeType(String mimetype) {
        this.properties.setProperty(MIMETYPE, mimetype);
    }

    public String getMimeType() {
        return this.properties.getProperty(MIMETYPE);
    }

    public void setVersionSerieId(String vsId) {
        this.properties.setProperty(VSID, vsId);
    }

    public String getVersionSerieId() {
        return this.properties.getProperty(VSID);
    }

    public boolean getHasContentFlag() {
        return Boolean.parseBoolean(this.properties.getProperty(HAS_CONTENT_FLAG, "false"));
    }

    public void setHasContentFlag(boolean hasContentFlag) {
        this.properties.setProperty(HAS_CONTENT_FLAG, Boolean.toString(hasContentFlag));
    }

    public boolean getSyncEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(SYNC_ENABLED, "false"));
    }

    public void setSyncEnabled(boolean syncEnabled) {
        this.properties.setProperty(SYNC_ENABLED, Boolean.toString(syncEnabled));
    }

    public long getSyncId() {
        return this.getPropertyValue(SYNC_ID, 0);
    }

    public void setSyncId(long syncId) {
        this.properties.setProperty(SYNC_ID, new Long(syncId).toString());
    }

    public String getSyncDevices() {
        return this.properties.getProperty(SYNC_DEVICES);
    }

    public void setSyncDevices(String syncDevices) {
        this.properties.setProperty(SYNC_DEVICES, syncDevices);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("id", this.getObjectId());
        json.put("name", this.getAlias());
        json.put(ITEM_ID, this.getItemId());
        json.put(MIMETYPE, this.getMimeType());
        json.put(REPOSITORY_ID, this.getRepositoryId());
        json.put(TEMPLATE, this.getTemplate());
        json.put(TYPE, this.getType());
        json.put(VSID, this.getVersionSerieId());
        json.put(SYNC_ID, (Object)this.getSyncId());
        json.put(SYNC_ENABLED, (Object)this.getSyncEnabled());
        json.put(REPOSITORY_LABEL, this.getRepositoryLabel());
        try {
            json.put(SYNC_DEVICES, JSONArray.parse(this.getSyncDevices()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return json;
    }
}

