/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import org.apache.commons.configuration.Configuration;

public class DesktopFeatureConfig
extends ConfigurationObject {
    private static final String DEFAULT_REPOSITORY = "defaultRepository";
    private static final String SHOW_TREE_VIEW = "showTreeView";
    private static final String SHOW_REPOSITORIES = "showRepositories";
    private static final String SHOW_VIEWS = "showViews";
    private static final String SHOW_DOCUMENT_INFO_PANE = "showDocumentInfoPane";
    private static final String DOCUMENT_INFO_PANE_DEFAULT_OPEN = "documentInfoPaneDefaultOpen";
    private static final String DOCUMENT_INFO_PANE_OPEN_ON_SELECTION = "documentInfoPaneOpenOnSelection";
    private static final String SHOW_MY_CHECKOUTS = "showMyCheckouts";
    private static final String FEATURE_CONFIGURATION = "featureConfiguration";

    @Override
    public String getObjectType() {
        return "desktopfeature";
    }

    public DesktopFeatureConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
    }

    @Override
    protected Class getDataType(String key) {
        if (key.equals(SHOW_REPOSITORIES) || key.equals(SHOW_VIEWS)) {
            return String[].class;
        }
        if (key.equals(SHOW_TREE_VIEW) || key.equals(SHOW_DOCUMENT_INFO_PANE) || key.equals(DOCUMENT_INFO_PANE_DEFAULT_OPEN) || key.equals(DOCUMENT_INFO_PANE_OPEN_ON_SELECTION)) {
            return Boolean.class;
        }
        return String.class;
    }

    public String getDefaultRepository() {
        return this.properties.getProperty(DEFAULT_REPOSITORY);
    }

    public void setDefaultRepository(String defaultRepository) {
        this.properties.setProperty(DEFAULT_REPOSITORY, defaultRepository);
    }

    public boolean getShowTreeView() {
        return Boolean.parseBoolean(this.properties.getProperty(SHOW_TREE_VIEW, "false"));
    }

    public void setShowTreeView(boolean showTreeView) {
        this.properties.setProperty(SHOW_TREE_VIEW, Boolean.toString(showTreeView));
    }

    public boolean getShowDocumentInfoPane() {
        return Boolean.parseBoolean(this.properties.getProperty(SHOW_DOCUMENT_INFO_PANE, "true"));
    }

    public void setShowDocumentInfoPane(boolean showDocumentInfoPane) {
        this.properties.setProperty(SHOW_DOCUMENT_INFO_PANE, Boolean.toString(showDocumentInfoPane));
    }

    public boolean getDocumentInfoPaneDefaultOpen() {
        return Boolean.parseBoolean(this.properties.getProperty(DOCUMENT_INFO_PANE_DEFAULT_OPEN, "true"));
    }

    public void setDocumentInfoPaneDefaultOpen(boolean documentInfoPaneDefaultOpen) {
        this.properties.setProperty(DOCUMENT_INFO_PANE_DEFAULT_OPEN, Boolean.toString(documentInfoPaneDefaultOpen));
    }

    public boolean getDocumentInfoPaneOpenOnSelection() {
        return Boolean.parseBoolean(this.properties.getProperty(DOCUMENT_INFO_PANE_OPEN_ON_SELECTION, "true"));
    }

    public void setDocumentInfoPaneOpenOnSelection(boolean documentInfoPaneOpenOnSelection) {
        this.properties.setProperty(DOCUMENT_INFO_PANE_OPEN_ON_SELECTION, Boolean.toString(documentInfoPaneOpenOnSelection));
    }

    public String getFeatureConfiguration() {
        return this.properties.getProperty(FEATURE_CONFIGURATION, "");
    }

    public void setFeatureConfiguration(String featureConfiguration) {
        this.properties.setProperty(FEATURE_CONFIGURATION, featureConfiguration);
    }

    public String[] getShowRepositories() {
        String showRep = this.properties.getProperty(SHOW_REPOSITORIES);
        if (showRep != null) {
            return this.stringToArray(this.properties.getProperty(SHOW_REPOSITORIES));
        }
        return null;
    }

    public void setShowRepositories(String[] repositories) {
        this.properties.setProperty(SHOW_REPOSITORIES, this.arrayToString(repositories));
    }

    public String[] getShowViews() {
        String showViews = this.properties.getProperty(SHOW_VIEWS);
        if (showViews != null) {
            return this.stringToArray(this.properties.getProperty(SHOW_VIEWS));
        }
        return null;
    }

    public void setShowViews(String[] views) {
        this.properties.setProperty(SHOW_VIEWS, this.arrayToString(views));
    }

    public void setShowMyCheckouts(boolean showMyCheckouts) {
        this.properties.setProperty(SHOW_MY_CHECKOUTS, Boolean.toString(showMyCheckouts));
    }

    public boolean getShowMyCheckouts() {
        return Boolean.parseBoolean(this.properties.getProperty(SHOW_MY_CHECKOUTS));
    }

    @Override
    public String toString() {
        return this.getName() == null || this.getName() == "" ? this.getObjectId() : this.getName();
    }

    @Override
    public JSONObject toJSON() {
        String id;
        int dot;
        String[] showViews;
        JSONObject json = new JSONObject();
        json.put(SHOW_TREE_VIEW, (Object)this.getShowTreeView());
        json.put(DEFAULT_REPOSITORY, this.getDefaultRepository());
        json.put(SHOW_DOCUMENT_INFO_PANE, (Object)this.getShowDocumentInfoPane());
        json.put(DOCUMENT_INFO_PANE_DEFAULT_OPEN, (Object)this.getDocumentInfoPaneDefaultOpen());
        json.put(DOCUMENT_INFO_PANE_OPEN_ON_SELECTION, (Object)this.getDocumentInfoPaneOpenOnSelection());
        json.put(SHOW_MY_CHECKOUTS, (Object)this.getShowMyCheckouts());
        json.put(FEATURE_CONFIGURATION, this.getFeatureConfiguration());
        String[] showReps = this.getShowRepositories();
        if (showReps != null) {
            JSONArray showRepositoriesArray = new JSONArray();
            for (int i = 0; i < showReps.length; ++i) {
                showRepositoriesArray.add(showReps[i]);
            }
            json.put(SHOW_REPOSITORIES, showRepositoriesArray);
        }
        if ((showViews = this.getShowViews()) != null) {
            JSONArray showViewsArray = new JSONArray();
            for (int i = 0; i < showViews.length; ++i) {
                showViewsArray.add(showViews[i]);
            }
            json.put(SHOW_VIEWS, showViewsArray);
        }
        if ((dot = (id = this.getObjectId()).indexOf(".")) > 0) {
            id = id.substring(dot + 1);
        }
        json.put("id", id);
        return json;
    }
}

