/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.ConfigurationObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public class DesktopAccessConfig
extends ConfigurationObject {
    private static final String USERS = "users";
    private static final String GROUPS = "groups";
    private static final String DENYUSERS = "denyUsers";
    private static final String REPOSITORY_TYPE = "repositoryType";
    private boolean lookupsCreated = false;
    private boolean caseInsensitiveCompare = false;
    private Set<String> denyUsersLookup = null;
    private Set<String> usersLookup = null;
    private Set<String> groupsLookup = null;

    public DesktopAccessConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.upgrade();
    }

    @Override
    public String getObjectType() {
        return "desktopAccess";
    }

    @Override
    protected Class getDataType(String key) {
        if (key.equals(USERS) || key.equals(GROUPS) || key.equals(DENYUSERS)) {
            return String[].class;
        }
        return String.class;
    }

    private void upgrade() {
        if (!this.isEmpty()) {
            this.setDefaultValue(REPOSITORY_TYPE, "");
        }
    }

    public String getRepositoryType() {
        return this.properties.getProperty(REPOSITORY_TYPE);
    }

    public void setRepositoryType(String repositoryType) {
        this.properties.setProperty(REPOSITORY_TYPE, repositoryType);
    }

    public String[] getDenyUsers() {
        return this.stringToArray(this.properties.getProperty(DENYUSERS));
    }

    public void setDenyUsers(String[] denyUsers) {
        this.properties.setProperty(DENYUSERS, this.arrayToString(denyUsers));
    }

    public String[] getUsers() {
        return this.stringToArray(this.properties.getProperty(USERS));
    }

    public void setUsers(String[] users) {
        this.properties.setProperty(USERS, this.arrayToString(users));
    }

    public String[] getGroups() {
        return this.stringToArray(this.properties.getProperty(GROUPS));
    }

    public void setGroups(String[] groups) {
        this.properties.setProperty(GROUPS, this.arrayToString(groups));
    }

    private String[] namesToLowerCase(String[] names) {
        String[] lcNames = null;
        if (names != null) {
            lcNames = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                lcNames[i] = names[i].toLowerCase();
            }
        }
        return lcNames;
    }

    private Set<String> createNamesLookup(String propertyName) {
        String[] names = this.stringToArray(this.properties.getProperty(propertyName));
        Set<String> namesLookup = null;
        if (names != null && names.length > 0) {
            if (this.caseInsensitiveCompare) {
                names = this.namesToLowerCase(names);
            }
            namesLookup = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(names)));
        }
        return namesLookup;
    }

    private boolean userFoundIn(String user, Set<String> usersLookup) {
        boolean userFound = false;
        if (usersLookup != null && usersLookup.size() > 0) {
            userFound = usersLookup.contains(user);
        }
        return userFound;
    }

    private boolean groupFoundIn(String[] userGroups, Set<String> groupsLookup) {
        boolean groupFound = false;
        if (userGroups != null && userGroups.length > 0 && groupsLookup != null && groupsLookup.size() > 0) {
            if (userGroups.length >= groupsLookup.size()) {
                String group;
                HashSet<String> userGroupsLookup = new HashSet<String>(Arrays.asList(userGroups));
                Iterator<String> i$ = groupsLookup.iterator();
                while (i$.hasNext() && !(groupFound = userGroupsLookup.contains(group = i$.next()))) {
                }
            } else {
                String group;
                String[] arr$ = userGroups;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !(groupFound = groupsLookup.contains(group = arr$[i$])); ++i$) {
                }
            }
        }
        return groupFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAccess(String userName, String[] groups) {
        DesktopAccessConfig desktopAccessConfig = this;
        synchronized (desktopAccessConfig) {
            if (!this.lookupsCreated) {
                this.caseInsensitiveCompare = this.properties.getProperty(REPOSITORY_TYPE).compareToIgnoreCase("od") == 0;
                this.denyUsersLookup = this.createNamesLookup(DENYUSERS);
                this.usersLookup = this.createNamesLookup(USERS);
                this.groupsLookup = this.createNamesLookup(GROUPS);
                this.lookupsCreated = true;
            }
        }
        if (this.caseInsensitiveCompare) {
            userName = userName.toLowerCase();
            groups = this.namesToLowerCase(groups);
        }
        if (this.userFoundIn(userName, this.denyUsersLookup)) {
            return false;
        }
        if (this.userFoundIn(userName, this.usersLookup)) {
            return true;
        }
        return this.groupFoundIn(groups, this.groupsLookup);
    }
}

