/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Cache;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.serviceability.AdminLogger;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;

public class DBCacher<T extends ConfigurationObject>
extends Thread {
    private AbstractConfiguration configuration;
    private Class<T> configClass;
    private String prefix;
    private static final char KEY_DELIMITER = '.';
    private static final String KEY_STRING_DELIMITER = "\\.";

    private DBCacher() {
    }

    public DBCacher(String prefix, AbstractConfiguration configuration, Class<T> configClass) {
        this.configuration = configuration;
        this.configClass = configClass;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends ConfigurationObject> void _getConfiguration(AbstractConfiguration configSrc, Class<T> ConfigClass, String idPrefix, String id) throws ConfigurationException, MissingValueException {
        String key = ConfigClass.getName() + "." + (idPrefix == null || idPrefix.length() == 0 ? "" : idPrefix + ".") + id;
        ConfigurationObject config = null;
        config = (ConfigurationObject)Cache.getInstance().get(key);
        if (config == null) {
            try {
                Constructor<T> constructor;
                Constructor<T> constructor2 = constructor = ConfigClass.getConstructor(Configuration.class, String.class, String.class);
                synchronized (constructor2) {
                    config = (ConfigurationObject)constructor.newInstance(configSrc, idPrefix, id);
                }
            }
            catch (Exception e) {
                ConfigurationException ce = new ConfigurationException((Throwable)e);
                AdminLogger.logError(DBCacher.class, (String)"getConfiguration", (HttpSession)null, (String)e.getMessage());
                throw ce;
            }
            if (!config.isEmpty()) {
                Cache.getInstance().add(key, config);
            } else {
                AdminLogger.logError(DBCacher.class, (String)"getConfiguration", (HttpSession)null, (String)("configuration not found, key: " + key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            Iterator it = this.configuration.getKeys(this.prefix);
            while (it != null) {
                if (!it.hasNext()) return;
                Cache cache = Cache.getInstance();
                synchronized (cache) {
                    String key = (String)it.next();
                    AdminLogger.logInfo(DBCacher.class, (String)"run", (HttpSession)null, (String)("Preload configuration, key: " + key));
                    String[] types = key.split(KEY_STRING_DELIMITER);
                    String id = StringUtils.join((Object[])Arrays.copyOfRange(types, 2, types.length), (char)'.');
                    DBCacher._getConfiguration(this.configuration, this.configClass, types[1], id);
                }
            }
            return;
        }
        catch (ConcurrentModificationException cme) {
            System.out.println("DBCacher exception: " + cme.getLocalizedMessage());
            return;
        }
        catch (Exception e) {
            System.out.println("DBCacher exception: " + e.getLocalizedMessage());
        }
    }
}

