/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.configuration.Cache;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.util.JSONUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.lang.StringUtils;

public abstract class ConfigurationObject {
    protected static final char ARRAY_DELIMITER = ',';
    protected static final char KEY_DELIMITER = '.';
    protected static final char LIST_ESC_CHAR = '\\';
    protected static final String LIST_ESCAPE = String.valueOf('\\');
    protected static final String LIST_SEPARATOR = "\\u003B";
    protected static final int MODIFIER = 26;
    private Configuration configuration;
    protected Properties properties;
    private String objectId;
    private String idPrefix;
    protected boolean cloned = false;

    public ConfigurationObject(Configuration configuration, String idPrefix, String objectId) {
        this.configuration = configuration;
        this.objectId = objectId;
        this.idPrefix = idPrefix;
        this.load();
    }

    public Configuration getConfigurationObject() {
        return this.configuration;
    }

    public abstract String getObjectType();

    public String getName() {
        return "";
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public String getKey() {
        String key = this.idPrefix == null || this.idPrefix.length() == 0 ? this.getObjectType() + '.' + this.objectId : this.getObjectType() + '.' + this.idPrefix + '.' + this.objectId;
        return key;
    }

    public Collection getList(String type, String appName, HttpServletRequest request) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        String key = null;
        try {
            Configuration configuration;
            AbstractConfiguration defaultConfig = Config.getDefaultConfiguration();
            key = this.getKey();
            if (key.startsWith("icon.navigator.default")) {
                if (this.configuration != null && this.configuration.containsKey(key)) {
                    configuration = this.configuration;
                    synchronized (configuration) {
                        this.properties = this.configuration.getProperties(key);
                    }
                } else {
                    this.properties = new Properties();
                }
            } else if (key.startsWith("iconStatus.navigator.") || key.startsWith("filetype.navigator") || key.startsWith("interfaceText.navigator")) {
                if (this.configuration != null && this.configuration.containsKey(key)) {
                    configuration = this.configuration;
                    synchronized (configuration) {
                        this.properties = this.configuration.getProperties(key);
                    }
                } else {
                    this.properties = defaultConfig != null && defaultConfig.containsKey(key) ? Config.getDefaultConfiguration().getProperties(key) : new Properties();
                }
            } else if (defaultConfig != null && defaultConfig.containsKey(key)) {
                this.properties = Config.getDefaultConfiguration().getProperties(key);
            } else if (this.configuration != null) {
                configuration = this.configuration;
                synchronized (configuration) {
                    this.properties = key.startsWith("desktop.navigator.test") ? this.configuration.getProperties(key) : this.configuration.getProperties(key);
                }
            } else {
                this.properties = new Properties();
            }
            if (!this.properties.isEmpty()) {
                Enumeration<Object> e = this.properties.keys();
                String keyValue = null;
                String value = null;
                while (e.hasMoreElements()) {
                    keyValue = (String)e.nextElement();
                    value = (String)this.properties.get(keyValue);
                    if (value.indexOf(LIST_SEPARATOR) == -1) continue;
                    this.properties.put(keyValue, StringUtils.replace((String)value, (String)LIST_SEPARATOR, (String)String.valueOf(';')));
                }
            }
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, (String)"load", (String)("Error in getting configuraiton, key is " + key), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws ConfigurationException {
        if (!this.cloned) {
            String propertiesString = this.propertiesToString(this.properties);
            Configuration configuration = this.configuration;
            synchronized (configuration) {
                try {
                    this.configuration.setProperty(this.getKey(), (Object)propertiesString);
                }
                catch (Exception e) {
                    this.configuration.setProperty(this.getKey(), (Object)propertiesString);
                }
            }
        }
    }

    public void dump(OutputStreamWriter osw) throws IOException {
        String configString = this.propertiesToString(this.properties);
        configString = PropertyConverter.escapeDelimiters((String)configString, (char)'\\');
        osw.write(this.getKey() + " = " + configString + "\n");
    }

    public static <V extends ConfigurationObject> void writeConfigurationToFile(OutputStreamWriter osw, Collection<V> configList) throws IOException, FileNotFoundException {
        for (ConfigurationObject configObject : configList) {
            if (configObject.isEmpty()) continue;
            configObject.dump(osw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Configuration configuration = this.configuration;
        synchronized (configuration) {
            this.configuration.clearProperty(this.getKey());
        }
    }

    public boolean isEmpty() {
        return this.properties == null || this.properties.entrySet() == null || this.properties.entrySet().size() <= 0;
    }

    public List stringToList(String string) {
        return PropertyConverter.split((String)string, (char)',');
    }

    public String[] stringToArray(String string) {
        String[] array = null;
        if (string == null || string.length() == 0) {
            array = new String[]{};
        } else {
            List list = PropertyConverter.split((String)string, (char)',');
            array = new String[list.size()];
            list.toArray(array);
        }
        return array;
    }

    public String arrayToString(String[] array) {
        if (array == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            String escapedValue = PropertyConverter.escapeDelimiters((String)array[i], (char)',');
            stringBuffer.append(escapedValue);
        }
        return stringBuffer.toString();
    }

    protected boolean skipThisPropertyWhenSaving(String key) {
        return false;
    }

    protected String propertiesToString(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (this.skipThisPropertyWhenSaving(key)) continue;
            if (stringBuffer.length() > 1) {
                stringBuffer.append(';');
            }
            String value = properties.getProperty(key);
            stringBuffer.append(key);
            stringBuffer.append("=");
            if (value != null && value.indexOf(59) != -1) {
                value = StringUtils.replace((String)value, (String)String.valueOf(';'), (String)LIST_SEPARATOR);
            }
            stringBuffer.append(value);
        }
        return stringBuffer.toString();
    }

    public String covertEmptyStringtoNull(String value) {
        return value != null && value.length() == 0 ? null : value;
    }

    protected <V extends ConfigurationObject> Map<String, V> getMap(Class<V> configClass, String idPrefix, String[] ids, boolean ... flags) {
        boolean skipCaching = true;
        if (flags != null && flags.length > 0) {
            skipCaching = flags[0];
        }
        LinkedHashMap<String, V> map = this.getConfiguration(configClass, idPrefix, ids, skipCaching);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends ConfigurationObject> LinkedHashMap<String, V> getConfiguration(Class<V> configClass, String idPrefix, String[] ids, boolean ... flags) {
        LinkedHashMap<String, V> map = new LinkedHashMap<String, V>();
        boolean skipCaching = false;
        if (flags != null && flags.length > 0) {
            skipCaching = flags[0];
        }
        try {
            LinkedHashMap<String, V> linkedHashMap = map;
            synchronized (linkedHashMap) {
                for (String id : ids) {
                    if (id == null || id.length() <= 0) continue;
                    V config = Config.getConfiguration(configClass, idPrefix, id, skipCaching);
                    map.put(id, config);
                }
            }
        }
        catch (Exception e) {
            AdminLogger.logError((Object)this, (String)"LinkedHasMap", (String)"Error in getting configuraiton", (Throwable)e);
        }
        return map;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        Set<Map.Entry<Object, Object>> keys = this.properties.entrySet();
        for (Map.Entry<Object, Object> entry : keys) {
            String key = entry.getKey().toString();
            if (entry.getValue() instanceof String) {
                String value = (String)entry.getValue();
                Class datatype = this.getDataType(key);
                try {
                    if (datatype == null) {
                        if (value.equals("true")) {
                            json.put(key, (Object)true);
                            continue;
                        }
                        if (value.equals("false")) {
                            json.put(key, (Object)false);
                            continue;
                        }
                        if (value.indexOf(",") > -1) {
                            String[] values = value.split(",");
                            JSONArray jsonArray = new JSONArray();
                            for (String element : values) {
                                jsonArray.add(element);
                            }
                            json.put(key, jsonArray);
                            continue;
                        }
                        json.put(key, value);
                        continue;
                    }
                    if (datatype == String.class) {
                        json.put(key, value);
                        continue;
                    }
                    if (datatype == Boolean.class) {
                        json.put(key, (Object)Boolean.parseBoolean(value));
                        continue;
                    }
                    if (datatype == Integer.class) {
                        if (value.equals("NaN")) {
                            json.put(key, value);
                            continue;
                        }
                        json.put(key, (Object)Integer.parseInt(value));
                        continue;
                    }
                    if (datatype != String[].class) continue;
                    json.put(key, JSONUtils.toJSONArray((String[])this.stringToArray(value)));
                }
                catch (Exception e) {
                    AdminLogger.logError((Object)this, (String)"toJSON", (String)("error converting property " + key + " value " + value + ": " + e.getMessage()));
                    json.put(key, value);
                }
                continue;
            }
            if (entry.getValue() instanceof ConfigurationObject) {
                ConfigurationObject configObj = (ConfigurationObject)entry.getValue();
                json.put(key, configObj.toJSON());
                continue;
            }
            json.put(key, entry.getValue());
        }
        if (this.getObjectId() != null) {
            json.put("id", this.getObjectId());
        }
        return json;
    }

    protected Class getDataType(String key) {
        return null;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getPropertyValue(String key) {
        return this.properties.getProperty(key);
    }

    public String getPropertyValue(String key, String defaultValue) {
        String value = this.properties.getProperty(key, defaultValue);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    public int getPropertyValue(String key, int defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public long getPropertyValue(String key, long defaultValue) {
        String value = this.properties.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getPropertyNames() {
        String key = this.getClass().getName() + ".getConstants.";
        LinkedHashMap<String, String> constants = (LinkedHashMap<String, String>)Cache.getInstance().get(key);
        if (constants == null) {
            constants = new LinkedHashMap<String, String>();
            try {
                LinkedHashMap<String, String> linkedHashMap = constants;
                synchronized (linkedHashMap) {
                    Field[] flds;
                    Class<?> c = this.getClass();
                    for (Field f : flds = c.getDeclaredFields()) {
                        if (f.isEnumConstant() || 26 != f.getModifiers() || f.getType() != String.class) continue;
                        f.setAccessible(true);
                        constants.put((String)f.get(this), (String)f.get(this));
                    }
                }
            }
            catch (Exception e) {
                AdminLogger.logError((Object)this, (String)"getPropertyNames", (String)("Key is: " + key), (Throwable)e);
            }
            Cache.getInstance().add(key, constants);
        }
        return constants;
    }

    public void setValues(JSONObject json) {
        this.setValues(json, false);
    }

    public void setValues(JSONObject json, boolean forceUpdate) {
        Map<String, String> names = this.getPropertyNames();
        Set keys = json.entrySet();
        for (Map.Entry entry : keys) {
            String sValue;
            String key = (String)entry.getKey();
            if (!forceUpdate && !names.containsKey(key)) continue;
            Object value = entry.getValue();
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    sValue = (String)jsonArray.get(i);
                    sValue = sValue.replace("\\", "\\\\");
                    sValue = PropertyConverter.escapeListDelimiter((String)sValue, (char)',');
                    buffer.append(sValue);
                }
                sValue = buffer.toString();
            } else {
                sValue = value != null ? value.toString() : "";
                sValue = sValue.replace("\\", "\\\\");
            }
            this.properties.setProperty(key, sValue);
        }
    }

    public void removeValuesFromList(String key, List<String> deleteValues) {
        this.removeValuesFromList(key, deleteValues, this.properties);
    }

    protected void removeValuesFromList(String key, List<String> deleteValues, Properties props) {
        String[] array = this.stringToArray(props.getProperty(key));
        boolean removed = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            String val = array[i];
            if (!this.isInList(deleteValues, val)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                String escapedValue = PropertyConverter.escapeDelimiters((String)val, (char)',');
                stringBuffer.append(escapedValue);
                continue;
            }
            removed = true;
        }
        if (removed) {
            props.setProperty(key, stringBuffer.toString());
        }
    }

    boolean isInList(List<String> keys, String key) {
        for (int i = 0; i < keys.size(); ++i) {
            if (!keys.get(i).equals(key)) continue;
            return true;
        }
        return false;
    }

    public void addValueToList(String key, String value) {
        String[] array = this.stringToArray(this.properties.getProperty(key));
        List<String> arrayOfKeys = Arrays.asList(array);
        if (!arrayOfKeys.contains(value)) {
            String[] newArray = new String[array.length + 1];
            for (int i = 0; i < array.length; ++i) {
                newArray[i] = array[i];
            }
            newArray[array.length] = value;
            this.properties.setProperty(key, this.arrayToString(newArray));
        }
    }

    protected void setDefaultValue(String propertyName, String defaultValue) {
        if (this.properties.getProperty(propertyName) == null && defaultValue != null) {
            this.properties.setProperty(propertyName, defaultValue);
        }
    }

    public String toString() {
        return this.getObjectId();
    }
}

