/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.configuration;

import com.ibm.ecm.Constants;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.IconStatusConfig;
import com.ibm.ecm.configuration.MenuConfig;
import com.ibm.ecm.configuration.PluginConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.configuration.ServerConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.ThemeConfig;
import com.ibm.ecm.configuration.ViewerConfig;
import com.ibm.ecm.configuration.ViewerMappingConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.extension.PluginMenu;
import com.ibm.ecm.extension.PluginMenuType;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.PluginUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;

public class ApplicationConfig
extends ConfigurationObject {
    private static final String LOCALES = "locales";
    private static final String PLUGINS = "plugins";
    private static final String THEMES = "themes";
    private static final String DESKTOPS = "desktops";
    private static final String REPOSITORIES = "repositories";
    private static final String MENUS = "menus";
    private static final String VIEWERS = "viewers";
    private static final String SERVERS = "servers";
    private static final String OBJECT_EXPIRATION = "objectExpiration";
    private static final String THREAD_SLEEP_TIME = "threadSleepTime";
    private static final String DESKTOP = "desktop";
    private static final String APPLICATION_VERSION = "applicationVersion";
    public static final String ENCRYPTION_KEY = "key";

    public ApplicationConfig(Configuration configuration, String idPrefix, String id) {
        super(configuration, idPrefix, id);
        this.upgrade();
    }

    private void upgrade() {
        if (!this.isEmpty()) {
            this.setDefaultValue(APPLICATION_VERSION, "2.0.2");
        }
    }

    @Override
    public String getObjectType() {
        return "application";
    }

    @Override
    protected Class getDataType(String key) {
        if (key.equals(LOCALES) || key.equals(PLUGINS) || key.equals(THEMES) || key.equals(DESKTOPS) || key.equals(REPOSITORIES) || key.equals(MENUS) || key.equals(VIEWERS) || key.equals(SERVERS)) {
            return String[].class;
        }
        if (key.equals(OBJECT_EXPIRATION) || key.equals(THREAD_SLEEP_TIME)) {
            return Integer.class;
        }
        return String.class;
    }

    public int getThreadSleepTime() {
        return this.getPropertyValue(THREAD_SLEEP_TIME, 5);
    }

    public void setThreadSleepTime(int sleepTime) {
        this.properties.setProperty(THREAD_SLEEP_TIME, Integer.toString(sleepTime));
    }

    public int getObjectExpiration() {
        return this.getPropertyValue(OBJECT_EXPIRATION, 5);
    }

    public void setObjectExpiration(int expirationTime) {
        this.properties.setProperty(OBJECT_EXPIRATION, Integer.toString(expirationTime));
    }

    @Override
    public Collection getList(String type, String appName, HttpServletRequest request) {
        if (type.equals(DESKTOPS)) {
            return this.getDesktopList(request);
        }
        if (type.equals(REPOSITORIES)) {
            return this.getRepositoriesList();
        }
        if (type.equals(MENUS)) {
            return this.getMenusList(request);
        }
        if (type.equals(SERVERS)) {
            return this.getServersList();
        }
        if (type.equals(PLUGINS)) {
            return this.getPluginsList();
        }
        if (type.equals(THEMES)) {
            return this.getThemesList();
        }
        if (type.equals(VIEWERS)) {
            return this.getViewersList(request);
        }
        if (type.equals("iconStatus")) {
            return this.getIconStatusList();
        }
        return null;
    }

    public String[] getDesktopsId() {
        return this.stringToArray(this.properties.getProperty(DESKTOPS));
    }

    public void setDesktopsId(String[] ids) {
        this.properties.put(DESKTOPS, this.arrayToString(ids));
    }

    public Collection<DesktopConfig> getDesktopList(HttpServletRequest request) {
        return this.getDesktopList(request, this.getDesktopsId());
    }

    public Collection<DesktopConfig> getDesktopList(HttpServletRequest request, String[] desktopsId) {
        Collection<DesktopConfig> list = this.getMap(DesktopConfig.class, this.getObjectId(), desktopsId, true).values();
        for (DesktopConfig config : list) {
            if (!config.getObjectId().equals("admin")) continue;
            String name = "";
            String description = "";
            try {
                name = MessageUtil.getMessage((HttpServletRequest)request, (String)("desktop." + config.getObjectId() + ".name"));
                description = MessageUtil.getMessage((HttpServletRequest)request, (String)("desktop." + config.getObjectId() + ".description"));
            }
            catch (Exception e) {
                // empty catch block
            }
            config.setName(name);
            config.setDescription(description);
        }
        return list;
    }

    public Collection<DesktopConfig> getDesktopList() {
        return this.getMap(DesktopConfig.class, this.getObjectId(), this.getDesktopsId(), true).values();
    }

    public String[] getRepositoriesId() {
        return this.stringToArray(this.properties.getProperty(REPOSITORIES));
    }

    public void setRepositoriesId(String[] ids) {
        this.properties.put(REPOSITORIES, this.arrayToString(ids));
    }

    public Collection<RepositoryConfig> getRepositoriesList() {
        return this.getRepositoriesList(this.getRepositoriesId());
    }

    public Collection<RepositoryConfig> getRepositoriesList(String[] ids) {
        return this.getMap(RepositoryConfig.class, this.getObjectId(), ids, true).values();
    }

    public String[] getViewersId() {
        return this.stringToArray(this.properties.getProperty(VIEWERS));
    }

    public void setViewersId(String[] ids) {
        this.properties.setProperty(VIEWERS, this.arrayToString(ids));
    }

    public void setPluginsId(String[] ids) {
        this.properties.setProperty(PLUGINS, this.arrayToString(ids));
    }

    public void setThemesId(String[] ids) {
        this.properties.setProperty(THEMES, this.arrayToString(ids));
    }

    public void setMenusId(String[] ids) {
        this.properties.setProperty(MENUS, this.arrayToString(ids));
    }

    public Collection<ViewerConfig> getViewersList(HttpServletRequest request) {
        Collection<ViewerConfig> list = this.getMap(ViewerConfig.class, this.getObjectId(), this.getViewersId(), true).values();
        for (ViewerConfig config : list) {
            if (!config.getObjectId().equals("default")) continue;
            String name = "";
            String description = "";
            try {
                name = MessageUtil.getMessage((HttpServletRequest)request, (String)"viewerMap.default.name");
                description = MessageUtil.getMessage((HttpServletRequest)request, (String)"viewerMap.default.description");
            }
            catch (Exception e) {
                // empty catch block
            }
            config.setName(name);
            config.setDescription(description);
        }
        return list;
    }

    public String[] getServersId() {
        return this.stringToArray(this.properties.getProperty(SERVERS));
    }

    public Collection<ServerConfig> getServersList() {
        return this.getMap(ServerConfig.class, this.getObjectId(), this.getServersId(), true).values();
    }

    public String[] getMenusId() {
        return this.stringToArray(this.properties.getProperty(MENUS));
    }

    public Collection<MenuConfig> getMenusList(HttpServletRequest request) {
        String methodName = "getMenusList";
        Map<String, MenuConfig> definedMenusMap = this.getMap(MenuConfig.class, this.getObjectId(), this.getMenusId(), true);
        Properties defaultProperties = Config.getDefaultConfiguration().getProperties(this.getObjectType() + "." + this.getObjectId() + ".defaultMenus");
        String[] defaultMenuIds = this.stringToArray(defaultProperties.getProperty("items"));
        Map<String, MenuConfig> menusMap = this.getMap(MenuConfig.class, this.getObjectId(), defaultMenuIds, true);
        Map pluginMenuTypeMap = PluginUtil.getPluginMenuTypes((HttpServletRequest)request);
        for (String key : definedMenusMap.keySet()) {
            MenuConfig menuConfig = definedMenusMap.get(key);
            if (menusMap.containsKey(key)) continue;
            menusMap.put(key, menuConfig);
        }
        Collection<MenuConfig> list = menusMap.values();
        for (MenuConfig menuConfig : list) {
            this.processMenuConfig(menuConfig, pluginMenuTypeMap, request);
        }
        ArrayList<MenuConfig> arrayList = new ArrayList<MenuConfig>(list);
        Map pluginMenuMap = PluginUtil.getPluginMenus((HttpServletRequest)request);
        for (String key : pluginMenuMap.keySet()) {
            PluginMenu pluginMenu = (PluginMenu)pluginMenuMap.get(key);
            try {
                MenuConfig config = Config.getMenuConfig(this.getObjectId(), pluginMenu.getId(), new boolean[0]);
                config.setName(pluginMenu.getName(request.getLocale()));
                config.setPluginId(pluginMenu.getPluginId());
                config.setDescription(pluginMenu.getDescription(request.getLocale()) != null ? pluginMenu.getDescription(request.getLocale()) : "");
                config.setType(pluginMenu.getMenuType());
                PluginMenuType pluginMenuType = (PluginMenuType)pluginMenuTypeMap.get(pluginMenu.getMenuType());
                if (pluginMenuType != null) {
                    config.setTypeLabel(pluginMenuType.getName(request.getLocale()));
                } else {
                    try {
                        config.setTypeLabel(MessageUtil.getMessage((HttpServletRequest)request, (String)("menuType." + config.getType() + ".label")));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                arrayList.add(config);
            }
            catch (Exception e) {
                AdminLogger.logError((Object)this, (String)methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        return arrayList;
    }

    private void processMenuConfig(MenuConfig menuConfig, Map<String, PluginMenuType> pluginMenuTypeMap, HttpServletRequest request) {
        if (menuConfig.getType() == null || menuConfig.getType().equals("")) {
            String id = menuConfig.getObjectId();
            if (id != null && id.startsWith("Default")) {
                menuConfig.setType(id.substring("Default".length()));
            } else {
                menuConfig.setType("");
            }
        }
        String typeLabel = "";
        if (pluginMenuTypeMap.containsKey(menuConfig.getType())) {
            PluginMenuType pluginMenuType = pluginMenuTypeMap.get(menuConfig.getType());
            typeLabel = pluginMenuType.getName(request.getLocale());
            menuConfig.setPluginId(pluginMenuType.getPluginId());
        } else {
            try {
                typeLabel = MessageUtil.getMessage((HttpServletRequest)request, (String)("menuType." + menuConfig.getType() + ".label"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        menuConfig.setTypeLabel(typeLabel);
        if (menuConfig.getObjectId().startsWith("Default")) {
            String defaultNameLabel = "";
            String defaultDescriptionLabel = "";
            try {
                defaultNameLabel = MessageUtil.getMessage((HttpServletRequest)request, (String)("menu." + menuConfig.getObjectId() + ".name"));
                defaultDescriptionLabel = MessageUtil.getMessage((HttpServletRequest)request, (String)("menu." + menuConfig.getObjectId() + ".description"));
            }
            catch (Exception e) {
                // empty catch block
            }
            menuConfig.setName(defaultNameLabel);
            menuConfig.setDescription(defaultDescriptionLabel);
        }
    }

    public String[] getLocales() {
        int nbIndex;
        String temp = this.properties.getProperty(LOCALES);
        if (temp.indexOf(",ro") == -1) {
            temp = temp + ",ro";
        }
        if (temp.indexOf(",no") == -1) {
            temp = temp + ",no";
        }
        if (temp.indexOf(",kk") == -1) {
            temp = temp + ",kk";
        }
        if (temp.indexOf(",ca") == -1) {
            temp = temp + ",ca";
        }
        if (temp.indexOf(",vi") == -1) {
            temp = temp + ",vi";
        }
        if ((nbIndex = temp.indexOf(",nb")) != -1) {
            temp = temp.substring(0, nbIndex) + temp.substring(nbIndex + 3);
        }
        return this.stringToArray(temp);
    }

    public String[] getLocalizeSettings() {
        Properties defaultProperties = Config.getDefaultConfiguration().getProperties(this.getObjectType() + "." + this.getObjectId() + ".defaultLocalizedSettings");
        String[] locales = this.stringToArray(defaultProperties.getProperty(LOCALES));
        return locales;
    }

    public String[] getPluginsId() {
        return this.stringToArray(this.properties.getProperty(PLUGINS));
    }

    public Collection<PluginConfig> getPluginsList() {
        return this.getPluginsList(this.getPluginsId());
    }

    public Collection<PluginConfig> getPluginsList(String[] ids) {
        return this.getMap(PluginConfig.class, this.getObjectId(), ids, true).values();
    }

    public String[] getThemesId() {
        return this.stringToArray(this.properties.getProperty(THEMES));
    }

    public Collection<ThemeConfig> getThemesList() {
        return this.getThemesList(this.getThemesId());
    }

    public Collection<ThemeConfig> getThemesList(String[] ids) {
        return this.getMap(ThemeConfig.class, this.getObjectId(), ids, true).values();
    }

    public DesktopConfig getDesktop() {
        DesktopConfig desktop = null;
        try {
            desktop = Config.getDesktopConfig(this.getObjectId(), this.getDesktopName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return desktop;
    }

    public String getDesktopName() {
        return this.properties.getProperty(DESKTOP);
    }

    public void setDesktopName(String desktop) {
        this.properties.setProperty(DESKTOP, desktop);
    }

    public String getEncryptionKey() {
        return this.properties.getProperty(ENCRYPTION_KEY);
    }

    public void setEncryptionKey(String key) {
        this.properties.setProperty(ENCRYPTION_KEY, key);
    }

    public String getApplicationVersion() {
        return this.getPropertyValue(APPLICATION_VERSION, "2.0.2");
    }

    public void setApplicationVersion(String version) {
        this.properties.setProperty(APPLICATION_VERSION, version);
    }

    public SettingsConfig getSettingsConfig() {
        try {
            SettingsConfig config = Config.getSettingsConfig(this.getObjectId());
            return config;
        }
        catch (ConfigurationException e) {
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return null;
    }

    public Collection<IconStatusConfig> getIconStatusList() {
        Properties defaultProperties = Config.getDefaultConfiguration().getProperties("settings." + this.getObjectId() + ".iconStatus");
        String[] iconStatusIds = this.stringToArray(defaultProperties.getProperty("items"));
        Map<String, IconStatusConfig> iconStatusMap = this.getMap(IconStatusConfig.class, this.getObjectId(), iconStatusIds, true);
        return iconStatusMap.values();
    }

    public boolean checkAdminAccessForUser(String userid) {
        SettingsConfig config;
        String methodName = "checkAdminAccessForUser";
        if (userid != null && !userid.isEmpty() && (config = this.getSettingsConfig()) != null) {
            List<String> adminUsers = config.getAdminUsersList();
            AdminLogger.logDebug((Object)this, (String)methodName, (String)("adminUsers defined in the config=" + adminUsers));
            if (adminUsers != null && !adminUsers.isEmpty()) {
                return this.containsIgnoreCase(adminUsers, userid);
            }
        }
        return false;
    }

    public boolean containsIgnoreCase(List<String> l, String s) {
        String methodName = "containsIgnoreCase";
        String shortNameFromPrinciple = s;
        String nameWithoutRealm = s;
        if (s.contains("@")) {
            StringTokenizer st = new StringTokenizer(s, "@");
            shortNameFromPrinciple = (String)st.nextElement();
        }
        if (s.contains("/")) {
            nameWithoutRealm = s.substring(s.indexOf("/") + 1, s.length());
        }
        for (String nextItem : l) {
            if (!nextItem.equalsIgnoreCase(s) && !nextItem.equalsIgnoreCase(shortNameFromPrinciple) && !nextItem.equalsIgnoreCase(nameWithoutRealm)) continue;
            AdminLogger.logDebug((Object)this, (String)methodName, (String)("adminUser found in the config=" + s));
            return true;
        }
        AdminLogger.logDebug((Object)this, (String)methodName, (String)("adminUser Not found in the config=" + s));
        return false;
    }

    public void exportDesktops(HttpServletRequest request, OutputStreamWriter osw, String[] desktopIds, String[] repositoryIds, String[] pluginIds, boolean includeSecurity) throws IOException, FileNotFoundException {
        Collection<DesktopConfig> desktops = this.getDesktopList(request, desktopIds);
        String appName = request.getParameter("application");
        appName = appName == null ? "navigator" : appName;
        this.exportCustomMenus(request, osw, desktops);
        this.exportCustomViewer(request, osw, desktops);
        for (DesktopConfig desktop : desktops) {
            if (!desktop.getObjectId().equalsIgnoreCase("admin")) {
                String repositoryId;
                Constants.AuthenticationType at;
                if (desktop.getDefault() != null && desktop.getDefault().equalsIgnoreCase("yes")) {
                    desktop.setDefault("No");
                }
                desktop.exportInterfaceText(appName, osw);
                desktop.exportMobileFeature(appName, osw);
                desktop.exportDesktopFeatures(appName, osw);
                if (includeSecurity && (at = desktop.getAuthenticationType()) == Constants.AuthenticationType.REPOSITORY && repositoryIds.length > 0 && (repositoryId = desktop.getDefaultRepositoryId()) != null && this.findId(repositoryId, repositoryIds) != null) {
                    desktop.exportSecurity(appName, osw);
                }
            }
            String[] filteredIds = this.filterIds(desktop.getRepositoriesId(), repositoryIds);
            desktop.setRepositoriesId(filteredIds);
            desktop.dump(osw);
            Config.removeConfigurationFromCache(desktop);
        }
    }

    private String findId(String findMe, String[] ids) {
        for (String id : ids) {
            if (id == null || !id.equals(findMe)) continue;
            return id;
        }
        return null;
    }

    public void exportRepositories(HttpServletRequest request, OutputStreamWriter osw, String[] repositoryIds) throws IOException, FileNotFoundException {
        Collection<RepositoryConfig> repositories = this.getRepositoriesList(repositoryIds);
        for (RepositoryConfig repository : repositories) {
            repository.exportPropertiesMapping(this.getObjectId(), osw, repository);
            repository.dump(osw);
        }
    }

    private void exportCustomMenus(HttpServletRequest request, OutputStreamWriter osw, Collection<DesktopConfig> desktops) throws IOException, FileNotFoundException {
        Collection<MenuConfig> menus = this.getMenusList(request);
        AbstractConfiguration config = Config.getDefaultConfiguration();
        String key = null;
        for (MenuConfig menuConfig : menus) {
            key = menuConfig.getKey();
            if (config.containsKey(key) || !this.findInDesktop(key, desktops)) continue;
            this.exportMenu(request, osw, menuConfig, (Configuration)config);
        }
    }

    private void exportMenu(HttpServletRequest request, OutputStreamWriter osw, MenuConfig menuConfig, Configuration config) throws IOException {
        String key;
        if (menuConfig.getItems() != null && menuConfig.getItems().length > 0) {
            try {
                menuConfig.loadSubMenus(request, menuConfig.getId());
                List<MenuConfig> subMenus = menuConfig.getSubMenus();
                for (MenuConfig menu : subMenus) {
                    this.exportMenu(request, osw, menu, config);
                }
            }
            catch (MissingValueException mve) {
                AdminLogger.logError((Object)this, (String)"exportMenu", (ServletRequest)request, (Throwable)mve);
            }
            catch (ConfigurationException ce) {
                AdminLogger.logError((Object)this, (String)"exportMenu", (ServletRequest)request, (Throwable)ce);
            }
        }
        if (!config.containsKey(key = menuConfig.getKey()) && !menuConfig.isEmpty()) {
            menuConfig.dump(osw);
        }
    }

    private void exportCustomViewer(HttpServletRequest request, OutputStreamWriter osw, Collection<DesktopConfig> desktops) throws IOException, FileNotFoundException {
        Collection<ViewerConfig> viewers = this.getViewersList(request);
        AbstractConfiguration config = Config.getDefaultConfiguration();
        String key = null;
        for (ViewerConfig viewerConfig : viewers) {
            key = viewerConfig.getKey();
            if (config.containsKey(key) || !this.findViewerInDesktop(key, desktops)) continue;
            viewerConfig.dump(osw);
            for (ViewerMappingConfig viewerMapping : viewerConfig.getViewerMappingList()) {
                viewerMapping.dump(osw);
            }
        }
    }

    public void exportPlugins(HttpServletRequest request, OutputStreamWriter osw, String[] pluginIds) throws IOException, FileNotFoundException {
        Collection<PluginConfig> plugins = this.getPluginsList(pluginIds);
        ConfigurationObject.writeConfigurationToFile(osw, plugins);
    }

    public void exportThemes(HttpServletRequest request, OutputStreamWriter osw, String[] themeIds) throws IOException, FileNotFoundException {
        Collection<ThemeConfig> themes = this.getThemesList(themeIds);
        ConfigurationObject.writeConfigurationToFile(osw, themes);
    }

    private boolean findViewerInDesktop(String key, Collection<DesktopConfig> desktops) {
        for (DesktopConfig desktop : desktops) {
            String[] keys;
            String id;
            String viewers = desktop.getViewer();
            if (viewers.indexOf(id = StringUtils.join((Object[])Arrays.copyOfRange(keys = key.split("\\."), 2, keys.length), (char)'.')) <= -1) continue;
            return true;
        }
        return false;
    }

    private boolean findInDesktop(String key, Collection<DesktopConfig> desktops) {
        AbstractConfiguration config = Config.getConfiguration();
        for (DesktopConfig desktop : desktops) {
            String[] keys;
            desktop.getViewer();
            Properties properties = config.getProperties(desktop.getKey());
            String desktopInString = this.propertiesToString(properties);
            if (desktopInString.indexOf((keys = key.split("\\."))[2]) <= -1) continue;
            return true;
        }
        return false;
    }

    private String[] filterIds(String[] oldIds, String[] baseIds) {
        String[] result = new String[oldIds.length];
        int i = 0;
        for (String id : oldIds) {
            for (String baseId : baseIds) {
                if (!baseId.equals(id)) continue;
                result[i++] = id;
            }
        }
        return result;
    }
}

