     h DFTNAME(CNVRTTEMP) 
      *********************************************************************
      *                                                                   *
      *                  IBM Web Services Client for ILE                  *
      *                                                                   *
      *  FILE NAME:      ConvertTempClientWSDL2RPG.RPGLE                  *
      *                                                                   *
      *  DESCRIPTION:    Source for ConvertTemp Web service client        *
      *                                                                   *
      *********************************************************************
      * LICENSE AND DISCLAIMER                                            *
      * ----------------------                                            *
      * This material contains IBM copyrighted sample programming source  *
      * code ( Sample Code ).                                             *
      * IBM grants you a nonexclusive license to compile, link, execute,  *
      * display, reproduce, distribute and prepare derivative works of    *
      * this Sample Code.  The Sample Code has not been thoroughly        *
      * tested under all conditions.  IBM, therefore, does not guarantee  *
      * or imply its reliability, serviceability, or function. IBM        *
      * provides no program services for the Sample Code.                 *
      *                                                                   *
      * All Sample Code contained herein is provided to you "AS IS"       *
      * without any warranties of any kind. THE IMPLIED WARRANTIES OF     *
      * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND             *
      * NON-INFRINGMENT ARE EXPRESSLY DISCLAIMED.                         *
      * SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED          *
      * WARRANTIES, SO THE ABOVE EXCLUSIONS MAY NOT APPLY TO YOU.  IN NO  *
      * EVENT WILL IBM BE LIABLE TO ANY PARTY FOR ANY DIRECT, INDIRECT,   *
      * SPECIAL OR OTHER CONSEQUENTIAL DAMAGES FOR ANY USE OF THE SAMPLE  *
      * CODE INCLUDING, WITHOUT LIMITATION, ANY LOST PROFITS, BUSINESS    *
      * INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA ON YOUR INFORMATION  *
      * HANDLING SYSTEM OR OTHERWISE, EVEN IF WE ARE EXPRESSLY ADVISED OF *
      * THE POSSIBILITY OF SUCH DAMAGES.                                  *
      *                                                                   *
      *  <START_COPYRIGHT>                                                *
      *                                                                   *
      *  Licensed Materials - Property of IBM                             *
      *                                                                   *
      *  5722-SS1, 5761-SS1, 5770-SS1                                     *
      *                                                                   *
      *  (c) Copyright IBM Corp. 2010, 2010                               *
      *  All Rights Reserved                                              *
      *                                                                   *
      *  U.S. Government Users Restricted Rights - use,                   *
      *  duplication or disclosure restricted by GSA                      *
      *  ADP Schedule Contract with IBM Corp.                             *
      *                                                                   *
      *  Status: Version 1 Release 0                                      *
      *  <END_COPYRIGHT>                                                  *
      *                                                                   *
      *********************************************************************
      *
      /copy ConvertTempPortType.rpgleinc       
                                                  
     d OutputText      s             50                                        
     d WsStub          ds                  likeds(This_t)                      
     d Input           ds                  likeds(CONVERTTEMPInput_t)      
     d Result          ds                  likeds(CONVERTTEMPResult_t)       

      *--------------------------------------------------------------------
      * Program entry point. The input parameter is a character field
      * representing the temperature in Fahrenheit.                    
      *--------------------------------------------------------------------
     C     *ENTRY        PLIST
     C                   PARM                    TEMPIN           32
      *--------------------------------------------------------------------
      * Web service logic. The code will attempt to invoke a Web 
      * service in order to convert temperature in Fahrenheit to Celsius
      * and then display the results. 
      *--------------------------------------------------------------------
                                    
      /free        
         // Get a Web service stub. The host and port for the endpoint may need 
         // to be changed to match host and port of Web service. Or you can pass 
         // blanks and endpoint in the WSDL file will be used.
         clear WsStub;
         WsStub.endpoint = 'http://localhost:10000/web/services/ConvertTemp';
        
         clear input;
         Input.TEMPIN.value = %trim(TEMPIN);
                            
         if (stub_create_ConvertTempPortType(WsStub) = *ON); 

           // Invoke the ConvertTemp Web service operation.                    
           if (stub_op_ConvertTemp(WsStub:Input:Result) = *ON); 
              OutputText = Input.TEMPIN.value + ' Fahrenheit is '  
                         + Result.TEMPOUT.value + ' Celsius.'; 
           else;                                                    
              OutputText = WsStub.excString;                                      
           endif;                                                   
      
           // Display results.
           dsply  OutputText;    

           // Destroy Web service stubs.
           stub_destroy_ConvertTempPortType(WsStub);                      
         endif;
                                                     
         *INLR=*ON;                                                 
      /end-free  