/*
       IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2007, ALL RIGHTS RESERVED.
 */

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace BulkLoader
{
    //
    // Adds new functionality to the TreeNode class to
    // differentiate between the nodes representing Folder 
    // and Document objects in Content Engine Objectstore's TreeView.
    // It also differentiates between nodes representing Directories 
    // and files in file system's Tree view. Nodes representing Folder 
    // objects are allowed to have children while nodes representing 
    // Document objects are not. Similarly, nodes representing directories
    // are allowed to have children while nodes representing files are not.
    //
    class CustomTreeNode : TreeNode
    {
        private bool allowChildren;

        //
        // Constructor
        //
        public CustomTreeNode(string text, bool allowChild) : base(text)
        {
            allowChildren = allowChild;
        }

        //
        // Constructor
        //
        public CustomTreeNode(string text, int imageIndex, int selectedImageIndex, bool allowChild) 
            : base(text,imageIndex,selectedImageIndex)
        {
            allowChildren = allowChild;
        }

        //
        // Getter and setter for allowChildren property.
        //
        public bool AllowChildren
        {
            set
            {
                allowChildren = value;
            }
            get
            {
                return allowChildren;
            }
        }
    }
}
