/**
	IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2007, ALL RIGHTS RESERVED.
 */

package bulkloader;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

/**
 * This class extends the DefaultTreeCellRenderer class and overrides it's
 * getTreeCellRendererComponent method which allows us to specify custom
 * icons (in place of default icons) for nodes in a JTree. JTrees in the 
 * LoaderFrame uses this class to render nodes in the tree. 
 */
public class CustomCellRenderer extends DefaultTreeCellRenderer
{
	private static final long serialVersionUID = 1L;

	public Component getTreeCellRendererComponent(
			JTree tree,
			Object value,
			boolean sel,
			boolean expanded,
			boolean leaf,
			int row,
			boolean hasFocus) 
	{

		super.getTreeCellRendererComponent(
				tree, value, sel,
				expanded, leaf, row,
				hasFocus);
		DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
		ClassLoader cldr = this.getClass().getClassLoader();
		java.net.URL closeURL = cldr.getResource("folderclose.gif");
		java.net.URL openURL = cldr.getResource("folderopen.gif");
		java.net.URL fileURL = cldr.getResource("file.gif");
		if (closeURL != null && openURL != null && fileURL != null)
		{
			ImageIcon closeIcon = new ImageIcon(closeURL);
			ImageIcon openIcon = new ImageIcon(openURL);
			ImageIcon fileIcon = new ImageIcon(fileURL);
			if (!node.getAllowsChildren())
			{
				setIcon(fileIcon);
			}
			setLeafIcon(closeIcon);
			setOpenIcon(openIcon);
			setClosedIcon(closeIcon);
		}
		return this;
	}
}
