# Sample program 
#  * (C) COPYRIGHT International Business Machines Corp., 2010
#  * All Rights Reserved * Licensed Materials - Property of IBM
#  *
#  * This sample program is provided AS IS and may be used, executed,
#  * copied and modified without royalty payment by customer
#  *
#  * (a) for its own instruction and study,
#  * (b) in order to develop applications designed to run with an IBM
#  *     WebSphere product for the customer's own internal use.

# This script updates the runtime trace settings of all servers known
# to the wsadmin session where it runs.

# Default values for optional parameters
TRACE_FILE_COUNT=5
TRACE_FILE_SIZE_MB=50
TRACE_FILE_TYPE="basic"
TRACE_FILE_NAME="trace.log"

# First check the usage
if (len(sys.argv) < 1) :
  print "USAGE: ./wsadmin.sh -lang jython -f setTraceOnAllServers.py <TRACESETTING> [COUNT] [SIZE] [FORMAT] [FILENAME]\n";
  print "The defaults are as follows: COUNT="+str(TRACE_FILE_COUNT)+", SIZE="+str(TRACE_FILE_SIZE_MB)+", TYPE="+TRACE_FILE_TYPE+", FILENAME="+TRACE_FILE_NAME+"\n";
  sys.exit(1);
if (len(sys.argv) > 1) :
  TRACE_FILE_COUNT=int(sys.argv[1]);
if (len(sys.argv) > 2) :
  TRACE_FILE_SIZE_MB=int(sys.argv[2]);
if (len(sys.argv) > 3) :
  TRACE_FILE_TYPE=sys.argv[3];
if (len(sys.argv) > 4) :
  TRACE_FILE_NAME=sys.argv[4];
TRACE_SETTING=sys.argv[0];
print "Changing trace output for all servers to " + str(TRACE_FILE_COUNT) + "x" + str(TRACE_FILE_SIZE_MB) + "MB (" + TRACE_FILE_TYPE + ")";
print "Changing trace string for all servers to " + TRACE_SETTING;
import javax.management as mgmt;

# Now find all of the servers
serverLookup = AdminControl.makeObjectName("WebSphere:type=TraceService,*");
allServers = AdminControl.queryNames_jmx(serverLookup, None);
for server in allServers:
  # Check this is not a nodeagent or a deployment manager
  nodeName = server.getKeyProperty("node");
  if (nodeName == None): nodeName = "?";
  serverName = server.getKeyProperty("process");
  if (serverName != None and serverName != "nodeagent" and serverName != "dmgr"):
    try:
      print "Changing trace for server " + nodeName + '/' + serverName;

      # Change the trace string
      traceAttr = mgmt.Attribute("traceSpecification", TRACE_SETTING);
      AdminControl.setAttribute_jmx(server, traceAttr);

      # Change the trace output details
      method = "setTraceOutputToFile";
      sig = ["java.lang.String","int","int","java.lang.String"];
      parms = [];
      parms.append("trace.log");
      parms.append(java.lang.Integer(TRACE_FILE_SIZE_MB))
      parms.append(java.lang.Integer(TRACE_FILE_COUNT))
      parms.append(TRACE_FILE_TYPE)
      AdminControl.invoke_jmx(server, method, parms, sig);

    except:
      # Just print the error and continue to the next server
      print "*** Failed to change trace for server " + nodeName + '/' + serverName + " ***:";
      print sys.excepthook(sys.exc_info()[0],sys.exc_info()[1],sys.exc_info()[2]);
      print "*** Exception end ***";
