# Sample program 
#  * (C) COPYRIGHT International Business Machines Corp., 2010
#  * All Rights Reserved * Licensed Materials - Property of IBM
#  *
#  * This sample program is provided AS IS and may be used, executed,
#  * copied and modified without royalty payment by customer
#  *
#  * (a) for its own instruction and study,
#  * (b) in order to develop applications designed to run with an IBM
#  *     WebSphere product for the customer's own internal use.

# This script requests a javacore from every server in the environment

# Now find all of the servers
serverLookup = AdminControl.makeObjectName("WebSphere:type=JVM,*");
allServers = AdminControl.queryNames_jmx(serverLookup, None);
for server in allServers:
  # Check this is not a nodeagent or a deployment manager
  nodeName = server.getKeyProperty("node");
  if (nodeName == None): nodeName = "?";
  serverName = server.getKeyProperty("process");
  if (serverName != None and serverName != "nodeagent" and serverName != "dmgr"):
    try:
      print "Requesting javacore from server " + nodeName + '/' + serverName;
      AdminControl.invoke_jmx(server, "dumpThreads", [], []);

    except:
      # Just print the error and continue to the next server
      print "*** Failed to request javacore from " + nodeName + '/' + serverName + " ***:";
      print sys.excepthook(sys.exc_info()[0],sys.exc_info()[1],sys.exc_info()[2]);
      print "*** Exception end ***";
