# Sample program 
#  * (C) COPYRIGHT International Business Machines Corp., 2010
#  * All Rights Reserved * Licensed Materials - Property of IBM
#  *
#  * This sample program is provided AS IS and may be used, executed,
#  * copied and modified without royalty payment by customer
#  *
#  * (a) for its own instruction and study,
#  * (b) in order to develop applications designed to run with an IBM
#  *     WebSphere product for the customer's own internal use.

# Messages on all (local & remote) queue points
#Display details (inc. UUID and XID) of all messages on all local and remote queue points, for all MEs known to the wsadmin console.
#Warning: As is, this may be very slow to run if there are a large number of messages on a queue.
#Possible modifications include only listing the details of messages in LOCKED state, only listing the first X messages on the queue, or extending/reducing the msg details printed.

# Section for local queue points starts here
from time import ctime
objName = AdminControl.makeObjectName('WebSphere:type=SIBQueuePoint,*')
qps = AdminControl.queryNames_jmx(objName, None)
for qp in qps:
 name = qp.getKeyProperty("name")
 me = qp.getKeyProperty("SIBMessagingEngine");
 depth = AdminControl.getAttribute_jmx(qp, 'depth')
 state = AdminControl.getAttribute_jmx(qp, 'state')
 print "QUEUEPOINT("+name+") ME("+me+") DEPTH("+str(depth)+") STATE("+str(state)+")"
 # Stop here if you are only interested in queue depths
 parms = []
 signature = []
 qpmsgs = AdminControl.invoke_jmx(qp, 'getQueuedMessages', parms, signature)
 for msg in qpmsgs:
   try:	
    parms = [msg.getId()]
    signature = ['java.lang.String']
    msgDetail = AdminControl.invoke_jmx(qp, 'getQueuedMessageDetail', parms, signature)
    if msg.getTransactionId():
     xid = msg.getTransactionId()
    else:
     xid = ''
    print ' MSG_UUID('+msgDetail.getBusSystemMessageId()+') APPROXLEN('+str(msg.getApproximateLength())+') REL('+msgDetail.getBusReliability()+') TIME('+ctime(msgDetail.getJsTimestamp())[0:19]+') STATE('+msg.getState()+') XID('+xid+')'
   except:
    print ' MSG_ADMINID(' + msg.getId() + ') no longer on queue'

# Section for remote queue points starts here
from time import ctime
objName = AdminControl.makeObjectName('WebSphere:type=SIBRemoteQueuePoint,*')
rqps = AdminControl.queryNames_jmx(objName, None)
for rqp in rqps:
 name = qp.getKeyProperty("name")
 me = qp.getKeyProperty("SIBMessagingEngine");
 remoteMe = AdminControl.getAttribute_jmx(rqp, 'remoteMessagingEngineUuid')
 print "REMOTEQUEUEPOINT("+name+") ME("+me+") REMOTE_ME("+remoteMe+")"
 parms = []
 signature = []
 ot = AdminControl.invoke_jmx(rqp, 'getOutboundTransmitter', parms, signature)
 parms = [ot]
 signature = ['com.ibm.websphere.sib.admin.SIBOutboundTransmitter']
 streams = AdminControl.invoke_jmx(rqp, 'getStreams', parms, signature)
 for stream in streams:
  print " STREAM(" + stream.getStreamId() + ") STATE(" + stream.getState() + ") ACTIVEMSGS(" + str(stream.getActiveMessages()) + ")"
 # Stop here if only interested in depths
 parms = [ot,stream]
 signature = ['com.ibm.websphere.sib.admin.SIBOutboundTransmitter', 'com.ibm.websphere.sib.admin.SIBOutboundTransmitterStream']
 qpmsgs = AdminControl.invoke_jmx(rqp, 'listTransmitMessages', parms, signature)
 for msg in qpmsgs:
  try:
   parms = [ot, stream, msg.getId()]
   signature = ['com.ibm.websphere.sib.admin.SIBOutboundTransmitter', 'com.ibm.websphere.sib.admin.SIBOutboundTransmitterStream','java.lang.String']
   msgDetail = AdminControl.invoke_jmx(rqp, 'getTransmitMessageDetail', parms, signature)
   if msgDetail.getTransactionId():
    xid = msgDetail.getTransactionId()
   else:
    xid = ''
   print ' MSG_UUID('+msgDetail.getBusSystemMessageId()+') APPROXLEN('+str(msgDetail.getJsApproximateLength())+') REL('+msgDetail.getBusReliability()+') TIME('+ctime(msgDetail.getJsTimestamp())[0:19]+') STATE('+msg.getState()+') XID('+xid+')'
  except:
   print ' MSG_ADMINID(' + msg.getId() + ') no longer on queue'