# Sample program 
#  * (C) COPYRIGHT International Business Machines Corp., 2010
#  * All Rights Reserved * Licensed Materials - Property of IBM
#  *
#  * This sample program is provided AS IS and may be used, executed,
#  * copied and modified without royalty payment by customer
#  *
#  * (a) for its own instruction and study,
#  * (b) in order to develop applications designed to run with an IBM
#  *     WebSphere product for the customer's own internal use.

# This script displays the status of all the messaging engines
# Find the state of all MEs using MBeans
print "View using SIBus MBeans:"
objName = AdminControl.makeObjectName('WebSphere:type=SIBMessagingEngine,*')
mes = AdminControl.queryNames_jmx(objName, None)
for me in mes:
  name    = me.getKeyProperty("name")
  process = me.getKeyProperty("process")
  node    = me.getKeyProperty("node")
  state   = AdminControl.invoke_jmx(me, 'state', [], [])
  stateEx = AdminControl.invoke_jmx(me, 'stateExtended', [], [])
  print 'ME:' + name + ' Process:' + process +  ' node: ' + node + ' State: ' + state + '\n'

# Find the state of all MEs using HAManager
objName = AdminControl.makeObjectName('WebSphere:type=HAManager,*')
hams = AdminControl.queryNames_jmx(objName, None)
for ham in hams:
  coregroup = ham.getKeyProperty("coregroup")
  process   = ham.getKeyProperty("process")
  print "View of HAManager on " + process + " (coregroup:" + coregroup + "):"
  parms = ["type=WSAF_SIB", java.lang.Integer(-1), java.lang.Boolean("true")]
  sig   = ["java.lang.String", "java.lang.Integer", "java.lang.Boolean"]
  groups = AdminControl.invoke_jmx(ham, 'queryGroupState', parms, sig)
  for group in groups:
    meName = group.getGroupName().getGroupProperties().get("WSAF_SIB_MESSAGING_ENGINE")
    if meName != None:
      memberData = group.getMemberData()
      statusLine = "ME: " + meName
      for member in memberData:
        server = member.getServerName()
        state = member.getMemberState().toString()
        statusLine = statusLine + " " + server + "(" + state + ")"
      print statusLine 
  