/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import pGraph.Viewer;

public class ViewerApplet
extends JApplet {
    private static final long serialVersionUID = 2546257572763997509L;
    private Viewer viewer = null;
    private boolean single_host = false;
    private String[] files = null;
    private String base = null;
    private JButton jb = null;
    private ViewerApplet va = this;
    private MyEventHandler myEventHandler = null;

    private void startViewer() {
        this.viewer = new Viewer(this.va, this.single_host);
        this.viewer.createConsole();
        this.viewer.setSize(1007, 400);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.viewer.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.viewer.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public String[] getFiles() {
        return this.files;
    }

    public InputStream getInputStream(String file) {
        try {
            URL source = file.contains("://") ? new URL(file) : new URL(String.valueOf(this.base) + file);
            URLConnection uc = source.openConnection();
            InputStream is = uc.getInputStream();
            return is;
        }
        catch (Exception e) {
            System.out.println("Error opening connection: " + this.base + file);
            return null;
        }
    }

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
        this.base = this.getCodeBase().toString();
        String source = this.getParameter("FILES");
        String mode = this.getParameter("SINGLE_HOST");
        String label = this.getParameter("LABEL");
        if (source != null) {
            this.files = source.split(",");
            if (this.files.length == 1 || mode != null && mode.compareToIgnoreCase("true") == 0) {
                this.single_host = true;
            }
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ViewerApplet.this.startViewer();
                }
            });
        }
        catch (Exception e) {
            System.err.println("startViewer didn't successfully complete");
        }
        this.myEventHandler = new MyEventHandler();
        this.jb = new JButton();
        if (label == null) {
            this.jb.setText("Start");
        } else {
            this.jb.setText(label);
        }
        this.jb.setFocusPainted(false);
        this.jb.setFont(new Font("sansserif", 1, 12));
        this.jb.addActionListener(this.myEventHandler);
        this.add(this.jb);
    }

    public void start() {
    }

    public void stop() {
        if (this.viewer != null) {
            this.viewer.dispose();
            this.viewer = null;
        }
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"FILES", "URLs", "comma separated list of files"}, {"SINGLE_HOST", "boolean", "true when files belong to same host"}, {"LABEL", "String", "label inside applet's button"}};
        return info;
    }

    class MyEventHandler
    implements ActionListener {
        MyEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ViewerApplet.this.jb) {
                if (ViewerApplet.this.viewer.isVisible()) {
                    return;
                }
                ViewerApplet.this.viewer.setVisible(true);
                ViewerApplet.this.viewer.activateFromApplet();
            }
        }
    }
}

