/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pGraph.About;
import pGraph.AvgSumXYPanel;
import pGraph.CPUPerfPanel;
import pGraph.Console;
import pGraph.DataSet;
import pGraph.GenericFrame;
import pGraph.GenericPanel;
import pGraph.GlobalConfig;
import pGraph.Parser;
import pGraph.ParserManager;
import pGraph.Parser_Lslparutil;
import pGraph.PerfData;
import pGraph.StackPanel;
import pGraph.SumXYPanel;
import pGraph.TextFrame;
import pGraph.TimePanel;
import pGraph.ViewerApplet;
import pGraph.XYPanel;

public class Viewer
extends JFrame {
    private static final long serialVersionUID = -6031065953328192272L;
    private int PNGindex = 0;
    public static String version = "Version 2.5.17";
    private GlobalConfig configuration = new GlobalConfig("pGraph.properties");
    public static final int VIEWER_HEIGHT = 400;
    public static final int VIEWER_WIDTH = 1007;
    private JMenuItem exitMenuItem = null;
    private JMenuItem openMMDirMenu = null;
    private JMenuItem openSMDirMenu = null;
    private JMenuItem openFileMenu = null;
    private JMenuItem aboutMenu = null;
    private JMenuItem consoleMenu = null;
    private JMenuItem openCfgMenu = null;
    private About about = null;
    private Console console = null;
    private JPanel sliderPanel = null;
    private JPanel buttonPanel = null;
    private int FRAME_X;
    private int FRAME_Y;
    private JMenu fileMenu = null;
    private JMenuBar menuBar = null;
    private JFileChooser openFileDialog = null;
    private JButton zoomButton = null;
    private TimePanel timePanel = null;
    private JLabel message = null;
    private JCheckBox noDisks = null;
    private JToggleButton[] button = null;
    private final byte CPU = 0;
    private final byte RAM = 1;
    private final byte DISKBUSY = (byte)2;
    private final byte DISKRW = (byte)3;
    private final byte DISKXFER = (byte)4;
    private final byte DISKBLOCK = (byte)5;
    private final byte ESSRW = (byte)6;
    private final byte ESSXFER = (byte)7;
    private final byte ADAPTERRW = (byte)8;
    private final byte ADAPTERXFER = (byte)9;
    private final byte NETWORKRW = (byte)10;
    private final byte CHECKER = (byte)11;
    private final byte KERNEL = (byte)12;
    private final byte SYSCALL = (byte)13;
    private final byte RSERVICE = (byte)14;
    private final byte WSERVICE = (byte)15;
    private final byte RWTO = (byte)16;
    private final byte RWFAIL = (byte)17;
    private final byte WQTIME = (byte)18;
    private final byte QSIZE = (byte)19;
    private final byte SQFULL = (byte)20;
    private final byte ADRSERVICE = (byte)21;
    private final byte ADWSERVICE = (byte)22;
    private final byte ADWQTIME = (byte)23;
    private final byte ADQSIZE = (byte)24;
    private final byte ADSQFULL = (byte)25;
    private final byte WPAR_CPU = (byte)26;
    private final byte WPAR_MEM = (byte)27;
    private final byte WPAR_DISK = (byte)28;
    private final byte TOPCPU = (byte)29;
    private final byte TOPRAM = (byte)30;
    private final byte FS = (byte)31;
    private final byte AIO = (byte)32;
    private final byte FCRW = (byte)33;
    private final byte FCXFER = (byte)34;
    private final byte DACRW = (byte)35;
    private final byte DACXFER = (byte)36;
    private final byte DSKSERVICE = (byte)37;
    private final byte DSKWAIT = (byte)38;
    private final byte ESSSERVICE = (byte)39;
    private final byte ESSWAIT = (byte)40;
    private final byte ESSBUSY = (byte)41;
    private final byte PROCPOOL = (byte)42;
    private final byte RWSERVICE = (byte)43;
    private final byte SEA = (byte)44;
    private final byte PCPU = (byte)45;
    private final byte MEMDETAILS = (byte)46;
    private final byte BUTTONS = (byte)47;
    private GenericFrame[] perfFrame = new GenericFrame[47];
    private JToggleButton[] textButton = null;
    private final byte T_LSSRAD = 0;
    private final byte T_LPARSTATI = 1;
    private final byte T_VMSTATV = (byte)2;
    private final byte T_BUTTONS = (byte)3;
    private TextFrame[] textFrame = new TextFrame[3];
    private Parser parser = null;
    private JProgressBar progressBar = new JProgressBar();
    private ParserManager parserManager = new ParserManager(this, this.configuration);
    private boolean batchMode = false;
    private String batchOutput = null;
    private GregorianCalendar batchBegin = null;
    private GregorianCalendar batchEnd = null;
    protected ViewerApplet applet = null;
    private byte appletMode = 0;
    private static final byte NO_APPLET = 0;
    private static final byte SINGLE_FILE = 1;
    private static final byte MULTIPLE_FILES_SINGLE_HOST = 2;
    private static final byte MULTIPLE_FILES_MULTIPLE_HOSTS = 3;
    private static final byte LOCAL_FILESYSTEM = 4;
    private MyEventHandler myEventHandler = null;

    public Viewer() {
        this.setup();
    }

    public Viewer(ViewerApplet applet, boolean single_host) {
        this.applet = applet;
        String[] files = applet.getFiles();
        this.appletMode = files == null ? (byte)4 : (files.length == 1 ? (byte)1 : (single_host ? (byte)2 : (byte)3));
        this.setup();
    }

    public void activateFromApplet() {
        if (this.applet == null) {
            return;
        }
        if (this.appletMode == 4) {
            return;
        }
        this.closeAllFrames();
        this.parser = null;
        this.activateButtons();
        this.parserManager.setSource(null);
        this.parserManager.setApplet(this.applet);
        if (this.appletMode == 1 || this.appletMode == 2) {
            this.parserManager.setSingleHost(true);
        } else {
            this.parserManager.setSingleHost(false);
        }
        Thread th = new Thread(this.parserManager);
        th.start();
    }

    public void createConsole() {
        this.console = new Console();
        this.console.setVisible(false);
    }

    private void setup() {
        this.myEventHandler = new MyEventHandler();
        this.exitMenuItem = new JMenuItem();
        this.exitMenuItem.setName("ExitMenuItem");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(this.myEventHandler);
        this.openFileMenu = new JMenuItem();
        this.openFileMenu.setName("OpenSingleFile");
        this.openFileMenu.setText("Single file");
        this.openFileMenu.addActionListener(this.myEventHandler);
        this.openMMDirMenu = new JMenuItem();
        this.openMMDirMenu.setName("OpenMMDirMenu");
        this.openMMDirMenu.setText("Directory: MULTIPLE hosts, multiple files");
        this.openMMDirMenu.addActionListener(this.myEventHandler);
        this.openSMDirMenu = new JMenuItem();
        this.openSMDirMenu.setName("OpenSMDirMenu");
        this.openSMDirMenu.setText("Directory: SINGLE host, multiple files");
        this.openSMDirMenu.addActionListener(this.myEventHandler);
        this.openCfgMenu = new JMenuItem();
        this.openCfgMenu.setName("openCfgMenu");
        this.openCfgMenu.setText("Configuration file");
        this.openCfgMenu.addActionListener(this.myEventHandler);
        this.fileMenu = new JMenu();
        this.fileMenu.setName("FileMenu");
        this.fileMenu.setText("File");
        if (this.appletMode == 0) {
            this.fileMenu.add(this.openFileMenu);
            this.fileMenu.add(this.openMMDirMenu);
            this.fileMenu.add(this.openSMDirMenu);
            this.fileMenu.add(this.openCfgMenu);
        }
        this.fileMenu.add(this.exitMenuItem);
        this.aboutMenu = new JMenuItem();
        this.aboutMenu.setName("AboutMenuItem");
        this.aboutMenu.setText("About");
        this.aboutMenu.addActionListener(this.myEventHandler);
        this.consoleMenu = new JMenuItem();
        this.consoleMenu.setName("ConsoleMenuItem");
        this.consoleMenu.setText("Console");
        this.consoleMenu.addActionListener(this.myEventHandler);
        JMenu help = new JMenu();
        help.setName("HelpMenu");
        help.setText("Help");
        help.add(this.consoleMenu);
        help.add(this.aboutMenu);
        this.menuBar = new JMenuBar();
        this.menuBar.setName("ControlCenterJMenuBar");
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(help);
        this.openFileDialog = new JFileChooser();
        this.openFileDialog.setName("OpenFile");
        this.openFileDialog.addComponentListener(this.myEventHandler);
        this.openFileDialog.setCurrentDirectory(this.configuration.getWorkingDirectory());
        this.sliderPanel = new JPanel();
        this.sliderPanel.setBorder(new EtchedBorder());
        this.sliderPanel.setLayout(new BorderLayout());
        this.zoomButton = new JButton();
        this.zoomButton.setFocusPainted(false);
        this.zoomButton.setFont(this.configuration.getButtonFont());
        this.zoomButton.setMargin(new Insets(2, 10, 2, 10));
        this.zoomButton.setText("Zoom");
        this.zoomButton.setHorizontalTextPosition(0);
        this.zoomButton.setHorizontalAlignment(0);
        this.zoomButton.addActionListener(this.myEventHandler);
        this.timePanel = new TimePanel();
        this.sliderPanel = new JPanel();
        this.sliderPanel.setBorder(new EtchedBorder());
        this.sliderPanel.setLayout(new BorderLayout());
        this.sliderPanel.add((Component)this.zoomButton, "West");
        this.sliderPanel.add((Component)this.timePanel, "Center");
        TitledBorder tb = new TitledBorder("Time Selection");
        this.sliderPanel.setBorder(tb);
        this.message = new JLabel();
        this.message.setText("No performance file selected.");
        this.message.setBorder(new EtchedBorder());
        this.noDisks = new JCheckBox("No disk data");
        this.noDisks.setFocusPainted(false);
        this.noDisks.addItemListener(this.myEventHandler);
        this.noDisks.setFont(this.configuration.getButtonFont());
        this.button = new JToggleButton[47];
        int i = 0;
        while (i < 47) {
            this.button[i] = new JToggleButton();
            this.button[i].setFocusPainted(false);
            this.button[i].setFont(this.configuration.getButtonFont());
            this.button[i].setMargin(new Insets(2, 10, 2, 10));
            this.button[i].addItemListener(this.myEventHandler);
            ++i;
        }
        this.button[0].setToolTipText("Show CPU usage");
        this.button[0].setText("CPU");
        this.button[45].setToolTipText("Show per CPU physical usage");
        this.button[45].setText("PCPU");
        this.button[46].setToolTipText("Show data based on page size");
        this.button[46].setText("Page size");
        this.button[1].setToolTipText("Show memory usage");
        this.button[1].setText("Memory");
        this.button[2].setToolTipText("Show disk busy statistics");
        this.button[2].setText("Disk Busy");
        this.button[41].setToolTipText("Show MPIO device busy statistics");
        this.button[41].setText("MPIO Busy");
        this.button[42].setToolTipText("Show Shared ProcPool statistics");
        this.button[42].setText("Proc Pool");
        this.button[3].setToolTipText("Show disk RW statistics");
        this.button[3].setText("Disk RW");
        this.button[4].setToolTipText("Show disk Xfer statistics");
        this.button[4].setText("Disk Xfer");
        this.button[5].setToolTipText("Show disk block statistics");
        this.button[5].setText("Disk Block");
        this.button[6].setToolTipText("Show MPIO RW statistics");
        this.button[6].setText("MPIO RW");
        this.button[7].setToolTipText("Show MPIO Xfer statistics");
        this.button[7].setText("MPIO Xfer");
        this.button[8].setToolTipText("Show Disk Adapter RW statistics");
        this.button[8].setText("Dsk I/O RW");
        this.button[9].setToolTipText("Show Disk Adapter Xfer statistics");
        this.button[9].setText("Dsk I/O Xfer");
        this.button[33].setToolTipText("Show Fibre Channel RW statistics");
        this.button[33].setText("FC RW");
        this.button[34].setToolTipText("Show Fibre Channel Xfer statistics");
        this.button[34].setText("FC I/O Xfer");
        this.button[35].setToolTipText("Show dac RW statistics");
        this.button[35].setText("Dac RW");
        this.button[36].setToolTipText("Show dac Xfer statistics");
        this.button[36].setText("Dac Xfer");
        this.button[10].setToolTipText("Show Network RW statistics");
        this.button[10].setText("Net RW");
        this.button[44].setToolTipText("Show SEA statistics");
        this.button[44].setText("SEA");
        this.button[12].setToolTipText("Show kernel data");
        this.button[12].setText("Kernel");
        this.button[13].setToolTipText("Show system calls");
        this.button[13].setText("SysCall");
        this.button[11].setToolTipText("Search data patterns");
        this.button[11].setText("Checker");
        this.button[14].setToolTipText("Show disk read service statistics");
        this.button[14].setText("Dsk RServ");
        this.button[15].setToolTipText("Show disk write service statistics");
        this.button[15].setText("Dsk WServ");
        this.button[43].setToolTipText("Show disk read+write service statistics");
        this.button[43].setText("Dsk RWServ");
        this.button[37].setToolTipText("Show disk service statistics");
        this.button[37].setText("Dsk Serv");
        this.button[39].setToolTipText("Show MPIO service statistics");
        this.button[39].setText("MPIO Serv");
        this.button[38].setToolTipText("Show disk wait statistics");
        this.button[38].setText("Dsk Wait");
        this.button[40].setToolTipText("Show MPIO wait statistics");
        this.button[40].setText("MPIO Wait");
        this.button[16].setToolTipText("Show disk RW timeout statistics");
        this.button[16].setText("Dsk RW TO");
        this.button[17].setToolTipText("Show disk RW failures statistics");
        this.button[17].setText("Dsk RW Fails");
        this.button[18].setToolTipText("Show disk Wait Queue Time statistics");
        this.button[18].setText("Dsk WaitQ T");
        this.button[19].setToolTipText("Show disk Queue Size statistics");
        this.button[19].setText("Dsk Queues");
        this.button[20].setToolTipText("Show disk Full Service Queue statistics");
        this.button[20].setText("Dsk SQ Full");
        this.button[21].setToolTipText("Show adapter read service statistics");
        this.button[21].setText("I/O RServ");
        this.button[22].setToolTipText("Show adapter write service statistics");
        this.button[22].setText("I/O WServ");
        this.button[23].setToolTipText("Show adapter wait queue statistics");
        this.button[23].setText("I/O WaitQ");
        this.button[24].setToolTipText("Show adapter queue size statistics");
        this.button[24].setText("I/O Queues");
        this.button[25].setToolTipText("Show adapter service queue full statistics");
        this.button[25].setText("I/O SrvQ Full");
        this.button[26].setToolTipText("Show WLM/WPAR CPU statistics");
        this.button[26].setText("WLM CPU");
        this.button[27].setToolTipText("Show WLM/WPAR Memory statistics");
        this.button[27].setText("WLM RAM");
        this.button[28].setToolTipText("Show WLM/WPAR Disk statistics");
        this.button[28].setText("WLM Disk");
        this.button[29].setToolTipText("Show top CPU processes");
        this.button[29].setText("Top CPU");
        this.button[30].setToolTipText("Show top Memory processes");
        this.button[30].setText("Top Mem");
        this.button[31].setToolTipText("Show file system statistics");
        this.button[31].setText("FileSystem");
        this.button[32].setToolTipText("Show Asynchronous I/O statistics");
        this.button[32].setText("Async IO");
        this.textButton = new JToggleButton[3];
        i = 0;
        while (i < 3) {
            this.textButton[i] = new JToggleButton();
            this.textButton[i].setFocusPainted(false);
            this.textButton[i].setFont(this.configuration.getButtonFont());
            this.textButton[i].setMargin(new Insets(2, 10, 2, 10));
            this.textButton[i].addItemListener(this.myEventHandler);
            ++i;
        }
        this.textButton[0].setToolTipText("Show cpu/memory affinity");
        this.textButton[0].setText("Affinity");
        this.textButton[1].setToolTipText("Lpar configuration");
        this.textButton[1].setText("LPAR CFG");
        this.textButton[2].setToolTipText("vmstat -v output");
        this.textButton[2].setText("vmstat -v");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(null);
        JPanel viewerContent = new JPanel();
        viewerContent.setLayout(new BorderLayout());
        viewerContent.add((Component)this.sliderPanel, "North");
        viewerContent.add((Component)this.buttonPanel, "Center");
        JPanel jpa2 = new JPanel();
        jpa2.setLayout(new BorderLayout());
        jpa2.add((Component)this.message, "West");
        jpa2.add((Component)this.noDisks, "East");
        JPanel jpa = new JPanel();
        jpa.setLayout(new BorderLayout());
        jpa.add((Component)jpa2, "North");
        jpa.add((Component)this.progressBar, "South");
        viewerContent.add((Component)jpa, "South");
        this.setContentPane(viewerContent);
        this.activateButtons();
        this.setName("pGraph Viewer");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.myEventHandler);
        this.setJMenuBar(this.menuBar);
        this.setResizable(true);
        this.setTitle("pGraph Viewer");
        this.progressBar.setValue(0);
    }

    private void activateButtons() {
        this.buttonPanel.removeAll();
        switch (this.parserManager.getFiletype()) {
            case 0: {
                break;
            }
            case 14: {
                this.addButton((byte)0, 0, 0);
                break;
            }
            case 12: {
                this.addButton((byte)0, 0, 0);
                break;
            }
            case 13: {
                this.addButton((byte)0, 0, 0);
                this.addButton((byte)1, 1, 0);
                this.addButton((byte)3, 2, 0);
                this.addButton((byte)10, 3, 0);
                break;
            }
            case 11: {
                this.addButton((byte)0, 0, 0);
                this.addButton((byte)2, 1, 0);
                this.addButton((byte)12, 2, 0);
                this.addButton((byte)13, 2, 1);
                break;
            }
            case 1: {
                this.addButton((byte)0, 0, 0);
                this.addButton((byte)45, 0, 1);
                this.addTButton((byte)0, 0, 2);
                this.addTButton((byte)1, 0, 3);
                this.addButton((byte)1, 1, 0);
                this.addTButton((byte)2, 1, 1);
                this.addButton((byte)46, 1, 2);
                this.addButton((byte)2, 2, 0);
                this.addButton((byte)3, 2, 1);
                this.addButton((byte)4, 2, 2);
                this.addButton((byte)5, 2, 3);
                this.addButton((byte)37, 2, 4);
                this.addButton((byte)38, 2, 5);
                this.addButton((byte)14, 2, 6);
                this.addButton((byte)15, 2, 7);
                this.addButton((byte)43, 2, 8);
                this.addButton((byte)6, 3, 0);
                this.addButton((byte)7, 3, 1);
                this.addButton((byte)39, 3, 2);
                this.addButton((byte)40, 3, 3);
                this.addButton((byte)35, 3, 4);
                this.addButton((byte)36, 3, 5);
                this.addButton((byte)8, 4, 0);
                this.addButton((byte)9, 4, 1);
                this.addButton((byte)33, 4, 2);
                this.addButton((byte)34, 4, 3);
                this.addButton((byte)10, 5, 0);
                this.addButton((byte)44, 5, 1);
                this.addButton((byte)12, 6, 0);
                this.addButton((byte)13, 6, 1);
                this.addButton((byte)32, 6, 2);
                this.addButton((byte)29, 7, 0);
                this.addButton((byte)30, 7, 1);
                this.addButton((byte)26, 8, 0);
                this.addButton((byte)27, 8, 1);
                this.addButton((byte)28, 8, 2);
                this.addButton((byte)31, 9, 0);
                break;
            }
            case 2: {
                this.addButton((byte)0, 0, 0);
                this.addButton((byte)1, 1, 0);
                this.addButton((byte)12, 2, 0);
                this.addButton((byte)13, 2, 1);
                break;
            }
            case 3: {
                this.addButton((byte)0, 0, 0);
                this.addButton((byte)1, 1, 0);
                this.addButton((byte)8, 2, 0);
                this.addButton((byte)10, 3, 0);
                break;
            }
            case 10: {
                this.addButton((byte)0, 0, 0);
                this.addButton((byte)1, 1, 0);
                this.addButton((byte)8, 2, 0);
                this.addButton((byte)10, 3, 0);
                break;
            }
            case 6: {
                this.addButton((byte)0, 0, 0);
                this.addButton((byte)1, 1, 0);
                this.addButton((byte)2, 2, 0);
                this.addButton((byte)3, 2, 1);
                this.addButton((byte)4, 2, 2);
                this.addButton((byte)37, 2, 3);
                this.addButton((byte)38, 2, 4);
                this.addButton((byte)6, 3, 0);
                this.addButton((byte)7, 3, 1);
                this.addButton((byte)39, 3, 2);
                this.addButton((byte)40, 3, 3);
                this.addButton((byte)35, 3, 4);
                this.addButton((byte)36, 3, 5);
                this.addButton((byte)10, 4, 0);
                this.addButton((byte)12, 5, 0);
                this.addButton((byte)13, 5, 1);
                this.addButton((byte)26, 6, 0);
                this.addButton((byte)27, 6, 1);
                this.addButton((byte)28, 6, 2);
                this.addButton((byte)31, 7, 0);
                break;
            }
            case 7: {
                this.addButton((byte)0, 0, 0);
                break;
            }
            case 8: {
                this.addButton((byte)2, 0, 0);
                this.addButton((byte)3, 0, 1);
                this.addButton((byte)4, 0, 2);
                this.addButton((byte)41, 0, 3);
                this.addButton((byte)6, 0, 4);
                this.addButton((byte)7, 0, 5);
                this.addButton((byte)14, 1, 0);
                this.addButton((byte)15, 1, 1);
                this.addButton((byte)43, 1, 2);
                this.addButton((byte)16, 2, 0);
                this.addButton((byte)17, 2, 1);
                this.addButton((byte)18, 3, 0);
                this.addButton((byte)19, 3, 1);
                this.addButton((byte)20, 3, 2);
                this.addButton((byte)8, 4, 0);
                this.addButton((byte)9, 4, 1);
                this.addButton((byte)21, 5, 0);
                this.addButton((byte)22, 5, 1);
                this.addButton((byte)23, 6, 0);
                this.addButton((byte)24, 6, 1);
                this.addButton((byte)25, 6, 2);
                break;
            }
            case 9: {
                this.addButton((byte)0, 0, 0);
                this.addButton((byte)42, 0, 1);
                this.addButton((byte)1, 1, 0);
                break;
            }
        }
        this.validate();
        this.repaint();
    }

    private void addButton(byte id, int x, int y) {
        this.button[id].setBounds(x * 100, y * 24, 98, 22);
        this.buttonPanel.add(this.button[id]);
    }

    private void addTButton(byte id, int x, int y) {
        this.textButton[id].setBounds(x * 100, y * 24, 98, 22);
        this.buttonPanel.add(this.textButton[id]);
    }

    private static GregorianCalendar getGC(String string) {
        int s;
        int m;
        int h;
        int D;
        int M;
        int Y;
        if (string.length() != "YYYYMMDDhhmmss".length()) {
            return null;
        }
        try {
            Y = Integer.parseInt(string.substring(0, 4), 10);
            M = Integer.parseInt(string.substring(4, 6), 10);
            D = Integer.parseInt(string.substring(6, 8), 10);
            h = Integer.parseInt(string.substring(8, 10), 10);
            m = Integer.parseInt(string.substring(10, 12), 10);
            s = Integer.parseInt(string.substring(12), 10);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new GregorianCalendar(Y, M - 1, D, h, m, s);
    }

    private static void usage_exit() {
        System.out.println("");
        System.out.println("pGraph.Viewer - " + version);
        System.out.println("Interactive Usage: pGraph.Viewer [file]");
        System.out.println("Batch Usage:       pGraph.Viewer [ -l begin end ] [ -d | -D ] <source> <output dir>");
        System.out.println("\t-l limits time frame: begin and end in YYYYMMDDhhmmss format.");
        System.out.println("\t-d source=directory : multiple hosts in multiple source files.");
        System.out.println("\t-D source=directory : single host with multiple source files.");
        System.out.println("\t<source> is by default a file. Use -d or -D to select a directory.");
        System.out.println("\t\tValid input files are: \"nmon\", \"vmstat -t\",");
        System.out.println("\t\t\"topasout <xmtrend file>\", \"topasout <topas_cec>\",");
        System.out.println("\t\t\"iostat -alDT\", \"lslparutil\"");
        System.out.println("\t<output dir> is where system usage reports in PNG format are written.");
        System.out.println("");
        System.exit(2);
    }

    private static String[] parse_args(String[] args) {
        if (args.length != 2 && args.length != 3 && args.length != 5 && args.length != 6) {
            Viewer.usage_exit();
        }
        String[] result = new String[5];
        int i = 0;
        while (i < result.length) {
            result[i] = null;
            ++i;
        }
        switch (args.length) {
            case 2: {
                result[2] = "FILE";
                result[3] = args[0];
                result[4] = args[1];
                break;
            }
            case 3: {
                if (args[0].equals("-d")) {
                    result[2] = "DIRMH";
                } else if (args[0].equals("-D")) {
                    result[2] = "DIRSH";
                } else {
                    Viewer.usage_exit();
                }
                result[3] = args[1];
                result[4] = args[2];
                break;
            }
            case 5: {
                if (!args[0].equals("-l")) {
                    Viewer.usage_exit();
                }
                result[0] = args[1];
                result[1] = args[2];
                result[2] = "FILE";
                result[3] = args[3];
                result[4] = args[4];
                break;
            }
            case 6: {
                if (!args[0].equals("-l")) {
                    Viewer.usage_exit();
                }
                if (args[3].equals("-d")) {
                    result[2] = "DIRMH";
                } else if (args[3].equals("-D")) {
                    result[2] = "DIRSH";
                } else {
                    Viewer.usage_exit();
                }
                result[0] = args[1];
                result[1] = args[2];
                result[3] = args[4];
                result[4] = args[5];
                break;
            }
            default: {
                Viewer.usage_exit();
            }
        }
        if (result[2] == null || !result[2].equals("FILE") && !result[2].equals("DIRMH") && !result[2].equals("DIRSH")) {
            Viewer.usage_exit();
        }
        return result;
    }

    private static void goInteractive(String fileName) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Viewer viewer = new Viewer();
            viewer.setSize(1007, 400);
            viewer.setPreferredSize(new Dimension(1007, 400));
            viewer.createConsole();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = viewer.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            viewer.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            viewer.pack();
            viewer.setVisible(true);
            if (fileName != null) {
                File file = new File(fileName);
                if (file.exists() && file.isFile() && file.canRead()) {
                    viewer.loadSingleFile(file);
                } else {
                    System.out.println("Cannot load " + fileName);
                }
            }
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of Viewer");
            exception.printStackTrace(System.out);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Viewer.goInteractive(null);
        } else if (args.length == 1 && !args[0].equalsIgnoreCase("-h") && !args[0].equalsIgnoreCase("-?")) {
            Viewer.goInteractive(args[0]);
        } else {
            Viewer.goBatch(args);
        }
    }

    private static void goBatch(String[] args) {
        String[] params = Viewer.parse_args(args);
        File file = new File(params[3]);
        File dir = new File(params[4]);
        if (!file.exists() || !file.canRead() || params[2].equals("FILE") && !file.isFile() || !params[2].equals("FILE") && !file.isDirectory()) {
            System.out.println("ERROR: " + params[3] + " is an invalid file or directory");
            System.exit(2);
        }
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                System.out.println("ERROR: " + params[4] + " exists and it is not a directory");
                System.exit(2);
            }
        } else if (!dir.mkdirs()) {
            System.out.println("ERROR: cannot create directory " + params[4]);
            System.exit(2);
        }
        Viewer viewer = null;
        try {
            viewer = new Viewer();
        }
        catch (HeadlessException e) {
            System.out.println("ERROR: A graphical environment is required.");
            System.exit(2);
        }
        viewer.setBatchMode(dir.getPath());
        if (params[0] != null && params[1] != null) {
            GregorianCalendar begin = Viewer.getGC(params[0]);
            GregorianCalendar end = Viewer.getGC(params[1]);
            if (begin == null || end == null) {
                System.out.println("ERROR: cannot parse limits.");
                System.exit(2);
            }
            if (end.before(begin)) {
                System.out.println("ERROR: end label can not be before begin label");
                System.exit(2);
            }
            viewer.setNewLimits(begin, end);
        }
        if (params[2].equals("FILE")) {
            viewer.loadSingleFile(file);
        } else if (params[2].equals("DIRMH")) {
            viewer.loadCECDirectory(file);
        } else if (params[2].equals("DIRSH")) {
            viewer.loadMultipleFilesSingleHost(file);
        } else {
            System.out.println("ERROR: internal error");
            System.exit(2);
        }
    }

    private void setNewLimits(GregorianCalendar begin, GregorianCalendar end) {
        this.batchBegin = begin;
        this.batchEnd = end;
    }

    private void createPNG(GenericPanel p, String s) {
        if (p == null || s == null) {
            return;
        }
        int height = this.configuration.getPanelHeight();
        p.setSize(new Dimension(DataSet.SLOTS, height));
        p.setOpaque(true);
        p.setDoubleBuffered(false);
        File file = new File(s);
        BufferedImage bi = new BufferedImage(DataSet.SLOTS + this.configuration.getTextareaWidth(), this.configuration.getPanelHeight(), 2);
        Graphics2D g2d = bi.createGraphics();
        p.validate();
        p.printAll(g2d);
        try {
            ImageIO.write((RenderedImage)bi, "png", file);
        }
        catch (IOException e) {
            System.out.println("ERROR: could not create file " + file);
            e.printStackTrace();
            return;
        }
        System.out.print(".");
    }

    private void publishPanel(GenericFrame gf, PrintWriter html, String dir, GenericPanel panel, String description) {
        if (gf != null) {
            gf.addGraph(panel, description);
        }
        if (dir != null && !(panel instanceof SumXYPanel)) {
            this.createPNG(panel, String.valueOf(dir) + File.separatorChar + this.PNGindex + ".png");
            html.println("<H2>" + description + "</H2>\n");
            html.println("<IMG SRC=" + this.PNGindex + ".png><BR>\n");
            ++this.PNGindex;
        }
    }

    private void addSeparator(GenericFrame gf, PrintWriter html, String string) {
        if (html == null) {
            gf.addSeparator(string);
        } else {
            html.println("<H2><CENTER>" + string + "</CENTER></H2>\n");
        }
    }

    private int numElementsNotNull(DataSet[] ds) {
        if (ds == null) {
            return 0;
        }
        int i = 0;
        int num = 0;
        while (i < ds.length) {
            if (ds[i] != null) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    private int setupWPAR_CPU_Graphic(String dir) {
        int j;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 26);
        GenericPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)6);
        if (names == null) {
            return panels;
        }
        int MAX = 64;
        int[] wlmclass = new int[64];
        int[][] wlmsubclass = new int[64][64];
        int i = 0;
        while (i < 64) {
            wlmclass[i] = -1;
            j = 0;
            while (j < 64) {
                wlmsubclass[i][j] = -1;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < names.length) {
            String[] s = names[i].split("\\.", 2);
            if (s.length == 1) {
                j = 0;
                while (wlmclass[j] >= 0) {
                    ++j;
                }
                wlmclass[j] = i;
            } else {
                j = 0;
                while (s[0].compareTo(names[wlmclass[j]]) != 0) {
                    ++j;
                }
                int k = 0;
                while (wlmsubclass[j][k] >= 0) {
                    ++k;
                }
                wlmsubclass[j][k] = i;
            }
            ++i;
        }
        int numclasses = 0;
        int numsubclasses = 0;
        while (wlmclass[numclasses] >= 0) {
            ++numclasses;
        }
        this.addSeparator(this.perfFrame[26], html, "Global CPU%");
        ds = new DataSet[numclasses];
        i = 0;
        while (i < numclasses) {
            ds[i] = pd.getData((byte)6, wlmclass[i], (byte)0);
            ++i;
        }
        String[] newNames = new String[numclasses];
        i = 0;
        while (i < numclasses) {
            newNames[i] = names[wlmclass[i]];
            ++i;
        }
        panel = new StackPanel(this.configuration);
        ((StackPanel)panel).setData(pd, ds, newNames);
        ((StackPanel)panel).setMaxData(100.0f);
        this.publishPanel(this.perfFrame[26], html, dir, panel, "Global CPU% Usage");
        ++panels;
        i = 0;
        while (i < numclasses) {
            ds = new DataSet[]{pd.getData((byte)6, wlmclass[i], (byte)0)};
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[26], html, dir, panel, String.valueOf(newNames[i]) + "-CPU%");
            ++panels;
            ++i;
        }
        i = 0;
        while (i < numclasses) {
            if (wlmsubclass[i][0] != -1) {
                numsubclasses = 0;
                while (wlmsubclass[i][numsubclasses] >= 0) {
                    ++numsubclasses;
                }
                this.addSeparator(this.perfFrame[26], html, "Class " + names[wlmclass[i]] + " CPU%");
                ds = new DataSet[numsubclasses];
                j = 0;
                while (j < numsubclasses) {
                    ds[j] = pd.getData((byte)6, wlmsubclass[i][j], (byte)0);
                    ++j;
                }
                newNames = new String[numsubclasses];
                j = 0;
                while (j < numsubclasses) {
                    newNames[j] = names[wlmsubclass[i][j]];
                    ++j;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, ds, newNames);
                ((StackPanel)panel).setMaxData(100.0f);
                this.publishPanel(this.perfFrame[26], html, dir, panel, "Class " + names[wlmclass[i]] + " CPU Usage");
                ++panels;
                j = 0;
                while (j < numsubclasses) {
                    ds = new DataSet[]{pd.getData((byte)6, wlmsubclass[i][j], (byte)0)};
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd, ds);
                    this.publishPanel(this.perfFrame[26], html, dir, panel, String.valueOf(newNames[j]) + "-CPU%");
                    ++panels;
                    ++j;
                }
            }
            ++i;
        }
        if (pd.getData((byte)6, 0, (byte)3) != null && pd.getData((byte)0, 0, (byte)0) != null) {
            this.addSeparator(this.perfFrame[26], html, "Global Proc");
            ds = new DataSet[numclasses];
            i = 0;
            while (i < numclasses) {
                ds[i] = pd.getData((byte)6, wlmclass[i], (byte)3);
                ++i;
            }
            newNames = new String[numclasses];
            i = 0;
            while (i < numclasses) {
                newNames[i] = names[wlmclass[i]];
                ++i;
            }
            panel = new StackPanel(this.configuration);
            ((StackPanel)panel).setData(pd, ds, newNames);
            ((StackPanel)panel).setMaxData(pd.getData((byte)0, 0, (byte)0));
            this.publishPanel(this.perfFrame[26], html, dir, panel, "Global Proc Consumed");
            ++panels;
            i = 0;
            while (i < numclasses) {
                ds = new DataSet[]{pd.getData((byte)6, wlmclass[i], (byte)3)};
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[26], html, dir, panel, String.valueOf(newNames[i]) + "-PC");
                ++panels;
                ++i;
            }
            i = 0;
            while (i < numclasses) {
                if (wlmsubclass[i][0] != -1) {
                    numsubclasses = 0;
                    while (wlmsubclass[i][numsubclasses] >= 0) {
                        ++numsubclasses;
                    }
                    this.addSeparator(this.perfFrame[26], html, "Class " + names[wlmclass[i]] + " Proc");
                    ds = new DataSet[numsubclasses];
                    j = 0;
                    while (j < numsubclasses) {
                        ds[j] = pd.getData((byte)6, wlmsubclass[i][j], (byte)3);
                        ++j;
                    }
                    newNames = new String[numsubclasses];
                    j = 0;
                    while (j < numsubclasses) {
                        newNames[j] = names[wlmsubclass[i][j]];
                        ++j;
                    }
                    panel = new StackPanel(this.configuration);
                    ((StackPanel)panel).setData(pd, ds, newNames);
                    ((StackPanel)panel).setMaxData(pd.getData((byte)6, wlmclass[i], (byte)3));
                    this.publishPanel(this.perfFrame[26], html, dir, panel, "Class " + names[wlmclass[i]] + " Proc Consumed");
                    ++panels;
                    j = 0;
                    while (j < numsubclasses) {
                        ds = new DataSet[]{pd.getData((byte)6, wlmsubclass[i][j], (byte)3)};
                        panel = new XYPanel(this.configuration);
                        panel.setData(pd, ds);
                        this.publishPanel(this.perfFrame[26], html, dir, panel, String.valueOf(newNames[j]) + "-PC");
                        ++panels;
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.finishFrame(dir, 26, html, panels);
        return panels;
    }

    private int setupWPAR_Memory_Graphic(String dir) {
        int j;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 27);
        GenericPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)6);
        if (names == null) {
            return panels;
        }
        int MAX = 64;
        int[] wlmclass = new int[64];
        int[][] wlmsubclass = new int[64][64];
        int i = 0;
        while (i < 64) {
            wlmclass[i] = -1;
            j = 0;
            while (j < 64) {
                wlmsubclass[i][j] = -1;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < names.length) {
            String[] s = names[i].split("\\.", 2);
            if (s.length == 1) {
                j = 0;
                while (wlmclass[j] >= 0) {
                    ++j;
                }
                wlmclass[j] = i;
            } else {
                j = 0;
                while (s[0].compareTo(names[wlmclass[j]]) != 0) {
                    ++j;
                }
                int k = 0;
                while (wlmsubclass[j][k] >= 0) {
                    ++k;
                }
                wlmsubclass[j][k] = i;
            }
            ++i;
        }
        int numclasses = 0;
        int numsubclasses = 0;
        while (wlmclass[numclasses] >= 0) {
            ++numclasses;
        }
        this.addSeparator(this.perfFrame[27], html, "Global Memory");
        ds = new DataSet[numclasses];
        i = 0;
        while (i < numclasses) {
            ds[i] = pd.getData((byte)6, wlmclass[i], (byte)1);
            ++i;
        }
        String[] newNames = new String[numclasses];
        i = 0;
        while (i < numclasses) {
            newNames[i] = names[wlmclass[i]];
            ++i;
        }
        panel = new StackPanel(this.configuration);
        ((StackPanel)panel).setData(pd, ds, newNames);
        ((StackPanel)panel).setMaxData(100.0f);
        this.publishPanel(this.perfFrame[27], html, dir, panel, "WLM Memory% Usage");
        ++panels;
        i = 0;
        while (i < numclasses) {
            ds = new DataSet[]{pd.getData((byte)6, wlmclass[i], (byte)1)};
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[27], html, dir, panel, newNames[i]);
            ++panels;
            ++i;
        }
        i = 0;
        while (i < numclasses) {
            if (wlmsubclass[i][0] != -1) {
                numsubclasses = 0;
                while (wlmsubclass[i][numsubclasses] >= 0) {
                    ++numsubclasses;
                }
                this.addSeparator(this.perfFrame[27], html, "Class " + names[wlmclass[i]] + " MEM%");
                ds = new DataSet[numsubclasses];
                j = 0;
                while (j < numsubclasses) {
                    ds[j] = pd.getData((byte)6, wlmsubclass[i][j], (byte)1);
                    ++j;
                }
                newNames = new String[numsubclasses];
                j = 0;
                while (j < numsubclasses) {
                    newNames[j] = names[wlmsubclass[i][j]];
                    ++j;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, ds, newNames);
                ((StackPanel)panel).setMaxData(100.0f);
                this.publishPanel(this.perfFrame[27], html, dir, panel, "Class " + names[wlmclass[i]] + " MEM Usage");
                ++panels;
                j = 0;
                while (j < numsubclasses) {
                    ds = new DataSet[]{pd.getData((byte)6, wlmsubclass[i][j], (byte)1)};
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd, ds);
                    this.publishPanel(this.perfFrame[27], html, dir, panel, newNames[j]);
                    ++panels;
                    ++j;
                }
            }
            ++i;
        }
        this.finishFrame(dir, 27, html, panels);
        return panels;
    }

    private int setupWPAR_Disk_Graphic(String dir) {
        int j;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 28);
        GenericPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)6);
        if (names == null) {
            return panels;
        }
        int MAX = 64;
        int[] wlmclass = new int[64];
        int[][] wlmsubclass = new int[64][64];
        int i = 0;
        while (i < 64) {
            wlmclass[i] = -1;
            j = 0;
            while (j < 64) {
                wlmsubclass[i][j] = -1;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < names.length) {
            String[] s = names[i].split("\\.", 2);
            if (s.length == 1) {
                j = 0;
                while (wlmclass[j] >= 0) {
                    ++j;
                }
                wlmclass[j] = i;
            } else {
                j = 0;
                while (s[0].compareTo(names[wlmclass[j]]) != 0) {
                    ++j;
                }
                int k = 0;
                while (wlmsubclass[j][k] >= 0) {
                    ++k;
                }
                wlmsubclass[j][k] = i;
            }
            ++i;
        }
        int numclasses = 0;
        int numsubclasses = 0;
        while (wlmclass[numclasses] >= 0) {
            ++numclasses;
        }
        this.addSeparator(this.perfFrame[28], html, "Global Disk I/O");
        ds = new DataSet[numclasses];
        i = 0;
        while (i < numclasses) {
            ds[i] = pd.getData((byte)6, wlmclass[i], (byte)2);
            ++i;
        }
        String[] newNames = new String[numclasses];
        i = 0;
        while (i < numclasses) {
            newNames[i] = names[wlmclass[i]];
            ++i;
        }
        panel = new StackPanel(this.configuration);
        ((StackPanel)panel).setData(pd, ds, newNames);
        ((StackPanel)panel).setMaxData(-1.0f);
        this.publishPanel(this.perfFrame[28], html, dir, panel, "Global Disk I/O");
        ++panels;
        i = 0;
        while (i < numclasses) {
            ds = new DataSet[]{pd.getData((byte)6, wlmclass[i], (byte)2)};
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[28], html, dir, panel, newNames[i]);
            ++panels;
            ++i;
        }
        i = 0;
        while (i < numclasses) {
            if (wlmsubclass[i][0] != -1) {
                numsubclasses = 0;
                while (wlmsubclass[i][numsubclasses] >= 0) {
                    ++numsubclasses;
                }
                this.addSeparator(this.perfFrame[28], html, "Class " + names[wlmclass[i]]);
                ds = new DataSet[numsubclasses];
                j = 0;
                while (j < numsubclasses) {
                    ds[j] = pd.getData((byte)6, wlmsubclass[i][j], (byte)2);
                    ++j;
                }
                newNames = new String[numsubclasses];
                j = 0;
                while (j < numsubclasses) {
                    newNames[j] = names[wlmsubclass[i][j]];
                    ++j;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, ds, newNames);
                ((StackPanel)panel).setMaxData(pd.getData((byte)6, wlmclass[i], (byte)2));
                this.publishPanel(this.perfFrame[28], html, dir, panel, "Class " + names[wlmclass[i]]);
                ++panels;
                j = 0;
                while (j < numsubclasses) {
                    ds = new DataSet[]{pd.getData((byte)6, wlmsubclass[i][j], (byte)2)};
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd, ds);
                    this.publishPanel(this.perfFrame[28], html, dir, panel, newNames[j]);
                    ++panels;
                    ++j;
                }
            }
            ++i;
        }
        this.finishFrame(dir, 28, html, panels);
        return panels;
    }

    private int setupTopCPU_Graphic(String dir) {
        int i;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 29);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)8);
        if (names != null) {
            ds = new DataSet[names.length];
            i = 0;
            while (i < names.length) {
                ds[i] = pd.getData((byte)8, i, (byte)0);
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, names, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[29], html, dir, panel, "Top Avg Processes");
            ++panels;
        }
        i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)8, i, (byte)0)};
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[29], html, dir, panel, names[i]);
            ++panels;
            ++i;
        }
        this.finishFrame(dir, 29, html, panels);
        return panels;
    }

    private int setupTopRAM_Graphic(String dir) {
        int i;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 30);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)8);
        if (names != null) {
            ds = new DataSet[names.length];
            i = 0;
            while (i < names.length) {
                ds[i] = pd.getData((byte)8, i, (byte)1);
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, names, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[30], html, dir, panel, "Top Avg Processes");
            ++panels;
        }
        i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)8, i, (byte)1)};
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[30], html, dir, panel, names[i]);
            ++panels;
            ++i;
        }
        this.finishFrame(dir, 30, html, panels);
        return panels;
    }

    private int setupFS_Graphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 31);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)9);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)9, i, (byte)0), pd.getData((byte)9, i, (byte)1)};
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[31], html, dir, panel, names[i]);
            ++panels;
            ++i;
        }
        this.finishFrame(dir, 31, html, panels);
        return panels;
    }

    private int setupPCPUGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 45);
        GenericPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)14);
        byte smt_threads = pd.getSmt_threads();
        String[] labels = new String[]{"Thread1", "Thread2", "Thread3", "Thread4"};
        if (smt_threads <= 0 || names == null) {
            return 0;
        }
        ds = new DataSet[]{pd.getData((byte)14, 0, (byte)0)};
        panel = new XYPanel(this.configuration);
        panel.setData(pd, ds);
        this.publishPanel(this.perfFrame[45], html, dir, panel, "Global");
        ++panels;
        int i = 1;
        while (i < names.length) {
            ds = new DataSet[smt_threads];
            ds[0] = pd.getData((byte)14, i, (byte)0);
            if (smt_threads >= 2) {
                ds[1] = pd.getData((byte)14, i + 1, (byte)0);
            }
            if (smt_threads == 4) {
                ds[2] = pd.getData((byte)14, i + 2, (byte)0);
                ds[3] = pd.getData((byte)14, i + 3, (byte)0);
            }
            panel = new StackPanel(this.configuration);
            ((StackPanel)panel).setData(pd, ds, labels);
            ((StackPanel)panel).setMaxData(1.0f);
            this.publishPanel(this.perfFrame[45], html, dir, panel, "VP" + (i / smt_threads + 1));
            ++panels;
            i += smt_threads;
        }
        this.finishFrame(dir, 45, html, panels);
        return panels;
    }

    private int setupCPUGraphic(String dir) {
        PerfData pd_local;
        int j;
        int num;
        String descr;
        Parser p;
        String[] lparNames;
        String[] names;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 0);
        GenericPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        Object ds = null;
        String cecName = this.parser.getCecName();
        if (this.parser.getParserNames() != null) {
            if (cecName != null) {
                this.addSeparator(this.perfFrame[0], html, "CEC " + cecName);
            } else {
                this.addSeparator(this.perfFrame[0], html, "LPARs / Systems");
            }
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull((DataSet[])(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)37), pd.getData((byte)0, 0, (byte)38), pd.getData((byte)0, 0, (byte)39)})) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, (DataSet[])ds);
            this.publishPanel(this.perfFrame[0], html, dir, panel, "Number of LPARs");
            ++panels;
        }
        if (this.parser.getParserNames() != null) {
            lparNames = this.parser.getParserNames();
            p = null;
            descr = cecName != null ? "CEC CPU" : "System/LPAR CPU";
            num = 0;
            int i = 0;
            while (i < lparNames.length) {
                if (this.parser.getParser(i) != null && this.parser.getParser(i).getPerfData().getData((byte)0, 0, (byte)0) != null) {
                    ++num;
                }
                ++i;
            }
            if (num > 0) {
                ds = new DataSet[num];
                names = new String[num];
                int i2 = 0;
                j = 0;
                while (i2 < lparNames.length) {
                    DataSet dsp;
                    p = this.parser.getParser(i2);
                    if (p != null && (dsp = p.getPerfData().getData((byte)0, 0, (byte)0)) != null) {
                        ds[j] = dsp;
                        names[j] = lparNames[i2];
                        ++j;
                    }
                    ++i2;
                }
                DataSet max = pd.getData((byte)0, 0, (byte)35);
                if (max == null) {
                    max = pd.getData((byte)0, 0, (byte)3);
                    descr = String.valueOf(descr) + " (uLPAR only)";
                } else {
                    descr = String.valueOf(descr) + " (DED included)";
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, (DataSet[])ds, names);
                ((StackPanel)panel).setMaxData(max);
                this.publishPanel(this.perfFrame[0], html, dir, panel, descr);
                ++panels;
            }
        }
        if (this.parser.getParserNames() != null) {
            lparNames = this.parser.getParserNames();
            p = null;
            descr = cecName != null ? "Hint: CEC dedicated CPU usage" : "Hint: System/LPAR dedicated CPU usage";
            num = 0;
            int i = 0;
            while (i < lparNames.length) {
                if (this.parser.getParser(i) != null && this.parser.getParser(i).getPerfData().getData((byte)0, 0, (byte)40) != null) {
                    ++num;
                }
                ++i;
            }
            if (num > 0) {
                ds = new DataSet[num];
                names = new String[num];
                int i3 = 0;
                j = 0;
                while (i3 < lparNames.length) {
                    DataSet dsp;
                    p = this.parser.getParser(i3);
                    if (p != null && (dsp = p.getPerfData().getData((byte)0, 0, (byte)40)) != null) {
                        ds[j] = dsp;
                        names[j] = lparNames[i3];
                        ++j;
                    }
                    ++i3;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, (DataSet[])ds, names);
                ((StackPanel)panel).setMaxData(null);
                this.publishPanel(this.perfFrame[0], html, dir, panel, descr);
                ++panels;
            }
        }
        if (this.parser.getParserNames() != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)0), pd.getData((byte)0, 0, (byte)40)};
            names = new String[]{"uLPAR", "Hint on dedicated LPAR"};
            if (this.numElementsNotNull((DataSet[])ds) == 2) {
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, (DataSet[])ds, names);
                ((StackPanel)panel).setMaxData(null);
                this.publishPanel(this.perfFrame[0], html, dir, panel, "uLPAR and hint on dedicated");
                ++panels;
            }
            if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull((DataSet[])(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)41)})) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, (DataSet[])ds);
                this.publishPanel(this.perfFrame[0], html, dir, panel, "uLPAR + hint dedicated");
                ++panels;
            }
        }
        names = pd.getNames((byte)1);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)1, i, (byte)0), pd.getData((byte)1, i, (byte)1), pd.getData((byte)1, i, (byte)2), pd.getData((byte)1, i, (byte)3)};
            panel = new CPUPerfPanel(this.configuration);
            panel.setData(pd, (DataSet[])ds);
            this.publishPanel(this.perfFrame[0], html, dir, panel, names[i]);
            ++panels;
            ++i;
        }
        names = pd.getNames((byte)0);
        if (names != null && this.numElementsNotNull((DataSet[])(ds = this.parser.getParserNames() != null ? new DataSet[]{pd.getData((byte)0, 0, (byte)3), pd.getData((byte)0, 0, (byte)5), pd.getData((byte)0, 0, (byte)0), pd.getData((byte)0, 0, (byte)58)} : new DataSet[]{pd.getData((byte)0, 0, (byte)1), pd.getData((byte)0, 0, (byte)5), pd.getData((byte)0, 0, (byte)0), pd.getData((byte)0, 0, (byte)59)})) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, (DataSet[])ds);
            this.publishPanel(this.perfFrame[0], html, dir, panel, "uLPARs: Processor Usage");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull((DataSet[])(ds = this.parser.getParserNames() != null ? null : new DataSet[]{pd.getData((byte)0, 0, (byte)60)})) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, (DataSet[])ds);
            this.publishPanel(this.perfFrame[0], html, dir, panel, "uLPARs: Folded VPs");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.parser.getParserNames() != null && this.numElementsNotNull((DataSet[])(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)1)})) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, (DataSet[])ds);
            this.publishPanel(this.perfFrame[0], html, dir, panel, "Global VP");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.parser.getParserNames() == null && this.numElementsNotNull((DataSet[])(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)61), pd.getData((byte)0, 0, (byte)62), pd.getData((byte)0, 0, (byte)63), pd.getData((byte)0, 0, (byte)64)})) > 0) {
            panel = new CPUPerfPanel(this.configuration);
            panel.setData(pd, (DataSet[])ds);
            this.publishPanel(this.perfFrame[0], html, dir, panel, "uLPARs: VP Usage");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull((DataSet[])(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)40)})) > 0) {
            String smt;
            panel = new XYPanel(this.configuration);
            panel.setData(pd, (DataSet[])ds);
            switch (pd.getSmtStatus()) {
                case 3: {
                    smt = "SMT ok";
                    break;
                }
                case 2: {
                    smt = "SMT OFF?";
                    break;
                }
                case 1: {
                    smt = "SMT ON?";
                    break;
                }
                case 0: {
                    smt = "SMT Unknown";
                    break;
                }
                default: {
                    smt = "SMT ??";
                }
            }
            this.publishPanel(this.perfFrame[0], html, dir, panel, "Hint: Processor Usage - " + smt);
            ++panels;
        }
        if (this.parser.getParserNames() == null && (names = pd.getNames((byte)0)) != null && this.numElementsNotNull((DataSet[])(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)2)})) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, (DataSet[])ds);
            this.publishPanel(this.perfFrame[0], html, dir, panel, "uLPARs: Logical CPU");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull((DataSet[])(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)6)})) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, (DataSet[])ds);
            this.publishPanel(this.perfFrame[0], html, dir, panel, "Entitlement Usage");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull((DataSet[])(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)3), pd.getData((byte)0, 0, (byte)4)})) == 2 && ds[0].getMax() > 0.0f && ds[1].getMax() > 0.0f) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, (DataSet[])ds);
            this.publishPanel(this.perfFrame[0], html, dir, panel, "Pool Usage");
            ++panels;
        }
        if (this.parser.getParserNames() != null) {
            String[] lparNames2 = this.parser.getParserNames();
            p = null;
            boolean separatorAdded = false;
            SumXYPanel sumXYPanel = null;
            int i4 = 0;
            while (i4 < lparNames2.length) {
                p = this.parser.getParser(i4);
                if (p != null && (ds = new DataSet[]{(pd_local = p.getPerfData()).getData((byte)0, 0, (byte)1), pd_local.getData((byte)0, 0, (byte)5), pd_local.getData((byte)0, 0, (byte)0), pd_local.getData((byte)0, 0, (byte)59)})[2] != null) {
                    if (!separatorAdded) {
                        if (p instanceof Parser_Lslparutil) {
                            this.addSeparator(this.perfFrame[0], html, "ALL LPARs: physical CPU");
                        } else {
                            this.addSeparator(this.perfFrame[0], html, "uLPAR: physical CPU");
                        }
                        separatorAdded = true;
                        sumXYPanel = new SumXYPanel(pd, this.configuration);
                        if (!(p instanceof Parser_Lslparutil)) {
                            sumXYPanel.setSmartComputing(true);
                        }
                        this.publishPanel(this.perfFrame[0], html, dir, sumXYPanel, "Physical CPU of selected LPAR");
                        ++panels;
                    }
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd_local, (DataSet[])ds);
                    this.publishPanel(this.perfFrame[0], html, dir, panel, "Phy-" + lparNames2[i4]);
                    ++panels;
                    if (sumXYPanel != null) {
                        ds = new DataSet[]{pd_local.getData((byte)0, 0, (byte)0)};
                        sumXYPanel.addPanel((DataSet[])ds, panel);
                    }
                }
                ++i4;
            }
            if (sumXYPanel != null) {
                sumXYPanel.computeData();
            }
        }
        if (this.parser.getParserNames() != null) {
            String[] lparNames3 = this.parser.getParserNames();
            p = null;
            boolean separatorAdded = false;
            SumXYPanel sumXYPanel = null;
            int i5 = 0;
            while (i5 < lparNames3.length) {
                p = this.parser.getParser(i5);
                if (p != null && (ds = new DataSet[]{(pd_local = p.getPerfData()).getData((byte)0, 0, (byte)40)})[0] != null) {
                    String smt;
                    if (!separatorAdded) {
                        this.addSeparator(this.perfFrame[0], html, "Dedicated LPAR: estimated physical CPU (check SMT!)");
                        separatorAdded = true;
                        sumXYPanel = new SumXYPanel(pd, this.configuration);
                        if (!(p instanceof Parser_Lslparutil)) {
                            sumXYPanel.setSmartComputing(true);
                        }
                        this.publishPanel(this.perfFrame[0], html, dir, sumXYPanel, "Est. physical CPU of selected LPAR");
                        ++panels;
                    }
                    switch (pd_local.getSmtStatus()) {
                        case 3: {
                            smt = "SMT ok";
                            break;
                        }
                        case 2: {
                            smt = "SMT OFF?";
                            break;
                        }
                        case 1: {
                            smt = "SMT ON?";
                            break;
                        }
                        case 0: {
                            smt = "SMT OFF?";
                            break;
                        }
                        default: {
                            smt = "SMT ??";
                        }
                    }
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd_local, (DataSet[])ds);
                    this.publishPanel(this.perfFrame[0], html, dir, panel, "Phy-" + lparNames3[i5] + " - " + smt);
                    ++panels;
                    if (sumXYPanel != null) {
                        ds = new DataSet[]{pd_local.getData((byte)0, 0, (byte)40)};
                        sumXYPanel.addPanel((DataSet[])ds, panel);
                    }
                }
                ++i5;
            }
            if (sumXYPanel != null) {
                sumXYPanel.computeData();
            }
        }
        if (this.parser.getParserNames() != null) {
            String[] lparNames4 = this.parser.getParserNames();
            p = null;
            boolean separatorAdded = false;
            int i6 = 0;
            while (i6 < lparNames4.length) {
                p = this.parser.getParser(i6);
                if (p != null && (pd_local = p.getPerfData()).getNames((byte)1) != null) {
                    if (!separatorAdded) {
                        this.addSeparator(this.perfFrame[0], html, "Avg CPU Usage");
                        separatorAdded = true;
                    }
                    ds = new DataSet[]{pd_local.getData((byte)1, 0, (byte)0), pd_local.getData((byte)1, 0, (byte)1), pd_local.getData((byte)1, 0, (byte)2), pd_local.getData((byte)1, 0, (byte)3)};
                    panel = new CPUPerfPanel(this.configuration);
                    panel.setData(pd_local, (DataSet[])ds);
                    this.publishPanel(this.perfFrame[0], html, dir, panel, "Avg-" + lparNames4[i6]);
                    ++panels;
                }
                ++i6;
            }
        }
        if (this.parser.getParserNames() != null) {
            String[] lparNames5 = this.parser.getParserNames();
            p = null;
            boolean separatorAdded = false;
            int i7 = 0;
            while (i7 < lparNames5.length) {
                p = this.parser.getParser(i7);
                if (p != null && (ds = new DataSet[]{(pd_local = p.getPerfData()).getData((byte)0, 0, (byte)65)})[0] != null) {
                    if (!separatorAdded) {
                        this.addSeparator(this.perfFrame[0], html, "Cycles Per Instruction");
                        separatorAdded = true;
                    }
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd_local, (DataSet[])ds);
                    this.publishPanel(this.perfFrame[0], html, dir, panel, "CPI-" + lparNames5[i7]);
                    ++panels;
                }
                ++i7;
            }
        }
        this.finishFrame(dir, 0, html, panels);
        return panels;
    }

    private int setupDiskBusyGraphic(String dir) {
        int i;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 2);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)2);
        if (names == null) {
            return panels;
        }
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length];
            ds = new DataSet[names.length];
            i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)2, i, (byte)0);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[2], html, dir, panel, "Top Avg Disk Busy");
            ++panels;
        }
        i = 0;
        while (names != null && i < names.length) {
            if (!names[i].startsWith("_Global")) {
                ds = new DataSet[]{pd.getData((byte)2, i, (byte)0)};
                if (this.numElementsNotNull(ds) != 0) {
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd, ds);
                    this.publishPanel(this.perfFrame[2], html, dir, panel, names[i]);
                    ++panels;
                }
            }
            ++i;
        }
        this.finishFrame(dir, 2, html, panels);
        return panels;
    }

    private int setupESSBusyGraphic(String dir) {
        int i;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 41);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)3);
        if (names == null) {
            return panels;
        }
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length];
            ds = new DataSet[names.length];
            i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)3, i, (byte)3);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[41], html, dir, panel, "Top Avg MPIO Busy");
            ++panels;
        }
        i = 0;
        while (names != null && i < names.length) {
            if (!names[i].startsWith("_Global")) {
                ds = new DataSet[]{pd.getData((byte)3, i, (byte)3)};
                if (this.numElementsNotNull(ds) != 0) {
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd, ds);
                    this.publishPanel(this.perfFrame[41], html, dir, panel, names[i]);
                    ++panels;
                }
            }
            ++i;
        }
        this.finishFrame(dir, 41, html, panels);
        return panels;
    }

    private int setupDiskRWGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 3);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        SumXYPanel sumXYPanel = null;
        String[] names = pd.getNames((byte)2);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length];
            ds = new DataSet[names.length];
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)2, i, (byte)1);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[3], html, dir, panel, "Top Avg Read");
            ++panels;
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)2, i, (byte)2);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[3], html, dir, panel, "Top Avg Write");
            ++panels;
            sumXYPanel = new SumXYPanel(pd, this.configuration);
            this.publishPanel(this.perfFrame[3], html, dir, sumXYPanel, "Selected disks");
            ++panels;
        }
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)2, i, (byte)1), pd.getData((byte)2, i, (byte)2)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[3], html, dir, panel, names[i]);
                ++panels;
                if (sumXYPanel != null && !names[i].startsWith("_Global")) {
                    sumXYPanel.addPanel(ds, panel);
                }
            }
            ++i;
        }
        if (sumXYPanel != null) {
            sumXYPanel.computeData();
        }
        this.finishFrame(dir, 3, html, panels);
        return panels;
    }

    private int setupDacRWGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 35);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)11);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length];
            ds = new DataSet[names.length];
            int i = 0;
            while (i < names.length) {
                if (!names[i].endsWith("-utm")) {
                    ds[counter] = pd.getData((byte)11, i, (byte)1);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[35], html, dir, panel, "Top Avg Read");
            ++panels;
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].endsWith("-utm")) {
                    ds[counter] = pd.getData((byte)11, i, (byte)2);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[35], html, dir, panel, "Top Avg Write");
            ++panels;
        }
        int i = 0;
        while (names != null && i < names.length) {
            if (!names[i].endsWith("-utm")) {
                ds = new DataSet[]{pd.getData((byte)11, i, (byte)1), pd.getData((byte)11, i, (byte)2)};
                if (this.numElementsNotNull(ds) != 0) {
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd, ds);
                    this.publishPanel(this.perfFrame[35], html, dir, panel, names[i]);
                    ++panels;
                }
            }
            ++i;
        }
        this.finishFrame(dir, 35, html, panels);
        return panels;
    }

    private int setupDiskXferGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 4);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        SumXYPanel sumXYPanel = null;
        String[] names = pd.getNames((byte)2);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length - 1];
            ds = new DataSet[names.length - 1];
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)2, i, (byte)5);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[4], html, dir, panel, "Top Avg Read/sec");
                ++panels;
            }
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)2, i, (byte)11);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[4], html, dir, panel, "Top Avg Write/sec");
                ++panels;
            }
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)2, i, (byte)3);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[4], html, dir, panel, "Top Avg Transfers/sec");
                ++panels;
            }
            sumXYPanel = new SumXYPanel(pd, this.configuration);
            this.publishPanel(this.perfFrame[4], html, dir, sumXYPanel, "Selected disks");
            ++panels;
        }
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)2, i, (byte)5), pd.getData((byte)2, i, (byte)11), pd.getData((byte)2, i, (byte)3)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[4], html, dir, panel, names[i]);
                ++panels;
                if (sumXYPanel != null && !names[i].startsWith("_Global")) {
                    sumXYPanel.addPanel(ds, panel);
                }
            }
            ++i;
        }
        if (sumXYPanel != null) {
            sumXYPanel.computeData();
        }
        this.finishFrame(dir, 4, html, panels);
        return panels;
    }

    private int setupDacXferGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 36);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)11);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length];
            ds = new DataSet[names.length];
            int i = 0;
            while (i < names.length) {
                if (!names[i].endsWith("-utm")) {
                    ds[counter] = pd.getData((byte)11, i, (byte)5);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[36], html, dir, panel, "Top Avg Read/sec");
                ++panels;
            }
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].endsWith("-utm")) {
                    ds[counter] = pd.getData((byte)11, i, (byte)11);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[36], html, dir, panel, "Top Avg Write/sec");
                ++panels;
            }
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].endsWith("-utm")) {
                    ds[counter] = pd.getData((byte)11, i, (byte)3);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[36], html, dir, panel, "Top Avg Transfers/sec");
                ++panels;
            }
        }
        int i = 0;
        while (names != null && i < names.length) {
            if (!names[i].endsWith("-utm")) {
                ds = new DataSet[]{pd.getData((byte)11, i, (byte)5), pd.getData((byte)11, i, (byte)11), pd.getData((byte)11, i, (byte)3)};
                if (this.numElementsNotNull(ds) != 0) {
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd, ds);
                    this.publishPanel(this.perfFrame[36], html, dir, panel, names[i]);
                    ++panels;
                }
            }
            ++i;
        }
        this.finishFrame(dir, 36, html, panels);
        return panels;
    }

    private int setupDiskBlockGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 5);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            if (!names[i].startsWith("_Global")) {
                ds = new DataSet[]{pd.getData((byte)2, i, (byte)4)};
                if (this.numElementsNotNull(ds) != 0) {
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd, ds);
                    this.publishPanel(this.perfFrame[5], html, dir, panel, names[i]);
                    ++panels;
                }
            }
            ++i;
        }
        this.finishFrame(dir, 5, html, panels);
        return panels;
    }

    private int setupEssRWGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 6);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        SumXYPanel sumXYPanel = null;
        String[] names = pd.getNames((byte)3);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length - 1];
            ds = new DataSet[names.length - 1];
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)3, i, (byte)0);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[6], html, dir, panel, "Top Avg Read");
            ++panels;
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)3, i, (byte)1);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[6], html, dir, panel, "Top Avg Write");
            ++panels;
            sumXYPanel = new SumXYPanel(pd, this.configuration);
            this.publishPanel(this.perfFrame[6], html, dir, sumXYPanel, "Selected disks");
            ++panels;
        }
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)3, i, (byte)0), pd.getData((byte)3, i, (byte)1)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[6], html, dir, panel, names[i]);
                ++panels;
                if (sumXYPanel != null && !names[i].startsWith("_Global")) {
                    sumXYPanel.addPanel(ds, panel);
                }
            }
            ++i;
        }
        if (sumXYPanel != null) {
            sumXYPanel.computeData();
        }
        this.finishFrame(dir, 6, html, panels);
        return panels;
    }

    private int setupAdapterRWGraphic(String dir) {
        int j;
        int i;
        int num;
        Parser p;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 8);
        GenericPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        SumXYPanel sumXYPanel = null;
        String[] names = pd.getNames((byte)4);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length - 1];
            ds = new DataSet[names.length - 1];
            int i2 = 0;
            while (i2 < names.length) {
                if (!names[i2].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)4, i2, (byte)0);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i2];
                        ++counter;
                    }
                }
                ++i2;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                ((XYPanel)panel).setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[8], html, dir, panel, "Top Avg Dsk Read");
                ++panels;
            }
            counter = 0;
            i2 = 0;
            while (i2 < names.length) {
                if (!names[i2].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)4, i2, (byte)1);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i2];
                        ++counter;
                    }
                }
                ++i2;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                ((XYPanel)panel).setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[8], html, dir, panel, "Top Avg Dsk Write");
                ++panels;
            }
            if (counter > 2) {
                sumXYPanel = new SumXYPanel(pd, this.configuration);
                this.publishPanel(this.perfFrame[8], html, dir, sumXYPanel, "Selected adapters");
                ++panels;
            }
        }
        int i3 = 0;
        while (names != null && i3 < names.length) {
            if (names.length != 2 || !names[i3].startsWith("_Global")) {
                ds = new DataSet[]{pd.getData((byte)4, i3, (byte)0), pd.getData((byte)4, i3, (byte)1)};
                if (this.numElementsNotNull(ds) != 0) {
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd, ds);
                    this.publishPanel(this.perfFrame[8], html, dir, panel, names[i3]);
                    ++panels;
                    if (sumXYPanel != null && !names[i3].startsWith("_Global")) {
                        sumXYPanel.addPanel(ds, panel);
                    }
                }
            }
            ++i3;
        }
        if (sumXYPanel != null) {
            sumXYPanel.computeData();
        }
        if (this.parser.getParserNames() != null) {
            String[] lparNames = this.parser.getParserNames();
            p = null;
            num = 0;
            int i4 = 0;
            while (i4 < lparNames.length) {
                if (this.parser.getParser(i4) != null && this.parser.getParser(i4).getPerfData().getData((byte)4, "_Global_Disk_Adapter", (byte)0) != null) {
                    ++num;
                }
                ++i4;
            }
            if (num > 0) {
                ds = new DataSet[num];
                names = new String[num];
                i = 0;
                j = 0;
                while (i < lparNames.length) {
                    DataSet dsp;
                    p = this.parser.getParser(i);
                    if (p != null && (dsp = p.getPerfData().getData((byte)4, "_Global_Disk_Adapter", (byte)0)) != null) {
                        ds[j] = dsp;
                        names[j] = lparNames[i];
                        ++j;
                    }
                    ++i;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, ds, names);
                ((StackPanel)panel).setMaxData(null);
                this.publishPanel(this.perfFrame[8], html, dir, panel, "Global disk read");
                ++panels;
            }
        }
        if (this.parser.getParserNames() != null) {
            String[] lparNames = this.parser.getParserNames();
            p = null;
            num = 0;
            int i5 = 0;
            while (i5 < lparNames.length) {
                if (this.parser.getParser(i5) != null && this.parser.getParser(i5).getPerfData().getData((byte)4, "_Global_Disk_Adapter", (byte)1) != null) {
                    ++num;
                }
                ++i5;
            }
            if (num > 0) {
                ds = new DataSet[num];
                names = new String[num];
                i = 0;
                j = 0;
                while (i < lparNames.length) {
                    DataSet dsp;
                    p = this.parser.getParser(i);
                    if (p != null && (dsp = p.getPerfData().getData((byte)4, "_Global_Disk_Adapter", (byte)1)) != null) {
                        ds[j] = dsp;
                        names[j] = lparNames[i];
                        ++j;
                    }
                    ++i;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, ds, names);
                ((StackPanel)panel).setMaxData(null);
                this.publishPanel(this.perfFrame[8], html, dir, panel, "Global disk write");
                ++panels;
            }
        }
        if (this.parser.getParserNames() != null) {
            String[] lparNames = this.parser.getParserNames();
            p = null;
            int i6 = 0;
            while (i6 < lparNames.length) {
                p = this.parser.getParser(i6);
                if (p != null) {
                    PerfData pd_local = p.getPerfData();
                    ds = new DataSet[]{pd_local.getData((byte)4, "_Global_Disk_Adapter", (byte)0), pd_local.getData((byte)4, "_Global_Disk_Adapter", (byte)1)};
                    if (ds[0] == null) {
                        ds[0] = pd_local.getData((byte)4, 0, (byte)0);
                        ds[1] = pd_local.getData((byte)4, 0, (byte)1);
                    }
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd_local, ds);
                    this.publishPanel(this.perfFrame[8], html, dir, panel, "Disk-" + lparNames[i6]);
                    ++panels;
                }
                ++i6;
            }
        }
        this.finishFrame(dir, 8, html, panels);
        return panels;
    }

    private int setupAdapterXferGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 9);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        SumXYPanel sumXYPanel = null;
        String[] names = pd.getNames((byte)4);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length - 1];
            ds = new DataSet[names.length - 1];
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)4, i, (byte)3);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[9], html, dir, panel, "Top Avg Read/sec");
                ++panels;
            }
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)4, i, (byte)7);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[9], html, dir, panel, "Top Avg Write/sec");
                ++panels;
            }
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)4, i, (byte)2);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[9], html, dir, panel, "Top Avg Transfers/sec");
                ++panels;
            }
            sumXYPanel = new SumXYPanel(pd, this.configuration);
            this.publishPanel(this.perfFrame[9], html, dir, sumXYPanel, "Selected adapters");
            ++panels;
        }
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)4, i, (byte)3), pd.getData((byte)4, i, (byte)7), pd.getData((byte)4, i, (byte)2)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[9], html, dir, panel, names[i]);
                ++panels;
                if (sumXYPanel != null && !names[i].startsWith("_Global")) {
                    sumXYPanel.addPanel(ds, panel);
                }
            }
            ++i;
        }
        if (sumXYPanel != null) {
            sumXYPanel.computeData();
        }
        this.finishFrame(dir, 9, html, panels);
        return panels;
    }

    private int setupFibreRWGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 33);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        SumXYPanel sumXYPanel = null;
        String[] names = pd.getNames((byte)10);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length - 1];
            ds = new DataSet[names.length - 1];
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)10, i, (byte)0);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[33], html, dir, panel, "Top Avg FC Read");
            ++panels;
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)10, i, (byte)1);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[33], html, dir, panel, "Top Avg FC Write");
            ++panels;
            sumXYPanel = new SumXYPanel(pd, this.configuration);
            this.publishPanel(this.perfFrame[33], html, dir, sumXYPanel, "Selected adapters");
            ++panels;
        }
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)10, i, (byte)0), pd.getData((byte)10, i, (byte)1)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[33], html, dir, panel, names[i]);
                ++panels;
                if (sumXYPanel != null && !names[i].startsWith("_Global")) {
                    sumXYPanel.addPanel(ds, panel);
                }
            }
            ++i;
        }
        if (sumXYPanel != null) {
            sumXYPanel.computeData();
        }
        this.finishFrame(dir, 33, html, panels);
        return panels;
    }

    private int setupFibreXferGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 34);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        SumXYPanel sumXYPanel = null;
        String[] names = pd.getNames((byte)10);
        if (names != null && names.length > 1) {
            String[] namesLocal = new String[names.length - 1];
            ds = new DataSet[names.length - 1];
            int counter = 0;
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)10, i, (byte)2);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[34], html, dir, panel, "Top Avg FC TransfersIN/sec");
            ++panels;
            counter = 0;
            i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)10, i, (byte)3);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            panel.setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[34], html, dir, panel, "Top Avg FC TransfersOUT/sec");
            ++panels;
            sumXYPanel = new SumXYPanel(pd, this.configuration);
            this.publishPanel(this.perfFrame[34], html, dir, sumXYPanel, "Selected adapters");
            ++panels;
        }
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)10, i, (byte)2), pd.getData((byte)10, i, (byte)3)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[34], html, dir, panel, names[i]);
                ++panels;
                if (sumXYPanel != null && !names[i].startsWith("_Global")) {
                    sumXYPanel.addPanel(ds, panel);
                }
            }
            ++i;
        }
        if (sumXYPanel != null) {
            sumXYPanel.computeData();
        }
        this.finishFrame(dir, 34, html, panels);
        return panels;
    }

    private int setupNetworkRWGraphic(String dir) {
        int j;
        int i;
        int num;
        Parser p;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 10);
        GenericPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        SumXYPanel sumXYPanel = null;
        String[] names = pd.getNames((byte)5);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length - 1];
            ds = new DataSet[names.length - 1];
            int i2 = 0;
            while (i2 < names.length) {
                if (!names[i2].startsWith("_Global") && !names[i2].startsWith("lo")) {
                    ds[counter] = pd.getData((byte)5, i2, (byte)0);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i2];
                        ++counter;
                    }
                }
                ++i2;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            ((XYPanel)panel).setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[10], html, dir, panel, "Top Avg Read");
            ++panels;
            counter = 0;
            i2 = 0;
            while (i2 < names.length) {
                if (!names[i2].startsWith("_Global") && !names[i2].equals("lo0")) {
                    ds[counter] = pd.getData((byte)5, i2, (byte)1);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i2];
                        ++counter;
                    }
                }
                ++i2;
            }
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds, namesLocal, 5);
            ((XYPanel)panel).setForbidErrorbars(true);
            this.publishPanel(this.perfFrame[10], html, dir, panel, "Top Avg Write");
            ++panels;
            sumXYPanel = new SumXYPanel(pd, this.configuration);
            this.publishPanel(this.perfFrame[10], html, dir, sumXYPanel, "Selected adapters");
            ++panels;
        }
        int i3 = 0;
        while (names != null && i3 < names.length) {
            ds = new DataSet[]{pd.getData((byte)5, i3, (byte)0), pd.getData((byte)5, i3, (byte)1)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[10], html, dir, panel, names[i3]);
                ++panels;
                if (sumXYPanel != null && !names[i3].startsWith("_Global") && !names[i3].equals("lo0")) {
                    sumXYPanel.addPanel(ds, panel);
                }
            }
            ++i3;
        }
        if (sumXYPanel != null) {
            sumXYPanel.computeData();
        }
        if (this.parser.getParserNames() != null) {
            String[] lparNames = this.parser.getParserNames();
            p = null;
            num = 0;
            int i4 = 0;
            while (i4 < lparNames.length) {
                if (this.parser.getParser(i4) != null && this.parser.getParser(i4).getPerfData().getData((byte)5, "_Global_Network", (byte)0) != null) {
                    ++num;
                }
                ++i4;
            }
            if (num > 0) {
                ds = new DataSet[num];
                names = new String[num];
                i = 0;
                j = 0;
                while (i < lparNames.length) {
                    DataSet dsp;
                    p = this.parser.getParser(i);
                    if (p != null && (dsp = p.getPerfData().getData((byte)5, "_Global_Network", (byte)0)) != null) {
                        ds[j] = dsp;
                        names[j] = lparNames[i];
                        ++j;
                    }
                    ++i;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, ds, names);
                ((StackPanel)panel).setMaxData(null);
                this.publishPanel(this.perfFrame[10], html, dir, panel, "Global network read");
                ++panels;
            }
        }
        if (this.parser.getParserNames() != null) {
            String[] lparNames = this.parser.getParserNames();
            p = null;
            num = 0;
            int i5 = 0;
            while (i5 < lparNames.length) {
                if (this.parser.getParser(i5) != null && this.parser.getParser(i5).getPerfData().getData((byte)5, "_Global_Network", (byte)1) != null) {
                    ++num;
                }
                ++i5;
            }
            if (num > 0) {
                ds = new DataSet[num];
                names = new String[num];
                i = 0;
                j = 0;
                while (i < lparNames.length) {
                    DataSet dsp;
                    p = this.parser.getParser(i);
                    if (p != null && (dsp = p.getPerfData().getData((byte)5, "_Global_Network", (byte)1)) != null) {
                        ds[j] = dsp;
                        names[j] = lparNames[i];
                        ++j;
                    }
                    ++i;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, ds, names);
                ((StackPanel)panel).setMaxData(null);
                this.publishPanel(this.perfFrame[10], html, dir, panel, "Global network write");
                ++panels;
            }
        }
        if (this.parser.getParserNames() != null) {
            String[] lparNames = this.parser.getParserNames();
            p = null;
            int i6 = 0;
            while (i6 < lparNames.length) {
                p = this.parser.getParser(i6);
                if (p != null) {
                    String[] s;
                    PerfData pd_local = p.getPerfData();
                    ds = new DataSet[]{pd_local.getData((byte)5, "_Global_Network", (byte)0), pd_local.getData((byte)5, "_Global_Network", (byte)1)};
                    if (ds[0] == null && ds[1] == null && (s = pd_local.getNames((byte)5)) != null && s.length == 2) {
                        if (s[0].startsWith("lo")) {
                            ds[0] = pd_local.getData((byte)5, 1, (byte)0);
                            ds[1] = pd_local.getData((byte)5, 1, (byte)1);
                        } else {
                            ds[0] = pd_local.getData((byte)5, 0, (byte)0);
                            ds[1] = pd_local.getData((byte)5, 0, (byte)1);
                        }
                    }
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd_local, ds);
                    this.publishPanel(this.perfFrame[10], html, dir, panel, "Net-" + lparNames[i6]);
                    ++panels;
                }
                ++i6;
            }
        }
        this.finishFrame(dir, 10, html, panels);
        return panels;
    }

    private int setupSEAGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 44);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)13);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)13, i, (byte)0), pd.getData((byte)13, i, (byte)1)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[44], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)13, i, (byte)2), pd.getData((byte)13, i, (byte)3)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[44], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 44, html, panels);
        return panels;
    }

    private int setupEssXferGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 7);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        SumXYPanel sumXYPanel = null;
        String[] names = pd.getNames((byte)3);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length - 1];
            ds = new DataSet[names.length - 1];
            counter = 0;
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)3, i, (byte)2);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 2) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[7], html, dir, panel, "Top Avg Transfers/sec");
                ++panels;
            }
            sumXYPanel = new SumXYPanel(pd, this.configuration);
            this.publishPanel(this.perfFrame[7], html, dir, sumXYPanel, "Selected disks");
            ++panels;
        }
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)3, i, (byte)2)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[7], html, dir, panel, names[i]);
                ++panels;
                if (sumXYPanel != null && !names[i].startsWith("_Global")) {
                    sumXYPanel.addPanel(ds, panel);
                }
            }
            ++i;
        }
        if (sumXYPanel != null) {
            sumXYPanel.computeData();
        }
        this.finishFrame(dir, 7, html, panels);
        return panels;
    }

    private int setupMemDetailsGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 46);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)0);
        if (names != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)67), pd.getData((byte)0, 0, (byte)69), pd.getData((byte)0, 0, (byte)75)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[46], html, dir, panel, "4KB Memory");
                ++panels;
            }
        }
        if ((names = pd.getNames((byte)0)) != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)71), pd.getData((byte)0, 0, (byte)72)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[46], html, dir, panel, "4KB Memory Paging");
                ++panels;
            }
        }
        if ((names = pd.getNames((byte)0)) != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)68), pd.getData((byte)0, 0, (byte)70), pd.getData((byte)0, 0, (byte)76)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[46], html, dir, panel, "64KB Memory");
                ++panels;
            }
        }
        if ((names = pd.getNames((byte)0)) != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)73), pd.getData((byte)0, 0, (byte)74)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[46], html, dir, panel, "64KB Memory Paging");
                ++panels;
            }
        }
        if ((names = pd.getNames((byte)0)) != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)77), pd.getData((byte)0, 0, (byte)78)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[46], html, dir, panel, "Page Faults by size");
                ++panels;
            }
        }
        this.finishFrame(dir, 46, html, panels);
        return panels;
    }

    private int setupMemoryGraphic(String dir) {
        int j;
        int i;
        int num;
        Parser p;
        String[] lparNames;
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 1);
        GenericPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)0);
        if (names != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)7)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Avg Virt Mem");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)8), pd.getData((byte)0, 0, (byte)16)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Physical Memory");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)9), pd.getData((byte)0, 0, (byte)10)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Paging Space");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)11), pd.getData((byte)0, 0, (byte)12)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "File paging activity");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)13), pd.getData((byte)0, 0, (byte)15), pd.getData((byte)0, 0, (byte)14)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "VMM Activity");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)66)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Page faults");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)36)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Page scan-free ratio");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)17), pd.getData((byte)0, 0, (byte)18), pd.getData((byte)0, 0, (byte)19)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Permanent Pages");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)24), pd.getData((byte)0, 0, (byte)25)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Client Pages");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)22), pd.getData((byte)0, 0, (byte)20), pd.getData((byte)0, 0, (byte)21)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Free Pages");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)50), pd.getData((byte)0, 0, (byte)51)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Large Pages");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)46), pd.getData((byte)0, 0, (byte)45), pd.getData((byte)0, 0, (byte)47)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Active Shared Memory");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)55), pd.getData((byte)0, 0, (byte)52), pd.getData((byte)0, 0, (byte)54), pd.getData((byte)0, 0, (byte)53)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Active Memory Expansion");
            ++panels;
        }
        if ((names = pd.getNames((byte)0)) != null && this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)56), pd.getData((byte)0, 0, (byte)57)}) > 0) {
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Comp Memory Pool Paging");
            ++panels;
        }
        if (this.parser.getParserNames() != null) {
            lparNames = this.parser.getParserNames();
            p = null;
            num = 0;
            int i2 = 0;
            while (i2 < lparNames.length) {
                if (this.parser.getParser(i2) != null && this.parser.getParser(i2).getPerfData().getData((byte)0, 0, (byte)46) != null) {
                    ++num;
                }
                ++i2;
            }
            if (num > 0) {
                ds = new DataSet[num];
                names = new String[num];
                i = 0;
                j = 0;
                while (i < lparNames.length) {
                    DataSet dsp;
                    p = this.parser.getParser(i);
                    if (p != null && (dsp = p.getPerfData().getData((byte)0, 0, (byte)46)) != null) {
                        ds[j] = dsp;
                        names[j] = lparNames[i];
                        ++j;
                    }
                    ++i;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, ds, names);
                ((StackPanel)panel).setMaxData(null);
                this.publishPanel(this.perfFrame[1], html, dir, panel, "Shared Memory Pool: physical memory usage");
                ++panels;
                i = 0;
                while (i < lparNames.length) {
                    p = this.parser.getParser(i);
                    if (p != null && this.numElementsNotNull(ds = new DataSet[]{p.getPerfData().getData((byte)0, 0, (byte)46), p.getPerfData().getData((byte)0, 0, (byte)45), p.getPerfData().getData((byte)0, 0, (byte)47)}) > 0) {
                        panel = new XYPanel(this.configuration);
                        panel.setData(pd, ds);
                        this.publishPanel(this.perfFrame[1], html, dir, panel, String.valueOf(lparNames[i]) + ": Active Shared Memory");
                        ++panels;
                    }
                    ++i;
                }
            }
        }
        if ((names = pd.getNames((byte)0)) != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)48)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[1], html, dir, panel, "Hypervisor Page In");
                ++panels;
            }
            if (this.numElementsNotNull(ds = new DataSet[]{pd.getData((byte)0, 0, (byte)49)}) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[1], html, dir, panel, "Hypervisor Page In Time");
                ++panels;
            }
        }
        if (this.parser.getParserNames() != null) {
            lparNames = this.parser.getParserNames();
            p = null;
            num = 0;
            int i3 = 0;
            while (i3 < lparNames.length) {
                if (this.parser.getParser(i3) != null && this.parser.getParser(i3).getPerfData().getData((byte)0, 0, (byte)48) != null) {
                    ++num;
                }
                ++i3;
            }
            if (num > 0) {
                ds = new DataSet[num];
                names = new String[num];
                i = 0;
                j = 0;
                while (i < lparNames.length) {
                    DataSet dsp;
                    p = this.parser.getParser(i);
                    if (p != null && (dsp = p.getPerfData().getData((byte)0, 0, (byte)48)) != null) {
                        ds[j] = dsp;
                        names[j] = lparNames[i];
                        ++j;
                    }
                    ++i;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, ds, names);
                ((StackPanel)panel).setMaxData(null);
                this.publishPanel(this.perfFrame[1], html, dir, panel, "Hypervisor Page In by LPAR");
                ++panels;
            }
        }
        if (this.parser.getParserNames() != null) {
            lparNames = this.parser.getParserNames();
            p = null;
            num = 0;
            int i4 = 0;
            while (i4 < lparNames.length) {
                if (this.parser.getParser(i4) != null && this.parser.getParser(i4).getPerfData().getData((byte)0, 0, (byte)23) != null) {
                    ++num;
                }
                ++i4;
            }
            if (num > 0) {
                ds = new DataSet[num];
                names = new String[num];
                i = 0;
                j = 0;
                while (i < lparNames.length) {
                    DataSet dsp;
                    p = this.parser.getParser(i);
                    if (p != null && (dsp = p.getPerfData().getData((byte)0, 0, (byte)23)) != null) {
                        ds[j] = dsp;
                        names[j] = lparNames[i];
                        ++j;
                    }
                    ++i;
                }
                panel = new StackPanel(this.configuration);
                ((StackPanel)panel).setData(pd, ds, names);
                ((StackPanel)panel).setMaxData(null);
                this.publishPanel(this.perfFrame[1], html, dir, panel, "Global RAM Usage");
                ++panels;
            }
        }
        if (this.parser.getParserNames() != null) {
            lparNames = this.parser.getParserNames();
            p = null;
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)23)};
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[1], html, dir, panel, "Globally Used MB");
            ++panels;
            int i5 = 0;
            while (i5 < lparNames.length) {
                p = this.parser.getParser(i5);
                if (p != null) {
                    PerfData pd_local = p.getPerfData();
                    ds = new DataSet[]{pd_local.getData((byte)0, 0, (byte)23)};
                    panel = new XYPanel(this.configuration);
                    panel.setData(pd_local, ds);
                    this.publishPanel(this.perfFrame[1], html, dir, panel, "Used MB-" + lparNames[i5]);
                    ++panels;
                }
                ++i5;
            }
        }
        this.finishFrame(dir, 1, html, panels);
        return panels;
    }

    private int setupKernelGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 12);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)0);
        if (names != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)26), pd.getData((byte)0, 0, (byte)27)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[12], html, dir, panel, "KernelQ");
                ++panels;
            }
        }
        if ((names = pd.getNames((byte)0)) != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)28)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[12], html, dir, panel, "Threads waiting for I/O");
                ++panels;
            }
        }
        if ((names = pd.getNames((byte)0)) != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)29)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[12], html, dir, panel, "Process Switch");
                ++panels;
            }
        }
        this.finishFrame(dir, 12, html, panels);
        return panels;
    }

    private int setupAIO_Graphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 32);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)0);
        if (names != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)42), pd.getData((byte)0, 0, (byte)43)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[32], html, dir, panel, "Async IO Processes");
                ++panels;
            }
        }
        if ((names = pd.getNames((byte)0)) != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)44)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[32], html, dir, panel, "Async IO CPU Usage");
                ++panels;
            }
        }
        this.finishFrame(dir, 32, html, panels);
        return panels;
    }

    private int setupSyscallGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 13);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)0);
        if (names != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)30)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[13], html, dir, panel, "All calls");
                ++panels;
            }
        }
        if ((names = pd.getNames((byte)0)) != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)31), pd.getData((byte)0, 0, (byte)32)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[13], html, dir, panel, "Fork&Exec");
                ++panels;
            }
        }
        if ((names = pd.getNames((byte)0)) != null) {
            ds = new DataSet[]{pd.getData((byte)0, 0, (byte)33), pd.getData((byte)0, 0, (byte)34)};
            if (this.numElementsNotNull(ds) > 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[13], html, dir, panel, "Read&Write");
                ++panels;
            }
        }
        this.finishFrame(dir, 13, html, panels);
        return panels;
    }

    private int setupDiskReadServiceGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 14);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        AvgSumXYPanel avgSumXYPanel = null;
        String[] names = pd.getNames((byte)2);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length];
            ds = new DataSet[names.length];
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)2, i, (byte)6);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 1) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[14], html, dir, panel, "Top Avg Read Service");
                ++panels;
                avgSumXYPanel = new AvgSumXYPanel(pd, this.configuration);
                this.publishPanel(this.perfFrame[14], html, dir, avgSumXYPanel, "Selected disks, weighted avg");
                ++panels;
            }
        }
        names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)2, i, (byte)7), pd.getData((byte)2, i, (byte)8), pd.getData((byte)2, i, (byte)6)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[14], html, dir, panel, names[i]);
                ++panels;
                DataSet wds = pd.getData((byte)2, i, (byte)5);
                ds = new DataSet[]{pd.getData((byte)2, i, (byte)6)};
                if (avgSumXYPanel != null && !names[i].startsWith("_Global") && wds != null) {
                    avgSumXYPanel.addPanel(ds, wds, panel);
                }
            }
            ++i;
        }
        if (avgSumXYPanel != null) {
            avgSumXYPanel.computeData();
        }
        this.finishFrame(dir, 14, html, panels);
        return panels;
    }

    private int setupDiskReadWriteServiceGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 43);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        AvgSumXYPanel avgSumXYPanel = null;
        String[] names = pd.getNames((byte)2);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length];
            ds = new DataSet[names.length];
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)2, i, (byte)25);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 1) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[43], html, dir, panel, "Top Avg Read+Write Service");
                ++panels;
                avgSumXYPanel = new AvgSumXYPanel(pd, this.configuration);
                this.publishPanel(this.perfFrame[43], html, dir, avgSumXYPanel, "Selected disks, weighted avg");
                ++panels;
            }
        }
        names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)2, i, (byte)25)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[43], html, dir, panel, names[i]);
                ++panels;
                DataSet wds = pd.getData((byte)2, i, (byte)26);
                ds = new DataSet[]{pd.getData((byte)2, i, (byte)25)};
                if (avgSumXYPanel != null && !names[i].startsWith("_Global") && wds != null) {
                    avgSumXYPanel.addPanel(ds, wds, panel);
                }
            }
            ++i;
        }
        if (avgSumXYPanel != null) {
            avgSumXYPanel.computeData();
        }
        this.finishFrame(dir, 43, html, panels);
        return panels;
    }

    private int setupAdapterReadServiceGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 21);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        AvgSumXYPanel avgSumXYPanel = null;
        String[] names = pd.getNames((byte)4);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length];
            ds = new DataSet[names.length];
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)4, i, (byte)4);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 1) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[21], html, dir, panel, "Top Avg Read Service");
                ++panels;
                avgSumXYPanel = new AvgSumXYPanel(pd, this.configuration);
                this.publishPanel(this.perfFrame[21], html, dir, avgSumXYPanel, "Selected adapter, weighted avg");
                ++panels;
            }
        }
        names = pd.getNames((byte)4);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)4, i, (byte)5), pd.getData((byte)4, i, (byte)6), pd.getData((byte)4, i, (byte)4)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[21], html, dir, panel, names[i]);
                ++panels;
                DataSet wds = pd.getData((byte)4, i, (byte)3);
                ds = new DataSet[]{pd.getData((byte)4, i, (byte)4)};
                if (avgSumXYPanel != null && !names[i].startsWith("_Global") && wds != null) {
                    avgSumXYPanel.addPanel(ds, wds, panel);
                }
            }
            ++i;
        }
        if (avgSumXYPanel != null) {
            avgSumXYPanel.computeData();
        }
        this.finishFrame(dir, 21, html, panels);
        return panels;
    }

    private int setupAdapterWriteServiceGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 22);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        AvgSumXYPanel avgSumXYPanel = null;
        String[] names = pd.getNames((byte)4);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length];
            ds = new DataSet[names.length];
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)4, i, (byte)8);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 1) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[22], html, dir, panel, "Top Avg Write Service");
                ++panels;
                avgSumXYPanel = new AvgSumXYPanel(pd, this.configuration);
                this.publishPanel(this.perfFrame[22], html, dir, avgSumXYPanel, "Selected adapter, weighted avg");
                ++panels;
            }
        }
        names = pd.getNames((byte)4);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)4, i, (byte)9), pd.getData((byte)4, i, (byte)10), pd.getData((byte)4, i, (byte)8)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[22], html, dir, panel, names[i]);
                ++panels;
                DataSet wds = pd.getData((byte)4, i, (byte)7);
                ds = new DataSet[]{pd.getData((byte)4, i, (byte)8)};
                if (avgSumXYPanel != null && !names[i].startsWith("_Global") && wds != null) {
                    avgSumXYPanel.addPanel(ds, wds, panel);
                }
            }
            ++i;
        }
        if (avgSumXYPanel != null) {
            avgSumXYPanel.computeData();
        }
        this.finishFrame(dir, 22, html, panels);
        return panels;
    }

    private int setupDiskWriteServiceGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 15);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        AvgSumXYPanel avgSumXYPanel = null;
        String[] names = pd.getNames((byte)2);
        if (names != null && names.length > 1) {
            int counter = 0;
            String[] namesLocal = new String[names.length];
            ds = new DataSet[names.length];
            int i = 0;
            while (i < names.length) {
                if (!names[i].startsWith("_Global")) {
                    ds[counter] = pd.getData((byte)2, i, (byte)12);
                    if (ds[counter] != null) {
                        namesLocal[counter] = names[i];
                        ++counter;
                    }
                }
                ++i;
            }
            if (counter > 1) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds, namesLocal, 5);
                panel.setForbidErrorbars(true);
                this.publishPanel(this.perfFrame[15], html, dir, panel, "Top Avg Write Service");
                ++panels;
                avgSumXYPanel = new AvgSumXYPanel(pd, this.configuration);
                this.publishPanel(this.perfFrame[15], html, dir, avgSumXYPanel, "Selected disks, weighted avg");
                ++panels;
            }
        }
        names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)2, i, (byte)13), pd.getData((byte)2, i, (byte)14), pd.getData((byte)2, i, (byte)12)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[15], html, dir, panel, names[i]);
                ++panels;
                DataSet wds = pd.getData((byte)2, i, (byte)11);
                ds = new DataSet[]{pd.getData((byte)2, i, (byte)12)};
                if (avgSumXYPanel != null && !names[i].startsWith("_Global") && wds != null) {
                    avgSumXYPanel.addPanel(ds, wds, panel);
                }
            }
            ++i;
        }
        if (avgSumXYPanel != null) {
            avgSumXYPanel.computeData();
        }
        this.finishFrame(dir, 15, html, panels);
        return panels;
    }

    private int setupDiskServiceGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 37);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[3];
            ds[0] = pd.getData((byte)2, i, (byte)23);
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[37], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 37, html, panels);
        return panels;
    }

    private int setupEssServiceGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 39);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)3);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[3];
            ds[0] = pd.getData((byte)3, i, (byte)4);
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[39], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 39, html, panels);
        return panels;
    }

    private int setupDiskWaitGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 38);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[3];
            ds[0] = pd.getData((byte)2, i, (byte)24);
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[38], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 38, html, panels);
        return panels;
    }

    private int setupEssWaitGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 40);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)3);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[3];
            ds[0] = pd.getData((byte)3, i, (byte)5);
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[40], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 40, html, panels);
        return panels;
    }

    private int setupDiskRWTimeoutGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 16);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)2, i, (byte)9), pd.getData((byte)2, i, (byte)15)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[16], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 16, html, panels);
        return panels;
    }

    private int setupDiskRWFailedGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 17);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)2, i, (byte)10), pd.getData((byte)2, i, (byte)16)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[17], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 17, html, panels);
        return panels;
    }

    private int setupDiskWaitQTimeGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 18);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)2, i, (byte)18), pd.getData((byte)2, i, (byte)19), pd.getData((byte)2, i, (byte)17)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[18], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 18, html, panels);
        return panels;
    }

    private int setupAdapterWaitQTimeGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 23);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)4);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)4, i, (byte)12), pd.getData((byte)4, i, (byte)13), pd.getData((byte)4, i, (byte)11)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[23], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 23, html, panels);
        return panels;
    }

    private int setupDiskQueueSizeGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 19);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)2, i, (byte)20), pd.getData((byte)2, i, (byte)21)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[19], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 19, html, panels);
        return panels;
    }

    private int setupAdapterQueueSizeGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 24);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)4);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)4, i, (byte)14), pd.getData((byte)4, i, (byte)15)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[24], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 24, html, panels);
        return panels;
    }

    private int setupDiskServiceQFullGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 20);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)2);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)2, i, (byte)22)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[20], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 20, html, panels);
        return panels;
    }

    private int setupAdapterServiceQFullGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 25);
        XYPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)4);
        int i = 0;
        while (names != null && i < names.length) {
            ds = new DataSet[]{pd.getData((byte)4, i, (byte)16)};
            if (this.numElementsNotNull(ds) != 0) {
                panel = new XYPanel(this.configuration);
                panel.setData(pd, ds);
                this.publishPanel(this.perfFrame[25], html, dir, panel, names[i]);
                ++panels;
            }
            ++i;
        }
        this.finishFrame(dir, 25, html, panels);
        return panels;
    }

    private int setupPoolGraphic(String dir) {
        int panels = 0;
        if (this.parser == null) {
            return panels;
        }
        PrintWriter html = this.setupFrame(dir, 42);
        GenericPanel panel = null;
        PerfData pd = this.parser.getPerfData();
        DataSet[] ds = null;
        String[] names = pd.getNames((byte)12);
        if (names == null) {
            return panels;
        }
        this.addSeparator(this.perfFrame[42], html, "Pool Summary");
        ds = new DataSet[names.length];
        int i = 0;
        while (i < names.length) {
            ds[i] = pd.getData((byte)12, i, (byte)1);
            ++i;
        }
        panel = new StackPanel(this.configuration);
        ((StackPanel)panel).setData(pd, ds, names);
        ((StackPanel)panel).setMaxData(pd.getData((byte)0, 0, (byte)3));
        this.publishPanel(this.perfFrame[42], html, dir, panel, "Pool Summary");
        ++panels;
        i = 0;
        while (i < names.length) {
            ds = new DataSet[]{names[i].equals("DefaultPool") ? pd.getData((byte)0, 0, (byte)3) : pd.getData((byte)12, i, (byte)0), pd.getData((byte)12, i, (byte)1)};
            panel = new XYPanel(this.configuration);
            panel.setData(pd, ds);
            this.publishPanel(this.perfFrame[42], html, dir, panel, names[i]);
            ++panels;
            ++i;
        }
        String[] lparNames = this.parser.getParserNames();
        Parser p = null;
        i = 0;
        while (i < names.length) {
            this.addSeparator(this.perfFrame[42], html, names[i]);
            if (this.parser.getParserNames() != null) {
                int k;
                String[] lparPools;
                int num = 0;
                int j = 0;
                while (j < lparNames.length) {
                    if (this.parser.getParser(j) != null && (lparPools = this.parser.getParser(j).getPerfData().getNames((byte)12)) != null) {
                        k = 0;
                        while (k < lparPools.length) {
                            if (lparPools[k].compareTo(names[i]) == 0) {
                                ++num;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                if (num > 0) {
                    ds = new DataSet[num];
                    String[] selectedLpars = new String[num];
                    j = 0;
                    k = 0;
                    while (j < lparNames.length) {
                        p = this.parser.getParser(j);
                        if (p != null && (lparPools = this.parser.getParser(j).getPerfData().getNames((byte)12)) != null) {
                            int w = 0;
                            while (w < lparPools.length) {
                                DataSet dsp;
                                if (lparPools[w].compareTo(names[i]) == 0 && (dsp = p.getPerfData().getData((byte)12, w, (byte)1)) != null) {
                                    ds[k] = dsp;
                                    selectedLpars[k] = lparNames[j];
                                    ++k;
                                    break;
                                }
                                ++w;
                            }
                        }
                        ++j;
                    }
                    DataSet max = names[i].equals("DefaultPool") ? pd.getData((byte)0, 0, (byte)3) : pd.getData((byte)12, i, (byte)0);
                    panel = new StackPanel(this.configuration);
                    ((StackPanel)panel).setData(pd, ds, selectedLpars);
                    ((StackPanel)panel).setMaxData(max);
                    this.publishPanel(this.perfFrame[42], html, dir, panel, String.valueOf(names[i]) + " Summary");
                    ++panels;
                    j = 0;
                    while (j < num) {
                        panel = new XYPanel(this.configuration);
                        DataSet[] ds1 = new DataSet[]{ds[j]};
                        panel.setData(pd, ds1);
                        this.publishPanel(this.perfFrame[42], html, dir, panel, selectedLpars[j]);
                        ++panels;
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.finishFrame(dir, 42, html, panels);
        return panels;
    }

    private void loadCECDirectory(File fileObj) {
        if (this.parserManager.running()) {
            System.out.println("Wait for parser to finish.");
            return;
        }
        this.closeAllFrames();
        this.parser = null;
        this.activateButtons();
        this.parserManager.setSource(fileObj);
        this.parserManager.setSingleHost(false);
        if (this.batchMode) {
            this.parserManager.setLimits(this.batchBegin, this.batchEnd);
        }
        Thread th = new Thread(this.parserManager);
        th.start();
    }

    private void loadConfigurationFile(File fileObj) {
        if (this.parserManager.running()) {
            System.out.println("Wait for parser to finish.");
            return;
        }
        this.closeAllFrames();
        this.parser = null;
        this.activateButtons();
        this.parserManager.setSingleHost(false);
        this.parserManager.setConfigurationFile(fileObj.getAbsolutePath());
        if (this.batchMode) {
            this.parserManager.setLimits(this.batchBegin, this.batchEnd);
        }
        Thread th = new Thread(this.parserManager);
        th.start();
    }

    private void loadSingleFile(File fileObj) {
        if (this.parserManager.running()) {
            System.out.println("Wait for parser to finish.");
            return;
        }
        this.closeAllFrames();
        this.parser = null;
        this.activateButtons();
        this.parserManager.setSource(fileObj);
        if (this.batchMode && this.batchBegin != null && this.batchEnd != null) {
            this.parserManager.setLimits(this.batchBegin, this.batchEnd);
        }
        Thread th = new Thread(this.parserManager);
        th.start();
    }

    public void parsingComplete(String name, Parser p) {
        if (this.parser == null && p != null) {
            this.parser = p;
            this.timePanel.setTime(this.parser.getStart(), this.parser.getEnd());
            this.activateButtons();
        } else {
            this.timePanel.setActive(this.parser.getStart(), this.parser.getEnd());
        }
        this.timePanel.repaint();
        int i = 0;
        while (i < this.perfFrame.length) {
            if (this.perfFrame[i] != null) {
                this.perfFrame[i].zoom();
            }
            ++i;
        }
        String fType = null;
        switch (this.parserManager.getFiletype()) {
            case 1: {
                fType = "[nmon] ";
                break;
            }
            case 2: {
                fType = "[vmstat -t] ";
                break;
            }
            case 6: {
                fType = "[xmtrend] ";
                break;
            }
            case 7: {
                fType = "[topas_cec] ";
                break;
            }
            case 8: {
                fType = "[iostat -alDT] ";
                break;
            }
            case 9: {
                fType = "[lslparutil] ";
                break;
            }
            case 3: {
                fType = "[Directory] ";
                break;
            }
            case 10: {
                fType = "[Configuration file] ";
                break;
            }
            case 11: {
                fType = "[sar] ";
                break;
            }
            case 12: {
                fType = "[Insight] ";
                break;
            }
            case 14: {
                fType = "[Snmp] ";
                break;
            }
            case 13: {
                fType = "[Collectl] ";
                break;
            }
            default: {
                fType = "ERROR! ";
            }
        }
        this.message.setText(String.valueOf(fType) + name);
        this.noDisks.setSelected(this.parser.isAvoidDisk());
        if (this.batchMode) {
            System.out.println("\nCreating PNG");
            this.createAppropriateHTML();
            System.out.println("DONE!!");
        }
    }

    private void loadMultipleFilesSingleHost(File dir) {
        if (this.parserManager.running()) {
            System.out.println("Wait for parser to finish.");
            return;
        }
        this.closeAllFrames();
        this.parser = null;
        this.activateButtons();
        this.parserManager.setSource(dir);
        this.parserManager.setSingleHost(true);
        if (this.batchMode) {
            this.parserManager.setLimits(this.batchBegin, this.batchEnd);
        }
        Thread th = new Thread(this.parserManager);
        th.start();
    }

    private void zoomEvent(GregorianCalendar newBegin, GregorianCalendar newEnd) {
        if (this.parserManager.running()) {
            System.out.println("Wait for parser to finish.");
            return;
        }
        if (this.parser == null) {
            return;
        }
        this.parserManager.setLimits(newBegin, newEnd);
        Thread th = new Thread(this.parserManager);
        th.start();
    }

    private void closeFrame(int id) {
        this.button[id].setSelected(false);
        if (this.perfFrame[id] != null) {
            this.perfFrame[id].dispose();
        }
        this.perfFrame[id] = null;
    }

    private void closeTFrame(int id) {
        this.textButton[id].setSelected(false);
        if (this.textFrame[id] != null) {
            this.textFrame[id].dispose();
        }
        this.textFrame[id] = null;
    }

    private void closeAllFrames() {
        int i = 0;
        while (i < 47) {
            this.closeFrame(i);
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.closeTFrame(i);
            ++i;
        }
    }

    private void createAppropriateHTML() {
        PrintWriter index;
        try {
            index = new PrintWriter(new FileOutputStream(new File(String.valueOf(this.batchOutput) + File.separatorChar + "index.html")));
        }
        catch (IOException e) {
            return;
        }
        byte filetype = this.parserManager.getFiletype();
        if (this.parserManager.getFiletype() == 0) {
            System.out.println("ERROR: unknown input data.");
            return;
        }
        if (filetype != 3 && filetype != 7) {
            index.println("<HTML><HEAD><TITLE>pGraph.Viewer graphs: " + this.parser.getFileName() + "</TITLE></HEAD>");
        } else if (this.parser.getCecName() != null) {
            index.println("<HTML><HEAD><TITLE>pGraph.Viewer graphs: " + this.parser.getCecName() + "</TITLE></HEAD>");
        } else {
            index.println("<HTML><HEAD><TITLE>pGraph.Viewer graphs: multiple systems</TITLE></HEAD>");
        }
        index.println("<frameset framespacing=\"0\" border=\"0\" rows=\"105,*\" frameborder=\"1\">");
        index.println("  <frame name=\"topframe\" scrolling=\"no\" noresize src=\"top.html\" marginwidth=\"0\" marginheight=\"0\">");
        index.println("  <frameset cols=\"215,*\">");
        index.println("    <frame name=\"menuframe\" target=\"graphframe\" src=\"menu.html\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"auto\">");
        index.println("    <frame name=\"graphframe\" src=\"welcome.html\" marginwidth=\"12\" marginheight=\"16\" scrolling=\"auto\">");
        index.println("  </frameset>");
        index.println("</frameset>");
        index.println("</HTML>");
        index.close();
        try {
            index = new PrintWriter(new FileOutputStream(new File(String.valueOf(this.batchOutput) + File.separatorChar + "welcome.html")));
        }
        catch (IOException e) {
            return;
        }
        index.println("<HTML><HEAD><TITLE>Menu</TITLE></HEAD>");
        index.println("<BODY bgcolor=#cccccc>");
        index.println("<H1>Welcome to pGraph generated reports.</H1>");
        index.println("Please select on the left frame the statistics you want to see.");
        index.println("</BODY></HTML>");
        index.close();
        try {
            index = new PrintWriter(new FileOutputStream(new File(String.valueOf(this.batchOutput) + File.separatorChar + "top.html")));
        }
        catch (IOException e) {
            return;
        }
        GregorianCalendar gc = this.parser.getStart();
        int y = gc.get(1);
        int M = gc.get(2) + 1;
        int d = gc.get(5);
        int h = gc.get(11);
        int m = gc.get(12);
        int s = gc.get(13);
        String from = "[" + y + "-" + (M < 10 ? "0" : "") + M + "-" + (d < 10 ? "0" : "") + d + ' ' + (h < 10 ? "0" : "") + h + ":" + (m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s + "]";
        gc = this.parser.getEnd();
        y = gc.get(1);
        M = gc.get(2) + 1;
        d = gc.get(5);
        h = gc.get(11);
        m = gc.get(12);
        s = gc.get(13);
        String to = "[" + y + "-" + (M < 10 ? "0" : "") + M + "-" + (d < 10 ? "0" : "") + d + ' ' + (h < 10 ? "0" : "") + h + ":" + (m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s + "]";
        index.println("<HTML><HEAD><TITLE>Top</TITLE></HEAD>");
        index.println("<BODY bgcolor=#cccccc><CENTER><H1>");
        if (filetype != 3 && filetype != 7 && filetype != 9) {
            index.println("System statistics ");
        } else if (this.parser.getCecName() != null) {
            index.println("CEC " + this.parser.getCecName() + " statistics ");
        } else {
            index.println("Multiple systems statistics ");
        }
        index.println("\n</H1></CENTER>\n");
        index.println("<P><CENTER>from " + from + " to " + to + "</CENTER>\n");
        index.println("</HTML>");
        index.close();
        try {
            index = new PrintWriter(new FileOutputStream(new File(String.valueOf(this.batchOutput) + File.separatorChar + "menu.html")));
        }
        catch (IOException e) {
            return;
        }
        index.println("<HTML><HEAD><TITLE>Menu</TITLE></HEAD>");
        index.println("<BODY bgcolor=#cccccc>");
        index.println("<BR><UL>");
        if (this.setupCPUGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 0);
        }
        if (this.setupPoolGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 42);
        }
        if (this.setupMemoryGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 1);
        }
        if (this.setupKernelGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 12);
        }
        if (this.setupSyscallGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 13);
        }
        if (this.setupDiskBusyGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 2);
        }
        if (this.setupESSBusyGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 41);
        }
        if (this.setupDiskRWGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 3);
        }
        if (this.setupDiskXferGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 4);
        }
        if (this.setupDiskBlockGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 5);
        }
        if (this.setupDiskReadServiceGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 14);
        }
        if (this.setupDiskWriteServiceGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 15);
        }
        if (this.setupDiskReadWriteServiceGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 43);
        }
        if (this.setupDiskRWTimeoutGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 16);
        }
        if (this.setupDiskWaitQTimeGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 18);
        }
        if (this.setupDiskQueueSizeGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 19);
        }
        if (this.setupDiskServiceQFullGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 20);
        }
        if (this.setupEssRWGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 6);
        }
        if (this.setupEssXferGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 7);
        }
        if (this.setupAdapterRWGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 8);
        }
        if (this.setupFibreRWGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 33);
        }
        if (this.setupAdapterXferGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 9);
        }
        if (this.setupFibreXferGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 33);
        }
        if (this.setupAdapterReadServiceGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 21);
        }
        if (this.setupAdapterWriteServiceGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 22);
        }
        if (this.setupAdapterWaitQTimeGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 23);
        }
        if (this.setupAdapterQueueSizeGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 24);
        }
        if (this.setupAdapterServiceQFullGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 25);
        }
        if (this.setupNetworkRWGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 10);
        }
        if (this.setupSEAGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 44);
        }
        if (this.setupWPAR_CPU_Graphic(this.batchOutput) > 0) {
            this.addMenu(index, 26);
        }
        if (this.setupWPAR_Memory_Graphic(this.batchOutput) > 0) {
            this.addMenu(index, 27);
        }
        if (this.setupWPAR_Disk_Graphic(this.batchOutput) > 0) {
            this.addMenu(index, 28);
        }
        if (this.setupTopCPU_Graphic(this.batchOutput) > 0) {
            this.addMenu(index, 29);
        }
        if (this.setupTopRAM_Graphic(this.batchOutput) > 0) {
            this.addMenu(index, 30);
        }
        if (this.setupFS_Graphic(this.batchOutput) > 0) {
            this.addMenu(index, 31);
        }
        if (this.setupAIO_Graphic(this.batchOutput) > 0) {
            this.addMenu(index, 32);
        }
        if (this.setupDiskServiceGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 37);
        }
        if (this.setupEssServiceGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 39);
        }
        if (this.setupDiskWaitGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 38);
        }
        if (this.setupEssWaitGraphic(this.batchOutput) > 0) {
            this.addMenu(index, 40);
        }
        index.println("</BODY></HTML>");
        index.close();
    }

    private void addMenu(PrintWriter html, int frameId) {
        html.println("<LI><A HREF=\"" + this.frameHtmlFile(frameId) + "\" target=\"graphframe\">" + this.frameDescription(frameId) + "</A>");
        System.out.print(" " + this.frameDescription(frameId) + ": done!\n");
    }

    private PrintWriter setupFrame(String dir, int frameId) {
        boolean newFrame = false;
        if (this.parser == null) {
            return null;
        }
        String frameName = this.frameDescription(frameId);
        String htmlName = this.frameHtmlFile(frameId);
        PrintWriter html = null;
        if (dir != null) {
            if (dir.charAt(dir.length() - 1) != File.separatorChar) {
                dir = String.valueOf(dir) + File.separatorChar;
            }
            try {
                html = new PrintWriter(new FileOutputStream(new File(String.valueOf(dir) + htmlName)));
            }
            catch (IOException e) {
                return null;
            }
            html.println("<HTML>\n<HEAD><TITLE>" + frameName + "</TITLE></HEAD>\n" + "<BODY bgcolor=#cccccc>\n" + "<H1>" + frameName + "</H1>\n");
        }
        if (dir == null) {
            if (this.perfFrame[frameId] == null) {
                this.perfFrame[frameId] = new GenericFrame(frameName, this.configuration);
                newFrame = true;
            } else {
                this.perfFrame[frameId].reset();
                newFrame = false;
            }
        }
        if (newFrame) {
            this.FRAME_X = 480 + DataSet.SLOTS;
            this.FRAME_Y = 450;
            this.perfFrame[frameId].setSize(this.FRAME_X, this.FRAME_Y);
            this.perfFrame[frameId].setDefaultCloseOperation(2);
            this.perfFrame[frameId].addWindowListener(this.myEventHandler);
            this.perfFrame[frameId].addPropertyChangeListener(this.myEventHandler);
            this.perfFrame[frameId].setVisible(true);
        } else if (this.perfFrame[frameId] != null) {
            this.perfFrame[frameId].repaint();
        }
        return html;
    }

    private void finishFrame(String dir, int frameId, PrintWriter html, int numPanels) {
        if (this.perfFrame[frameId] != null) {
            this.perfFrame[frameId].repaint();
        }
        if (html != null) {
            html.println("</BODY></HTML>\n");
            html.close();
            if (numPanels == 0 && dir != null) {
                String htmlName = this.frameHtmlFile(frameId);
                if (dir.charAt(dir.length() - 1) != File.separatorChar) {
                    dir = String.valueOf(dir) + File.separatorChar;
                }
                File file = new File(String.valueOf(dir) + htmlName);
                file.delete();
            }
        }
    }

    private String frameHtmlFile(int id) {
        switch (id) {
            case 0: {
                return "cpu.html";
            }
            case 42: {
                return "procpool.html";
            }
            case 1: {
                return "memory.html";
            }
            case 2: {
                return "diskbusy.html";
            }
            case 41: {
                return "mpiobusy.html";
            }
            case 3: {
                return "diskrw.html";
            }
            case 4: {
                return "diskxfers.html";
            }
            case 5: {
                return "disksize.html";
            }
            case 6: {
                return "vpathrw.html";
            }
            case 7: {
                return "vpathxfers.html";
            }
            case 8: {
                return "adapterRW.html";
            }
            case 9: {
                return "adapterXfer.html";
            }
            case 33: {
                return "fibreRW.html";
            }
            case 34: {
                return "fibreXfer.html";
            }
            case 35: {
                return "dacRW.html";
            }
            case 36: {
                return "dacXfer.html";
            }
            case 10: {
                return "network.html";
            }
            case 11: {
                return null;
            }
            case 12: {
                return "kernel.html";
            }
            case 13: {
                return "syscall.html";
            }
            case 14: {
                return "diskrservice.html";
            }
            case 15: {
                return "diskwservice.html";
            }
            case 43: {
                return "diskrwservice.html";
            }
            case 37: {
                return "diskservice.html";
            }
            case 39: {
                return "essservice.html";
            }
            case 38: {
                return "diskwait.html";
            }
            case 40: {
                return "esswait.html";
            }
            case 16: {
                return "diskrwtimeout.html";
            }
            case 17: {
                return "diskrwfail.html";
            }
            case 18: {
                return "diskwqt.html";
            }
            case 19: {
                return "diskqs.html";
            }
            case 20: {
                return "diskqf.html";
            }
            case 21: {
                return "adapterRservice.html";
            }
            case 22: {
                return "adapterWservice.html";
            }
            case 23: {
                return "adapterwqt.html";
            }
            case 24: {
                return "adapterqs.html";
            }
            case 25: {
                return "adapterqf.html";
            }
            case 26: {
                return "wpar_cpu.html";
            }
            case 27: {
                return "wpar_ram.html";
            }
            case 28: {
                return "wpar_disk.html";
            }
            case 29: {
                return "top_procs_cpu.html";
            }
            case 30: {
                return "top_procs_mem.html";
            }
            case 31: {
                return "file_system.html";
            }
            case 32: {
                return "asyncio.html";
            }
            case 44: {
                return "SEA.html";
            }
            case 45: {
                return "pcpu.html";
            }
            case 46: {
                return "memdetail.html";
            }
        }
        System.out.println("frameHtmlFile(): unknown frameId");
        return null;
    }

    private String frameDescription(int id) {
        switch (id) {
            case 0: {
                return "CPU Usage";
            }
            case 42: {
                return "Shared ProcPools";
            }
            case 1: {
                return "Memory Usage";
            }
            case 2: {
                return "Disk Busy";
            }
            case 41: {
                return "MPIO Device Busy";
            }
            case 3: {
                return "Disk RW Rates";
            }
            case 4: {
                return "Disk Transfers";
            }
            case 5: {
                return "Disk I/O Size";
            }
            case 6: {
                return "MPIO RW Rates";
            }
            case 7: {
                return "MPIO Transfers";
            }
            case 8: {
                return "Disk Adapter RW Rates";
            }
            case 9: {
                return "Disk Adapter Transfers";
            }
            case 33: {
                return "Fibre Channel RW Rates";
            }
            case 34: {
                return "Fibre Channel Transfers";
            }
            case 35: {
                return "Dac RW rates";
            }
            case 36: {
                return "Dac transfers";
            }
            case 10: {
                return "Network RW Rates";
            }
            case 11: {
                return null;
            }
            case 12: {
                return "Kernel";
            }
            case 13: {
                return "System Calls";
            }
            case 14: {
                return "Disk Read Service";
            }
            case 15: {
                return "Disk Write Service";
            }
            case 43: {
                return "Disk Read+Write Service";
            }
            case 37: {
                return "Disk Service";
            }
            case 39: {
                return "MPIO Service";
            }
            case 38: {
                return "Disk Wait Time";
            }
            case 40: {
                return "MPIO Wait Time";
            }
            case 16: {
                return "Disk Read/Write Timeouts";
            }
            case 17: {
                return "Disk Read/Write Failures";
            }
            case 18: {
                return "Disk Wait Queue Time Spent";
            }
            case 19: {
                return "Disk Wait&Service Queue Size";
            }
            case 20: {
                return "Disk service queue full";
            }
            case 21: {
                return "Adapter Read Service";
            }
            case 22: {
                return "Adapter Write Service";
            }
            case 23: {
                return "Adapter Wait Queue Time Spent";
            }
            case 24: {
                return "Adapter Wait&Service Queue Size";
            }
            case 25: {
                return "Adapter service queue full";
            }
            case 26: {
                return "WLM CPU Usage";
            }
            case 27: {
                return "WLM MEM% Usage";
            }
            case 28: {
                return "WLM Disk Usage";
            }
            case 29: {
                return "Top processes CPU usage";
            }
            case 30: {
                return "Top processes memory usage";
            }
            case 31: {
                return "File System usage";
            }
            case 32: {
                return "Asynchronous IO usage";
            }
            case 44: {
                return "SEA Statistics";
            }
            case 45: {
                return "Per CPU Physical Usage";
            }
            case 46: {
                return "Memory details by page size";
            }
        }
        System.out.println("frameDescription(): unknown frameId");
        return null;
    }

    public void showReadProgress(int p) {
        this.firePropertyChange("read_progress", null, new Integer(p));
    }

    public void setProgressValue(int v) {
        this.progressBar.setValue(v);
        if (this.batchMode) {
            if (v == 0) {
                System.out.println();
            }
            System.out.print("#");
        }
    }

    public void setProgressIndeterminate(boolean v) {
        this.progressBar.setIndeterminate(v);
    }

    public void setProgressMessage(String s) {
        this.message.setText(s);
        if (this.batchMode) {
            System.out.println(s);
        }
    }

    public void setBatchMode(String batchOutput) {
        this.batchMode = true;
        this.batchOutput = batchOutput;
    }

    private void setupAffinityText(String dir) {
        if (this.parser == null) {
            return;
        }
        PerfData pd = this.parser.getPerfData();
        int num = pd.getNumLssrad();
        this.textFrame[0] = new TextFrame();
        this.textFrame[0].addWindowListener(this.myEventHandler);
        this.textFrame[0].addPropertyChangeListener(this.myEventHandler);
        this.textFrame[0].setVisible(true);
        this.textFrame[0].setTitle("Affinity");
        this.textFrame[0].setHeader(new String[]{"REF1", "SRAD", "MEM", "CPU"});
        int i = 0;
        while (i < num) {
            String[] ss = new String[]{pd.getLssradRef1(i), pd.getLssradSrad(i), pd.getLssradMem(i), pd.getLssradCpu(i)};
            this.textFrame[0].addTableRow(ss);
            ++i;
        }
        this.textFrame[0].reset();
    }

    private void setupLparstatiText(String dir) {
        String[] r;
        if (this.parser == null) {
            return;
        }
        PerfData pd = this.parser.getPerfData();
        this.textFrame[1] = new TextFrame();
        this.textFrame[1].setTitle("LPAR Configuration");
        this.textFrame[1].setHeader(new String[]{"Variable", "Value"});
        int i = 0;
        while ((r = pd.getTextlabelNum((byte)0, i++)) != null) {
            this.textFrame[1].addTableRow(r);
        }
        this.textFrame[1].addWindowListener(this.myEventHandler);
        this.textFrame[1].addPropertyChangeListener(this.myEventHandler);
        this.textFrame[1].setVisible(true);
        this.textFrame[1].reset();
    }

    private void setupVmstatvText(String dir) {
        if (this.parser == null) {
            return;
        }
        PerfData pd = this.parser.getPerfData();
        this.textFrame[2] = new TextFrame();
        this.textFrame[2].setTitle("vmstat -v");
        this.textFrame[2].setHeader(new String[]{"Variable", "Start value", "End value"});
        int i = 0;
        String[] result = null;
        boolean stop = false;
        while (!stop) {
            String[] before = pd.getTextlabelNum((byte)1, i);
            String[] end = pd.getTextlabelNum((byte)2, i);
            if (before == null) {
                stop = true;
                continue;
            }
            result = new String[]{before[0], before[1], end[1]};
            this.textFrame[2].addTableRow(result);
            ++i;
        }
        this.textFrame[2].addWindowListener(this.myEventHandler);
        this.textFrame[2].addPropertyChangeListener(this.myEventHandler);
        this.textFrame[2].setVisible(true);
        this.textFrame[2].reset();
    }

    class MyEventHandler
    implements ChangeListener,
    ItemListener,
    ActionListener,
    ComponentListener,
    WindowListener,
    PropertyChangeListener {
        MyEventHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Vector v;
            if (evt.getPropertyName().equals("zoomEvent")) {
                v = (Vector)evt.getNewValue();
                long delta = Viewer.this.timePanel.getMaxActive().getTimeInMillis() - Viewer.this.timePanel.getMinActive().getTimeInMillis();
                GregorianCalendar newBegin = new GregorianCalendar();
                GregorianCalendar newEnd = new GregorianCalendar();
                newBegin.setTimeInMillis(Viewer.this.timePanel.getMinActive().getTimeInMillis() + (long)(1.0f * (float)((Integer)v.elementAt(0)).intValue() * (float)delta / (float)(DataSet.SLOTS - 1)));
                newEnd.setTimeInMillis(Viewer.this.timePanel.getMinActive().getTimeInMillis() + (long)(1.0f * (float)((Integer)v.elementAt(1)).intValue() * (float)delta / (float)(DataSet.SLOTS - 1)));
                Viewer.this.zoomEvent(newBegin, newEnd);
            }
            if (evt.getPropertyName().equals("errorBar")) {
                v = (Vector)evt.getNewValue();
                Boolean b = (Boolean)v.elementAt(0);
                int i = 0;
                while (i < Viewer.this.perfFrame.length) {
                    if (Viewer.this.perfFrame[i] != null) {
                        Viewer.this.perfFrame[i].showErrorBars(b);
                    }
                    ++i;
                }
            }
        }

        public void stateChanged(ChangeEvent e) {
        }

        public void actionPerformed(ActionEvent e) {
            int rc;
            if (e.getSource() == Viewer.this.zoomButton) {
                Viewer.this.zoomEvent(Viewer.this.timePanel.getMinZoom(), Viewer.this.timePanel.getMaxZoom());
            }
            if (e.getSource() == Viewer.this.exitMenuItem) {
                if (Viewer.this.applet == null) {
                    System.exit(0);
                } else {
                    Viewer.this.closeAllFrames();
                    Viewer.this.parser = null;
                    Viewer.this.setVisible(false);
                }
            }
            if (e.getSource() == Viewer.this.openFileMenu) {
                Viewer.this.openFileDialog.setFileSelectionMode(0);
                Viewer.this.openFileDialog.setMultiSelectionEnabled(false);
                rc = Viewer.this.openFileDialog.showOpenDialog(Viewer.this.openFileMenu);
                if (rc == 0) {
                    Viewer.this.loadSingleFile(Viewer.this.openFileDialog.getSelectedFile());
                }
            }
            if (e.getSource() == Viewer.this.aboutMenu) {
                if (Viewer.this.about == null) {
                    Viewer.this.about = new About();
                }
                Viewer.this.about.setDefaultCloseOperation(2);
                Viewer.this.about.setVisible(true);
            }
            if (e.getSource() == Viewer.this.consoleMenu) {
                Viewer.this.console.setVisible(true);
            }
            if (e.getSource() == Viewer.this.openMMDirMenu) {
                Viewer.this.openFileDialog.setFileSelectionMode(1);
                Viewer.this.openFileDialog.setMultiSelectionEnabled(false);
                rc = Viewer.this.openFileDialog.showOpenDialog(Viewer.this.openMMDirMenu);
                if (rc == 0) {
                    Viewer.this.loadCECDirectory(Viewer.this.openFileDialog.getSelectedFile());
                }
            }
            if (e.getSource() == Viewer.this.openCfgMenu) {
                Viewer.this.openFileDialog.setFileSelectionMode(0);
                Viewer.this.openFileDialog.setMultiSelectionEnabled(false);
                rc = Viewer.this.openFileDialog.showOpenDialog(Viewer.this.openCfgMenu);
                if (rc == 0) {
                    Viewer.this.loadConfigurationFile(Viewer.this.openFileDialog.getSelectedFile());
                }
            }
            if (e.getSource() == Viewer.this.openSMDirMenu) {
                Viewer.this.openFileDialog.setFileSelectionMode(1);
                Viewer.this.openFileDialog.setMultiSelectionEnabled(false);
                rc = Viewer.this.openFileDialog.showOpenDialog(Viewer.this.openSMDirMenu);
                if (rc == 0) {
                    Viewer.this.loadMultipleFilesSingleHost(Viewer.this.openFileDialog.getSelectedFile());
                }
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
            int i = 0;
            while (i < 47) {
                if (e.getSource() == Viewer.this.perfFrame[i]) {
                    Viewer.this.closeFrame(i);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < 3) {
                if (e.getSource() == Viewer.this.textFrame[i]) {
                    Viewer.this.closeTFrame(i);
                    return;
                }
                ++i;
            }
        }

        public void windowClosing(WindowEvent e) {
            if (e.getSource() == Viewer.this) {
                if (Viewer.this.applet == null) {
                    System.exit(0);
                } else {
                    Viewer.this.closeAllFrames();
                    Viewer.this.parser = null;
                    Viewer.this.setVisible(false);
                }
            }
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == Viewer.this.noDisks) {
                if (Viewer.this.noDisks.isSelected()) {
                    if (Viewer.this.parser != null) {
                        Viewer.this.parser.setAvoidDisk(true);
                    }
                } else if (Viewer.this.parser != null) {
                    Viewer.this.parser.setAvoidDisk(false);
                }
            }
            if (e.getSource() == Viewer.this.button[0]) {
                if (Viewer.this.button[0].isSelected()) {
                    Viewer.this.setupCPUGraphic(null);
                } else {
                    Viewer.this.closeFrame(0);
                }
            }
            if (e.getSource() == Viewer.this.button[45]) {
                if (Viewer.this.button[45].isSelected()) {
                    Viewer.this.setupPCPUGraphic(null);
                } else {
                    Viewer.this.closeFrame(45);
                }
            }
            if (e.getSource() == Viewer.this.button[46]) {
                if (Viewer.this.button[46].isSelected()) {
                    Viewer.this.setupMemDetailsGraphic(null);
                } else {
                    Viewer.this.closeFrame(46);
                }
            }
            if (e.getSource() == Viewer.this.button[1]) {
                if (Viewer.this.button[1].isSelected()) {
                    Viewer.this.setupMemoryGraphic(null);
                } else {
                    Viewer.this.closeFrame(1);
                }
            }
            if (e.getSource() == Viewer.this.button[2]) {
                if (Viewer.this.button[2].isSelected()) {
                    Viewer.this.setupDiskBusyGraphic(null);
                } else {
                    Viewer.this.closeFrame(2);
                }
            }
            if (e.getSource() == Viewer.this.button[41]) {
                if (Viewer.this.button[41].isSelected()) {
                    Viewer.this.setupESSBusyGraphic(null);
                } else {
                    Viewer.this.closeFrame(41);
                }
            }
            if (e.getSource() == Viewer.this.button[42]) {
                if (Viewer.this.button[42].isSelected()) {
                    Viewer.this.setupPoolGraphic(null);
                } else {
                    Viewer.this.closeFrame(42);
                }
            }
            if (e.getSource() == Viewer.this.button[3]) {
                if (Viewer.this.button[3].isSelected()) {
                    Viewer.this.setupDiskRWGraphic(null);
                } else {
                    Viewer.this.closeFrame(3);
                }
            }
            if (e.getSource() == Viewer.this.button[4]) {
                if (Viewer.this.button[4].isSelected()) {
                    Viewer.this.setupDiskXferGraphic(null);
                } else {
                    Viewer.this.closeFrame(4);
                }
            }
            if (e.getSource() == Viewer.this.button[6]) {
                if (Viewer.this.button[6].isSelected()) {
                    Viewer.this.setupEssRWGraphic(null);
                } else {
                    Viewer.this.closeFrame(6);
                }
            }
            if (e.getSource() == Viewer.this.button[7]) {
                if (Viewer.this.button[7].isSelected()) {
                    Viewer.this.setupEssXferGraphic(null);
                } else {
                    Viewer.this.closeFrame(7);
                }
            }
            if (e.getSource() == Viewer.this.button[5]) {
                if (Viewer.this.button[5].isSelected()) {
                    Viewer.this.setupDiskBlockGraphic(null);
                } else {
                    Viewer.this.closeFrame(5);
                }
            }
            if (e.getSource() == Viewer.this.button[8]) {
                if (Viewer.this.button[8].isSelected()) {
                    Viewer.this.setupAdapterRWGraphic(null);
                } else {
                    Viewer.this.closeFrame(8);
                }
            }
            if (e.getSource() == Viewer.this.button[9]) {
                if (Viewer.this.button[9].isSelected()) {
                    Viewer.this.setupAdapterXferGraphic(null);
                } else {
                    Viewer.this.closeFrame(9);
                }
            }
            if (e.getSource() == Viewer.this.button[33]) {
                if (Viewer.this.button[33].isSelected()) {
                    Viewer.this.setupFibreRWGraphic(null);
                } else {
                    Viewer.this.closeFrame(33);
                }
            }
            if (e.getSource() == Viewer.this.button[34]) {
                if (Viewer.this.button[34].isSelected()) {
                    Viewer.this.setupFibreXferGraphic(null);
                } else {
                    Viewer.this.closeFrame(34);
                }
            }
            if (e.getSource() == Viewer.this.button[35]) {
                if (Viewer.this.button[35].isSelected()) {
                    Viewer.this.setupDacRWGraphic(null);
                } else {
                    Viewer.this.closeFrame(35);
                }
            }
            if (e.getSource() == Viewer.this.button[36]) {
                if (Viewer.this.button[36].isSelected()) {
                    Viewer.this.setupDacXferGraphic(null);
                } else {
                    Viewer.this.closeFrame(36);
                }
            }
            if (e.getSource() == Viewer.this.button[10]) {
                if (Viewer.this.button[10].isSelected()) {
                    Viewer.this.setupNetworkRWGraphic(null);
                } else {
                    Viewer.this.closeFrame(10);
                }
            }
            if (e.getSource() == Viewer.this.button[44]) {
                if (Viewer.this.button[44].isSelected()) {
                    Viewer.this.setupSEAGraphic(null);
                } else {
                    Viewer.this.closeFrame(44);
                }
            }
            if (e.getSource() == Viewer.this.button[12]) {
                if (Viewer.this.button[12].isSelected()) {
                    Viewer.this.setupKernelGraphic(null);
                } else {
                    Viewer.this.closeFrame(12);
                }
            }
            if (e.getSource() == Viewer.this.button[13]) {
                if (Viewer.this.button[13].isSelected()) {
                    Viewer.this.setupSyscallGraphic(null);
                } else {
                    Viewer.this.closeFrame(13);
                }
            }
            if (e.getSource() == Viewer.this.button[14]) {
                if (Viewer.this.button[14].isSelected()) {
                    Viewer.this.setupDiskReadServiceGraphic(null);
                } else {
                    Viewer.this.closeFrame(14);
                }
            }
            if (e.getSource() == Viewer.this.button[15]) {
                if (Viewer.this.button[15].isSelected()) {
                    Viewer.this.setupDiskWriteServiceGraphic(null);
                } else {
                    Viewer.this.closeFrame(15);
                }
            }
            if (e.getSource() == Viewer.this.button[43]) {
                if (Viewer.this.button[43].isSelected()) {
                    Viewer.this.setupDiskReadWriteServiceGraphic(null);
                } else {
                    Viewer.this.closeFrame(43);
                }
            }
            if (e.getSource() == Viewer.this.button[37]) {
                if (Viewer.this.button[37].isSelected()) {
                    Viewer.this.setupDiskServiceGraphic(null);
                } else {
                    Viewer.this.closeFrame(37);
                }
            }
            if (e.getSource() == Viewer.this.button[39]) {
                if (Viewer.this.button[39].isSelected()) {
                    Viewer.this.setupEssServiceGraphic(null);
                } else {
                    Viewer.this.closeFrame(39);
                }
            }
            if (e.getSource() == Viewer.this.button[38]) {
                if (Viewer.this.button[38].isSelected()) {
                    Viewer.this.setupDiskWaitGraphic(null);
                } else {
                    Viewer.this.closeFrame(38);
                }
            }
            if (e.getSource() == Viewer.this.button[40]) {
                if (Viewer.this.button[40].isSelected()) {
                    Viewer.this.setupEssWaitGraphic(null);
                } else {
                    Viewer.this.closeFrame(40);
                }
            }
            if (e.getSource() == Viewer.this.button[16]) {
                if (Viewer.this.button[16].isSelected()) {
                    Viewer.this.setupDiskRWTimeoutGraphic(null);
                } else {
                    Viewer.this.closeFrame(16);
                }
            }
            if (e.getSource() == Viewer.this.button[17]) {
                if (Viewer.this.button[17].isSelected()) {
                    Viewer.this.setupDiskRWFailedGraphic(null);
                } else {
                    Viewer.this.closeFrame(17);
                }
            }
            if (e.getSource() == Viewer.this.button[18]) {
                if (Viewer.this.button[18].isSelected()) {
                    Viewer.this.setupDiskWaitQTimeGraphic(null);
                } else {
                    Viewer.this.closeFrame(18);
                }
            }
            if (e.getSource() == Viewer.this.button[19]) {
                if (Viewer.this.button[19].isSelected()) {
                    Viewer.this.setupDiskQueueSizeGraphic(null);
                } else {
                    Viewer.this.closeFrame(19);
                }
            }
            if (e.getSource() == Viewer.this.button[20]) {
                if (Viewer.this.button[20].isSelected()) {
                    Viewer.this.setupDiskServiceQFullGraphic(null);
                } else {
                    Viewer.this.closeFrame(20);
                }
            }
            if (e.getSource() == Viewer.this.button[21]) {
                if (Viewer.this.button[21].isSelected()) {
                    Viewer.this.setupAdapterReadServiceGraphic(null);
                } else {
                    Viewer.this.closeFrame(21);
                }
            }
            if (e.getSource() == Viewer.this.button[22]) {
                if (Viewer.this.button[22].isSelected()) {
                    Viewer.this.setupAdapterWriteServiceGraphic(null);
                } else {
                    Viewer.this.closeFrame(22);
                }
            }
            if (e.getSource() == Viewer.this.button[23]) {
                if (Viewer.this.button[23].isSelected()) {
                    Viewer.this.setupAdapterWaitQTimeGraphic(null);
                } else {
                    Viewer.this.closeFrame(23);
                }
            }
            if (e.getSource() == Viewer.this.button[24]) {
                if (Viewer.this.button[24].isSelected()) {
                    Viewer.this.setupAdapterQueueSizeGraphic(null);
                } else {
                    Viewer.this.closeFrame(24);
                }
            }
            if (e.getSource() == Viewer.this.button[25]) {
                if (Viewer.this.button[25].isSelected()) {
                    Viewer.this.setupAdapterServiceQFullGraphic(null);
                } else {
                    Viewer.this.closeFrame(25);
                }
            }
            if (e.getSource() == Viewer.this.button[26]) {
                if (Viewer.this.button[26].isSelected()) {
                    Viewer.this.setupWPAR_CPU_Graphic(null);
                } else {
                    Viewer.this.closeFrame(26);
                }
            }
            if (e.getSource() == Viewer.this.button[27]) {
                if (Viewer.this.button[27].isSelected()) {
                    Viewer.this.setupWPAR_Memory_Graphic(null);
                } else {
                    Viewer.this.closeFrame(27);
                }
            }
            if (e.getSource() == Viewer.this.button[28]) {
                if (Viewer.this.button[28].isSelected()) {
                    Viewer.this.setupWPAR_Disk_Graphic(null);
                } else {
                    Viewer.this.closeFrame(28);
                }
            }
            if (e.getSource() == Viewer.this.button[29]) {
                if (Viewer.this.button[29].isSelected()) {
                    Viewer.this.setupTopCPU_Graphic(null);
                } else {
                    Viewer.this.closeFrame(29);
                }
            }
            if (e.getSource() == Viewer.this.button[30]) {
                if (Viewer.this.button[30].isSelected()) {
                    Viewer.this.setupTopRAM_Graphic(null);
                } else {
                    Viewer.this.closeFrame(30);
                }
            }
            if (e.getSource() == Viewer.this.button[31]) {
                if (Viewer.this.button[31].isSelected()) {
                    Viewer.this.setupFS_Graphic(null);
                } else {
                    Viewer.this.closeFrame(31);
                }
            }
            if (e.getSource() == Viewer.this.button[32]) {
                if (Viewer.this.button[32].isSelected()) {
                    Viewer.this.setupAIO_Graphic(null);
                } else {
                    Viewer.this.closeFrame(32);
                }
            }
            if (e.getSource() == Viewer.this.textButton[0]) {
                if (Viewer.this.textButton[0].isSelected()) {
                    Viewer.this.setupAffinityText(null);
                } else {
                    Viewer.this.closeTFrame(0);
                }
            }
            if (e.getSource() == Viewer.this.textButton[1]) {
                if (Viewer.this.textButton[1].isSelected()) {
                    Viewer.this.setupLparstatiText(null);
                } else {
                    Viewer.this.closeTFrame(1);
                }
            }
            if (e.getSource() == Viewer.this.textButton[2]) {
                if (Viewer.this.textButton[2].isSelected()) {
                    Viewer.this.setupVmstatvText(null);
                } else {
                    Viewer.this.closeTFrame(2);
                }
            }
        }
    }
}

