/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.util.GregorianCalendar;
import java.util.Vector;
import pGraph.Parser;
import pGraph.ParserManager;

public class Parser_Nmon
extends Parser {
    private static final byte AIX = 0;
    private static final byte LINUX = 1;
    private byte operatingSystem = 0;
    private byte smt = 0;

    public Parser_Nmon(ParserManager v) {
        this.manager = v;
    }

    public void scanTimeLimits() {
        try {
            this.parseTimeLimits();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.start != null && this.end != null) {
            this.valid = true;
        }
    }

    private void parseTimeLimits() throws Exception {
        GregorianCalendar gc = null;
        int MAXWAIT = 10;
        boolean aaaFound = false;
        BufferedReader br = this.getReader();
        while (true) {
            String line;
            if ((line = br.readLine()) == null) {
                if (this.start == null || this.end == null) break;
                this.valid = true;
                break;
            }
            ++this.total_lines;
            if (!aaaFound && line.startsWith("AAA")) {
                aaaFound = true;
            }
            if (!aaaFound && this.total_lines > 10) {
                return;
            }
            if (!line.startsWith("ZZZZ") || line.length() < 19) continue;
            if ((gc = this.parseDate(line, gc)) == null) {
                System.out.println("Error in line " + this.total_lines + " " + line);
                continue;
            }
            if (this.start == null || gc.before(this.start)) {
                this.start = gc;
            }
            if (this.end != null && !gc.after(this.end)) continue;
            this.end = gc;
        }
    }

    public void parseData(boolean firstParse, boolean lastParse) {
        block4: {
            if (this.start == null || this.end == null) {
                return;
            }
            if (firstParse) {
                this.avoidTop = false;
            }
            try {
                this.int_parseData(firstParse, lastParse);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.fileName) + ": Warning, incomplete parsing of nmon data (line " + this.current_file_line_read + ")");
                if (!lastParse) break block4;
                this.endOfData();
            }
        }
        this.firstRun = false;
    }

    private void int_parseData(boolean firstParse, boolean lastParse) throws Exception {
        String line;
        GregorianCalendar gc = null;
        String timeLabel = "";
        int slot = -1;
        String lastType = null;
        Vector diskLabel = new Vector();
        Vector essLabel = new Vector();
        Vector<String> scsiLabel = new Vector<String>();
        Vector<String> networkLabel = new Vector<String>();
        Vector fsLabel = new Vector();
        Vector wlmLabel = new Vector();
        Vector fcLabel = new Vector();
        Vector<String> seaLabel = new Vector<String>();
        boolean suppressFCwarning = false;
        boolean suppressJFSwarning = false;
        int diskRead = 0;
        int essRead = 0;
        String diskName = null;
        String cpu = null;
        String mem = null;
        String srad = null;
        String ref1 = null;
        if (firstParse) {
            this.perfData.setLimits(this.start, this.end);
            this.lines_read = 0;
        }
        this.current_file_line_read = 0;
        BufferedReader br = this.getReader();
        block67: while ((line = this.readLineAndShowProgress(br)) != null) {
            float f8;
            float f7;
            float f6;
            float f5;
            float f4;
            float f3;
            float f2;
            float f1;
            int j;
            int i;
            Vector v;
            block213: {
                int type;
                String cpuName;
                if (line.length() == 0) continue;
                v = this.splitLine(line);
                if (((String)v.elementAt(0)).equals("AAA") && line.toLowerCase().contains("linux")) {
                    this.operatingSystem = 1;
                }
                if (((String)v.elementAt(0)).equals("ZZZZ")) {
                    if ((gc = this.parseDate(v, gc)) == null) {
                        System.out.println("Error in line " + this.current_file_line_read + " " + line);
                        continue;
                    }
                    timeLabel = gc.before(this.start) || gc.after(this.end) ? null : (String)v.elementAt(1);
                    slot = this.getSlot(gc);
                    diskRead = 0;
                    essRead = 0;
                    continue;
                }
                if (((String)v.elementAt(0)).equals("BBBP") && v.size() >= 5 && ((String)v.elementAt(3)).indexOf("systemid") >= 0) {
                    this.cecName = ((String)v.elementAt(4)).substring(0, 9);
                    continue;
                }
                if (((String)v.elementAt(0)).equals("BBBP") && v.size() >= 3 && ((String)v.elementAt(2)).equals("lssrad")) {
                    if (v.size() == 3) {
                        cpu = null;
                        mem = null;
                        srad = null;
                        ref1 = null;
                        continue;
                    }
                    if (((String)v.elementAt(3)).startsWith("\"REF1")) continue;
                    if (!((String)v.elementAt(3)).startsWith("\" ")) {
                        if (ref1 != null) {
                            cpu = null;
                            mem = null;
                            srad = null;
                            ref1 = null;
                        }
                        ref1 = (String)v.elementAt(3);
                        ref1 = ref1.substring(1, ref1.length() - 1);
                        continue;
                    }
                    String[] ss = ((String)v.elementAt(3)).replaceAll("\"", "").trim().split(" {2,}");
                    srad = ss[0];
                    mem = ss[1];
                    cpu = ss.length >= 3 ? ss[2] : null;
                    this.perfData.addLssrad(ref1, srad, mem, cpu);
                    continue;
                }
                if (((String)v.elementAt(0)).equals("BBBP") && v.size() >= 3 && ((String)v.elementAt(2)).equals("lparstat -i")) {
                    if (v.size() == 3) continue;
                    String[] ss = ((String)v.elementAt(3)).replaceAll("\"", "").split(":");
                    this.perfData.addTextLabel((byte)0, ss[0].trim(), ss[1].trim());
                    continue;
                }
                if (((String)v.elementAt(0)).equals("BBBP") && v.size() >= 3 && ((String)v.elementAt(2)).equals("vmstat -v")) {
                    if (v.size() == 3) continue;
                    String[] ss = new String[2];
                    String s = ((String)v.elementAt(3)).replaceAll("\"", "").trim();
                    int pos = s.indexOf(32);
                    ss[0] = s.substring(pos + 1);
                    ss[1] = s.substring(0, pos);
                    this.perfData.addTextLabel((byte)1, ss[0], ss[1]);
                    continue;
                }
                if (((String)v.elementAt(0)).equals("BBBP") && v.size() >= 3 && ((String)v.elementAt(2)).equals("ending vmstat -v")) {
                    if (v.size() == 3) continue;
                    String[] ss = new String[2];
                    String s = ((String)v.elementAt(3)).replaceAll("\"", "").trim();
                    int pos = s.indexOf(32);
                    ss[0] = s.substring(pos + 1);
                    ss[1] = s.substring(0, pos);
                    this.perfData.addTextLabel((byte)2, ss[0], ss[1]);
                    continue;
                }
                if (((String)v.elementAt(0)).equals("BBBL") && v.size() >= 4 && ((String)v.elementAt(2)).equals("smt threads")) {
                    this.smt = Byte.parseByte((String)v.elementAt(3));
                    this.perfData.setSmt_threads(this.smt);
                    continue;
                }
                if (((String)v.elementAt(0)).equals("BBBP") && v.size() == 4 && ((String)v.elementAt(2)).equals("lparstat -i")) {
                    if (((String)v.elementAt(3)).endsWith("Dedicated-SMT\"")) {
                        this.perfData.setSmtStatus((byte)1);
                    }
                    if (((String)v.elementAt(3)).endsWith("Dedicated\"")) {
                        this.perfData.setSmtStatus((byte)2);
                    }
                }
                if (!((String)v.elementAt(1)).startsWith("T")) {
                    if (((String)v.elementAt(0)).equals("IOADAPT")) {
                        i = 2;
                        while (i < v.size()) {
                            j = ((String)v.elementAt(i)).indexOf("_");
                            scsiLabel.add(((String)v.elementAt(i)).substring(0, j));
                            i += 3;
                        }
                        continue;
                    }
                    if (((String)v.elementAt(0)).equals("NET")) {
                        i = 2;
                        while (i < 2 + (v.size() - 2) / 2) {
                            j = ((String)v.elementAt(i)).indexOf("-");
                            networkLabel.add(((String)v.elementAt(i)).substring(0, j));
                            ++i;
                        }
                        continue;
                    }
                }
                if (!this.multipleLPAR && !((String)v.elementAt(1)).startsWith("T")) {
                    if (((String)v.elementAt(0)).startsWith("DISKBUSY")) {
                        if (this.avoidDisk) continue;
                        i = 2;
                        while (i < v.size()) {
                            diskLabel.add(v.elementAt(i));
                            ++i;
                        }
                        if (!this.firstRun || diskLabel.size() <= this.MAX_DISKS) continue;
                        this.avoidDisk = true;
                        System.out.println("More than " + this.MAX_DISKS + " disks. Skipping disk data.");
                        System.out.println("    - Deselect \"No disk data\" to include disk data and then press Zoom button.");
                        System.out.println("    - Use pGraph.properties file and change MaxDisks variable.");
                        continue;
                    }
                    if (((String)v.elementAt(0)).equals("ESSREAD")) {
                        i = 2;
                        while (i < v.size()) {
                            essLabel.add(v.elementAt(i));
                            ++i;
                        }
                        continue;
                    }
                    if (((String)v.elementAt(0)).equals("JFSFILE")) {
                        i = 2;
                        while (i < v.size()) {
                            fsLabel.add(v.elementAt(i));
                            ++i;
                        }
                        continue;
                    }
                    if (((String)v.elementAt(0)).equals("WLMCPU")) {
                        i = 2;
                        while (i < v.size()) {
                            wlmLabel.add(v.elementAt(i));
                            ++i;
                        }
                        continue;
                    }
                    if (((String)v.elementAt(0)).equals("FCREAD")) {
                        i = 2;
                        while (i < v.size()) {
                            fcLabel.add(v.elementAt(i));
                            ++i;
                        }
                        continue;
                    }
                    if (((String)v.elementAt(0)).equals("SEA")) {
                        i = 2;
                        while (i < 2 + (v.size() - 2) / 2) {
                            j = ((String)v.elementAt(i)).indexOf("-");
                            seaLabel.add(((String)v.elementAt(i)).substring(0, j));
                            ++i;
                        }
                        continue;
                    }
                }
                if (!((String)v.elementAt(1)).equals(timeLabel) && (v.size() <= 2 || !((String)v.elementAt(0)).equals("TOP") || !((String)v.elementAt(2)).equals(timeLabel))) continue;
                if (((String)v.elementAt(0)).startsWith("CPU") && ((String)v.elementAt(0)).indexOf("_USE") < 0) {
                    cpuName = ((String)v.elementAt(0)).equals("CPU_ALL") ? AVG_CPU : (String)v.elementAt(0);
                    if (v.size() < 6) continue;
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(2));
                        f2 = Float.parseFloat((String)v.elementAt(3));
                        f3 = Float.parseFloat((String)v.elementAt(4));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue;
                    }
                    this.perfData.add(slot, (byte)1, (byte)0, cpuName, f1);
                    this.perfData.add(slot, (byte)1, (byte)1, cpuName, f2);
                    this.perfData.add(slot, (byte)1, (byte)2, cpuName, f3);
                    this.perfData.add(slot, (byte)1, (byte)3, cpuName, 100.0f - f1 - f2 - f3);
                    continue;
                }
                if (((String)v.elementAt(0)).startsWith("PCPU")) {
                    cpuName = ((String)v.elementAt(0)).equals("PCPU_ALL") ? AVG_CPU : (String)v.elementAt(0);
                    if (v.size() < 6) continue;
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(2));
                        f2 = Float.parseFloat((String)v.elementAt(3));
                        f3 = Float.parseFloat((String)v.elementAt(4));
                        f4 = Float.parseFloat((String)v.elementAt(5));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue;
                    }
                    this.perfData.add(slot, (byte)14, (byte)0, cpuName, f1 + f2 + f3 + f4);
                    continue;
                }
                if (((String)v.elementAt(0)).equals("MEM")) {
                    if (this.operatingSystem == 0) {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(7));
                            f2 = Float.parseFloat((String)v.elementAt(4));
                            f3 = Float.parseFloat((String)v.elementAt(4)) * 1024.0f / 4.0f;
                            f4 = Float.parseFloat((String)v.elementAt(6));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                            continue;
                        }
                        this.perfData.add(slot, (byte)7, f1);
                        this.perfData.add(slot, (byte)8, f2);
                        this.perfData.add(slot, (byte)22, f3);
                        this.perfData.add(slot, (byte)16, f4);
                        if (v.size() < 12) continue;
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(8));
                            f2 = Float.parseFloat((String)v.elementAt(9));
                            f3 = Float.parseFloat((String)v.elementAt(10));
                            f4 = Float.parseFloat((String)v.elementAt(11));
                        }
                        catch (NumberFormatException e) {
                            continue;
                        }
                        this.perfData.add(slot, (byte)53, f1);
                        this.perfData.add(slot, (byte)52, f2);
                        this.perfData.add(slot, (byte)55, f3);
                        this.perfData.add(slot, (byte)54, f4);
                        continue;
                    }
                    if (this.operatingSystem != 1) continue;
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(2)) / 1024.0f;
                        f2 = Float.parseFloat((String)v.elementAt(6)) / 1024.0f;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue;
                    }
                    this.perfData.add(slot, (byte)16, f1);
                    this.perfData.add(slot, (byte)8, f2);
                    continue;
                }
                if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("MEMUSE")) {
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(2));
                        f2 = Float.parseFloat((String)v.elementAt(3));
                        f3 = Float.parseFloat((String)v.elementAt(4));
                        f4 = Float.parseFloat((String)v.elementAt(5));
                        f5 = Float.parseFloat((String)v.elementAt(6));
                        if (v.size() >= 9) {
                            f6 = Float.parseFloat((String)v.elementAt(7));
                            f7 = Float.parseFloat((String)v.elementAt(8));
                        } else {
                            f6 = -1.0f;
                            f7 = -1.0f;
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue;
                    }
                    this.perfData.add(slot, (byte)17, f1);
                    this.perfData.add(slot, (byte)18, f2);
                    this.perfData.add(slot, (byte)19, f3);
                    this.perfData.add(slot, (byte)20, f4);
                    this.perfData.add(slot, (byte)21, f5);
                    if (v.size() < 9) continue;
                    this.perfData.add(slot, (byte)24, f6);
                    this.perfData.add(slot, (byte)25, f7);
                    continue;
                }
                if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("VM") && !((String)v.elementAt(2)).equals("Paging and Virtual Memory")) {
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(11));
                        f2 = Float.parseFloat((String)v.elementAt(12));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue;
                    }
                    if ((double)f1 > 1000000.0) {
                        f1 = -1.0f;
                    }
                    if ((double)f2 > 1000000.0) {
                        f2 = -1.0f;
                    }
                    this.perfData.add(slot, (byte)9, f1);
                    this.perfData.add(slot, (byte)10, f2);
                    continue;
                }
                if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("PAGE")) {
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(5));
                        f2 = Float.parseFloat((String)v.elementAt(6));
                        f3 = Float.parseFloat((String)v.elementAt(7));
                        f4 = Float.parseFloat((String)v.elementAt(8));
                        f5 = Float.parseFloat((String)v.elementAt(9));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue;
                    }
                    this.perfData.add(slot, (byte)9, f1);
                    this.perfData.add(slot, (byte)10, f2);
                    this.perfData.add(slot, (byte)13, f3);
                    this.perfData.add(slot, (byte)15, f4);
                    this.perfData.add(slot, (byte)14, f5);
                    if (v.size() <= 10) continue;
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(10));
                        f2 = Float.parseFloat((String)v.elementAt(11));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue;
                    }
                    this.perfData.add(slot, (byte)56, f1);
                    this.perfData.add(slot, (byte)57, f2);
                    continue;
                }
                if (((String)v.elementAt(0)).equals("LPAR")) {
                    float f11;
                    float f10;
                    float f9;
                    try {
                        if (this.operatingSystem == 0) {
                            f1 = Float.parseFloat((String)v.elementAt(2));
                            f2 = Integer.parseInt((String)v.elementAt(3));
                            f3 = Integer.parseInt((String)v.elementAt(4));
                            f4 = Integer.parseInt((String)v.elementAt(5));
                            f5 = Float.parseFloat((String)v.elementAt(6));
                            f6 = Float.parseFloat((String)v.elementAt(8));
                            f7 = v.size() > 21 ? Float.parseFloat((String)v.elementAt(21)) : -1.0f;
                            f8 = Float.parseFloat((String)v.elementAt(17));
                            f9 = Float.parseFloat((String)v.elementAt(18));
                            f10 = Float.parseFloat((String)v.elementAt(19));
                            f11 = Float.parseFloat((String)v.elementAt(20));
                        } else if (this.operatingSystem == 1) {
                            f1 = Float.parseFloat((String)v.elementAt(2));
                            f2 = Integer.parseInt((String)v.elementAt(12));
                            f3 = -1.0f;
                            f4 = -1.0f;
                            f5 = Float.parseFloat((String)v.elementAt(9));
                            f6 = -1.0f;
                            f7 = -1.0f;
                            f11 = -1.0f;
                            f10 = -1.0f;
                            f9 = -1.0f;
                            f8 = -1.0f;
                        } else {
                            f11 = -1.0f;
                            f10 = -1.0f;
                            f9 = -1.0f;
                            f8 = -1.0f;
                            f7 = -1.0f;
                            f6 = -1.0f;
                            f5 = -1.0f;
                            f4 = -1.0f;
                            f3 = -1.0f;
                            f2 = -1.0f;
                            f1 = -1.0f;
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue;
                    }
                    if (f1 <= 192.0f) {
                        this.perfData.add(slot, (byte)0, f1);
                    }
                    if (f2 <= 192.0f) {
                        this.perfData.add(slot, (byte)1, f2);
                    }
                    if (f3 <= 1536.0f) {
                        this.perfData.add(slot, (byte)2, f3);
                    }
                    if (f4 <= 192.0f) {
                        this.perfData.add(slot, (byte)3, f4);
                    }
                    if (f5 <= 192.0f) {
                        this.perfData.add(slot, (byte)5, f5);
                    }
                    if (f6 > 0.0f && f6 <= 192.0f) {
                        this.perfData.add(slot, (byte)4, f6);
                    }
                    if (f1 >= 0.0f && f1 <= 192.0f && f5 > 0.0f && f5 <= 192.0f) {
                        this.perfData.add(slot, (byte)6, 100.0f * f1 / f5);
                    }
                    if (f7 <= 192.0f) {
                        this.perfData.add(slot, (byte)60, f7);
                    }
                    if (f8 <= 100.0f) {
                        this.perfData.add(slot, (byte)61, f8);
                    }
                    if (f9 <= 100.0f) {
                        this.perfData.add(slot, (byte)62, f9);
                    }
                    if (f10 <= 100.0f) {
                        this.perfData.add(slot, (byte)63, f10);
                    }
                    if (!(f11 <= 100.0f)) continue;
                    this.perfData.add(slot, (byte)64, f11);
                    continue;
                }
                if (this.multipleLPAR || this.avoidDisk || !((String)v.elementAt(0)).startsWith("DISK")) break block213;
                if (lastType == null || !((String)v.elementAt(0)).startsWith(lastType)) {
                    diskRead = 0;
                    lastType = (String)v.elementAt(0);
                }
                if (diskRead + v.size() - 2 > diskLabel.size()) {
                    System.out.println("Warning: new disks have been added since nmon started. Skippping disk data.");
                    this.avoidDisk = true;
                    continue;
                }
                if (((String)v.elementAt(0)).startsWith("DISKREADSERV")) {
                    type = 6;
                } else if (((String)v.elementAt(0)).startsWith("DISKWRITESERV")) {
                    type = 12;
                } else if (((String)v.elementAt(0)).startsWith("DISKBUSY")) {
                    type = 0;
                } else if (((String)v.elementAt(0)).startsWith("DISKREAD")) {
                    type = 1;
                } else if (((String)v.elementAt(0)).startsWith("DISKWRITE")) {
                    type = 2;
                } else if (((String)v.elementAt(0)).startsWith("DISKXFER")) {
                    type = 3;
                } else if (((String)v.elementAt(0)).startsWith("DISKBSIZE")) {
                    type = 4;
                } else if (((String)v.elementAt(0)).startsWith("DISKSERV")) {
                    type = 23;
                } else if (((String)v.elementAt(0)).startsWith("DISKWAIT")) {
                    type = 24;
                } else if (((String)v.elementAt(0)).startsWith("DISKRIO")) {
                    type = 5;
                } else {
                    if (!((String)v.elementAt(0)).startsWith("DISKWIO")) continue;
                    type = 11;
                }
                i = 2;
                while (i < v.size()) {
                    block215: {
                        block214: {
                            byte newType;
                            try {
                                f1 = Float.parseFloat((String)v.elementAt(i));
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                                break;
                            }
                            diskName = (String)diskLabel.elementAt(i - 2 + diskRead);
                            if (!diskName.startsWith("hdiskpower")) break block214;
                            switch (type) {
                                case 1: {
                                    newType = 0;
                                    break;
                                }
                                case 2: {
                                    newType = 1;
                                    break;
                                }
                                case 3: {
                                    newType = 2;
                                    break;
                                }
                                case 23: {
                                    newType = 4;
                                    break;
                                }
                                case 24: {
                                    newType = 5;
                                    break;
                                }
                                default: {
                                    break block215;
                                }
                            }
                            this.perfData.add(slot, (byte)3, newType, diskName, f1);
                            break block215;
                        }
                        if (diskName.startsWith("dac")) {
                            this.perfData.add(slot, (byte)11, (byte)type, diskName, f1);
                        } else {
                            this.perfData.add(slot, (byte)2, (byte)type, diskName, f1);
                        }
                    }
                    ++i;
                }
                diskRead += v.size() - 2;
                continue;
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).startsWith("ESS")) {
                byte type;
                if (!((String)v.elementAt(0)).equals(lastType)) {
                    essRead = 0;
                }
                lastType = (String)v.elementAt(0);
                if (((String)v.elementAt(0)).equals("ESSREAD")) {
                    type = 0;
                } else if (((String)v.elementAt(0)).equals("ESSWRITE")) {
                    type = 1;
                } else {
                    if (!((String)v.elementAt(0)).equals("ESSXFER")) continue;
                    type = 2;
                }
                i = 2;
                while (i < v.size()) {
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(i));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue block67;
                    }
                    this.perfData.add(slot, (byte)3, type, (String)essLabel.elementAt(i - 2 + essRead), f1);
                    ++i;
                }
                continue;
            }
            if (((String)v.elementAt(0)).equals("IOADAPT")) {
                i = 2;
                j = 0;
                while (i < v.size()) {
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(i));
                        f2 = Float.parseFloat((String)v.elementAt(i + 1));
                        f3 = Float.parseFloat((String)v.elementAt(i + 2));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue block67;
                    }
                    if (!(f1 > 1.0E7f || f2 > 1.0E7f || f3 > 1.0E7f)) {
                        this.perfData.add(slot, (byte)4, (byte)0, (String)scsiLabel.elementAt(j), f1);
                        this.perfData.add(slot, (byte)4, (byte)1, (String)scsiLabel.elementAt(j), f2);
                        this.perfData.add(slot, (byte)4, (byte)2, (String)scsiLabel.elementAt(j), f3);
                    }
                    i += 3;
                    ++j;
                }
                continue;
            }
            if (((String)v.elementAt(0)).startsWith("NET")) {
                if (((String)v.elementAt(0)).equals("NET")) {
                    i = 2;
                    j = 0;
                    while (i < 2 + (v.size() - 2) / 2) {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(i));
                            f2 = Float.parseFloat((String)v.elementAt(i + networkLabel.size()));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                            continue block67;
                        }
                        this.perfData.add(slot, (byte)5, (byte)0, (String)networkLabel.elementAt(j), f1);
                        this.perfData.add(slot, (byte)5, (byte)1, (String)networkLabel.elementAt(j), f2);
                        ++i;
                        ++j;
                    }
                    continue;
                }
                if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("NETPACKET")) {
                    i = 2;
                    j = 0;
                    while (i < 2 + (v.size() - 2) / 2) {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(i));
                            f2 = Float.parseFloat((String)v.elementAt(i + networkLabel.size()));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                            continue block67;
                        }
                        this.perfData.add(slot, (byte)5, (byte)2, (String)networkLabel.elementAt(j), f1);
                        this.perfData.add(slot, (byte)5, (byte)3, (String)networkLabel.elementAt(j), f2);
                        ++i;
                        ++j;
                    }
                    continue;
                }
                if (this.multipleLPAR || !((String)v.elementAt(0)).equals("NETERROR")) continue;
                i = 2;
                j = 0;
                while (i < 2 + (v.size() - 2) / 3) {
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(i));
                        f2 = Float.parseFloat((String)v.elementAt(i + networkLabel.size()));
                        f3 = Float.parseFloat((String)v.elementAt(i + networkLabel.size() * 2));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue block67;
                    }
                    this.perfData.add(slot, (byte)5, (byte)4, (String)networkLabel.elementAt(j), f1);
                    this.perfData.add(slot, (byte)5, (byte)5, (String)networkLabel.elementAt(j), f2);
                    this.perfData.add(slot, (byte)5, (byte)6, (String)networkLabel.elementAt(j), f3);
                    ++i;
                    ++j;
                }
                continue;
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("PROC")) {
                try {
                    f1 = Float.parseFloat((String)v.elementAt(2));
                    f2 = Float.parseFloat((String)v.elementAt(3));
                    f3 = Float.parseFloat((String)v.elementAt(4));
                    f4 = Float.parseFloat((String)v.elementAt(5));
                    f5 = Float.parseFloat((String)v.elementAt(6));
                    f6 = Float.parseFloat((String)v.elementAt(7));
                    f7 = Float.parseFloat((String)v.elementAt(8));
                    f8 = Float.parseFloat((String)v.elementAt(9));
                }
                catch (NumberFormatException e) {
                    System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                    continue;
                }
                this.perfData.add(slot, (byte)26, f1);
                this.perfData.add(slot, (byte)27, f2);
                this.perfData.add(slot, (byte)29, f3);
                this.perfData.add(slot, (byte)30, f4);
                this.perfData.add(slot, (byte)33, f5);
                this.perfData.add(slot, (byte)34, f6);
                this.perfData.add(slot, (byte)31, f7);
                this.perfData.add(slot, (byte)32, f8);
                continue;
            }
            if (!this.multipleLPAR && !this.avoidTop && ((String)v.elementAt(0)).equals("TOP")) {
                try {
                    f1 = Float.parseFloat((String)v.elementAt(3));
                    f2 = Float.parseFloat((String)v.elementAt(8));
                    f3 = Float.parseFloat((String)v.elementAt(9));
                }
                catch (NumberFormatException e) {
                    System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                    continue;
                }
                if (f1 <= 12800.0f) {
                    this.perfData.add(slot, (byte)7, (byte)0, String.valueOf((String)v.elementAt(13)) + ":" + (String)v.elementAt(1), f1);
                } else {
                    this.perfData.add(slot, (byte)7, (byte)0, String.valueOf((String)v.elementAt(13)) + ":" + (String)v.elementAt(1), 0.0f);
                }
                this.perfData.add(slot, (byte)7, (byte)1, String.valueOf((String)v.elementAt(13)) + ":" + (String)v.elementAt(1), f2);
                this.perfData.add(slot, (byte)7, (byte)2, String.valueOf((String)v.elementAt(13)) + ":" + (String)v.elementAt(1), f3);
                if (this.perfData.getNumTopProc() < this.MAX_TOPPROC) continue;
                this.avoidTop = true;
                this.perfData.invalidateTop();
                System.out.println("Too many TOP processes. Limit of " + this.MAX_TOPPROC + " has been reached: skipping TOP data.");
                System.out.println("    - Select a smaller time period to show TOP information.");
                System.out.println("    - Use pGraph.properties file and change MaxTopProcs variable to higher value.");
                continue;
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("JFSFILE")) {
                if (v.size() - 2 != fsLabel.size()) {
                    if (suppressJFSwarning) continue;
                    System.out.println("JFSFILE line " + this.current_file_line_read + " skipped: filesystem number has changed.");
                    suppressJFSwarning = true;
                    continue;
                }
                i = 2;
                while (i < v.size()) {
                    block204: {
                        if (!((String)v.elementAt(i)).contains("nan")) {
                            try {
                                f1 = Float.parseFloat((String)v.elementAt(i));
                            }
                            catch (NumberFormatException e) {
                                System.out.println("Error parsing line " + this.current_file_line_read + ": " + line + " element #" + i);
                                break block204;
                            }
                            diskName = (String)fsLabel.elementAt(i - 2);
                            this.perfData.add(slot, (byte)9, (byte)0, diskName, f1);
                        }
                    }
                    ++i;
                }
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("JFSINODE")) {
                if (v.size() - 2 != fsLabel.size()) {
                    if (suppressJFSwarning) continue;
                    System.out.println("JFSINODE line " + this.current_file_line_read + " skipped: filesystem number has changed.");
                    suppressJFSwarning = true;
                    continue;
                }
                i = 2;
                while (i < v.size()) {
                    block205: {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(i));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line + " element #" + i);
                            break block205;
                        }
                        diskName = (String)fsLabel.elementAt(i - 2);
                        this.perfData.add(slot, (byte)9, (byte)1, diskName, f1);
                    }
                    ++i;
                }
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("WLMCPU")) {
                i = 2;
                while (i < v.size()) {
                    block206: {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(i));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line + " element #" + i);
                            break block206;
                        }
                        diskName = (String)wlmLabel.elementAt(i - 2);
                        this.perfData.add(slot, (byte)6, (byte)0, diskName, f1);
                    }
                    ++i;
                }
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("WLMMEM")) {
                i = 2;
                while (i < v.size()) {
                    block207: {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(i));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line + " element #" + i);
                            break block207;
                        }
                        diskName = (String)wlmLabel.elementAt(i - 2);
                        this.perfData.add(slot, (byte)6, (byte)1, diskName, f1);
                    }
                    ++i;
                }
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("WLMBIO")) {
                i = 2;
                while (i < v.size()) {
                    block208: {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(i));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line + " element #" + i);
                            break block208;
                        }
                        diskName = (String)wlmLabel.elementAt(i - 2);
                        this.perfData.add(slot, (byte)6, (byte)2, diskName, f1);
                    }
                    ++i;
                }
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("PROCAIO")) {
                try {
                    f1 = Float.parseFloat((String)v.elementAt(2));
                    f2 = Float.parseFloat((String)v.elementAt(3));
                    f3 = Float.parseFloat((String)v.elementAt(4));
                }
                catch (NumberFormatException e) {
                    System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                    continue;
                }
                this.perfData.add(slot, (byte)42, f1);
                this.perfData.add(slot, (byte)43, f2);
                this.perfData.add(slot, (byte)44, f3);
                continue;
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("FCREAD")) {
                if (fcLabel.size() != v.size() - 2) {
                    if (suppressFCwarning) continue;
                    System.out.println("Missing FC labels in FCxxxx. Skipping data");
                    suppressFCwarning = true;
                    continue;
                }
                i = 2;
                while (i < v.size()) {
                    block209: {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(i));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line + " element #" + i);
                            break block209;
                        }
                        diskName = (String)fcLabel.elementAt(i - 2);
                        this.perfData.add(slot, (byte)10, (byte)0, diskName, f1);
                    }
                    ++i;
                }
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("FCWRITE")) {
                if (fcLabel.size() != v.size() - 2) {
                    if (suppressFCwarning) continue;
                    System.out.println("Missing FC labels in FCxxxx. Skipping data");
                    suppressFCwarning = true;
                    continue;
                }
                i = 2;
                while (i < v.size()) {
                    block210: {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(i));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line + " element #" + i);
                            break block210;
                        }
                        diskName = (String)fcLabel.elementAt(i - 2);
                        this.perfData.add(slot, (byte)10, (byte)1, diskName, f1);
                    }
                    ++i;
                }
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("FCXFERIN")) {
                if (fcLabel.size() != v.size() - 2) {
                    if (suppressFCwarning) continue;
                    System.out.println("Missing FC labels in FCxxxx. Skipping data");
                    suppressFCwarning = true;
                    continue;
                }
                i = 2;
                while (i < v.size()) {
                    block211: {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(i));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line + " element #" + i);
                            break block211;
                        }
                        diskName = (String)fcLabel.elementAt(i - 2);
                        this.perfData.add(slot, (byte)10, (byte)2, diskName, f1);
                    }
                    ++i;
                }
            }
            if (!this.multipleLPAR && ((String)v.elementAt(0)).equals("FCXFEROUT")) {
                if (fcLabel.size() != v.size() - 2) {
                    if (suppressFCwarning) continue;
                    System.out.println("Missing FC labels in FCxxxx. Skipping data");
                    suppressFCwarning = true;
                    continue;
                }
                i = 2;
                while (i < v.size()) {
                    block212: {
                        try {
                            f1 = Float.parseFloat((String)v.elementAt(i));
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Error parsing line " + this.current_file_line_read + ": " + line + " element #" + i);
                            break block212;
                        }
                        diskName = (String)fcLabel.elementAt(i - 2);
                        this.perfData.add(slot, (byte)10, (byte)3, diskName, f1);
                    }
                    ++i;
                }
            }
            if (this.multipleLPAR || !((String)v.elementAt(0)).startsWith("SEA")) continue;
            if (((String)v.elementAt(0)).equals("SEA")) {
                i = 2;
                j = 0;
                while (i < 2 + (v.size() - 2) / 2) {
                    try {
                        f1 = Float.parseFloat((String)v.elementAt(i));
                        f2 = Float.parseFloat((String)v.elementAt(i + seaLabel.size()));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                        continue block67;
                    }
                    this.perfData.add(slot, (byte)13, (byte)0, (String)seaLabel.elementAt(j), f1);
                    this.perfData.add(slot, (byte)13, (byte)1, (String)seaLabel.elementAt(j), f2);
                    ++i;
                    ++j;
                }
                continue;
            }
            if (!((String)v.elementAt(0)).equals("SEAPACKET")) continue;
            i = 2;
            j = 0;
            while (i < 2 + (v.size() - 2) / 2) {
                try {
                    f1 = Float.parseFloat((String)v.elementAt(i));
                    f2 = Float.parseFloat((String)v.elementAt(i + seaLabel.size()));
                }
                catch (NumberFormatException e) {
                    System.out.println("Error parsing line " + this.current_file_line_read + ": " + line);
                    continue block67;
                }
                this.perfData.add(slot, (byte)13, (byte)2, (String)seaLabel.elementAt(j), f1);
                this.perfData.add(slot, (byte)13, (byte)3, (String)seaLabel.elementAt(j), f2);
                ++i;
                ++j;
            }
        }
        br.close();
        if (lastParse) {
            this.perfData.endOfData();
        }
    }

    private Vector splitLine(String s) {
        int end;
        Vector<String> result = new Vector<String>();
        int begin = 0;
        while ((end = s.indexOf(44, begin)) >= 0) {
            result.add(s.substring(begin, end));
            begin = end + 1;
        }
        result.add(s.substring(begin));
        return result;
    }

    private GregorianCalendar parseDate(String line, GregorianCalendar last) {
        return this.parseDate(this.splitLine(line), last);
    }

    private GregorianCalendar parseDate(Vector v, GregorianCalendar last) {
        int s;
        int m;
        int h;
        String time = (String)v.elementAt(2);
        try {
            h = Integer.parseInt(time.substring(0, 2));
            m = Integer.parseInt(time.substring(3, 5));
            s = Integer.parseInt(time.substring(6));
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (v.size() == 4) {
            String date = (String)v.elementAt(3);
            int day = Integer.parseInt(date.substring(0, 2));
            int year = Integer.parseInt(date.substring(7));
            String str = date.substring(3, 6);
            int month = 0;
            if (str.equals("JAN")) {
                month = 0;
            } else if (str.equals("FEB")) {
                month = 1;
            } else if (str.equals("MAR")) {
                month = 2;
            } else if (str.equals("APR")) {
                month = 3;
            } else if (str.equals("MAY")) {
                month = 4;
            } else if (str.equals("JUN")) {
                month = 5;
            } else if (str.equals("JUL")) {
                month = 6;
            } else if (str.equals("AUG")) {
                month = 7;
            } else if (str.equals("SEP")) {
                month = 8;
            } else if (str.equals("OCT")) {
                month = 9;
            } else if (str.equals("NOV")) {
                month = 10;
            } else if (str.equals("DEC")) {
                month = 11;
            }
            return new GregorianCalendar(year, month, day, h, m, s);
        }
        if (last == null) {
            return new GregorianCalendar(1970, 0, 1, h, m, s);
        }
        if (h < last.get(11)) {
            return new GregorianCalendar(1970, 0, last.get(5) + 1, h, m, s);
        }
        return new GregorianCalendar(1970, 0, last.get(5), h, m, s);
    }
}

