/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.util.GregorianCalendar;
import pGraph.FileTokenizer;
import pGraph.Parser;
import pGraph.ParserManager;

public class Parser_Collectl
extends Parser {
    public Parser_Collectl(ParserManager v) {
        this.manager = v;
    }

    public void parseData(boolean firstParse, boolean lastParse) {
        block2: {
            try {
                this.int_parseData(firstParse, lastParse);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(this.fileName) + ": Warning, incomplete parsing of collectl data.");
                if (!lastParse) break block2;
                this.endOfData();
            }
        }
    }

    private void int_parseData(boolean firstParse, boolean lastParse) throws Exception {
        byte[] group = null;
        byte[] type = null;
        String[] item = null;
        String used = "";
        String skipped = "";
        if (firstParse) {
            this.perfData.setLimits(this.start, this.end);
        }
        BufferedReader br = this.getReader();
        FileTokenizer ft = new FileTokenizer(br, this.fileName);
        ft.setSeparator(' ');
        int numTokens = 0;
        boolean found = false;
        found = false;
        while (!found && (numTokens = this.readLineAndShowProgress(ft)) >= 0) {
            if (numTokens < 2 || !ft.getStringToken(0).equals("#Date") || !ft.getStringToken(1).equals("Time")) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        group = new byte[numTokens - 2];
        type = new byte[numTokens - 2];
        item = new String[numTokens - 2];
        int i = 0;
        while (i < numTokens - 2) {
            type[i] = -1;
            group[i] = -1;
            item[i] = null;
            ++i;
        }
        i = 0;
        while (i < numTokens - 2) {
            String s = ft.getStringToken(i + 2);
            if (s.startsWith("[CPU")) {
                group[i] = 1;
                if (s.charAt(4) != ']') {
                    skipped = String.valueOf(skipped) + s + " ";
                    group[i] = -1;
                    type[i] = -1;
                    item[i] = null;
                } else {
                    item[i] = Parser.AVG_CPU;
                    if (s.substring(5).equals("User%")) {
                        used = String.valueOf(used) + s + " ";
                        type[i] = 0;
                    } else if (s.substring(5).equals("Sys%")) {
                        used = String.valueOf(used) + s + " ";
                        type[i] = 1;
                    } else if (s.substring(5).equals("Wait%")) {
                        used = String.valueOf(used) + s + " ";
                        type[i] = 2;
                    } else if (s.substring(5).equals("Idle%")) {
                        used = String.valueOf(used) + s + " ";
                        type[i] = 3;
                    } else {
                        skipped = String.valueOf(skipped) + s + " ";
                        group[i] = -1;
                        type[i] = -1;
                        item[i] = null;
                    }
                }
            } else if (s.startsWith("[MEM")) {
                group[i] = 0;
                if (s.substring(5).equals("Tot")) {
                    used = String.valueOf(used) + s + " ";
                    type[i] = 16;
                } else if (s.substring(5).equals("Free")) {
                    used = String.valueOf(used) + s + " ";
                    type[i] = 8;
                } else if (s.substring(5).equals("SwapIn")) {
                    used = String.valueOf(used) + s + " ";
                    type[i] = 9;
                } else if (s.substring(5).equals("SwapOut")) {
                    used = String.valueOf(used) + s + " ";
                    type[i] = 10;
                } else {
                    skipped = String.valueOf(skipped) + s + " ";
                    group[i] = -1;
                    type[i] = -1;
                    item[i] = null;
                }
            } else if (s.startsWith("[NET")) {
                group[i] = 5;
                if (s.charAt(4) != ']') {
                    skipped = String.valueOf(skipped) + s + " ";
                    group[i] = -1;
                    type[i] = -1;
                    item[i] = null;
                } else {
                    item[i] = "All nets";
                    if (s.substring(5).equals("RxKBTot")) {
                        used = String.valueOf(used) + s + " ";
                        type[i] = 0;
                    } else if (s.substring(5).equals("TxKBTot")) {
                        used = String.valueOf(used) + s + " ";
                        type[i] = 1;
                    } else {
                        skipped = String.valueOf(skipped) + s + " ";
                        group[i] = -1;
                        type[i] = -1;
                        item[i] = null;
                    }
                }
            } else if (s.startsWith("[DSK")) {
                group[i] = 2;
                if (s.charAt(4) != ']') {
                    skipped = String.valueOf(skipped) + s + " ";
                    group[i] = -1;
                    type[i] = -1;
                    item[i] = null;
                } else {
                    item[i] = "All disks";
                    if (s.substring(5).equals("ReadTot")) {
                        used = String.valueOf(used) + s + " ";
                        type[i] = 5;
                    } else if (s.substring(5).equals("WriteTot")) {
                        used = String.valueOf(used) + s + " ";
                        type[i] = 11;
                    } else if (s.substring(5).equals("ReadKBTot")) {
                        used = String.valueOf(used) + s + " ";
                        type[i] = 1;
                    } else if (s.substring(5).equals("WriteKBTot")) {
                        used = String.valueOf(used) + s + " ";
                        type[i] = 2;
                    } else {
                        skipped = String.valueOf(skipped) + s + " ";
                        group[i] = -1;
                        type[i] = -1;
                        item[i] = null;
                    }
                }
            } else {
                skipped = String.valueOf(skipped) + s + " ";
                group[i] = -1;
                type[i] = -1;
                item[i] = null;
            }
            ++i;
        }
        System.out.println("DEBUG: Using fields:   " + used);
        System.out.println("DEBUG: Skipped fields: " + skipped);
        while ((numTokens = this.readLineAndShowProgress(ft)) >= 0) {
            GregorianCalendar gc;
            if (numTokens != group.length + 2) {
                System.out.println(String.valueOf(this.fileName) + "@" + this.lines_read + ": Unexpected number of fields. Skipping line.");
                continue;
            }
            String date = ft.getStringToken(0);
            String time = ft.getStringToken(1);
            try {
                gc = new GregorianCalendar(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(4, 6)) - 1, Integer.parseInt(date.substring(6)), Integer.parseInt(time.substring(0, 2)), Integer.parseInt(time.substring(3, 5)), Integer.parseInt(time.substring(6)));
            }
            catch (NumberFormatException nfe) {
                System.out.println("Warning: invalid time label in collectl data. Skipping line. " + this.fileName + "@" + this.lines_read);
                continue;
            }
            int slot = this.getSlot(gc);
            i = 0;
            while (i < numTokens - 2) {
                float f1;
                if (group[i] != -1 && !((f1 = ft.getFloatToken(i + 2)) < 0.0f)) {
                    if (group[i] == 0) {
                        if (type[i] == 16) {
                            f1 /= 1024.0f;
                        }
                        if (type[i] == 8) {
                            f1 /= 1024.0f;
                        }
                    }
                    this.perfData.add(slot, group[i], type[i], item[i], f1);
                }
                ++i;
            }
        }
        br.close();
        if (lastParse) {
            this.perfData.endOfData();
        }
    }

    public void scanTimeLimits() {
        try {
            this.parseTimeLimits();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.start != null && this.end != null) {
            this.valid = true;
        }
    }

    private void parseTimeLimits() throws Exception {
        int numTokens;
        this.valid = false;
        BufferedReader br = this.getReader();
        FileTokenizer ft = new FileTokenizer(br, this.fileName);
        ft.setSeparator(' ');
        while ((numTokens = ft.readLine()) >= 0) {
            GregorianCalendar curr;
            ++this.total_lines;
            if (numTokens < 2) continue;
            String date = ft.getStringToken(0);
            String time = ft.getStringToken(1);
            if (date.startsWith("#")) continue;
            if (date.length() != 8 || time.length() != 8) {
                System.out.println("Warning: invalid time label in collectl data. Skipping line. " + this.fileName + "@" + this.lines_read);
                continue;
            }
            try {
                curr = new GregorianCalendar(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(4, 6)) - 1, Integer.parseInt(date.substring(6)), Integer.parseInt(time.substring(0, 2)), Integer.parseInt(time.substring(3, 5)), Integer.parseInt(time.substring(6)));
            }
            catch (NumberFormatException nfe) {
                System.out.println("Warning: invalid time label in collectl data. Skipping line. " + this.fileName + "@" + this.lines_read);
                continue;
            }
            if (this.start == null) {
                this.start = curr;
                this.end = (GregorianCalendar)this.start.clone();
                continue;
            }
            this.end = curr;
        }
        br.close();
    }
}

