/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Vector;
import pGraph.DataSet;
import pGraph.Parser;
import pGraph.ParserManager;
import pGraph.Parser_Insight;
import pGraph.Parser_Nmon;
import pGraph.Parser_Sar;
import pGraph.Parser_Topas;
import pGraph.Parser_Vmstat;
import pGraph.PerfData;

public class Parser_CEC
extends Parser {
    private String[] fileName = null;
    private String directory = null;
    private Parser[] parser = null;
    private boolean loadFromConfigurationFile = false;
    private float[] fileNameWeight = null;
    private String[] singleHostDir = null;
    private float[] singleHostDirWeight = null;
    private String[][] singleHostDirFiles = null;
    private Parser[] parserSingleHost = null;
    private static final byte UNKNOWN = 0;
    private static final byte NMON = 1;
    private static final byte XMTREND = 2;
    private static final byte SAR = 3;
    private static final byte INSIGHT = 4;
    private byte filetype = 0;
    protected static final byte VALUE = 0;
    protected static final byte MIN = 1;
    protected static final byte MAX = 2;
    private String line;

    public Parser_CEC(ParserManager v) {
        this.manager = v;
    }

    public void scanTimeLimits() {
        block36: {
            GregorianCalendar e;
            GregorianCalendar s;
            if (this.applet != null && this.fileName == null) {
                this.fileName = this.applet.getFiles();
            }
            this.parser = new Parser[this.fileName.length];
            int i = 0;
            while (i < this.fileName.length) {
                this.parser[i] = this.applet == null && !this.loadFromConfigurationFile ? this.parseFileAndScanTimeLimits(String.valueOf(this.directory) + File.separator + this.fileName[i]) : this.parseFileAndScanTimeLimits(this.fileName[i]);
                if (this.parser[i] == null) {
                    System.out.println("Skipping invalid file: " + this.fileName[i]);
                } else if (this.loadFromConfigurationFile && this.filetype == 0) {
                    System.out.println("Skipping invalid file: " + this.fileName[i]);
                } else {
                    if (this.loadFromConfigurationFile) {
                        this.parser[i].setCpuWeight(this.fileNameWeight[i]);
                    }
                    s = this.parser[i].getStart();
                    e = this.parser[i].getEnd();
                    if (this.start == null) {
                        this.start = s;
                    } else if (s.before(this.start)) {
                        this.start = s;
                    }
                    if (this.end == null) {
                        this.end = e;
                    } else if (e.after(this.end)) {
                        this.end = e;
                    }
                }
                ++i;
            }
            if (!this.loadFromConfigurationFile) break block36;
            this.parserSingleHost = new Parser[this.singleHostDir.length];
            i = 0;
            while (i < this.singleHostDir.length) {
                block38: {
                    int j;
                    int num;
                    int numLines;
                    byte myFileType;
                    block37: {
                        myFileType = 0;
                        numLines = 0;
                        num = 0;
                        j = 0;
                        while (j < this.singleHostDirFiles[i].length) {
                            Parser p = this.parseFileAndScanTimeLimits(this.singleHostDirFiles[i][j]);
                            if (this.filetype != 1 && this.filetype != 2 && this.filetype != 3 && this.filetype != 4) {
                                p = null;
                            }
                            if (p == null) {
                                System.out.println("Skipping invalid file: " + this.singleHostDirFiles[i][j]);
                                this.singleHostDirFiles[i][j] = null;
                            } else if (myFileType == 0) {
                                myFileType = this.filetype;
                            } else if (myFileType != this.filetype) {
                                System.out.println("Skipping valid file of inconsistent type in directory: " + this.singleHostDirFiles[i][j]);
                                this.singleHostDirFiles[i][j] = null;
                            }
                            if (this.singleHostDirFiles[i][j] != null) {
                                ++num;
                                s = p.getStart();
                                e = p.getEnd();
                                if (this.start == null) {
                                    this.start = s;
                                } else if (s.before(this.start)) {
                                    this.start = s;
                                }
                                if (this.end == null) {
                                    this.end = e;
                                } else if (e.after(this.end)) {
                                    this.end = e;
                                }
                                numLines += p.getTotal_lines();
                            }
                            ++j;
                        }
                        if (myFileType != 0) break block37;
                        this.singleHostDir[i] = null;
                        this.singleHostDirFiles[i] = null;
                        break block38;
                    }
                    switch (myFileType) {
                        case 1: {
                            this.parserSingleHost[i] = new Parser_Nmon(this.manager);
                            break;
                        }
                        case 2: {
                            this.parserSingleHost[i] = new Parser_Topas(this.manager);
                            break;
                        }
                        case 3: {
                            this.parserSingleHost[i] = new Parser_Sar(this.manager);
                            break;
                        }
                        default: {
                            break block38;
                        }
                    }
                    this.parserSingleHost[i].setApplet(this.applet);
                    this.parserSingleHost[i].setTotal_lines(numLines);
                    this.parserSingleHost[i].setCpuWeight(this.singleHostDirWeight[i]);
                    String[] goodNames = new String[num];
                    j = 0;
                    while (j < this.singleHostDirFiles[i].length) {
                        if (this.singleHostDirFiles[i][j] != null) {
                            goodNames[j] = this.singleHostDirFiles[i][j];
                        }
                        ++j;
                    }
                    this.singleHostDirFiles[i] = goodNames;
                }
                ++i;
            }
        }
        if (this.start != null && this.end != null) {
            this.valid = true;
        }
    }

    public void parseData(boolean firstParse, boolean lastParse) {
        int j;
        if (!firstParse && !lastParse) {
            System.out.println("ERROR: wrong firstParse/lastParse in CECParser");
            return;
        }
        if (!this.valid) {
            return;
        }
        this.perfData.setLimits(this.start, this.end);
        DataSet ds = null;
        int i = 0;
        while (this.fileName != null && i < this.fileName.length) {
            if (this.parser[i] != null) {
                this.parser[i].setStart(this.start);
                this.parser[i].setEnd(this.end);
                this.parser[i].setMultipleLPAR(true);
                this.manager.setProgressMessage("[Directory] Parsing: " + this.parser[i].getFileName());
                this.parser[i].parseData(true, true);
            }
            ++i;
        }
        if (this.loadFromConfigurationFile && this.singleHostDir != null) {
            i = 0;
            while (i < this.parserSingleHost.length) {
                if (this.parserSingleHost[i] != null) {
                    this.parserSingleHost[i].setStart(this.start);
                    this.parserSingleHost[i].setEnd(this.end);
                    this.parserSingleHost[i].setMultipleLPAR(true);
                    this.parserSingleHost[i].setFileName(this.singleHostDirFiles[i][0]);
                    this.manager.setProgressMessage("Parsing: " + this.singleHostDirFiles[i][0]);
                    if (this.singleHostDirFiles[i].length == 1) {
                        this.parserSingleHost[i].parseData(true, true);
                    } else {
                        this.parserSingleHost[i].parseData(true, false);
                        j = 1;
                        while (j < this.singleHostDirFiles[i].length - 1) {
                            this.parserSingleHost[i].setFileName(this.singleHostDirFiles[i][j]);
                            this.manager.setProgressMessage("Parsing: " + this.singleHostDirFiles[i][j]);
                            this.parserSingleHost[i].parseData(false, false);
                            ++j;
                        }
                        this.parserSingleHost[i].setFileName(this.singleHostDirFiles[i][this.singleHostDirFiles[i].length - 1]);
                        this.manager.setProgressMessage("Parsing: " + this.singleHostDirFiles[i][this.singleHostDirFiles[i].length - 1]);
                        this.parserSingleHost[i].parseData(false, true);
                    }
                    this.parserSingleHost[i].setFileName(this.singleHostDir[i]);
                }
                ++i;
            }
        }
        boolean multipleCECs = false;
        this.cecName = null;
        if (this.parser != null) {
            i = 0;
            while (i < this.parser.length && this.parser[i] == null) {
                ++i;
            }
            if (i < this.parser.length) {
                this.cecName = this.parser[i].getCecName();
            }
            ++i;
            while (i < this.parser.length && this.cecName != null) {
                if (this.parser[i] != null && !this.cecName.equals(this.parser[i].getCecName())) {
                    this.cecName = null;
                    multipleCECs = true;
                }
                ++i;
            }
        }
        if (!multipleCECs && this.parserSingleHost != null) {
            if (this.cecName == null) {
                i = 0;
                while (i < this.parserSingleHost.length && this.parserSingleHost[i] == null) {
                    ++i;
                }
                if (i < this.parserSingleHost.length) {
                    this.cecName = this.parserSingleHost[i].getCecName();
                }
                ++i;
            } else {
                i = 0;
            }
            while (i < this.parserSingleHost.length && this.cecName != null) {
                if (this.parserSingleHost[i] != null && !this.cecName.equals(this.parserSingleHost[i].getCecName())) {
                    this.cecName = null;
                    multipleCECs = true;
                }
                ++i;
            }
        }
        PerfData pd = null;
        boolean VP = false;
        boolean LP = true;
        int POOL = 2;
        int PFREE = 3;
        int ENT = 4;
        int PC = 5;
        int DED_PC = 6;
        int USEDMEM = 7;
        int LOGMEM = 8;
        int PHYMEM = 9;
        int HYPPAG = 10;
        int DISKR = 11;
        int DISKW = 12;
        int DISKX = 13;
        int NETR = 14;
        int NETW = 15;
        int NUM = 16;
        float[][] sumData = new float[16][3];
        i = 0;
        while (i < DataSet.SLOTS) {
            String[] s;
            int shared = 0;
            int dedicated = 0;
            j = 0;
            while (j < 16) {
                int k = 0;
                while (k < 3) {
                    sumData[j][k] = -1.0f;
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < this.fileName.length) {
                if (this.parser[j] != null) {
                    pd = this.parser[j].getPerfData();
                    ds = pd.getData((byte)0, 0, (byte)5);
                    if (ds == null) {
                        ++dedicated;
                    } else {
                        ++shared;
                    }
                    sumData[0] = this.addWithValidData(pd.getData((byte)0, 0, (byte)1), i, sumData[0]);
                    sumData[1] = this.addWithValidData(pd.getData((byte)0, 0, (byte)2), i, sumData[1]);
                    sumData[4] = this.addWithValidData(pd.getData((byte)0, 0, (byte)5), i, sumData[4]);
                    sumData[5] = this.addWithValidData(pd.getData((byte)0, 0, (byte)0), i, sumData[5]);
                    sumData[6] = this.addWithValidData(pd.getData((byte)0, 0, (byte)40), i, sumData[6]);
                    if (this.cecName != null) {
                        if (sumData[2][0] < 0.0f) {
                            sumData[2] = this.addWithValidData(pd.getData((byte)0, 0, (byte)3), i, sumData[2]);
                        }
                        if (sumData[3][0] < 0.0f) {
                            sumData[3] = this.addWithValidData(pd.getData((byte)0, 0, (byte)4), i, sumData[3]);
                        }
                    }
                    sumData[7] = this.addWithValidData(pd.getData((byte)0, 0, (byte)23), i, sumData[7]);
                    sumData[9] = this.addWithValidData(pd.getData((byte)0, 0, (byte)46), i, sumData[9]);
                    sumData[10] = this.addWithValidData(pd.getData((byte)0, 0, (byte)48), i, sumData[10]);
                    ds = pd.getData((byte)4, "_Global_Disk_Adapter", (byte)0);
                    if (ds == null) {
                        ds = pd.getData((byte)4, 0, (byte)1);
                    }
                    sumData[11] = this.addWithValidData(ds, i, sumData[11]);
                    ds = pd.getData((byte)4, "_Global_Disk_Adapter", (byte)1);
                    if (ds == null) {
                        ds = pd.getData((byte)4, 0, (byte)2);
                    }
                    sumData[12] = this.addWithValidData(ds, i, sumData[12]);
                    ds = pd.getData((byte)4, "_Global_Disk_Adapter", (byte)2);
                    if (ds == null) {
                        ds = pd.getData((byte)4, 0, (byte)3);
                    }
                    sumData[13] = this.addWithValidData(ds, i, sumData[13]);
                    ds = pd.getData((byte)5, "_Global_Network", (byte)0);
                    if (ds == null && (s = pd.getNames((byte)5)) != null && s.length == 2) {
                        ds = s[0].startsWith("lo") ? pd.getData((byte)5, 1, (byte)0) : pd.getData((byte)5, 0, (byte)0);
                    }
                    sumData[14] = this.addWithValidData(ds, i, sumData[14]);
                    ds = pd.getData((byte)5, "_Global_Network", (byte)1);
                    if (ds == null && (s = pd.getNames((byte)5)) != null && s.length == 2) {
                        ds = s[0].startsWith("lo") ? pd.getData((byte)5, 1, (byte)1) : pd.getData((byte)5, 0, (byte)1);
                    }
                    sumData[15] = this.addWithValidData(ds, i, sumData[15]);
                }
                ++j;
            }
            j = 0;
            while (this.parserSingleHost != null && j < this.parserSingleHost.length) {
                if (this.parserSingleHost[j] != null) {
                    pd = this.parserSingleHost[j].getPerfData();
                    ds = pd.getData((byte)0, 0, (byte)5);
                    if (ds == null) {
                        ++dedicated;
                    } else {
                        ++shared;
                    }
                    sumData[0] = this.addWithValidData(pd.getData((byte)0, 0, (byte)1), i, sumData[0]);
                    sumData[1] = this.addWithValidData(pd.getData((byte)0, 0, (byte)2), i, sumData[1]);
                    sumData[4] = this.addWithValidData(pd.getData((byte)0, 0, (byte)5), i, sumData[4]);
                    sumData[5] = this.addWithValidData(pd.getData((byte)0, 0, (byte)0), i, sumData[5]);
                    sumData[6] = this.addWithValidData(pd.getData((byte)0, 0, (byte)40), i, sumData[6]);
                    if (this.cecName != null) {
                        if (sumData[2][0] < 0.0f) {
                            sumData[2] = this.addWithValidData(pd.getData((byte)0, 0, (byte)3), i, sumData[2]);
                        }
                        if (sumData[3][0] < 0.0f) {
                            sumData[3] = this.addWithValidData(pd.getData((byte)0, 0, (byte)4), i, sumData[3]);
                        }
                    }
                    sumData[7] = this.addWithValidData(pd.getData((byte)0, 0, (byte)23), i, sumData[7]);
                    sumData[9] = this.addWithValidData(pd.getData((byte)0, 0, (byte)46), i, sumData[9]);
                    sumData[10] = this.addWithValidData(pd.getData((byte)0, 0, (byte)48), i, sumData[10]);
                    ds = pd.getData((byte)4, "_Global_Disk_Adapter", (byte)0);
                    if (ds == null) {
                        ds = pd.getData((byte)4, 0, (byte)1);
                    }
                    sumData[11] = this.addWithValidData(ds, i, sumData[11]);
                    ds = pd.getData((byte)4, "_Global_Disk_Adapter", (byte)1);
                    if (ds == null) {
                        ds = pd.getData((byte)4, 0, (byte)2);
                    }
                    sumData[12] = this.addWithValidData(ds, i, sumData[12]);
                    ds = pd.getData((byte)4, "_Global_Disk_Adapter", (byte)2);
                    if (ds == null) {
                        ds = pd.getData((byte)4, 0, (byte)3);
                    }
                    sumData[13] = this.addWithValidData(ds, i, sumData[13]);
                    ds = pd.getData((byte)5, "_Global_Network", (byte)0);
                    if (ds == null && (s = pd.getNames((byte)5)) != null && s.length == 2) {
                        ds = s[0].startsWith("lo") ? pd.getData((byte)5, 1, (byte)0) : pd.getData((byte)5, 0, (byte)0);
                    }
                    sumData[14] = this.addWithValidData(ds, i, sumData[14]);
                    ds = pd.getData((byte)5, "_Global_Network", (byte)1);
                    if (ds == null && (s = pd.getNames((byte)5)) != null && s.length == 2) {
                        ds = s[0].startsWith("lo") ? pd.getData((byte)5, 1, (byte)1) : pd.getData((byte)5, 0, (byte)1);
                    }
                    sumData[15] = this.addWithValidData(ds, i, sumData[15]);
                }
                ++j;
            }
            this.perfData.addBySlot(i, (byte)1, sumData[0][0], sumData[0][1], sumData[0][2]);
            this.perfData.addBySlot(i, (byte)2, sumData[1][0], sumData[1][1], sumData[1][2]);
            this.perfData.addBySlot(i, (byte)5, sumData[4][0], sumData[4][1], sumData[4][2]);
            this.perfData.addBySlot(i, (byte)0, sumData[5][0], sumData[5][1], sumData[5][2]);
            this.perfData.addBySlot(i, (byte)40, sumData[6][0], sumData[6][1], sumData[6][2]);
            if (this.cecName != null) {
                this.perfData.addBySlot(i, (byte)3, sumData[2][0], sumData[2][1], sumData[2][2]);
                this.perfData.addBySlot(i, (byte)4, sumData[3][0], sumData[3][1], sumData[3][2]);
            }
            this.perfData.addBySlot(i, (byte)23, sumData[7][0], sumData[7][1], sumData[7][2]);
            this.perfData.addBySlot(i, (byte)45, sumData[8][0], sumData[8][1], sumData[8][2]);
            this.perfData.addBySlot(i, (byte)46, sumData[9][0], sumData[9][1], sumData[9][2]);
            this.perfData.addBySlot(i, (byte)48, sumData[10][0], sumData[10][1], sumData[10][2]);
            this.perfData.addBySlot(i, (byte)4, (byte)0, "_Global_Disk_Adapter", sumData[11][0], sumData[11][1], sumData[11][2]);
            this.perfData.addBySlot(i, (byte)4, (byte)1, "_Global_Disk_Adapter", sumData[12][0], sumData[12][1], sumData[12][2]);
            this.perfData.addBySlot(i, (byte)4, (byte)2, "_Global_Disk_Adapter", sumData[13][0], sumData[13][1], sumData[13][2]);
            this.perfData.addBySlot(i, (byte)5, (byte)0, "_Global_Network", sumData[14][0], sumData[14][1], sumData[14][2]);
            this.perfData.addBySlot(i, (byte)5, (byte)1, "_Global_Network", sumData[15][0], sumData[15][1], sumData[15][2]);
            this.perfData.add(i, (byte)38, shared);
            this.perfData.add(i, (byte)37, dedicated);
            ++i;
        }
        this.perfData.endOfData();
    }

    private float getvalidData(DataSet ds, int slot) {
        if (ds == null) {
            return -1.0f;
        }
        int lslot = ds.getNearestValidSlotLeft(slot);
        int rslot = ds.getNearestValidSlotRight(slot);
        if (lslot < 0 || rslot < 0 || lslot >= DataSet.SLOTS || rslot >= DataSet.SLOTS) {
            return -1.0f;
        }
        if (slot == lslot) {
            return ds.getValue(slot);
        }
        return this.linear(slot, lslot, rslot, ds.getValue(lslot), ds.getValue(rslot));
    }

    private float[] addWithValidData(DataSet ds, int slot, float[] data) {
        float value;
        float max;
        float min;
        if (ds == null) {
            return data;
        }
        int lslot = ds.getNearestValidSlotLeft(slot);
        int rslot = ds.getNearestValidSlotRight(slot);
        if (lslot < 0 || rslot < 0 || lslot >= DataSet.SLOTS || rslot >= DataSet.SLOTS) {
            return data;
        }
        if (slot == lslot) {
            min = ds.getAbsMin(slot);
            max = ds.getAbsMax(slot);
            value = ds.getValue(slot);
        } else {
            float lvalue = ds.getAbsMin(lslot);
            float rvalue = ds.getAbsMin(rslot);
            min = this.linear(slot, lslot, rslot, lvalue, rvalue);
            lvalue = ds.getAbsMax(lslot);
            rvalue = ds.getAbsMax(rslot);
            max = this.linear(slot, lslot, rslot, lvalue, rvalue);
            lvalue = ds.getValue(lslot);
            rvalue = ds.getValue(lslot);
            value = this.linear(slot, lslot, rslot, lvalue, rvalue);
        }
        if (value < 0.0f) {
            return data;
        }
        data[0] = data[0] >= 0.0f ? data[0] + value : value;
        data[1] = data[1] >= 0.0f ? data[1] + min : min;
        data[2] = data[2] >= 0.0f ? data[2] + max : max;
        return data;
    }

    public void setFileName(String string) {
        if (string == null) {
            return;
        }
        int num = 0;
        this.directory = string;
        File dir = new File(string);
        String[] s = dir.list();
        int i = 0;
        while (i < s.length) {
            File file = new File(string, s[i]);
            if (file.isDirectory()) {
                s[i] = null;
            } else {
                ++num;
            }
            ++i;
        }
        this.fileName = new String[num];
        i = 0;
        int j = 0;
        while (i < s.length) {
            if (s[i] != null) {
                this.fileName[j++] = s[i];
            }
            ++i;
        }
    }

    public void setConfigurationFile(String file) {
        if (file == null) {
            return;
        }
        try {
            this.readConfigurationFile(file);
        }
        catch (IOException ioe) {
            System.out.println("Error reading configuration file.");
            System.out.println("Offending line is: " + this.line);
            System.out.println("Remaining lines are ignored.");
            return;
        }
        this.loadFromConfigurationFile = true;
    }

    public Parser getParser(int num) {
        if (this.parser == null) {
            return this.parserSingleHost[num];
        }
        if (num < this.parser.length) {
            return this.parser[num];
        }
        return this.parserSingleHost[num - this.parser.length];
    }

    private float linear(int x, int x1, int x2, float y1, float y2) {
        float f = 1.0f * (y2 - y1) / (float)(x2 - x1) * (float)x + (1.0f * (float)x2 * y1 - 1.0f * (float)x1 * y2) / (float)(x2 - x1);
        return f;
    }

    private Parser parseFileAndScanTimeLimits(String name) {
        Parser parser = new Parser_Nmon(this.manager);
        parser.setFileName(name);
        parser.setApplet(this.applet);
        this.manager.setProgressMessage("[Directory] Check if nmon: " + name);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = 1;
            return parser;
        }
        parser = new Parser_Vmstat(this.manager);
        parser.setFileName(name);
        parser.setApplet(this.applet);
        this.manager.setProgressMessage("Check if vmstat: " + name);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            System.out.println("vmstat -t: " + name);
            return parser;
        }
        parser = new Parser_Topas(this.manager);
        parser.setFileName(name);
        parser.setApplet(this.applet);
        this.manager.setProgressMessage("[Directory] Check if topasout: " + name);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            this.filetype = ((Parser_Topas)parser).getType() == Parser_Topas.TOPASCEC ? (byte)0 : (byte)2;
            return parser;
        }
        parser = new Parser_Sar(this.manager);
        parser.setFileName(name);
        parser.setApplet(this.applet);
        this.manager.setProgressMessage("Check if sar: " + name);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            System.out.println("sar -t: " + name);
            this.filetype = (byte)3;
            return parser;
        }
        parser = new Parser_Insight(this.manager);
        parser.setFileName(name);
        parser.setApplet(this.applet);
        this.manager.setProgressMessage("Check if Insight: " + name);
        parser.scanTimeLimits();
        if (parser.isValid()) {
            System.out.println("Insight: " + name);
            this.filetype = (byte)4;
            return parser;
        }
        System.out.println("invalid:   " + name);
        return null;
    }

    public String[] getParserNames() {
        int ix;
        if (this.parser == null) {
            return null;
        }
        String[] result = null;
        result = this.parserSingleHost == null ? new String[this.parser.length] : new String[this.parser.length + this.parserSingleHost.length];
        int i = 0;
        while (this.parser != null && i < this.parser.length) {
            if (this.parser[i] != null) {
                ix = this.parser[i].getFileName().lastIndexOf(File.separatorChar);
                result[i] = this.parser[i].getFileName().substring(ix + 1);
            }
            ++i;
        }
        int num = this.parser == null ? 0 : this.parser.length;
        i = 0;
        while (this.parserSingleHost != null && i < this.parserSingleHost.length) {
            if (this.parserSingleHost[i] != null) {
                ix = this.parserSingleHost[i].getFileName().lastIndexOf(File.separatorChar);
                result[num + i] = this.parserSingleHost[i].getFileName().substring(ix + 1);
            }
            ++i;
        }
        return result;
    }

    private String[] splitConfigurationLine(String line) {
        if (line == null) {
            return null;
        }
        if (line.startsWith("#")) {
            return null;
        }
        String[] tokens = line.split("(\\s*=\\s*)|(\\s*@\\s*)|(\\s+-\\s+)");
        int i = 0;
        i = 0;
        while (i < tokens.length) {
            tokens[i] = tokens[i].trim();
            ++i;
        }
        i = 0;
        while (i < tokens.length) {
            if (tokens[i] != null && tokens[i].startsWith("\"") && tokens[i].endsWith("\"")) {
                tokens[i] = tokens[i].substring(1, tokens[i].length() - 1);
            }
            ++i;
        }
        return tokens;
    }

    private void readConfigurationFile(String cfg) throws IOException {
        int j;
        String[] s;
        File f;
        BufferedReader br;
        try {
            br = new BufferedReader(new FileReader(cfg), 0x100000);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Configuration file " + cfg + " not found.");
            return;
        }
        String base = null;
        Vector<String> sh_dir = new Vector<String>();
        Vector<Float> sh_dir_w = new Vector<Float>();
        Vector<String> mh_dir = new Vector<String>();
        Vector<Float> mh_dir_w = new Vector<Float>();
        Vector<String> file = new Vector<String>();
        Vector<Float> file_w = new Vector<Float>();
        this.end = null;
        this.start = null;
        while ((this.line = br.readLine()) != null) {
            float w;
            String[] tokens;
            block51: {
                tokens = this.splitConfigurationLine(this.line);
                if (tokens == null) continue;
                if (tokens[0].equalsIgnoreCase("ZOOM")) {
                    if (tokens.length != 3) {
                        System.out.println("Configuration file error, line skipped: " + this.line);
                        continue;
                    }
                    this.start = this.getGC(tokens[1]);
                    this.end = this.getGC(tokens[2]);
                    if (this.start != null && this.end != null && !this.end.before(this.start)) continue;
                    System.out.println("Configuration file error, line skipped: " + this.line);
                    this.end = null;
                    this.start = null;
                    continue;
                }
                if (tokens[0].equalsIgnoreCase("BASE")) {
                    if (tokens.length != 2) {
                        System.out.println("Configuration file error, line skipped: " + this.line);
                        continue;
                    }
                    f = new File(tokens[1]);
                    if (!f.isAbsolute()) {
                        System.out.println("BASE must be an absolute path! Line skipped: " + this.line);
                        continue;
                    }
                    if (!f.exists() || !f.isDirectory()) {
                        System.out.println("BASE does not exist or it is not a directory, line skipped: " + this.line);
                        continue;
                    }
                    base = tokens[1];
                    if (base.endsWith(File.separator)) continue;
                    base = String.valueOf(base) + File.separator;
                    continue;
                }
                if (tokens[0].equalsIgnoreCase("SH_DIR")) {
                    block49: {
                        if (tokens.length < 2 || tokens.length > 3) {
                            System.out.println("Configuration file error, line skipped: " + this.line);
                            continue;
                        }
                        if (tokens.length == 3) {
                            try {
                                w = Float.parseFloat(tokens[2]);
                                break block49;
                            }
                            catch (NumberFormatException nfe) {
                                System.out.println("Invalid float number, line skipped: " + this.line);
                                continue;
                            }
                        }
                        w = 1.0f;
                    }
                    f = new File(tokens[1]);
                    if (f.isAbsolute()) {
                        if (!f.exists() || !f.isDirectory()) {
                            System.out.println("Invalid absolute directory, line skipped: " + this.line);
                            continue;
                        }
                        sh_dir.add(tokens[1]);
                    } else {
                        f = new File(String.valueOf(base) + tokens[1]);
                        if (!f.exists() || !f.isDirectory()) {
                            System.out.println("Invalid relative directory, line skipped: " + this.line);
                            continue;
                        }
                        sh_dir.add(String.valueOf(base) + tokens[1]);
                    }
                    sh_dir_w.add(new Float(w));
                    continue;
                }
                if (tokens[0].equalsIgnoreCase("MH_DIR")) {
                    block50: {
                        if (tokens.length < 2 || tokens.length > 3) {
                            System.out.println("Configuration file error, line skipped: " + this.line);
                            continue;
                        }
                        if (tokens.length == 3) {
                            try {
                                w = Float.parseFloat(tokens[2]);
                                break block50;
                            }
                            catch (NumberFormatException nfe) {
                                System.out.println("Invalid float number, line skipped: " + this.line);
                                continue;
                            }
                        }
                        w = 1.0f;
                    }
                    f = new File(tokens[1]);
                    if (f.isAbsolute()) {
                        if (!f.exists() || !f.isDirectory()) {
                            System.out.println("Invalid absolute directory, line skipped: " + this.line);
                            continue;
                        }
                        mh_dir.add(tokens[1]);
                    } else {
                        f = new File(String.valueOf(base) + tokens[1]);
                        if (!f.exists() || !f.isDirectory()) {
                            System.out.println("Invalid relative directory, line skipped: " + this.line);
                            continue;
                        }
                        mh_dir.add(String.valueOf(base) + tokens[1]);
                    }
                    mh_dir_w.add(new Float(w));
                    continue;
                }
                if (tokens.length > 2) {
                    System.out.println("Invalid number of tokens, line skipped: " + this.line);
                    continue;
                }
                if (tokens.length == 2) {
                    try {
                        w = Float.parseFloat(tokens[1]);
                        break block51;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Invalid float number, line skipped: " + this.line);
                        continue;
                    }
                }
                w = 1.0f;
            }
            f = new File(tokens[0]);
            if (f.isAbsolute()) {
                if (!f.exists() || f.isDirectory()) {
                    System.out.println("Invalid absolute file, line skipped: " + this.line);
                    continue;
                }
                file.add(tokens[0]);
            } else {
                f = new File(String.valueOf(base) + tokens[0]);
                if (!f.exists() || f.isDirectory()) {
                    System.out.println("Invalid relative file, line skipped: " + this.line);
                    continue;
                }
                file.add(String.valueOf(base) + tokens[0]);
            }
            file_w.add(new Float(w));
        }
        int num = 0;
        int i = 0;
        while (i < mh_dir.size()) {
            f = new File((String)mh_dir.elementAt(i));
            s = f.list();
            j = 0;
            while (j < s.length) {
                f = new File((String)mh_dir.elementAt(i), s[j]);
                if (!f.isDirectory()) {
                    ++num;
                }
                ++j;
            }
            ++i;
        }
        this.fileName = new String[num + file.size()];
        this.fileNameWeight = new float[num + file.size()];
        num = 0;
        i = 0;
        while (i < mh_dir.size()) {
            f = new File((String)mh_dir.elementAt(i));
            s = f.list();
            j = 0;
            while (j < s.length) {
                f = new File((String)mh_dir.elementAt(i), s[j]);
                if (!f.isDirectory()) {
                    this.fileName[num] = String.valueOf((String)mh_dir.elementAt(i)) + File.separator + s[j];
                    this.fileNameWeight[num] = ((Float)mh_dir_w.elementAt(i)).floatValue();
                    ++num;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < file.size()) {
            this.fileName[num] = (String)file.elementAt(i);
            this.fileNameWeight[num] = ((Float)file_w.elementAt(i)).floatValue();
            ++num;
            ++i;
        }
        this.singleHostDir = new String[sh_dir.size()];
        this.singleHostDirWeight = new float[sh_dir_w.size()];
        this.singleHostDirFiles = new String[sh_dir.size()][];
        i = 0;
        while (i < sh_dir.size()) {
            this.singleHostDir[i] = (String)sh_dir.elementAt(i);
            this.singleHostDirWeight[i] = ((Float)sh_dir_w.elementAt(i)).floatValue();
            File[] child = new File(this.singleHostDir[i]).listFiles();
            num = 0;
            j = 0;
            while (j < child.length) {
                if (child[j].isDirectory()) {
                    child[j] = null;
                } else {
                    ++num;
                }
                ++j;
            }
            if (num == 0) {
                System.out.println("Warning! Empty single host dir: " + this.singleHostDir[i]);
            }
            this.singleHostDirFiles[i] = new String[num];
            j = 0;
            int k = 0;
            while (j < child.length) {
                if (child[j] != null) {
                    this.singleHostDirFiles[i][k++] = child[j].getPath();
                }
                ++j;
            }
            ++i;
        }
    }

    private GregorianCalendar getGC(String string) {
        int s;
        int m;
        int h;
        int D;
        int M;
        int Y;
        if (string.length() != "YYYYMMDDhhmmss".length()) {
            return null;
        }
        try {
            Y = Integer.parseInt(string.substring(0, 4), 10);
            M = Integer.parseInt(string.substring(4, 6), 10);
            D = Integer.parseInt(string.substring(6, 8), 10);
            h = Integer.parseInt(string.substring(8, 10), 10);
            m = Integer.parseInt(string.substring(10, 12), 10);
            s = Integer.parseInt(string.substring(12), 10);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new GregorianCalendar(Y, M - 1, D, h, m, s);
    }
}

