/*
 * Decompiled with CFR 0.152.
 */
package pGraph;

public class NmonTokenizer {
    private String input = null;
    private String[] tokens = null;
    private String[][] keys = null;
    private int line_num = 0;
    private static boolean DEBUG = false;

    public void parseString(String s, int num) {
        this.input = s;
        this.line_num = num;
        this.tokens = this.input.split(",+");
    }

    public void updateKeys() {
        int i;
        String[][] newKeys;
        if (this.keys == null) {
            newKeys = new String[][]{new String[this.tokens.length]};
        } else {
            newKeys = new String[this.keys.length + 1][];
            i = 0;
            while (i < this.keys.length) {
                newKeys[i] = this.keys[i];
                ++i;
            }
            newKeys[this.keys.length] = new String[this.tokens.length];
        }
        i = 0;
        while (i < this.tokens.length) {
            newKeys[newKeys.length - 1][i] = this.tokens[i].trim();
            ++i;
        }
        this.keys = newKeys;
    }

    public float getValueFromKey(String label) {
        float result;
        if (this.tokens == null || this.keys == null) {
            return -1.0f;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.tokens[0].equals(this.keys[i][0])) break;
            ++i;
        }
        if (i == this.keys.length) {
            System.out.println("Error line " + this.line_num + ": unknown key " + this.tokens[0]);
            return -1.0f;
        }
        if (this.tokens.length != this.keys[i].length) {
            System.out.println("Error line " + this.line_num + ": unexpected change of number of tokens: ");
            return -1.0f;
        }
        int j = 2;
        while (j < this.keys[i].length) {
            if (this.keys[i][j].equals(label)) break;
            ++j;
        }
        if (j == this.keys[i].length) {
            return -1.0f;
        }
        try {
            result = Float.parseFloat(this.tokens[j]);
        }
        catch (NumberFormatException e) {
            if (DEBUG) {
                System.out.println("Error line " + this.line_num + ": error parsing label " + label);
            }
            return -1.0f;
        }
        return result;
    }

    public float getValue(int n) {
        float result;
        if (this.tokens == null) {
            return -1.0f;
        }
        if (n >= this.tokens.length) {
            return -1.0f;
        }
        try {
            result = Float.parseFloat(this.tokens[n]);
        }
        catch (NumberFormatException e) {
            if (DEBUG) {
                System.out.println("Error line " + this.line_num + ": error parsing token " + this.tokens[n]);
            }
            return -1.0f;
        }
        if ((double)result > 1.0E8) {
            result = -1.0f;
        }
        return result;
    }

    public String getString(int n) {
        if (this.tokens == null) {
            return null;
        }
        if (n >= this.tokens.length) {
            return null;
        }
        return this.tokens[n];
    }

    public String getStringFromKey(String label) {
        if (this.tokens == null || this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.tokens[0].equals(this.keys[i][0])) break;
            ++i;
        }
        if (i == this.keys.length) {
            System.out.println("Error line " + this.line_num + ": unknown key " + this.tokens[0]);
            return null;
        }
        if (this.tokens.length != this.keys[i].length) {
            System.out.println("Error line " + this.line_num + ": unexpected change of number of tokens: ");
            return null;
        }
        int j = 2;
        while (j < this.keys[i].length) {
            if (this.keys[i][j].equals(label)) break;
            ++j;
        }
        if (j == this.keys[i].length) {
            return null;
        }
        return this.tokens[j];
    }

    public String[] getKeys() {
        if (this.tokens == null || this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.tokens[0].equals(this.keys[i][0])) break;
            ++i;
        }
        if (i == this.keys.length) {
            System.out.println("Error line " + this.line_num + ": unknown key " + this.tokens[0]);
            return null;
        }
        return this.keys[i];
    }

    public int getNumTokens() {
        if (this.tokens == null) {
            return -1;
        }
        return this.tokens.length;
    }
}

